<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;
use App\Tipo;
use App\Solicitud;
use App\Archivos;
use App\ServicioTieneUsuarios;
use App\EncargadoSolicitud;
use App\Roles;
use DB;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Auth;

class AsignadorController extends Controller
{
    //------------------------------------------------------------
    public function page($tp_destino)
    {
        $destino    =   '';
        $id_usuario =   Auth::user()->id;
        $id_rol     =   Auth::user()->id_rol;
        $rol_actual =   UtilController::getRolActivo($id_usuario);
        $roles      =   UtilController::listarRolesUsuario($id_usuario);

        if($tp_destino === 'inicio')
            $destino = 'asignador.inicio_asignador';

        if($tp_destino === 'servicios')
            $destino = 'asignador.bandeja_asignador';

        return view($destino)
                ->with('id_rol',$id_rol)
                ->with('rol_actual',$rol_actual)
                ->with('data',$roles)
                ->with('count',count($roles));
    }
    //------------------------------------------------------------
    public function index(Request $request)
    {
        $id_direccion   =   Auth::user()->id_direccion;
        $id_depto       =   Auth::user()->id_depto;
        $fl_mostrar     =   $request->fl_mostrar;
        $fl_direccion   =   $request->fl_direccion;
        $fl_depto       =   $request->fl_depto;
        $fl_servicio    =   $request->fl_servicio;
        $fl_macrozona   =   $request->fl_macrozona;
        $fl_undvecinal  =   $request->fl_unidadvecinal;
        $fl_ticket      =   $request->fl_ticket;
        $fl_vecino      =   $request->fl_persona;
        $fl_motivo      =   $request->fl_motivo;
        $fl_ubicacion   =   $request->fl_ubicacion;
        $page           =   $request->page;
        $fc_desde       =   $request->fc_desde;
        $fc_hasta       =   $request->fc_hasta;


        $data           =   Solicitud:: 
                            join('gsut_prioridad as prioridad','prioridad.id','=','gsut_solicitud.id_prioridad')
                            ->join('gsut_motivo as motivo','motivo.id','=','gsut_solicitud.id_motivo')
                            ->join('gsut_tipo as tipo','tipo.id','=','gsut_solicitud.id_tipo')
                            ->join('gsut_estado as estado','estado.id','=','gsut_solicitud.id_estado')
                            ->join('gsut_direccion as dir_destino','dir_destino.id','=','gsut_solicitud.id_direccion_destino')
                            ->join('gsut_depto as depto_destino','depto_destino.id','=','gsut_solicitud.id_depto_destino')
                            ->leftjoin('gsut_macroterritorio as mt','mt.id','=','gsut_solicitud.id_macroterritorio')
                            ->leftjoin('gsut_unidadvecinal as uv','uv.id','=','gsut_solicitud.id_unidadvecinal')
                            ->join('gsut_tipo_ingreso as ti','ti.id','=','gsut_solicitud.tp_ingreso')
                            ->select('gsut_solicitud.id',
                                'gsut_solicitud.nr_ticket',
                                'gsut_solicitud.id_municipio',
                                'gsut_solicitud.id_direccion',
                                'gsut_solicitud.id_depto',
                                'gsut_solicitud.id_tipo',
                                'gsut_solicitud.nm_tipo',
                                'gsut_solicitud.id_prioridad',
                                'gsut_solicitud.id_motivo',
                                'motivo.nm_motivo',
                                'gsut_solicitud.id_direccion_destino',
                                'dir_destino.nm_direccion as nm_direccion_destino',
                                'gsut_solicitud.id_depto_destino',
                                'depto_destino.nm_depto as nm_depto_destino',
                                'gsut_solicitud.id_ubicacion',
                                'gsut_solicitud.id_macroterritorio',
                                'mt.cod_territorio',
                                'gsut_solicitud.id_unidadvecinal',
                                'uv.cod_unidadvecinal',
                                'uv.nm_unidadvecinal',
                                'gsut_solicitud.tp_direccion',
                                'gsut_solicitud.nr_direccion',
                                'gsut_solicitud.nm_direccion',
                                'gsut_solicitud.nm_ubicacion',
                                'gsut_solicitud.str_latitud',
                                'gsut_solicitud.str_longitud',
                                'gsut_solicitud.nr_rut_vecino',
                                'gsut_solicitud.str_observacion',
                                'gsut_solicitud.str_aclaratoria',
                                'gsut_solicitud.tp_visado_mt',
                                'gsut_solicitud.tp_rechazado',
                                'gsut_solicitud.id_estado',
                                'estado.nm_estado',
                                'estado.nm_color',
                                'gsut_solicitud.contexto_municipal',
                                'gsut_solicitud.tp_ingreso',
                                'ti.nm_ingreso',
                                'gsut_solicitud.id_autor',
                                'gsut_solicitud.tp_activo',
                                'gsut_solicitud.tp_feedback',
                                'gsut_solicitud.tp_recepcion',
                                'gsut_solicitud.tp_satisfaccion',
                                'gsut_solicitud.str_feedback',
                                'gsut_solicitud.fc_publicado',
                                'gsut_solicitud.fc_creacion as fc_ingreso',
                                'gsut_solicitud.created_at',
                                'gsut_solicitud.updated_at as fc_tramitacion')
                            ->selectRaw("(case when tp_vecino = 1 then 'SI' else 'NO' end) as tp_vecino")
                            ->where('gsut_solicitud.tp_activo','=',1)
                            ->where('tipo.tp_asignacion','=',1)
                            ->where('gsut_solicitud.id_estado','>=',2)
                            ->where('gsut_solicitud.id_direccion_destino','=',$id_direccion)
                            ->orderBy('gsut_solicitud.created_at','DESC')
                            ->with('tipo','prioridad','vecino','archivos','ubicacion','asignados','archivos_asignacion','solicitud','derivacion');

        /* ----- Inicio - Filtro ----- */
            if($fl_mostrar != 0)
                $data   =   $data->where('gsut_solicitud.id_estado','=',$fl_mostrar);

            if(isset($fl_direccion)) 
                $data   =   $data->where('gsut_solicitud.id_direccion_destino','=',$fl_direccion);

            if(isset($fl_depto)) 
                $data   =   $data->where('gsut_solicitud.id_depto_destino','=',$fl_depto);

            if(isset($fl_servicio))
                $data   =   $data->where('gsut_solicitud.id_tipo','=',$fl_servicio);

            if(isset($fl_macrozona))
                $data   =   $data->where('gsut_solicitud.id_macroterritorio','=',$fl_macrozona);

            if(isset($fl_undvecinal))
                $data   =   $data->where('gsut_solicitud.id_unidadvecinal','=',$fl_undvecinal);

            if(isset($fl_ticket))
                $data   =   $data->where('gsut_solicitud.nr_ticket','=',$fl_ticket);

            if(isset($fl_vecino))
                $data   =   $data->where('gsut_solicitud.nr_rut_vecino','=',$fl_vecino);

            if(isset($fl_motivo))
                $data   =   $data->where('gsut_solicitud.id_motivo','=',$fl_motivo);

            if(isset($fl_ubicacion))
                $data   =   $data->where('gsut_solicitud.id_ubicacion','=',$fl_ubicacion);

            if(isset($fc_desde) && isset($fc_hasta))
            {
                $fc_desde   =   Carbon::parse($fc_desde)->format('Y-m-d');
                $fc_hasta   =   Carbon::parse($fc_hasta)->format('Y-m-d');
                $data       =   $data->whereDate('gsut_solicitud.created_at','>=',$fc_desde)
                                     ->whereDate('gsut_solicitud.created_at','<=',$fc_hasta);
            }
        /* ----- Termino - Filtro ----- */

        $data   =   $data->groupBy('gsut_solicitud.id')->paginate(20);

        $data->getCollection()->transform(function ($value) {
            $value->tiempo_tramitado    =   UtilController::getTiempoTramitacion($value->fc_ingreso, $value->fc_publicado, $value->nr_estado);
            $value->tiene_pp            =   (UtilController::getCantidadRespuestas(2, $value->id) != 0) ? 'SI' : 'NO'; // Tiene Publicaciones Parciales
            return $value;
        });

        return [
            'pagination' => [
                'total'        => $data->total(),
                'current_page' => $data->currentPage(),
                'per_page'     => $data->perPage(),
                'last_page'    => $data->lastPage(),
                'from'         => $data->firstItem(),
                'to'           => $data->lastItem(),
            ],
            'info' => $data
        ];
    }
    //------------------------------------------------------------
    public function asignarSolicitud(Request $request)
    {
        $solicitud          =   null;
        $nr_servicio        =   1;
        $nr_solicitud       =   $request->nr_id;
        $nr_ticket          =   $request->nr_ticket;
        $str_observacion    =   $request->str_observacion;
        $arr_personal       =   $request->arr_funcionarios;
        $arr_archivo        =   $request->arr_archivo;
        $arr_observacion    =   $request->arr_observacion;
        $str_html           =   $request->str_observacion_html;
        $fc_actual          =   Date('Y-m-d');
        $nr_estado          =   3; // En Gestion
        $tp_ingreso         =   5; // asignador | administrador
        $encargados         =   [];
        $archivos           =   [];
        $arr_valida         =   [
                                    'error'     =>  0,
                                    'tp_icon'   =>  'success',
                                    'title'     =>  'Asignación de Solicitud',
                                    'msj'       =>  '',
                                ];

        try {
            $solicitud      =   UtilController::getDataSolicitud($nr_solicitud);
            $nr_servicio    =   $solicitud->id_tipo;

            if(count($arr_personal))
            {
                $valida     =   UtilController::validaPermisos($arr_personal);

                if($valida['error'] == 1)
                    return $valida;
            }
            else
            {
                $valida     =   [
                    'error'     =>  1,
                    'tp_icon'   =>  'warning',
                    'title'     =>  'Asignar Solicitud',
                    'msj'       =>  'No se han encontrado funcionarios asignados a la solicitud',
                    'encargado' =>  [],
                    'archivo'   =>  [],
                ];

                return $valida;
            }

            foreach ($arr_personal as $value) {
                $modelo     =   new EncargadoSolicitud();
                $modelo->id_solicitud   =   $nr_solicitud;
                $modelo->id_encargado   =   $value;
                $modelo->fc_asignado    =   $fc_actual;
                $modelo->tp_activo      =   1;
                $modelo->save();
            }

            Solicitud::where('id','=',$nr_solicitud)->update(['id_estado'     =>  $nr_estado]);

            GsutHistoriaController::registrarHistoria($nr_solicitud, $nr_servicio, $str_observacion, $str_html, $nr_estado, $fc_actual, NULL);

            // Carga de archivo
            ArchivosController::registrarArchivo('tb_asignacion', $nr_solicitud, $arr_archivo, $arr_observacion);

            EmailController::enviarNotificaciones($tp_ingreso, $nr_solicitud); // Notificación via mail

            // se obtienen los encargados de la solicitud y archivo
            $encargados     =   self::getEncargadoSolicitud($nr_solicitud);
            $archivos       =   self::getArchivosAsignacion($nr_solicitud);

            $arr_valida     =   [
                                    'error'     =>  0,
                                    'tp_icon'   =>  'success',
                                    'title'     =>  'Asignación de Solicitud',
                                    'msj'       =>  'Se han asignado los funcionarios a la solicitud: "#'.$nr_ticket.'"',
                                    'encargado' =>  $encargados,
                                    'archivo'   =>  $archivos,
                                ];
        } catch (Exception $e) {
            $arr_valida     =   [
                                    'error'     =>  1,
                                    'tp_icon'   =>  'danger',
                                    'title'     =>  'Asignación de Solicitud',
                                    'msj'       =>  'No se ha podido asignar a los funcionarios a la solicitud : "#'.$nr_ticket.'"',
                                    'encargado' =>  [],
                                    'archivo'   =>  [],
                                ];
        }

        return $arr_valida;
    }
    //------------------------------------------------------------
    public static function setQuitarAsignacion($nr_solicitud)
    {
        $realizado  =   0;

        try {
            $arr_personal   =   self::getEncargadoSolicitud($nr_solicitud);

            foreach ($arr_personal as $key => $value) {
                EncargadoSolicitud::
                where('id_solicitud','=',$nr_solicitud)
                ->where('id_encargado','=',$value['id_encargado'])
                ->update([
                    'tp_activo'     =>  0 // Inactivo
                ]);
            }

            $realizado  =   1;
        } catch (Exception $e) {
            $realizado  =   0;
        }

        return $realizado;
    }
    //------------------------------------------------------------
    public static function setAsignarSolicitud($nr_servicio, $nr_solicitud)
    {
        $nr_ticket          =   '';
        $arr_personal       =   [];
        $fc_actual          =   Date('Y-m-d');
        $nr_estado          =   3; // En Gestion
        $encargados         =   [];
        $archivos           =   [];
        $arr_valida         =   [
                                    'error'     =>  0,
                                    'tp_icon'   =>  'success',
                                    'title'     =>  'Asignación de Solicitud',
                                    'msj'       =>  '',
                                ];

        try {
            $solicitud      =   UtilController::getDataSolicitud($nr_solicitud);
            $arr_personal   =   self::getFuncionariosAsignadosToServicio($nr_servicio);

            if($solicitud)
                $nr_ticket  =   $solicitud->nr_ticket;
            
            if(count($arr_personal))
            {
                //  $valida     =   UtilController::validaPermisos($arr_personal);

                //  if($valida['error'] == 1)
                //      return $valida;
            }
            else
            {
                $valida     =   [
                    'error'     =>  1,
                    'tp_icon'   =>  'warning',
                    'title'     =>  'Asignar Solicitud',
                    'msj'       =>  'No se han encontrado funcionarios asignados a la solicitud',
                    'encargado' =>  [],
                    'archivo'   =>  [],
                ];

                return $valida;
            }

            foreach ($arr_personal as $value) {
                $modelo     =   new EncargadoSolicitud();
                $modelo->id_solicitud   =   $nr_solicitud;
                $modelo->id_encargado   =   $value;
                $modelo->fc_asignado    =   $fc_actual;
                $modelo->tp_activo      =   1;
                $modelo->save();
            }

            // se obtienen los encargados de la solicitud y archivo
            $encargados     =   self::getEncargadoSolicitud($nr_solicitud);
            $archivos       =   self::getArchivosAsignacion($nr_solicitud);

            $arr_valida     =   [
                                    'error'     =>  0,
                                    'tp_icon'   =>  'success',
                                    'title'     =>  'Asignación de Solicitud',
                                    'msj'       =>  'Se han asignado los funcionarios a la solicitud: "#'.$nr_ticket.'"',
                                    'encargado' =>  $encargados,
                                    'archivo'   =>  $archivos,
                                ];
        } catch (Exception $e) {
            $arr_valida     =   [
                                    'error'     =>  1,
                                    'tp_icon'   =>  'danger',
                                    'title'     =>  'Asignación de Solicitud',
                                    'msj'       =>  'No se ha podido asignar a los funcionarios a la solicitud : "#'.$nr_ticket.'"',
                                    'encargado' =>  [],
                                    'archivo'   =>  [],
                                ];
        }

        return $arr_valida;
    }
    //------------------------------------------------------------
    public function listadoAsignados(Request $request)
    {
        $nr_servicio    =   $request->nr_servicio;

        $data           =   Tipo::
                            join('gsut_servicio_tiene_usuario as stu','stu.id_servicio','=','gsut_tipo.id')
                            ->join('users as u','u.id','=','stu.id_usuario')
                            ->join('gsut_direccion as dir','dir.id','=','u.id_direccion')
                            ->join('gsut_depto as depto','depto.id','=','u.id_depto')
                            ->select('u.id as value',
                                DB::raw('concat(depto.nm_depto," - ",u.name) as label'),
                                'u.name',
                                'dir.nm_direccion',
                                'depto.nm_depto')
                            ->where('u.tp_activo','=',1)
                            ->where('stu.tp_activo','=',1)
                            ->where('stu.id_servicio','=',$nr_servicio)
                            ->get();

        return ['funcionarios' => $data];
    }
    //------------------------------------------------------------
    public static function getEncargadoSolicitud($nr_solicitud)
    {
        $data   =   [];

        try {
            $encargados     =   EncargadoSolicitud::
                                join('users as u','u.id','=','gsut_encargado_solicitud.id_encargado')
                                ->join('gsut_direccion as dir','dir.id','=','u.id_direccion')
                                ->join('gsut_depto as depto','depto.id','=','u.id_depto')
                                ->select('gsut_encargado_solicitud.id_solicitud',
                                    'gsut_encargado_solicitud.id_encargado',
                                    DB::raw('concat(u.nombre," ",u.ap_paterno," ",u.ap_materno) as nm_funcionario'),
                                    'dir.nm_direccion',
                                    'depto.nm_depto',
                                    'gsut_encargado_solicitud.fc_asignado',
                                    'gsut_encargado_solicitud.tp_activo')
                                ->where('gsut_encargado_solicitud.id_solicitud','=',$nr_solicitud)
                                ->get();

            if($encargados->count())
                $data   =   $encargados->toArray();
        } catch (Exception $e) {
            $data   =   [];
        }

        return $data;
    }
    //-----------------------------------------------------------
    public static function getArchivosAsignacion($nr_solicitud)
    {
        $data   =   [];

        try {
            $archivos   =   Archivos::
                            where('nr_id','=',$nr_solicitud)
                            ->where('tp_tabla','=','tb_asignacion')
                            ->get();

            if($archivos->count())
                $data   =   $archivos->toArray();
        } catch (Exception $e) {
            $data   =   [];
        }

        return $data;
    }
    //------------------------------------------------------------
    public static function getFuncionariosAsignadosToServicio($nr_servicio)
    {
        $arr_funcionarios   =   [];

        try {
            $data   =   ServicioTieneUsuarios::
                        join('users as u','u.id','=','gsut_servicio_tiene_usuario.id_usuario')
                        ->select('u.id')
                        ->where('id_servicio','=',$nr_servicio)
                        ->where('gsut_servicio_tiene_usuario.tp_activo','=',1)
                        ->get();

            if($data->count())
                $arr_funcionarios   =   $data->pluck('id')->toArray();
        } catch (Exception $e) {
            $arr_funcionarios   =   [];
        }

        return $arr_funcionarios;
    }
    //------------------------------------------------------------
    public static function asignarFuncionario(Request $request)
    {
        $tp_activo      =   1;
        $nr_servicio    =   $request->nr_servicio;
        $nm_servicio    =   trim($request->nm_servicio);
        $arr_persona    =   $request->arr_funcionarios;
        $arr_valida     =   [
                                'error'     =>  0,
                                'tp_icon'   =>  'success',
                                'title'     =>  'Registrar Funcionarios al Servicio',
                                'msj'       =>  'Se han registrado los funcionarios al servicio : "'.$nm_servicio.'"',
                            ];

        try {
            if(count($arr_persona))
            {
                foreach ($arr_persona as $value) {
                    $modelo     =   new ServicioTieneUsuarios();
                    $modelo->id_servicio    =   $nr_servicio;
                    $modelo->id_usuario     =   $value;
                    $modelo->tp_activo      =   $tp_activo;
                    $modelo->save();
                }
            }
        } catch (Exception $e) {
            \Log::debug(__METHOD__ . " Error : " . $e->getMessage());
            $arr_valida     =   [
                                    'error'     =>  1,
                                    'tp_icon'   =>  'danger',
                                    'title'     =>  'Registrar Funcionarios al Servicio',
                                    'msj'       =>  'No se ha podido registrar los funcionarios al servicio : "'.$nm_servicio.'"',
                                ];
        }

        return $arr_valida;
    }
    //------------------------------------------------------------
    public static function habilitarSolicitudes(Request $request)
    {
        $arr_solicitudes    =    null;
        $nr_direccion       =   $request->id_direccion; // Direccion Municipal
        $nr_servicio        =   $request->nr_servicio; // Id Servicio
        $nm_servicio        =   trim($request->nm_servicio);
        $arr_persona        =   (isset($request->arr_funcionarios)) ? $request->arr_funcionarios : [];
        $fc_fecha           =   Date("Y-m-d H:i:s");
        $tp_activo          =   1;
        $arr_valida         =   [
                                    'error'     =>  0,
                                    'tp_icon'   =>  'success',
                                    'title'     =>  'Habilitando Solicitudes',
                                    'msj'       =>  'Se han habilitado las solicitudes historicas para los nuevos integrantes del servicio : "'.$nm_servicio.'"',
                                ];

        try {
            $arr_solicitudes    =   self::getSolicitudesServicio($nr_direccion, $nr_servicio);

            if($arr_solicitudes != null)
            {
                if(count($arr_persona))
                {
                    foreach ($arr_persona as $persona) {
                        foreach ($arr_solicitudes as $key => $value) {
                            $modelo     =   new EncargadoSolicitud();
                            $modelo->id_solicitud   =   $value->id;
                            $modelo->id_encargado   =   $persona;
                            $modelo->fc_asignado    =   $fc_fecha;
                            $modelo->tp_activo      =   $tp_activo;
                            $modelo->save();
                        }
                    }
                }
            }
        } catch (Exception $e) {
            \Log::debug(__METHOD__ . " Error : " . $e->getMessage());
            $arr_valida     =   [
                                    'error'     =>  1,
                                    'tp_icon'   =>  'danger',
                                    'title'     =>  'Habilitando Solicitudes',
                                    'msj'       =>  'No se han podido habilitar las solicitudes a los nuevos integrantes del servicio : "'.$nm_servicio.'"',
                                ];
        }

        return $arr_valida;        
    }
    //------------------------------------------------------------
    public static function getSolicitudesServicio($nr_direccion, $nr_servicio)
    {
        $arr_solicitudes    =   null;

        try {
            $data   =   Solicitud::
                        select('id','id_direccion_destino','id_tipo')
                        ->where('id_direccion_destino','=',$nr_direccion)
                        ->where('id_tipo','=',$nr_servicio)
                        ->whereIn('id_estado',[1,2,3,4])
                        ->get();

            if($data->count())
                $arr_solicitudes    =   $data;
        } catch (Exception $e) {
            $arr_solicitudes    =   null;
        }

        return $arr_solicitudes;
    }
    //------------------------------------------------------------
    public function quitarFuncionario(Request $request)
    {
        $nr_direccion   =   $request->id_direccion;
        $nr_servicio    =   $request->nr_servicio;
        $nm_servicio    =   $request->nm_servicio;
        $nr_persona     =   $request->nr_funcionario;
        $nm_persona     =   $request->nm_funcionario;
        $tp_activo      =   0;
        $arr_solicitud  =   null;
        $arr_valida     =   [];

        try {
            ServicioTieneUsuarios::
            where('id_servicio','=',$nr_servicio)
            ->where('id_usuario','=',$nr_persona)
            ->delete();

            $arr_solicitud  =   self::getSolicitudesServicio($nr_direccion, $nr_servicio);

            if($arr_solicitud != null)
            {
                $arr_data   =   collect($arr_solicitud)->pluck('id')->toArray();

                EncargadoSolicitud::
                where('id_encargado','=',$nr_persona)
                ->whereIn('id_solicitud',$arr_data)
                ->delete();
            }

            $arr_valida     =   [
                                    'error'     =>  0,
                                    'tp_icon'   =>  'success',
                                    'title'     =>  'Desasignar Funcionarios del Servicio',
                                    'msj'       =>  'Se ha desasignado al funcionario "'.$nm_persona.'" del servicio "'.$nm_servicio.'"',
                                ];
        } catch (Exception $e) {
            $arr_valida     =   [
                                    'error'     =>  1,
                                    'tp_icon'   =>  'danger',
                                    'title'     =>  'Desasignar Funcionarios del Servicio',
                                    'msj'       =>  'No se ha podido desasignar al funcionario "'.$nm_persona.'" del servicio "'.$nm_servicio.'"',
                                ];
        }

        return $arr_valida;
    }
    //------------------------------------------------------------
}
