<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\User;
use App\Solicitud;
use App\Historial;
use App\Respuesta;
use App\EncuestaTelefonista;

use DB;
use Validator;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Facades\Excel;

use App\Http\Controllers\UtilController;

class EncuestadorController extends Controller
{
    //------------------------------------------------------------
    public function page($tp_destino)
    {
        $destino    =   '';
        $id_usuario =   Auth::user()->id;
        $id_rol     =   Auth::user()->id_rol;
        $rol_actual =   UtilController::getRolActivo($id_usuario);
        $roles      =   UtilController::listarRolesUsuario($id_usuario);

        if($tp_destino === 'inicio')
            $destino = 'encuestador.inicio_encuestador';

        if($tp_destino === 'solicitud')
            $destino = 'encuestador.bandeja_encuestador';

        if($tp_destino === 'llamados')
            $destino = 'encuestador.llamados_encuestador';

        if($tp_destino === 'agendamientos')
            $destino = 'encuestador.bandeja_agendados';

        return view($destino)
                ->with('id_rol',$id_rol)
                ->with('rol_actual',$rol_actual)
                ->with('data',$roles)
                ->with('count',count($roles));
    }
    //------------------------------------------------------------
    public function index(Request $request)
    {
        $id_user        =   Auth::user()->id;
        $id_rol         =   Auth::user()->id_rol;
        $tp_admin       =   Auth::user()->tp_admin;
        $nr_direccion   =   Auth::user()->id_direccion;
        $nr_depto       =   Auth::user()->id_depto;
        $fl_mostrar     =   $request->fl_mostrar;
        $fl_estado      =   $request->fl_estado;
        $fl_direccion   =   $request->fl_direccion;
        $fl_depto       =   $request->fl_depto;
        $fl_servicio    =   $request->fl_servicio;
        $fl_macrozona   =   $request->fl_macrozona;
        $fl_undvecinal  =   $request->fl_unidadvecinal;
        $fl_ticket      =   $request->fl_ticket;
        $fl_vecino      =   $request->fl_persona;
        $fl_motivo      =   $request->fl_motivo;
        $fl_ubicacion   =   $request->fl_ubicacion;
        $tp_criterio    =   $request->tp_criterio;
        $tp_orden       =   $request->tp_orden;
        $page           =   $request->page;
        $fc_desde       =   $request->fc_desde;
        $fc_hasta       =   $request->fc_hasta;
        $tp_validar     =   $request->tp_validar;
        $arr_excluir    =   [51]; // Podas y Arbolado Urbano

        $data           =   Solicitud:: 
                            join('gsut_prioridad as prioridad','prioridad.id','=','gsut_solicitud.id_prioridad')
                            ->join('gsut_motivo as motivo','motivo.id','=','gsut_solicitud.id_motivo')
                            ->join('gsut_tipo as tipo','tipo.id','=','gsut_solicitud.id_tipo')
                            ->join('gsut_estado as estado','estado.id','=','gsut_solicitud.id_estado')
                            ->join('gsut_direccion as dir_destino','dir_destino.id','=','gsut_solicitud.id_direccion_destino')
                            ->join('gsut_depto as depto_destino','depto_destino.id','=','gsut_solicitud.id_depto_destino')
                            ->leftjoin('gsut_macroterritorio as mt','mt.id','=','gsut_solicitud.id_macroterritorio')
                            ->leftjoin('gsut_unidadvecinal as uv','uv.id','=','gsut_solicitud.id_unidadvecinal')
                            ->join('gsut_tipo_ingreso as ti','ti.id','=','gsut_solicitud.tp_ingreso')
                            ->leftjoin('gsut_estado_encuesta as estado_encuesta','estado_encuesta.id','=','gsut_solicitud.id_estado_encuesta')
                            ->select('gsut_solicitud.id',
                                'gsut_solicitud.nr_anio',
                                'gsut_solicitud.nr_mes',
                                'gsut_solicitud.nr_ticket',
                                'gsut_solicitud.id_municipio',
                                'gsut_solicitud.id_direccion',
                                'gsut_solicitud.id_depto',
                                'gsut_solicitud.id_tipo',
                                'gsut_solicitud.nm_tipo',
                                'gsut_solicitud.id_prioridad',
                                'gsut_solicitud.id_motivo',
                                'prioridad.nm_prioridad',
                                'motivo.nm_motivo',
                                'gsut_solicitud.id_direccion_destino',
                                'dir_destino.nm_direccion as nm_direccion_destino',
                                'gsut_solicitud.id_depto_destino',
                                'depto_destino.nm_depto as nm_depto_destino',
                                'gsut_solicitud.id_ubicacion',
                                'gsut_solicitud.id_macroterritorio',
                                'mt.cod_territorio',
                                'gsut_solicitud.id_unidadvecinal',
                                'uv.cod_unidadvecinal',
                                'uv.nm_unidadvecinal',
                                'gsut_solicitud.tp_direccion',
                                'gsut_solicitud.nr_direccion',
                                'gsut_solicitud.nm_direccion',
                                'gsut_solicitud.nm_ubicacion',
                                'gsut_solicitud.str_latitud',
                                'gsut_solicitud.str_longitud',
                                'gsut_solicitud.nr_rut_vecino',
                                'gsut_solicitud.str_observacion',
                                'gsut_solicitud.str_observacion_html',
                                'gsut_solicitud.str_aclaratoria',
                                'gsut_solicitud.tp_visado_mt',
                                'gsut_solicitud.tp_rechazado',
                                'gsut_solicitud.id_estado',
                                'estado.nm_estado',
                                'estado.nm_color',
                                'gsut_solicitud.contexto_municipal',
                                'gsut_solicitud.tp_ingreso',
                                'ti.nm_ingreso',
                                'gsut_solicitud.id_autor',
                                'gsut_solicitud.tp_activo',
                                'gsut_solicitud.id_estado_encuesta',
                                'estado_encuesta.nm_estado as nm_estado_encuesta',
                                'gsut_solicitud.tp_feedback',
                                'gsut_solicitud.tp_recepcion',
                                'gsut_solicitud.tp_satisfaccion',
                                'gsut_solicitud.str_feedback',
                                'gsut_solicitud.fc_creacion as fc_ingreso',
                                'gsut_solicitud.created_at',
                                'gsut_solicitud.fc_publicado',
                                'gsut_solicitud.fc_finalizado',
                                'gsut_solicitud.updated_at as fc_tramitacion')
                            ->selectRaw("(case when tp_vecino = 1 then 'SI' else 'NO' end) as tp_vecino")
                            ->where('gsut_solicitud.tp_activo','=',1)
                            ->whereIn('gsut_solicitud.id_estado',[5,6])
                            // ->whereNotIn('gsut_solicitud.id_tipo',$arr_excluir)
                            ->whereNotIn('gsut_solicitud.id_estado_encuesta',[7])
                            ->whereExists(function ($query) {
                                $query->select(DB::raw('1'))
                                    ->from('gsut_vecino')
                                    ->whereRaw('gsut_vecino.nr_rut = gsut_solicitud.nr_rut_vecino');
                            })
                            ->with('tipo','vecino','publicacion');

        /* ----- Inicio - Filtro por Rol ----- */
            if(in_array($id_rol,[25]))
            {
                if(UtilController::getCantidadTelefonistas() > 1)
                    $data   =   $data->where('gsut_solicitud.id_telefonista','=',$id_user);
                else
                    $data   =   $data->whereRaw('(select count(s.id)
                                                from     gsut_solicitud as s
                                                where    s.tp_activo = 1
                                                    and  s.nr_rut_vecino = gsut_solicitud.nr_rut_vecino
                                                    and  s.nr_anio = gsut_solicitud.nr_anio
                                                    and  s.nr_mes = gsut_solicitud.nr_mes
                                                    and  s.id_estado in (5,6)) <= 1');
            }
        /* ----- Termino - Filtro por Rol ----- */

        /* ----- Inicio Periodo Encuesta - Rango Fecha ----- */
            // $data   =   $data->whereIn('gsut_solicitud.nr_anio',[2025])
            //                 ->whereIn('gsut_solicitud.nr_mes',[10,11,12]);
        /* ----- Termino Periodo Encuesta - Rango Fecha ----- */

        /* ----- Inicio - Filtro ----- */
            if($fl_mostrar != 0)
                $data   =   $data->whereIn('gsut_solicitud.id_estado_encuesta',[$fl_mostrar]);
            else
                $data   =   $data->whereIn('gsut_solicitud.id_estado_encuesta',[1,2,3,6])
                                ->orderBy('gsut_solicitud.id_estado_encuesta','ASC');;

            if(isset($fl_direccion)) 
                $data   =   $data->where('gsut_solicitud.id_direccion_destino','=',$fl_direccion);

            if(isset($fl_depto)) 
                $data   =   $data->where('gsut_solicitud.id_depto_destino','=',$fl_depto);

            if(isset($fl_servicio))
                $data   =   $data->where('gsut_solicitud.id_tipo','=',$fl_servicio);

            if(isset($fl_macrozona))
                $data   =   $data->where('gsut_solicitud.id_macroterritorio','=',$fl_macrozona);

            if(isset($fl_undvecinal))
                $data   =   $data->where('gsut_solicitud.id_unidadvecinal','=',$fl_undvecinal);

            if(isset($fl_ticket))
                $data   =   $data->where('gsut_solicitud.nr_ticket','=',$fl_ticket);

            if(isset($fl_vecino))
                $data   =   $data->where('gsut_solicitud.nr_rut_vecino','=',$fl_vecino);

            if(isset($fl_motivo))
                $data   =   $data->where('gsut_solicitud.id_motivo','=',$fl_motivo);

            if(isset($fl_ubicacion))
                $data   =   $data->where('gsut_solicitud.id_ubicacion','=',$fl_ubicacion);
        /* ----- Termino - Filtro ----- */

        /*----- Inicio - Orden por Campos -----*/
            if(in_array($tp_criterio, ['id','id_macroterritorio','id_unidadvecinal','created_at']))
                $data   =   $data->orderBy('gsut_solicitud.'.$tp_criterio, $tp_orden);

            if($tp_criterio === 'nm_direccion')
                $data   =   $data->orderBy('dir_destino.nm_direccion',$tp_orden);

            if($tp_criterio === 'nm_depto')
                $data   =   $data->orderBy('depto_destino.nm_depto',$tp_orden);

            if($tp_criterio === 'nm_estado')
                $data   =   $data->orderBy('estado.nm_estado',$tp_orden);
        /*----- Termino - Orden por Campos -----*/

        if(in_array($id_rol,[25]))
        {
            if(UtilController::getCantidadTelefonistas() > 1)
                $data   =   $data->paginate(20);
            else 
                $data   =   $data->groupBy('gsut_solicitud.nr_anio','gsut_solicitud.nr_mes','gsut_solicitud.nr_rut_vecino')->paginate(20);
        }
        else
            $data   =   $data->paginate(20);

        $data->getCollection()->transform(function ($value) use ($id_rol, $tp_admin) {
            $value->tiempo_tramitado        =   UtilController::getTiempoTramitacion($value->fc_ingreso, $value->fc_publicado, $value->id_estado);
            $value->contactos_realizados    =   UtilController::cantidadContactosRealizados($value->nr_rut_vecino);
            $value->verificar_nro_contacto  =   (UtilController::verificarContactoVecino($value->nr_rut_vecino) == 1) ? "SI" : "NO";
            $value->llamados_realizados     =   UtilController::cantidadLlamadosRealizados($value->nr_rut_vecino);
            $value->tiene_obs_encuesta      =   (UtilController::isTicketTieneObservacionEncuesta($value->id) == 1) ? "SI" : "NO";
            return $value;
        });

        return [
            'pagination' => [
                'total'         =>  $data->total(),
                'current_page'  =>  $data->currentPage(),
                'per_page'      =>  $data->perPage(),
                'last_page'     =>  $data->lastPage(),
                'from'          =>  $data->firstItem(),
                'to'            =>  $data->lastItem(),
            ],
            'info' => $data,
            'nr_atendidos'      =>  UtilController::getCantidadTicketAtendidosPorTelefonista($id_user),
            'nr_pendientes'     =>  UtilController::getCantidadSolicitudTelefonistasEstado($id_user, 1),
            'nr_nocontactado'   =>  UtilController::getCantidadSolicitudTelefonistasEstado($id_user, 6),
            'nr_agendados'      =>  UtilController::getCantidadTicketAgendadosporFecha(Date('Y-m-d')),
        ];
    }
    //------------------------------------------------------------
    public function index_telefonistas(Request $request)
    {
        $nr_anio    =   (isset($request->nr_anio)) ? $request->nr_anio : 0;
        $nr_mes     =   (isset($request->nr_mes)) ? $request->nr_mes : 0;
        $nr_dia     =   (isset($request->nr_dia)) ? $request->nr_dia : 0;
        $arr_attr   =   (Object) [
                            'nr_anio'   =>  (isset($nr_anio)) ? $nr_anio : 0,
                            'nr_mes'    =>  (isset($nr_mes)) ?  $nr_mes : 0,
                            'nr_dia'    =>  (isset($nr_dia)) ? $nr_dia : 0,
                        ];

        $data   =   EncuestaTelefonista::
                    join('users as telefonista','telefonista.id','=','gsut_encuesta_telefonistas.id_telefonista')
                    ->select('gsut_encuesta_telefonistas.id',
                        'gsut_encuesta_telefonistas.id_telefonista',
                        'gsut_encuesta_telefonistas.nr_cantidad',
                        'telefonista.nombre',
                        'telefonista.ap_paterno',
                        'telefonista.ap_materno',
                        'telefonista.email as nm_email',
                        'telefonista.movil as nr_movil',
                        DB::raw('concat(telefonista.nombre," ",telefonista.ap_paterno," ",telefonista.ap_materno) as nm_telefonista'),
                        DB::raw('(case when gsut_encuesta_telefonistas.tp_activo=1 then "Habilitado" else "Deshabilitado" end) as nm_estado'),
                        'gsut_encuesta_telefonistas.tp_activo');

        $data   =   $data->groupBy('gsut_encuesta_telefonistas.id')->paginate(20);
        
        $data->getCollection()->transform(function ($value) use ($arr_attr) {
            $value->cant_ticket         =   UtilController::getCantidadEncuestasRealizadas(21, $value->id_telefonista, $arr_attr);
            $value->cant_pendientes     =   UtilController::getCantidadEncuestasRealizadas(1, $value->id_telefonista, $arr_attr);
            $value->cant_parciales      =   UtilController::getCantidadEncuestasRealizadas(2, $value->id_telefonista, $arr_attr);
            $value->cant_reagendados    =   UtilController::getCantidadEncuestasRealizadas(3, $value->id_telefonista, $arr_attr);
            $value->cant_rechazados     =   UtilController::getCantidadEncuestasRealizadas(4, $value->id_telefonista, $arr_attr);
            $value->cant_no_contactados =   UtilController::getCantidadEncuestasRealizadas(6, $value->id_telefonista, $arr_attr);
            $value->cant_atendidos      =   UtilController::getCantidadEncuestasRealizadas(20, $value->id_telefonista, $arr_attr);
            $value->cant_terminados     =   UtilController::getCantidadEncuestasRealizadas(5, $value->id_telefonista, $arr_attr);
            return $value;
        });
        
        return [
            'pagination' => [
                'total'        => $data->total(),
                'current_page' => $data->currentPage(),
                'per_page'     => $data->perPage(),
                'last_page'    => $data->lastPage(),
                'from'         => $data->firstItem(),
                'to'           => $data->lastItem(),
            ],
            'info'      => $data,
            'nr_cantidad_ticket'    =>  UtilController::getCantidadSolicitudTelefonistasEstado(0,1),
        ];
    }
    //------------------------------------------------------------
    public function index_agendados(Request $request)
    {
        $id_user        =   Auth::user()->id;
        $id_rol         =   Auth::user()->id_rol;
        $tp_admin       =   Auth::user()->tp_admin;
        $nr_direccion   =   Auth::user()->id_direccion;
        $nr_depto       =   Auth::user()->id_depto;
        $fl_mostrar     =   $request->fl_mostrar;
        $fl_estado      =   $request->fl_estado;
        $fl_direccion   =   $request->fl_direccion;
        $fl_depto       =   $request->fl_depto;
        $fl_servicio    =   $request->fl_servicio;
        $fl_macrozona   =   $request->fl_macrozona;
        $fl_undvecinal  =   $request->fl_unidadvecinal;
        $fl_ticket      =   $request->fl_ticket;
        $fl_vecino      =   $request->fl_persona;
        $fl_motivo      =   $request->fl_motivo;
        $fl_ubicacion   =   $request->fl_ubicacion;
        $tp_criterio    =   $request->tp_criterio;
        $tp_orden       =   $request->tp_orden;
        $page           =   $request->page;
        $fc_buscar      =   $request->fc_buscar;
        $fc_desde       =   $request->fc_desde;
        $fc_hasta       =   $request->fc_hasta;
        $tp_validar     =   $request->tp_validar;
        $arr_excluir    =   [51]; // Podas y Arbolado Urbano

        $fc_buscar      =   Carbon::parse($fc_buscar)->format('Y-m-d');

        $data           =   Solicitud:: 
                            join('gsut_prioridad as prioridad','prioridad.id','=','gsut_solicitud.id_prioridad')
                            ->join('gsut_motivo as motivo','motivo.id','=','gsut_solicitud.id_motivo')
                            ->join('gsut_tipo as tipo','tipo.id','=','gsut_solicitud.id_tipo')
                            ->join('gsut_estado as estado','estado.id','=','gsut_solicitud.id_estado')
                            ->join('gsut_direccion as dir_destino','dir_destino.id','=','gsut_solicitud.id_direccion_destino')
                            ->join('gsut_depto as depto_destino','depto_destino.id','=','gsut_solicitud.id_depto_destino')
                            ->leftjoin('gsut_macroterritorio as mt','mt.id','=','gsut_solicitud.id_macroterritorio')
                            ->leftjoin('gsut_unidadvecinal as uv','uv.id','=','gsut_solicitud.id_unidadvecinal')
                            ->join('gsut_tipo_ingreso as ti','ti.id','=','gsut_solicitud.tp_ingreso')
                            ->leftjoin('gsut_estado_encuesta as estado_encuesta','estado_encuesta.id','=','gsut_solicitud.id_estado_encuesta')
                            ->select('gsut_solicitud.id',
                                'gsut_solicitud.nr_anio',
                                'gsut_solicitud.nr_mes',
                                'gsut_solicitud.nr_ticket',
                                'gsut_solicitud.id_municipio',
                                'gsut_solicitud.id_direccion',
                                'gsut_solicitud.id_depto',
                                'gsut_solicitud.id_tipo',
                                'gsut_solicitud.nm_tipo',
                                'gsut_solicitud.id_prioridad',
                                'gsut_solicitud.id_motivo',
                                'prioridad.nm_prioridad',
                                'motivo.nm_motivo',
                                'gsut_solicitud.id_direccion_destino',
                                'dir_destino.nm_direccion as nm_direccion_destino',
                                'gsut_solicitud.id_depto_destino',
                                'depto_destino.nm_depto as nm_depto_destino',
                                'gsut_solicitud.id_ubicacion',
                                'gsut_solicitud.id_macroterritorio',
                                'mt.cod_territorio',
                                'gsut_solicitud.id_unidadvecinal',
                                'uv.cod_unidadvecinal',
                                'uv.nm_unidadvecinal',
                                'gsut_solicitud.tp_direccion',
                                'gsut_solicitud.nr_direccion',
                                'gsut_solicitud.nm_direccion',
                                'gsut_solicitud.nm_ubicacion',
                                'gsut_solicitud.str_latitud',
                                'gsut_solicitud.str_longitud',
                                'gsut_solicitud.nr_rut_vecino',
                                'gsut_solicitud.str_observacion',
                                'gsut_solicitud.str_observacion_html',
                                'gsut_solicitud.str_aclaratoria',
                                'gsut_solicitud.tp_visado_mt',
                                'gsut_solicitud.tp_rechazado',
                                'gsut_solicitud.id_estado',
                                'estado.nm_estado',
                                'estado.nm_color',
                                'gsut_solicitud.contexto_municipal',
                                'gsut_solicitud.tp_ingreso',
                                'ti.nm_ingreso',
                                'gsut_solicitud.id_autor',
                                'gsut_solicitud.tp_activo',
                                'gsut_solicitud.id_estado_encuesta',
                                'estado_encuesta.nm_estado as nm_estado_encuesta',
                                'gsut_solicitud.tp_feedback',
                                'gsut_solicitud.tp_recepcion',
                                'gsut_solicitud.tp_satisfaccion',
                                'gsut_solicitud.str_feedback',
                                'gsut_solicitud.fc_creacion as fc_ingreso',
                                'gsut_solicitud.created_at',
                                'gsut_solicitud.fc_publicado',
                                'gsut_solicitud.fc_finalizado',
                                'gsut_solicitud.updated_at as fc_tramitacion')
                            ->selectRaw("(case when tp_vecino = 1 then 'SI' else 'NO' end) as tp_vecino")
                            ->where('gsut_solicitud.tp_activo','=',1)
                            ->whereIn('gsut_solicitud.id_estado',[5,6])
                            ->whereNotIn('gsut_solicitud.id_tipo',$arr_excluir)
                            ->whereExists(function ($query) {
                                $query->select(DB::raw('1'))
                                    ->from('gsut_vecino')
                                    ->whereRaw('gsut_vecino.nr_rut = gsut_solicitud.nr_rut_vecino');
                            })
                            ->whereExists(function ($query) use ($fc_buscar) {
                                $query->select(DB::raw('1'))
                                    ->from('gsut_encuesta_llamada as llamada')
                                    ->join('gsut_encuesta_respuestas as respuesta','respuesta.id_llamada','=','llamada.id')
                                    ->join('gsut_encuesta_pregunta as pregunta','pregunta.id','=','respuesta.id_pregunta')
                                    ->whereColumn('llamada.id_solicitud', 'gsut_solicitud.id')
                                    ->whereRaw('gsut_solicitud.id_estado_encuesta = 3')
                                    ->whereRaw('gsut_solicitud.id = llamada.id_solicitud')
                                    ->whereRaw('pregunta.tp_pregunta = 4')
                                    ->where(DB::raw('date_format(respuesta.nm_alternativa,"%Y-%m-%d")'),'=',$fc_buscar)
                                    ->whereNotExists(function ($query) use ($fc_buscar) {
                                        $query->select(DB::raw(1))
                                            ->from('gsut_encuesta_llamada as llamada2')
                                            ->join('gsut_encuesta_respuestas as respuesta2','respuesta2.id_llamada','=','llamada2.id')
                                            ->whereColumn('llamada2.id_solicitud', 'llamada.id_solicitud')
                                            ->where(DB::raw('date_format(respuesta2.nm_alternativa,"%Y-%m-%d")'),'>',$fc_buscar);
                                    });
                            })
                            ->with('tipo','vecino','publicacion','agendados');

        /* ----- Inicio - Filtro por Rol ----- */
            if(in_array($id_rol,[25]))
            {
                if(UtilController::getCantidadTelefonistas() > 1)
                    $data   =   $data->where('gsut_solicitud.id_telefonista','=',$id_user);
            }
        /* ----- Termino - Filtro por Rol ----- */

        /* ----- Inicio - Filtro ----- */
            if($fl_mostrar != 0)
                $data   =   $data->whereIn('gsut_solicitud.id_estado_encuesta',[$fl_mostrar]);
            else
                $data   =   $data->whereIn('gsut_solicitud.id_estado_encuesta',[1,2,3,6])
                                ->orderBy('gsut_solicitud.id_estado_encuesta','ASC');;

            if(isset($fl_direccion)) 
                $data   =   $data->where('gsut_solicitud.id_direccion_destino','=',$fl_direccion);

            if(isset($fl_depto)) 
                $data   =   $data->where('gsut_solicitud.id_depto_destino','=',$fl_depto);

            if(isset($fl_servicio))
                $data   =   $data->where('gsut_solicitud.id_tipo','=',$fl_servicio);

            if(isset($fl_macrozona))
                $data   =   $data->where('gsut_solicitud.id_macroterritorio','=',$fl_macrozona);

            if(isset($fl_undvecinal))
                $data   =   $data->where('gsut_solicitud.id_unidadvecinal','=',$fl_undvecinal);

            if(isset($fl_ticket))
                $data   =   $data->where('gsut_solicitud.nr_ticket','=',$fl_ticket);

            if(isset($fl_vecino))
                $data   =   $data->where('gsut_solicitud.nr_rut_vecino','=',$fl_vecino);

            if(isset($fl_motivo))
                $data   =   $data->where('gsut_solicitud.id_motivo','=',$fl_motivo);

            if(isset($fl_ubicacion))
                $data   =   $data->where('gsut_solicitud.id_ubicacion','=',$fl_ubicacion);
        /* ----- Termino - Filtro ----- */

        /*----- Inicio - Orden por Campos -----*/
            if(in_array($tp_criterio, ['id','id_macroterritorio','id_unidadvecinal','created_at']))
                $data   =   $data->orderBy('gsut_solicitud.'.$tp_criterio, $tp_orden);

            if($tp_criterio === 'nm_direccion')
                $data   =   $data->orderBy('dir_destino.nm_direccion',$tp_orden);

            if($tp_criterio === 'nm_depto')
                $data   =   $data->orderBy('depto_destino.nm_depto',$tp_orden);

            if($tp_criterio === 'nm_estado')
                $data   =   $data->orderBy('estado.nm_estado',$tp_orden);
        /*----- Termino - Orden por Campos -----*/

        $data   =   $data->paginate(20);

        $data->getCollection()->transform(function ($value) use ($id_rol, $tp_admin) {
            $value->tiempo_tramitado        =   UtilController::getTiempoTramitacion($value->fc_ingreso, $value->fc_publicado, $value->id_estado);
            $value->contactos_realizados    =   UtilController::cantidadContactosRealizados($value->nr_rut_vecino);
            $value->verificar_nro_contacto  =   (UtilController::verificarContactoVecino($value->nr_rut_vecino) == 1) ? "SI" : "NO";
            $value->llamados_realizados     =   UtilController::cantidadLlamadosRealizados($value->nr_rut_vecino);
            $value->tiene_obs_encuesta      =   (UtilController::isTicketTieneObservacionEncuesta($value->id) == 1) ? "SI" : "NO";
            return $value;
        });

        return [
            'pagination' => [
                'total'         =>  $data->total(),
                'current_page'  =>  $data->currentPage(),
                'per_page'      =>  $data->perPage(),
                'last_page'     =>  $data->lastPage(),
                'from'          =>  $data->firstItem(),
                'to'            =>  $data->lastItem(),
            ],
            'info' => $data,
            'nr_agendados'      => $data->total()
        ];
    }
    //------------------------------------------------------------
    public function store(Request $request)
    {
        $nr_telefonista     =   $request->nr_telefonista;
        $nm_telefonista     =   $request->nm_telefonista;
        $nr_cantidad        =   0;
        $nr_autor           =   Auth::user()->id;
        $tp_activo          =   1;
        $str_title          =   'Agregar Telefonista a la Encuesta de Servicio';
        $str_msj            =   '';
        $arr_valida         =   ['error' => 0, 'tp_icon' => 'success', 'title' => $str_title, 'msj' => ''];
        $model              =   null;

        if($this->existeTelefonista($request))
        {
            $str_msj        =   'El telefonista "'.$nm_telefonista.'", ya se encuentra registrado"';
            $arr_valida     =   [
                                    'error'     =>  0, 
                                    'tp_icon'   =>  'warning', 
                                    'title'     =>  $str_title, 
                                    'msj'       =>  $str_msj,
                                ];
        }
        else
        {
            $arr_datos          =   [
                                        'id_telefonista'    =>  $nr_telefonista,
                                        'nr_cantidad'       =>  $nr_cantidad,
                                        'id_autor'          =>  $nr_autor,
                                        'tp_activo'         =>  $tp_activo
                                    ];

            $model              =   EncuestaTelefonista::create($arr_datos);

            if($model->id)
            {
                $str_msj        =   'Se ha habilitado al telefonista "'.$nm_telefonista.'" para la realizar la "Encuesta de Servicio de Atención Vecino"';
                $arr_valida     =   [
                                        'error'     =>  0, 
                                        'tp_icon'   =>  'success', 
                                        'title'     =>  $str_title, 
                                        'msj'       =>  $str_msj,
                                    ];
            }
            else
            {
                $str_msj        =   'Ha ocurrido un problema al habilitar al telefonista "'.$nm_telefonista.'"';
                $arr_valida     =   [
                                        'error'     =>  0, 
                                        'tp_icon'   =>  'warning', 
                                        'title'     =>  $str_title, 
                                        'msj'       =>  $str_msj,
                                    ];
            }
        }

        return $arr_valida;
    }
    //------------------------------------------------------------
    public function delete(Request $request)
    {
        $nr_telefonista     =   $request->nr_telefonista;
        $nm_telefonista     =   $request->nm_telefonista;
        $str_title          =   'Quitar Telefonista de la Encuesta de Servicio';
        $str_msj            =   '';
        $arr_valida         =   ['error' => 0, 'tp_icon' => 'success', 'title' => $str_title, 'msj' => ''];

        if($this->existeTelefonista($request))
        {
            EncuestaTelefonista::where('id_telefonista','=',$nr_telefonista)->delete();

            Solicitud::where('id_telefonista','=',$nr_telefonista)
            ->whereIn('id_estado_encuesta',[1,2,3,6])
            ->update([
                'id_telefonista'        =>  0
            ]);

            $str_msj        =   'Se ha retirado al telefonista "'.$nm_telefonista.'" de la "Encuesta de Servicio de Atención Vecino"';
            $arr_valida     =   [
                                    'error'     =>  0, 
                                    'tp_icon'   =>  'success', 
                                    'title'     =>  $str_title, 
                                    'msj'       =>  $str_msj,
                                ];
        }
        else 
        {
            $str_msj        =   'Ha ocurrido un problema al retirar al telefonista "'.$nm_telefonista.'" de la "Encuesta de Servicio de Atención Vecino"';
            $arr_valida     =   [
                                    'error'     =>  0, 
                                    'tp_icon'   =>  'warning', 
                                    'title'     =>  $str_title, 
                                    'msj'       =>  $str_msj,
                                ];
        }

        return $arr_valida;
    }
    //------------------------------------------------------------
    public function existeTelefonista(Request $request)
    {
        $nr_telefonista     =   $request->nr_telefonista;
        $nr_valida          =   0;

        $data   =   EncuestaTelefonista::where('id_telefonista','=',$nr_telefonista)->get();

        if($data->count())
            $nr_valida  =   1;

        return $nr_valida;
    }
    //------------------------------------------------------------
    public function getHistorial(Request $request)
    {
        $id_solicitud       =   $request->id_solicitud;
        $respuestas         =   $this->getRespuestas($id_solicitud);

        $data   =   Historial::
                    join('gsut_solicitud as solicitud','solicitud.id','=','gsut_historial.id_solicitud')
                    ->join('users as autor','autor.id','=','gsut_historial.id_autor')
                    ->join('gsut_direccion as dir','dir.id','=','gsut_historial.id_direccion')
                    ->join('gsut_depto as depto','depto.id','=','gsut_historial.id_depto')
                    ->join('gsut_estado as estado','estado.id','=','gsut_historial.id_estado')
                    ->leftjoin('gsut_vecino as vecino','vecino.nr_rut','=','solicitud.nr_rut_vecino')
                    ->join('gsut_prioridad as prioridad','prioridad.id','=','solicitud.id_prioridad')
                    ->join('gsut_tipo as tipo','tipo.id','=','gsut_historial.id_tipo')
                    ->select('gsut_historial.id',
                        'tipo.nm_tipo',
                        'gsut_historial.id_solicitud',
                        'gsut_historial.nr_historia',
                        'solicitud.id_direccion',
                        'solicitud.nr_ticket',
                        'solicitud.tp_feedback',
                        DB::raw('date_format(solicitud.fc_feedback, "%d-%m-%Y %H:%i") as fc_feedback'),
                        'solicitud.str_feedback',
                        'solicitud.tp_recepcion',
                        'solicitud.tp_satisfaccion',
                        'solicitud.tp_feedback_vecino',
                        DB::raw('date_format(solicitud.fc_feedback_vecino, "%d-%m-%Y %H:%i") as fc_feedback_vecino'),
                        'solicitud.tp_satisfaccion_vecino',
                        'solicitud.str_feedback_vecino',
                        'solicitud.id_direccion_destino',
                        'solicitud.id_estado as id_estado_solicitud',
                        'prioridad.id as id_prioridad_solicitud',
                        'prioridad.nm_prioridad as nm_prioridad_solicitud',
                        DB::raw('concat(autor.nombre," ",autor.ap_paterno," ",autor.ap_materno) as nm_autor'),
                        DB::raw('concat(vecino.nm_vecino," ",vecino.ap_paterno," ",vecino.ap_materno) as nm_vecino'),
                        'dir.nm_direccion',
                        'depto.nm_depto',
                        DB::raw('date_format(gsut_historial.fc_inicio, "%d-%m-%Y %H:%i") as fc_inicio'),
                        DB::raw('date_format(gsut_historial.fc_termino, "%d-%m-%Y %H:%i") as fc_termino'),
                        DB::raw('(case when gsut_historial.fc_termino
                                        then timestampdiff(day, gsut_historial.fc_inicio, gsut_historial.fc_termino) 
                                        else timestampdiff(day, gsut_historial.fc_inicio, now()) 
                                        end) as fc_diferencia'),
                        'gsut_historial.str_observacion',
                        'gsut_historial.str_observacion_html',
                        'solicitud.str_observacion as str_sol_observacion',
                        'solicitud.str_observacion_html as str_solicitud_html',
                        'gsut_historial.id_estado',
                        'gsut_historial.id_accion',
                        'solicitud.tp_visado_mt',
                        'solicitud.tp_rechazado',
                        'estado.nm_estado',
                        'gsut_historial.tp_activo')                    
                    ->where('gsut_historial.tp_activo','=','1')
                    ->where('gsut_historial.id_solicitud','=',$id_solicitud)
                    ->orderBy('gsut_historial.nr_historia')
                    ->get();

        

        return ['arr_historial' => $data,'arr_respuestas'=>$respuestas];
    }
    //------------------------------------------------------------
    public function getRespuestas($id_solicitud)
    {
        $data   =   Respuesta::
                    select('gsut_respuesta.id',
                        'gsut_respuesta.id_solicitud',
                        'gsut_respuesta.id_autor',
                        'gsut_respuesta.fc_ingreso',
                        'gsut_respuesta.str_observacion',
                        'gsut_respuesta.str_observacion_html',
                        'gsut_respuesta.id_historia',
                        'gsut_respuesta.str_ruta_adjunto',
                        'depto.nm_depto',
                        'dir.nm_direccion',
                        'gsut_respuesta.tp_validado',
                        'gsut_respuesta.tp_activo',
                        'gsut_respuesta.tp_respuesta')
                    ->selectRaw("(case 
                        when tp_respuesta = 1 then 'Publicación Definitiva' 
                        when tp_respuesta = 2 then 'Publicación Parcial' 
                        when tp_respuesta = 3 then 'Pre-Publicación Definitiva' 
                        when tp_respuesta = 4 then 'Pre-Publicación Parcial' 
                        when tp_respuesta = 5 then 'Pre-Publicación Definitiva Rechazada' 
                        when tp_respuesta = 6 then 'Pre-Publicación Parcial Rechazada' 
                        else 'Respuesta Interna' end) as nm_respuesta")
                    ->selectRaw('CONCAT(nombre," ",ap_paterno) as usuario')
                    ->join('users as autor','autor.id','=','gsut_respuesta.id_autor')
                    ->join('gsut_direccion as dir','dir.id','=','autor.id_direccion')
                    ->join('gsut_depto as depto','depto.id','=','autor.id_depto')
                    ->with('archivos')
                    ->where('id_solicitud','=',$id_solicitud)
                    ->whereIn('gsut_respuesta.tp_respuesta',[1])
                    ->where('gsut_respuesta.tp_activo','=',1)
                    ->orderBy('gsut_respuesta.created_at','asc')
                    ->get();

        return $data;
    }
    //------------------------------------------------------------
}
