<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\ApiUser;
use App\LogApiActividad;

class LogController extends Controller
{
    //------------------------------------------------------------
    public function iniciarLog($request, $method)
    {
        $model  =   null;

        try {
            $api_endpoint       =   $request->path();
            $api_token          =   $request->attributes->get('api-token');
            $request_payload    =   json_encode($request->all());
            $ip_address         =   $request->ip();
            $nr_user            =   $this->getApiUserIdToToken($api_token);
            $arr_data           =   [
                                        'api_user_id'       =>  $nr_user,
                                        'ip_address'        =>  $ip_address,
                                        'method'            =>  $method,
                                        'api_endpoint'      =>  $api_endpoint,
                                        'request_payload'   =>  $request_payload
                                    ];
            $model  =   LogApiActividad::create($arr_data);
        } catch (Exception $e) {
            $model  =   null;
        }

        return  $model;
    }
    //------------------------------------------------------------
    public function finalizarLog($data_log, $status, $payload, $startTime)
    {
        // Marca el tiempo de termino
        $endTime    =   microtime(true);

        // Calcula la duración
        $duration   =   $endTime - $startTime;

        // Se registran parametros de Log
        if($data_log) {
            $data_log->response_status      =   $status;
            $data_log->response_payload     =   json_encode($payload);
            $data_log->duration             =   $duration;
            $data_log->save();
        }
    }
    //------------------------------------------------------------
    public function getApiUserIdToToken($api_token)
    {
        $nr_id  =   0;

        try {
            $data   =   ApiUser::where('api_token', $api_token)->get();
            if($data->count())
                $nr_id  =   $data->first()->id;
        } catch (Exception $e) {
            $nr_id  =   0;
        }
        return  $nr_id;
    }
    //------------------------------------------------------------
}
