<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Solicitud;
use DB;
use Validator;
use Freshwork\ChileanBundle\Rut;
use Illuminate\Support\Facades\Auth;
use App\Prioridad;
use App\Vecino;
use App\Direccion;
use App\UnidadVecinal;
use App\User;
use App\Tipo;
use App\Historial;

use App\Http\Requests\SolicitudRequest;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Session;

//Controladores
use App\Http\Controllers\GsutTipoController;
use App\Http\Controllers\GsutPrioridadController;
use App\Http\Controllers\EmailController;
use App\Http\Controllers\MaestroDireccionesController;
use App\Http\Controllers\DireccionMunicipalController;
use App\Http\Controllers\UtilController;
use App\Http\Controllers\GsutFlujoController;

class MacroZonaController extends Controller
{
    public function visacion(Request $request)
    {
            $fc_inicio          =   Date("Y-m-d H:i:s");
            $nr_id              =   $request->nr_id;
            $opcion             =   $request->opcion;
            $str_observacion    =   $request->str_observacion;
            $str_html           =   $request->str_observacion_html;
            $msj                =   'Visación Exitosa';
            $encargados         =   [];
            $archivos           =   [];

            $data_solicitud     =   UtilController::getDataSolicitud($nr_id);
            $nr_tipo            =   $data_solicitud->id_tipo;
            $nr_ticket          =   $data_solicitud->nr_ticket;
            $data_servicio      =   Tipo::where('id','=',$nr_tipo)->first();            

            if(!$data_solicitud)
                return 1;

            $id_direccion   = $data_solicitud->id_direccion_destino;
            $id_depto       = $data_solicitud->id_depto_destino;

            if($opcion == 2)
            {
                if($data_servicio->tp_asignacion == 1)
                    GsutHistoriaController::registrarHistoria($nr_id, $data_solicitud->id_tipo, $str_observacion, $str_html, $opcion, $fc_inicio, NULL);
                else
                {
                    $opcion  =   3;
                    AsignadorController::setAsignarSolicitud($nr_tipo, $nr_id);
                    GsutHistoriaController::registrarHistoria($nr_id, $data_solicitud->id_tipo, $str_observacion, $str_html, $opcion, $fc_inicio, NULL); // Estado 2 visado macro zona

                    // se obtienen los encargados de la solicitud y archivo
                    $encargados     =   AsignadorController::getEncargadoSolicitud($nr_id);
                    $archivos       =   AsignadorController::getArchivosAsignacion($nr_id);
                }
            }

            if($opcion == 7)
                GsutHistoriaController::registrarHistoria($nr_id, $data_solicitud->id_tipo, $str_observacion, $str_html, $opcion, $fc_inicio, $fc_inicio); 

            Solicitud::
            where('id','=',$nr_id)
            ->update([
                'id_estado'      => $opcion,
                'fc_visado_mt'  => $fc_inicio,
                'tp_visado_mt'  => 1
            ]);

            $msj    =   'Se ha realizado la visación de la Solicitud <strong>#'.$nr_ticket.'</strong>';


            EmailController::enviarNotificaciones($opcion, $nr_id);

            if($opcion == 7)
            {
                $msj = 'Se ha rechazado la Solicitud <strong>#'.$nr_ticket.'</strong>';

                EmailController::enviarNotificacionVecino(105, $nr_id, $str_observacion); // 105. Notificación de anulación de solicitud
            }

            return [
                    'error'     =>  0,
                    'existe'    =>  1,
                    'tp_icon'   =>  'success',
                    'title'     =>  'Visación de Solicitud',
                    'msj'       =>  $msj,
                    'encargado' =>  $encargados,
                    'archivo'   =>  $archivos,
                ];
    }

    public function updateSolicitud(Request $request)
    {
        $tp_consulta        =   $request->tp_consulta;
        $id_solicitud       =   $request->id_consulta;
        $nr_motivo          =   $request->nr_motivo;
        $nr_prioridad       =   $request->nr_prioridad;
        $arr_archivo        =   $request->arr_archivo;
        $arr_observacion    =   $request->arr_observacion;
        $fc_fecha           =   Date('Y-m-d');
        $id_estado          =   1; // ingresado - Por visar
        $arr_valida         =   [];
        
        try {
            $arr_valida     =   [
                                    'error'     =>  0,
                                    'existe'    =>  1,
                                    'tp_icon'   =>  'success',
                                    'title'     =>  'Actualizar Solicitud',
                                    'msj'       =>  'Se realiza actualización de la solicitud',
                                ];

            $info   =   [
                        'id_motivo'             =>  $nr_motivo,                                         // form
                        'id_prioridad'          =>  $nr_prioridad,                                      // form
                    ];

            $model  =   Solicitud::
                        where('id','=',$id_solicitud)
                        ->update($info);

            // Carga de archivo
            ArchivosController::registrarArchivo('tb_solicitud', $id_solicitud, $arr_archivo, $arr_observacion);

            $msj    =   'Se ha registrado la solicitud Correctamente';            
        } catch (Exception $e) {
            $arr_valida     =   [
                                    'error'     =>  1,
                                    'existe'    =>  0,
                                    'tp_icon'   =>  'danger',
                                    'title'     =>  'Actualizar Solicitud',
                                    'msj'       =>  'Ha ocurrido un error al actualizar la solicitud',
                                ];
        }

        return $arr_valida;
    }

    public function indexMacroZona(Request $request)
    {
        $id_user        =   Auth::user()->id;
        $id_rol         =   Auth::user()->id_rol;
        $tp_admin       =   Auth::user()->tp_admin;
        $nr_direccion   =   Auth::user()->id_direccion;
        $nr_depto       =   Auth::user()->id_depto;
        $fl_mostrar     =   $request->fl_mostrar;
        $fl_direccion   =   $request->fl_direccion;
        $fl_depto       =   $request->fl_depto;
        $fl_servicio    =   $request->fl_servicio;
        $fl_macrozona   =   $request->fl_macrozona;
        $fl_undvecinal  =   $request->fl_unidadvecinal;
        $fl_ticket      =   $request->fl_ticket;
        $fl_ingreso     =   $request->fl_ingreso;
        $fl_vecino      =   $request->fl_persona;
        $fl_motivo      =   $request->fl_motivo;
        $fl_ubicacion   =   $request->fl_ubicacion;
        $tp_criterio    =   $request->tp_criterio;
        $tp_orden       =   $request->tp_orden;
        $page           =   $request->page;
        $fc_desde       =   $request->fc_desde;
        $fc_hasta       =   $request->fc_hasta;
        $tp_validar     =   $request->tp_validar;
        $propias        =   $request->input('propias',0);

        $data           =   Solicitud:: 
                            join('gsut_prioridad as prioridad','prioridad.id','=','gsut_solicitud.id_prioridad')
                            ->join('gsut_motivo as motivo','motivo.id','=','gsut_solicitud.id_motivo')
                            ->join('gsut_tipo as tipo','tipo.id','=','gsut_solicitud.id_tipo')
                            ->join('gsut_estado as estado','estado.id','=','gsut_solicitud.id_estado')
                            ->join('gsut_direccion as dir_destino','dir_destino.id','=','gsut_solicitud.id_direccion_destino')
                            ->join('gsut_depto as depto_destino','depto_destino.id','=','gsut_solicitud.id_depto_destino')
                            ->leftjoin('gsut_macroterritorio as mt','mt.id','=','gsut_solicitud.id_macroterritorio')
                            ->leftjoin('gsut_unidadvecinal as uv','uv.id','=','gsut_solicitud.id_unidadvecinal')
                            ->leftjoin('gsut_distribucion_territorio as dt', function ($join) 
                            {
                                $join->on('dt.nr_id','=','mt.id')
                                     ->where('dt.tp_tabla','=','tb_macroterritorio');
                            })
                            ->join('gsut_tipo_ingreso as ti','ti.id','=','gsut_solicitud.tp_ingreso')
                            ->select('gsut_solicitud.id',
                                'gsut_solicitud.nr_ticket',
                                'gsut_solicitud.id_municipio',
                                'gsut_solicitud.id_direccion',
                                'gsut_solicitud.id_depto',
                                'gsut_solicitud.id_tipo',
                                'gsut_solicitud.nm_tipo',
                                'gsut_solicitud.id_prioridad',
                                'gsut_solicitud.id_motivo',
                                'motivo.nm_motivo',
                                'gsut_solicitud.tp_clonado',
                                'gsut_solicitud.str_clonado',
                                'gsut_solicitud.str_clonado_html',
                                'gsut_solicitud.nr_fuente',
                                'gsut_solicitud.id_direccion_destino',
                                'dir_destino.nm_direccion as nm_direccion_destino',
                                'gsut_solicitud.id_depto_destino',
                                'depto_destino.nm_depto as nm_depto_destino',
                                'gsut_solicitud.id_ubicacion',
                                'gsut_solicitud.id_macroterritorio',
                                'mt.cod_territorio',
                                'gsut_solicitud.id_unidadvecinal',
                                'uv.cod_unidadvecinal',
                                'uv.nm_unidadvecinal',
                                'gsut_solicitud.tp_direccion',
                                'gsut_solicitud.nr_direccion',
                                'gsut_solicitud.nm_direccion',
                                'gsut_solicitud.nm_ubicacion',
                                'gsut_solicitud.str_latitud',
                                'gsut_solicitud.str_longitud',
                                'gsut_solicitud.nr_rut_vecino',
                                'gsut_solicitud.str_observacion',
                                'gsut_solicitud.str_observacion_html',
                                'gsut_solicitud.str_aclaratoria',
                                'gsut_solicitud.tp_visado_mt',
                                'gsut_solicitud.tp_rechazado',
                                'gsut_solicitud.id_estado',
                                'estado.nm_estado',
                                'estado.nm_color',
                                'gsut_solicitud.contexto_municipal',
                                'gsut_solicitud.tp_ingreso',
                                'ti.nm_ingreso',
                                'gsut_solicitud.id_autor',
                                'gsut_solicitud.tp_activo',
                                'gsut_solicitud.tp_feedback',
                                'gsut_solicitud.tp_recepcion',
                                'gsut_solicitud.tp_satisfaccion',
                                'gsut_solicitud.str_feedback',
                                'gsut_solicitud.fc_publicado',
                                'gsut_solicitud.fc_creacion as fc_ingreso',
                                'gsut_solicitud.created_at',
                                'gsut_solicitud.updated_at as fc_tramitacion')
                            ->selectRaw("(case when tp_vecino = 1 then 'SI' else 'NO' end) as tp_vecino")
                            ->where('gsut_solicitud.tp_activo','=',1)
                            //->orderBy('gsut_solicitud.created_at','DESC')
                            ->with('tipo','prioridad','vecino','archivos','ubicacion','asignados','archivos_asignacion','solicitud','derivacion');
                
            /* ----- Inicio - Filtro Bandeja ----- */
                if($propias == 1)
                    $data   =   $data->where('gsut_solicitud.id_autor','=',$id_user);

                // if($propias == 0)
                //     $data   =   $data->whereNotIn('gsut_solicitud.id_autor',[$id_user]);
            /* ----- Termino - Filtro Bandeja ----- */

            /* ----- Inicio - Filtro ----- */
                if($fl_mostrar != 0)
                {
                    if($fl_mostrar != 5)
                        $data   =   $data->where('gsut_solicitud.id_estado','=',$fl_mostrar);
                    else
                        $data   =   $data->whereIn('gsut_solicitud.id_estado',[5,6]);
                }

                if(isset($fl_direccion)) 
                    $data   =   $data->where('gsut_solicitud.id_direccion_destino','=',$fl_direccion);

                if(isset($fl_depto)) 
                    $data   =   $data->where('gsut_solicitud.id_depto_destino','=',$fl_depto);

                if(isset($fl_ingreso))
                    $data   =   $data->where('gsut_solicitud.tp_ingreso','=',$fl_ingreso);

                if(isset($fl_servicio))
                    $data   =   $data->where('gsut_solicitud.id_tipo','=',$fl_servicio);

                if(isset($fl_macrozona))
                    $data   =   $data->where('gsut_solicitud.id_macroterritorio','=',$fl_macrozona);

                if(isset($fl_undvecinal))
                    $data   =   $data->where('gsut_solicitud.id_unidadvecinal','=',$fl_undvecinal);

                if(isset($fl_ticket))
                    $data   =   $data->where('gsut_solicitud.nr_ticket','=',$fl_ticket);

                if(isset($fl_vecino))
                    $data   =   $data->where('gsut_solicitud.nr_rut_vecino','=',$fl_vecino);

                if(isset($fl_motivo))
                    $data   =   $data->where('gsut_solicitud.id_motivo','=',$fl_motivo);

                if(isset($fl_ubicacion))
                    $data   =   $data->where('gsut_solicitud.id_ubicacion','=',$fl_ubicacion);

                if(isset($fc_desde) && isset($fc_hasta))
                {
                    $fc_desde   =   Carbon::parse($fc_desde)->format('Y-m-d');
                    $fc_hasta   =   Carbon::parse($fc_hasta)->format('Y-m-d');
                    $data       =   $data->whereDate('gsut_solicitud.created_at','>=',$fc_desde)
                                         ->whereDate('gsut_solicitud.created_at','<=',$fc_hasta);
                }
            /* ----- Termino - Filtro ----- */

            /*----- Inicio - Orden por Campos -----*/
                if(in_array($tp_criterio, ['id','id_macroterritorio','id_unidadvecinal','created_at']))
                    $data   =   $data->orderBy('gsut_solicitud.'.$tp_criterio, $tp_orden);

                if($tp_criterio === 'nm_direccion')
                    $data   =   $data->orderBy('dir_destino.nm_direccion',$tp_orden);

                if($tp_criterio === 'nm_depto')
                    $data   =   $data->orderBy('depto_destino.nm_depto',$tp_orden);

                if($tp_criterio === 'nm_estado')
                    $data   =   $data->orderBy('estado.nm_estado',$tp_orden);
            /*----- Termino - Orden por Campos -----*/

            $data   =   $data->groupBy('gsut_solicitud.id');
            $data   =   $data->paginate(20);

            $data->getCollection()->transform(function ($value) {
                $value->tiempo_tramitado    =   UtilController::getTiempoTramitacion($value->fc_ingreso, $value->fc_publicado, $value->id_estado);
                $value->tiene_pp            =   (UtilController::getCantidadRespuestas(2, $value->id) != 0) ? 'SI' : 'NO'; // Tiene Publicaciones Parciales
                return $value;
            });

            return [
                'pagination' => [
                    'total'        => $data->total(),
                    'current_page' => $data->currentPage(),
                    'per_page'     => $data->perPage(),
                    'last_page'    => $data->lastPage(),
                    'from'         => $data->firstItem(),
                    'to'           => $data->lastItem(),
                ],
                'info'          => $data,
                'nr_propias'    => UtilController::ContadorSolicitudes(0),
                'nr_bandeja'    => UtilController::ContadorSolicitudes(1),
            ];
    }

    public function index($tp_destino)
    {
        $destino    =   '';
        $id_usuario =   Auth::user()->id;
        $id_rol     =   Auth::user()->id_rol;
        $rol_actual =   UtilController::getRolActivo($id_usuario);
        $roles      =   UtilController::listarRolesUsuario($id_usuario);

        if($tp_destino == 'inicio')
            $destino = 'macro_zona.inicio_macrozona';

        if($tp_destino == 'ingreso')
            $destino = 'macro_zona.ingreso_macrozona';

        if($tp_destino == 'listado')
            $destino = 'macro_zona.mis_solicitudes_macrozona';

        if($tp_destino == 'bandeja')
            $destino = 'macro_zona.bandeja_macrozona';

        return view($destino)
                ->with('id_rol',$id_rol)
                ->with('rol_actual',$rol_actual)
                ->with('data',$roles)
                ->with('count',count($roles));
    }
}
