<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\UtilController;

use App\PDFs;
use App\UserThread;

use Auth;
use File;


class PDFController extends Controller
{

    public function deletePdf(Request $request)
    {
        $bearer_token       =   env('BEARER_TOKEN');
        $endpoint           =   env('ENDPOINT_OPENAI').'/protected/delete/payload/';
        $id_user            =   Auth::user()->id;
        $key                =   $request->key;
        $tp_categoria       =   $request->tp_categoria?:1;
        $index_qdrant       =   'collection_user_'.$id_user;
        $nombre_guardado    =   $request->nombre_guardado;
        $nombre_real        =   $request->nombre_real;
        $key                =   $request->key;
        $ruta               =   $request->ruta;
        $contexto           =   $request->contexto;
        $asistente_id       =   $request->asistente_id;        
        $utils              =   new UtilController();
        $form_params        =   [
                                    'form_params'   =>  [
                                        'name_collection' =>  $index_qdrant,
                                        'key'             =>  $key,
                                        'value_key'       =>  $nombre_real
                                    ]
                                ];        
        
        try {

            $utils->PeticionHttp($bearer_token,'POST',$endpoint,$form_params);
            if(!File::exists(storage_path('app/public/'.$ruta)))
            {
                $pdf  = PDFs::where('nombre_guardado','=',$nombre_guardado)->delete();
                UserThread::where('user_id',$id_user)->where('asistente_id',$asistente_id)->where('contexto','=',$contexto)->delete();
                \Storage::disk('public')->delete($ruta);

                $pdf  = PDFs::where('nombre_guardado','=',$nombre_guardado)->where('id_usuario','=',$id_user)->delete();
                UserThread::where('user_id',$id_user)->where('asistente_id',$asistente_id)->where('contexto','=',$contexto)->delete();

                return ['error'=>0,'msj'=>'PDF eliminado correctamente','color'=>'success','title'=>'Exito'];
            }
        } catch (\Throwable $th) 
        {
            return ['error'=>1,'msj'=>'El archivo no existe','color'=>'error','title'=>'Error','db'=> []];

        }
    }

    public function getPreview(Request $request)
    {
        $str_ruta   =   $request->ruta;
        $subpath    =   'public/'.$str_ruta;
        $path       =   storage_path('app/'.$subpath);

        if (file_exists($path)) {
            $docContent     =   \Storage::get($subpath);
            $type           =   \Storage::mimeType($subpath);
           
            return \Response::make($docContent, 200, [
                'Content-Type'        => $type,
                //'Content-Disposition' => 'inline; filename="'.$manuscript->file_name.'"',
            ]);
       }
    }
    
    public function upload(Request $request)
    {
        $now            = date("Y-m-d H:i:s");
        $id_user        = Auth::user()->id;
        $fc_subida      = $request->fc_subida?:$now;

        $index_qdrant   = 'collection_user_'.$id_user;
        $max_id         = PDFs::where('id_usuario','=',$id_user)->count()+1;
        $pdf            = new PDFs();
        $endpoint       = env('ENDPOINT_OPENAI').'/protected/upload_file';
        $bearer_token   = env('BEARER_TOKEN');

        $utils          = new UtilController();


        if($request->file('pdf'))
		{

            $request->validate(['pdf'   => 'file|required|mimes:pdf|max:'.env('MAX_FILE_SIZE')],
                                [
                                    'pdf.required'  => 'El :attribute es obligatorio.',
                                    'pdf.file'      => 'El :attribute debe ser un archivo.',
                                    'pdf.mimes'     => 'El :attribute debe ser un PDF.',
                                    'pdf.max'       => 'El :attribute no debe ser mayor a :max kilobytes.',
                                ], 
                                ['pdf' => 'archivo']);
                                
            $file                       = $request->file('pdf');
            $nameFile                   = $file->getClientOriginalName();

            $repetido = PDFs::where('nombre_real','=',$nameFile)
                            ->where('id_usuario','=',$id_user)
                            ->count();

            if($repetido > 0)
                return ['error'=>1,'title'=>'Error','msj'=>'El archivo ya existe','color'=>'error','db'=> [],'pdf_id'=>0];

            $ruta                       =  '/user/'.$id_user.'/'.$max_id.'.pdf';
            $pdf->ruta                  = $ruta;

            

            $pdf->nombre_real           = $nameFile;
            $pdf->nombre_guardado       = $max_id.'.pdf';
            $pdf->tipo                  = $file->getMimeType();
            $pdf->tamano                = $file->getSize();
            $pdf->extension             = $file->getClientOriginalExtension();
            $pdf->id_usuario            = $id_user;
            $pdf->fc_subida             = $fc_subida;
            $pdf->index_qdrant          = $index_qdrant;
            \Storage::disk('public')->put($ruta,  \File::get($file));
            $pdf->save();

            

            $type                       =   pathinfo($ruta, PATHINFO_EXTENSION);
            $data                       =   file_get_contents(storage_path('app/public/'.$ruta));
            $base64                     =   base64_encode(File::get($file->getPathname()));

            $form_params                =   [   'base64_file'       =>  $base64,
                                                    'collection_name'   =>  $index_qdrant,
                                                    'nombre_real'       =>  $nameFile,
                                                    'id'                =>  $pdf->id
                                                ];

            try
            {
                $res                        = $utils->PeticionHttp($bearer_token,'POST',$endpoint,$form_params);
                $json                       = json_decode($res, true);
                $message                    = $json['message'];

            }
            catch(\Exception $e)
            {
                $pdf->delete();
                return ['error'=>1,'title'=>'Error','msj'=>'Error al guardar el PDF','color'=>'error','pdf_id'=>0,'msj_error'=>$e->getMessage()];
            }
       
               

        }
        else
            return ['error'=>1,'title'=>'Error','msj'=>'Error al guardar el PDF','color'=>'error','pdf_id'=>0];

                return ['error'=>0,'title'=>'Exito','msj'=>$message,'color'=>'success','pdf_id'=>$pdf->id ];
    }

    public function getPDfs(Request $request)
    {
        $nm_file        = $request->nm_file;
        $nr_mes         = $request->nr_mes;
        $nr_anno        = $request->nr_anno;
        $id_user        = Auth::user()->id;

        $pdfs           = PDFs::select( 'nombre_real',
                                        'nombre_guardado',
                                        'ruta',
                                        'tipo',
                                        'tamano',
                                        'extension',
                                        'id_usuario',
                                        'index_qdrant',
                                        'id')
                                        ->selectRaw('DATE_FORMAT(fc_subida,"%d-%m-%Y") as fc_subida')
                                        ->where('id_usuario','=',$id_user);


        if($nm_file != '')
            $pdfs->where('nombre_real','like','%'.$nm_file.'%');

        if($nr_mes != 0)
            $pdfs->whereRaw('MONTH(fc_subida) = '.$nr_mes);
        
        if($nr_anno != 0)
            $pdfs->whereRaw('YEAR(fc_subida) = '.$nr_anno);

        return ['pdfs' => $pdfs->get()];
    }
}
