<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Vecino extends Model
{
    protected $table        =   'gsut_vecino';
    protected $primaryKey   =   'id';
    protected $fillable     =   [
                                    'nr_rut',
                                    'nm_vecino',
                                    'ap_paterno',
                                    'ap_materno',
                                    'id_region',
                                    'id_comuna',
                                    'id_ubicacion',
                                    'id_macroterritorio',
                                    'id_unidadvecinal',
                                    'nr_calle',
                                    'nm_calle',
                                    'nm_ubicacion',
                                    'tp_direccion',
                                    'str_latitud',
                                    'str_longitud',
                                    'str_aclaratoria',
                                    'nr_prefijo',
                                    'nr_telefono',
                                    'nm_mail',
                                    'tp_vecino',
                                    'id_autor',
                                    'tp_activo'
                                ];

    public $timestamps = true;
    //-----------------------------------------------------------
    public function region()
    {
        return $this->belongsTo('App\Regiones','id_region','id')
                    ->select(['id','nm_region']);
    }
    //-----------------------------------------------------------
    public function comuna()
    {
        return $this->belongsTo('App\Comunas','id_comuna','id')
                    ->select(['id','nm_comuna']);
    }
    //-----------------------------------------------------------
}
