<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGsutRespuestaTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('gsut_respuesta', function(Blueprint $table)
		{
			$table->bigIncrements('id');
			$table->integer('id_solicitud')->unsigned();
			$table->dateTime('fc_ingreso')->nullable();
			$table->text('str_observacion', 65535)->nullable();
			$table->text('str_observacion_html', 65535)->nullable();
			$table->integer('id_historia')->nullable();
			$table->integer('id_autor')->nullable();
			$table->integer('tp_respuesta')->unsigned()->default(0);
			$table->integer('tp_validado')->unsigned()->default(0);
			$table->integer('nr_fuente')->unsigned()->default(0);
			$table->text('str_ruta_adjunto')->nullable();
			$table->integer('tp_activo')->unsigned()->default(1);

			/*
				tp_respuesta 	
				0. 	Respuesta Interna
				1.	Publicación Definitiva
				2. 	Publicación Parcial
				3. 	Pre-Publicación Definitiva
				4. 	Pre-Publicación Parcial
			*/
			
			$table->timestamps();
		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::dropIfExists('gsut_respuesta');
	}

}
