@extends('audiencias.adminlte')
@section('content')
    <div class="mt-2">
        <div class="container-fluid" id="app">
            <div class="row">
                <div class="col-12 text-center">
                    <div class="bg-primary">
                        <h2 style="color: white;">Reuniones Comunitarias</h5>
                    </div>
                </div>

                <div class="col-12">
                    <div class="x_content">
                        <div class="col-md-12 col-sm-12">
                            <div class="row-flow">
                                <!-- Datos usuarios -->
                                <div class="card mt-2 border-info">
                                    <div class="card-header bg-primary border-info" >
                                        <div class="form-check form-check-inline">
                                            <h4 class="form-check-label text-white" for="inlineCheckbox1">Datos Vecino</h4>
                                        </div>
                                    </div>
                                    <div class="card-body" v-if="tp_vecino == 1">
                                        <div class="row" >
                                            <!-- Rut Vecino -->
                                            <div class="col-md-3 col-sm-6 mt-2">
                                                <div class="form-group">
                                                    <label>Rut Vecino</label>
                                                    <input id="rut_vecino" @change="validarRut(0);" type="text" class="form-control vecino" v-model="rut_vecino">
                                                    <small v-if="arr_valida.rut_vecino" v-text="arr_valida.rut_vecino[0]"></small>
                                                    <small class="text-error text-danger" v-if="arr_form.rut_vecino"  v-text="arr_form.rut_vecino"></small>
                                                </div>
                                            </div>
                                            <!-- Nombre -->
                                            <div class="col-md-3 col-sm-6 mt-2">
                                                <div class="form-group">
                                                    <label>Nombre</label>
                                                    <input type="text" maxlength="50" class="form-control vecino" v-model="nm_vecino">
                                                    <small v-if="arr_valida.nm_vecino" v-text="arr_valida.nm_vecino[0]"></small>
                                                    <small class="text-error text-danger" v-if="arr_form.nm_vecino"  v-text="arr_form.nm_vecino"></small>
                                                </div>
                                            </div>
                                            <!-- Primer Apellido -->
                                            <div class="col-md-3 col-sm-6 mt-2">
                                                <div class="form-group">
                                                    <label>Primer Apellido</label>
                                                    <input type="text" maxlength="50" class="form-control vecino" v-model="ap_paterno">
                                                    <small v-if="arr_valida.ap_paterno" v-text="arr_valida.ap_paterno[0]"></small>
                                                    <small class="text-error text-danger" v-if="arr_form.ap_paterno"  v-text="arr_form.ap_paterno"></small>
                                                </div>
                                            </div>
                                            <!-- Segundo Apellido -->
                                            <div class="col-md-3 col-sm-6 mt-2">
                                                <div class="form-group">
                                                    <label>Segundo Apellido</label>
                                                    <input type="text" maxlength="50" class="form-control vecino" v-model="ap_materno">
                                                    <small v-if="arr_valida.ap_materno" v-text="arr_valida.ap_materno[0]"></small>
                                                    <small class="text-error text-danger" v-if="arr_form.ap_materno"  v-text="arr_form.ap_materno"></small>
                                                </div>
                                            </div>
                                            <!-- Telfono -->                                                    
                                            <div class="col-lg-3 col-md-4 col-sm-6 mt-2">
                                                <div class="form-group">
                                                    <label>Teléfono</label>
                                                    <div class=" input-group">
                                                    <div class="input-group-prepend">                                                    
                                                        <div class="input-group-text">
                                                        <select v-model="pre_fijo" class="vecino">
                                                            <option value="+569">+569</option>
                                                            <option value="+562">+562</option>
                                                        </select>
                                                        </div>
                                                    </div>
                                                    <input v-model="nr_telefono" type="text"  maxlength="8" type="text" class="form-control vecino" 
                                                            onkeypress="return justNumbers(event);">                                                    
                                                    </div>
                                                    <small v-if="arr_valida.nr_telefono" v-text="arr_valida.nr_telefono[0]"></small>
                                                    <small class="text-error text-danger" v-if="arr_form.nr_telefono"  v-text="arr_form.nr_telefono"></small>
                                                </div>
                                            </div>
                                            <!-- Mail -->
                                            <div class="col-md-4 col-sm-6 mt-2">
                                                <div class="form-group">
                                                    <label>Correo Electrónico</label>
                                                    <input type="text" maxlength="50" id="mail_vecino" class="form-control vecino tp_bloquear_accion" 
                                                        v-model="mail_vecino" @change="validarMail(0)">
                                                    <small v-if="arr_valida.nm_mail" v-text="arr_valida.nm_mail[0]"></small>
                                                    <small class="text-error text-danger" v-if="arr_form.mail_vecino"  v-text="arr_form.mail_vecino"></small>
                                                </div>
                                            </div>
                                            <!-- Confirmar Mail -->
                                            <div class="col-md-4 col-sm-6 mt-2">
                                                <div class="form-group">
                                                    <label>Confirmar Correo</label>
                                                    <input type="text" maxlength="50" id="confirmar_mail_vecino" class="form-control vecino tp_bloquear_accion" 
                                                        v-model="confirmar_mail_vecino" @change="validarMail(0)">
                                                    <small class="text-error text-danger" v-if="arr_form.confirmar_mail"  v-text="arr_form.confirmar_mail"></small>
                                                </div>
                                            </div>
                                            <!-- Regiones -->
                                            <div class="col-md-3 mt-2">
                                                <div class="form-group">
                                                    <label>Región</label>
                                                    <multiselect 
                                                        :show-labels="false"
                                                        :searchable="true"
                                                        v-model="nr_region"
                                                        :options="arr_region"
                                                        :multiple="false"
                                                        :showNoOptions=false
                                                        placeholder="Ingresar Región"
                                                        @select="asyncComuna"
                                                        label="label" track-by="label">
                                                            <span slot="noResult">No se han encontrado resultados</span>
                                                    </multiselect>
                                                    <small v-if="arr_valida.nr_region" v-text="arr_valida.nr_region[0]"></small>
                                                    <small class="text-error text-danger" v-if="arr_form.nr_region"  v-text="arr_form.nr_region"></small>
                                                </div>
                                            </div>
                                            <!-- Comunas -->
                                            <div class="col-md-3 mt-2">
                                                <div class="form-group">
                                                    <label>Comuna</label>
                                                    <multiselect 
                                                        :show-labels="false"
                                                        :searchable="true"
                                                        v-model="nr_comuna"
                                                        :options="arr_comuna"
                                                        :multiple="false"
                                                        :showNoOptions=false
                                                        placeholder="Ingresar Comuna"
                                                        @select="asyncUbicacion" 
                                                        :disabled="getValue(nr_region != 0)"
                                                        label="label" track-by="label">
                                                            <span slot="noResult">No se han encontrado resultados</span>
                                                    </multiselect>
                                                    <small v-if="arr_valida.nr_comuna" v-text="arr_valida.nr_comuna[0]"></small>
                                                    <small class="text-error text-danger" v-if="arr_form.nr_comuna"  v-text="arr_form.nr_comuna"></small>
                                                </div>
                                            </div>
                                            <!-- Direccion Vecino -->
                                            <template v-if="tp_comuna == 1">
                                                <div class="col-md-3 mt-2">
                                                    <div class="form-group">
                                                        <label>Dirección de residencia</label>
                                                        <multiselect 
                                                            :show-labels="false"
                                                            :searchable="true"
                                                            v-model="arr_ubicacion_vecino"
                                                            :options="arr_calles_vecino"
                                                            :multiple="false"
                                                            :showNoOptions =false
                                                            placeholder="Ingresar Ubicacion"
                                                            @search-change="asyncUbicacionVecino" 
                                                            :disabled="getValue(nr_comuna != 0)"
                                                            label="label" track-by="label">
                                                                <span slot="noResult">No se han encontrado resultados</span>
                                                        </multiselect>
                                                        <small v-if="arr_valida.arr_ubicacion_vecino" v-text="arr_valida.arr_ubicacion_vecino[0]"></small>
                                                        <small class="text-error text-danger" v-if="arr_form.nm_ubicacion_vecino"  v-text="arr_form.nm_ubicacion_vecino"></small>
                                                    </div>
                                                </div>
                                            </template>
                                            <template v-else>
                                                <div class="col-md-3 mt-2">
                                                    <div class="form-group">
                                                        <label>Dirección de residencia</label>
                                                        <input type="text" maxlength="50" class="form-control vecino" v-model="nm_ubicacion_vecino">
                                                        <small class="text-error text-danger" v-if="arr_form.nm_ubicacion_vecino"  v-text="arr_form.nm_ubicacion_vecino"></small>
                                                    </div>
                                                </div>
                                            </template>
                                            <!-- Clasificacion de ubicacion vecino -->
                                            <div class="col-md-2 col-sm-6 mt-2">
                                                <div class="form-group">
                                                    <label>Casa/Depto/Oficina</label>
                                                    <select v-model="tp_ubicacion_vecino" class="form-control  vecino">
                                                        <option value="1">Casa</option>
                                                        <option value="2">Depto</option>
                                                        <option value="3">Oficina</option>
                                                    </select>
                                                    <small v-if="arr_valida.tp_ubicacion_vecino" v-text="arr_valida.tp_ubicacion_vecino[0]"></small>
                                                </div>
                                            </div>
                                            <!-- Aclaratoria -->
                                            <div class="col-md-3 mt-2">
                                                <div class="form-group">
                                                    <label>Aclaratoria</label>
                                                    <input type="text" maxlength="50" class="form-control vecino" v-model="str_aclaratoria_vecino" 
                                                        placeholder="Nro. Depto. | Nro. Casa | Otra aclaración del lugar">
                                                    <small class="text-error text-danger" v-if="arr_form.str_aclaratoria_vecino"  v-text="arr_form.str_aclaratoria_vecino"></small>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Datos Solicitud -->
                                <div class="card mt-4">
                                    <div class="card-header bg-primary" style="color:white">
                                        <h4 class="text-center" style="color:white">Datos del Requerimiento</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <!-- Motivo Solicitud -->
                                            <div class="col-lg-3 col-md-4 col-sm-6 mt-2">
                                                <div class="form-group">
                                                    <label>Tipo de Requerimiento</label>
                                                    <multiselect
                                                        :show-labels="false"
                                                        :searchable="true"
                                                        v-model="nr_motivo"
                                                        :options="arr_motivo"
                                                        :multiple="false"
                                                        :showNoOptions ="false" 
                                                        placeholder="Seleccione Tipo de Requerimiento"
                                                        label="label"
                                                        track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                    </multiselect>
                                                    <small v-if="arr_valida.nr_motivo" v-text="arr_valida.nr_motivo[0]"></small>
                                                    <small class="text-error text-danger" v-if="arr_form.nr_motivo"  v-text="arr_form.nr_motivo"></small>
                                                </div>
                                            </div>    
                                            <!-- Tipo Servicio -->
                                            <div class="col-lg-3 col-md-4 col-sm-6 mt-2">
                                                <div class="form-group">
                                                    <div class="row">
                                                        <label>
                                                            Servicio @if ($tp_video)<a href="#" class="ml-3" style="font-weight: bold;" @click="mostrarVideoSwal()">
                                                            Video explicativo "Cómo buscar un servicio escribiendo una palabra"</a>@endif
                                                        </label>
                                                    </div>
                                                    <multiselect
                                                        :show-labels="false"
                                                        :searchable="true"
                                                        v-model="nr_tipo"
                                                        :options="arr_servicio"
                                                        :multiple="false"
                                                        :showNoOptions ="false" 
                                                        placeholder="Seleccione Servicio" 
                                                        @select="asyncServicios"
                                                        label="label"
                                                        track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                    </multiselect>
                                                    <small v-if="arr_valida.nr_tipo" v-text="arr_valida.nr_tipo[0]"></small>
                                                    <small class="text-error text-danger" v-if="arr_form.nr_tipo"  v-text="arr_form.nr_tipo"></small>
                                                </div>
                                                <small v-html="str_servicio"></small>
                                            </div>                                       
                                            <!-- Ubicacion problema -->
                                            <div class="col-lg-3 col-md-4 col-sm-6 mt-2" v-if="tp_ubicacion == 1">
                                                <div class="form-group">
                                                    <label>Dirección del Requerimiento</label>
                                                    <multiselect
                                                        :show-labels="false"
                                                        :searchable="true"
                                                        v-model="arr_direccion_solicitud"
                                                        :options="arr_calles_solicitud"
                                                        :multiple="false"
                                                        :showNoOptions =false
                                                        placeholder="Ingresar Dirección"
                                                        label="label" 
                                                        @search-change="asyncUbicacionSolicitud"
                                                        track-by="label">
                                                            <span slot="noResult">No se han encontrado resultados</span>
                                                    </multiselect>
                                                    <small v-if="arr_valida.arr_direccion_solicitud" v-text="arr_valida.arr_direccion_solicitud[0]"></small>
                                                    <small class="text-error text-danger" v-if="arr_form.nm_ubicacion_solicitud"  v-text="arr_form.nm_ubicacion_solicitud"></small>
                                                </div>
                                            </div>
                                            <!-- Aclaratoria -->
                                            <div class="col-lg-3 col-md-4 col-sm-6 mt-2" v-if="tp_ubicacion == 1">
                                                <div class="form-group">
                                                    <label>Aclaratoria</label>
                                                    <input type="text" maxlength="50" class="form-control" v-model="str_aclaratoria_solicitud" 
                                                        placeholder="Dirección y numeración u otra aclaración del lugar">
                                                    <small class="text-error text-danger" v-if="arr_form.str_aclaratoria_solicitud"  v-text="arr_form.str_aclaratoria_solicitud"></small>
                                                </div>
                                            </div>
                                            <!-- Descripcion Solicitud -->
                                            <div class="col-md-12 mt-2">
                                                <div class="form-group">
                                                    <label>Descripción Requerimiento :</label> <br>
                                                    <div id="txt_solicitud"></div>
                                                    <small class="form-text text-muted">
                                                        <span>Cantidad maxima de caracteres a utilizar 2000</span>
                                                    </small> 
                                                    <small class="text-error text-danger" v-if="arr_form.str_observacion"  v-text="arr_form.str_observacion"></small>
                                                </div>
                                            </div>

                                            <!-- Tabla de Archivos Adjuntos -->
                                            <div class="table-responsive mt-2">
                                                <table  class="table table-bordered table-striped table-sm" style="width: 100%">
                                                    <thead>
                                                        <tr class="bg-primary">
                                                            <th class="text-center" style="color:white" colspan="5">Documentos Adjuntos 
                                                                <button @click="abrirModal('archivo','anexar')" class="btn btn-success btn-sm" 
                                                                    > 
                                                                    <i class="fas fa-plus"></i>
                                                                </button>
                                                            </th>
                                                        </tr>
                                                        <tr v-if="arr_archivo.length || ( solicitud_actual.archivos && solicitud_actual.archivos.length)">
                                                            <th class="text-center">#</th>
                                                            <th class="text-center">Nombre</th>
                                                            <th class="text-center">Descripción</th>
                                                            <th class="text-center">Tamaño MB</th>
                                                            <th class="text-center">Opción</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <template v-if="arr_archivo.length">
                                                            
                                                            <tr v-for="(archivo, index) in arr_archivo" :key="index">
                                                                <td class="text-center">@{{ (index+1) }}</td>
                                                                <td style="min-width: 20px; max-width: 50px;">@{{ archivo.file.name }}</td>
                                                                <td style="min-width: 20px; max-width: 300px;">@{{ archivo.descripcion }}</td>
                                                                <td style="min-width: 20px; max-width: 300px;">@{{ archivo.sizeMB }}</td>
                                                                <td style="min-width: 20px; max-width: 50px;" class="text-center">
                                                                    <button type="button" class="btn btn-sm btn-danger" title="Quitar Documento" @click="quitarAdjunto('archivo', index);">
                                                                        <i class="fas fa-times-circle"></i> Quitar
                                                                    </button>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td></td>
                                                                <td></td>
                                                                <td><strong style="float: right;">Tamaño Total MB (Máximo 20 MB)</strong></td>
                                                                <td v-text="totalizarCampo(arr_archivo,'sizeMB')"></td>
                                                            </tr>
                                                        </template>
                                                        <template v-if="solicitud_actual.archivos && solicitud_actual.archivos.length">
                                                            <tr>
                                                                <th class="text-center bg-success" colspan="4" style="color:white">Archivos Cargados</th>
                                                                
                                                            </tr>
                                                            <tr v-for="archivo in solicitud_actual.archivos" >
                                                                <td>
                                                                    <a target=_blank :href="'/files/get/?ruta='+archivo.str_archivo">@{{ archivo.nm_archivo }}</a>
                                                                </td>
                                                                <td>@{{ archivo.str_observacion }}</td>
                                                                <td class="text-center">
                                                                    <button @click="deleteFiles(archivo.str_archivo,archivo.nm_archivo)" type="button" class="btn btn-sm btn-danger" title="Quitar Documento">
                                                                        <i class="fas fa-times-circle"></i> Eliminar
                                                                    </button>
                                                                </td>
                                                            </tr>
                                                        </template>
                                                        <template v-if="!solicitud_actual.archivos && !arr_archivo.length">
                                                            <td colspan="4">
                                                                <div class="empty" empty-text="No hay archivos adjuntos para listar"></div>
                                                            </td>
                                                        </template>                                                
                                                    </tbody>
                                                </table>

                                                <div v-if="totalizarCampo(arr_archivo,'sizeMB')>20" class="alert alert-danger text-center" role="alert">
                                                    El tamaño total de los adjuntos no puede superar los 20 MB
                                                </div>
                                            </div>

                                            <button v-if="btn_envio == 0 " :disabled="totalizarCampo(arr_archivo,'sizeMB')>20" type="button" 
                                                class="btn btn-success  waves-effect waves-light" @click="ensamblarDatos('registrar',0)">
                                                <i class="fas fa-save"></i> Registrar
                                            </button>
                                            <button v-else type="button"  class="btn btn-success">Registrando <i  class="fas fa-spin fa-spinner"></i></button>                            
                                            
                                            <div class="text-center text-error">
                                                <div v-for="error in arr_error" :key="error" v-text="error"></div>
                                            </div>
                                        </div>
                                    </div>                                
                                </div>
                            </div>                      
                        </div>
                    </div>
                </div>

                <!-- Modal Adjunto -->
                <div class="modal" tabindex="-1" id="modal_adjunto">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header bg-primary">
                                <h5 class="modal-title  text-white">Ingresar Adjunto</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <div class="form-group">
                                    <label>Seleccione Archivo</label>
                                    <input class="form-control" accept=".jpeg,.jpg,.png,.doc,.docx,.xls,.xlsx,.ppt,.pptx,.pdf,.dwg,.dgn,.rar,.zip"
                                        type="file" id="file_adjunto" >
                                </div>
                                <div class="form-group mt-2">
                                    <label>Ingresar Descripción</label>
                                    <textarea maxlength="200" rows="3" v-model="file_observacion" class="form-control" placeholder="Descripción del archivo"></textarea>
                                    <small id="cant_caracteres" class="form-text text-muted" v-text="'Disponible '+(200-file_observacion.trim().length)+' caracteres'" v-if="file_observacion"></small>
                                </div>
                                <template v-if="file_error">
                                    <div class="text-center text-error">
                                        <div v-for="error in arr_error" :key="error" v-text="error"></div>
                                    </div>
                                </template>
                            </div>
                            <div class="modal-footer">
                                <button @click="cerrarModal('archivo')" type="button" class="btn btn-light">Cerrar</button>
                                <button type="button" class="btn btn-primary" @click="validarAdjunto(tp_adjunto, 'save')">Subir</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        Vue.component('vue-multiselect', window.VueMultiselect.default);

        var app = new Vue({
            el: '#app',
            data: {
                //-------------------------------------
                btn_envio                   :   0,
                modal_principal             :   0,
                modal_adjunto               :   0,
                modal_mensaje               :   0,
                accion_principal            :   0,
                accion_adjunto              :   0,
                accion_mensaje              :   0,
                boton_principal             :   1,
                boton_adjunto               :   0,
                boton_mensaje               :   0,
                titulo_principal            :   '',
                titulo_adjunto              :   '',
                titulo_mensaje              :   '',
                tp_modal                    :   0,
                tp_vecino                   :   1,
                //-------------------------------------
                arr_valida                  :   [],
                arr_error                   :   [],
                tp_error                    :   [],
                total_mb_archivos           :   0,
                max_mb_archivos             :   20,
                //-------------------------------------
                pagination                  : {
                    'total' : 0,
                    'current_page' : 0,
                    'per_page' : 0,
                    'last_page' : 0,
                    'from' : 0,
                    'to' : 0,
                },
                //-------------------------------------
                offset                      :   3,
                debounceTimer               :   null,
                cancelToken                 :   null,
                searchCache                 :   new Map(),
                isLoading                   :   false,
                //-------------------------------------
                fl_tipo                     :   [],
                fl_prioridad                :   [],
                fl_funcionario              :   [],
                fl_persona                  :   [],
                fl_direccion                :   [],
                fl_unidadvecinal            :   [],
                fl_ticket                   :   [],
                //-------------------------------------
                arr_archivo                 :   [],
                arr_files                   :   [],
                arr_files_obs               :   [],
                file_observacion            :   '',
                tp_adjunto                  :   '',
                file_error                  :   0,
                tp_save_adjunto             :   0,
                key_uuid                    :   null,
                //-------------------------------------
                arr_index                   :   [],
                arr_region                  :   [],
                arr_comuna                  :   [],
                arr_prioridad               :   [],
                arr_motivo                  :   [],
                arr_funcionario             :   [],
                arr_persona                 :   [],
                arr_calles_vecino           :   [],
                arr_calles_solicitud        :   [],
                arr_dir_municipal           :   [],
                arr_unidadvecinal           :   [],
                arr_ticket                  :   [],
                //-------------------------------------
                arr_solicitudes             :   [],
                //-------------------------------------
                tp_municipal                :   1,
                nr_prioridad                :   2,
                nr_funcionario              :   [],
                //-------------------------------------
                tp_visualizar               :   {
                    tp_resumir : 1,
                    nr_index : null,
                },
                rut_vecino                  :   '',
                nm_vecino                   :   '',
                ap_paterno                  :   '',
                ap_materno                  :   '',
                str_vecino                  :   '',
                nm_direccion                :   '',
                nr_direccion                :   0,
                nr_depto                    :   0,
                tp_ubicacion                :   1,
                nr_telefono                 :   '',
                mail_vecino                 :   '',
                confirmar_mail_vecino       :   '',
                str_observacion             :   '',                
                nr_tipo                     :   {
                    'value' : 0,
                    'label' : 'Seleccione Servicio',
                    'id_direccion' : 0,
                },
                str_servicio                :   '',
                tp_direccion                :   1,
                tp_ubicacion_vecino         :   1,
                str_aclaratoria_vecino      :   '',
                str_aclaratoria_solicitud   :   '',
                //Datos Solicitud
                arr_direccion_solicitud     :   [],
                arr_ubicacion_vecino        :   [],
                nm_ubicacion_vecino         :   '',
                nr_ubicacion                :   '',
                str_longitud                :   '',
                str_latitud                 :   '',
                str_observacion             :   '',
                fc_ingreso                  :   '',
                tp_aprobado                 :   0,
                tp_activo                   :   1,
                id_consulta                 :   0,
                nr_dir_municipal            :   0,
                nr_tp_direccion_solicitud   :   1,
                nr_motivo                   :   {
                    value: 0,
                    label: "Seleccione Tipo de Requerimiento",
                },
                nr_region                   :   {
                    value: 13,
                    label: "Metropolitana de Santiago",
                },
                nr_comuna                   :   {
                    value: 287,
                    label: "San Miguel",
                },
                tp_comuna                   :   1,
                //-------------------------------------
                existe_vecino               :   0,
                //-------------------------------------
                arr_form                    : {},
                solicitud_actual            : [],
                arr_data_default            : [],
                arr_tipos                   : [{
                    'value' : 0,
                    'label' : 'Seleccione Servicio',
                    'id_direccion' : 0,
                }],
                arr_servicio                : [],
                nr_dir_disabled             : 0,
                id_estado                   : 0,
                dir_1                       : 0,
                dir_2                       : 0,
                pre_fijo                    : '+569',
                //------------------------------------
                arr_historial               :   [],
                //------------------------------------
                arr_mostrar                 :   [
                    {
                        'value'     :   0,
                        'label'     :   'Todos',
                    },
                    {
                        'value'     :   1,
                        'label'     :   'Ingresada',
                    },
                    {
                        'value'     :   2,
                        'label'     :   'Por Asignar',
                    }, 
                    {
                        'value'     :   3,
                        'label'     :   'En Revisión',
                    },                    
                    {
                        'value'     :   4,
                        'label'     :   'Publicada',
                    },
                    {
                        'value'     :   5,
                        'label'     :   'Finalizada',
                    },
                    {
                        'value'     :   7,
                        'label'     :   'Anulada',
                    },
                ],
                fl_mostrar                  :   1,
                //------------------------------------
                tp_feedback                 :   0,
                nr_recepcion                :   0,
                tp_recepcion                :   [
                    {
                        'value' : 0,
                        'label' : 'No Contactado',
                    }
                ],
                nr_satisfaccion             :   0,
                tp_satisfaccion             :   [],
                str_feedback                :   '',
                str_error                   :   '',
                //------------------------------------
                arr_recepcion               :   [
                    {
                        'value' : 0,
                        'label' : 'No Contactado',
                    },
                    {
                        'value' : 1,
                        'label' : 'Contactado',
                    },
                ],
                arr_satisfaccion            :   [
                    {
                        'value' : 5,
                        'label' : 'Muy satisfecho',
                    },
                    {
                        'value' : 4,
                        'label' : 'Satisfecho',
                    },
                    {
                        'value' : 3,
                        'label' : 'Normal',
                    },
                    {
                        'value' : 2,
                        'label' : 'Poco satisfecho',
                    },
                    {
                        'value' : 1,
                        'label' : 'Nada satisfecho',
                    },
                ],
                //------------------------------------
            },
            components: {
                Multiselect: window.VueMultiselect.default
            },

            filters:{
                resumir: function (texto, limite=90, final=' ...')
                {
                    var largo = texto.toString().length;
                    if(largo > limite){
                        for (var i = 0; i < largo; i++) {
                            if(texto[i] == ' ' && i >= limite){
                                texto = texto.substring(0,i);
                                texto = texto + final;
                                return texto;
                            }
                        }                    
                    }
                    return texto;
                },
                formatDate: function (fecha)
                {
                    if(fecha)
                        return moment(String(fecha)).format('DD-MM-YYYY')
                },

                formatDateTime: function (fecha)
                {
                    if(fecha)
                    {
                        return moment(String(fecha)).format('DD-MM-YYYY HH:mm')
                    }
                },
            },

            computed:{
                //-------------------------------------------------------------------------------------------
                isActivedPagination: function()
                {
                    return this.pagination.current_page;
                },
                //-------------------------------------------------------------------------------------------
                pagesNumber: function()
                {
                    if(!this.pagination.to) {
                        return [];
                    }

                    var from = this.pagination.current_page - this.offset;
                    if(from < 1) {
                        from = 1;
                    }

                    var to = from + (this.offset * 2);
                    if(to >= this.pagination.last_page){
                        to = this.pagination.last_page;
                    }

                    var pagesArray = [];
                    while(from <= to) {
                        pagesArray.push(from);
                        from++;
                    }
                    return pagesArray;
                },
                //-------------------------------------------------------------------------------------------
            },

            methods: {
                //-------------------------------------------------------------------------------------------
                existeTextArea()
                {
                    let me  =   this;

                    if($('#str_observacion'))
                    {
                        console.log('Existe textArea : #str_observacion');

                        activeTextArea();
                    }
                    else
                    {
                        console.log('NO existe textArea : #str_observacion');
                    }
                },
                //-------------------------------------------------------------------------------------------
                cargarTinyMCE()
                {
                    $("#txt_solicitud").html('<textarea class="form-control tinymce" maxlength="2000" rows="2" id="str_observacion" disabled="true"></textarea>');
                },
                //-------------------------------------------------------------------------------------------
                generateUUID() { 
                    return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
                        const r = Math.random() * 16 | 0, v = c == 'x' ? r : (r & 0x3 | 0x8);
                        return v.toString(16);
                    });
                },
                //-------------------------------------------------------------------------------------------
                totalizarCampo(arr, field) 
                {
                    let total = arr.reduce((a, b) => a + (Number(b[field]) || 0), 0);
                    return total.toFixed(2);
                },
                //-------------------------------------------------------------------------------------------
                asyncServicios(item) // obtiene servicios por direccion
                {
                    let me  =   this;

                    if(item)
                    {
                        me.nr_tipo          =   item;
                        me.str_servicio     =   item.str_tipo_html;
                        me.nr_dir_municipal =   item.id_direccion;
                        me.nr_depto         =   item.id_depto;
                        me.tp_ubicacion     =   item.tp_ubicacion;

                        if(item.notificacion)
                            me.desplegarNotificacion('warning', '<h2>Informativo</h2>', item.notificacion.str_notificacion_html);
                    }
                    else
                    {
                        me.nr_tipo          =   [];
                        me.str_servicio     =   '';
                        me.tp_ubicacion     =   1;
                    }
                },
                //-------------------------------------------------------------------------------------------
                getVecino()
                {
                    let me      = this;
                    var ruta    = '/get/vecino/'+me.rut_vecino;

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta           = response.data;
                        var vecino              = respuesta.vecino;
                        var tramites            = respuesta.tramites;

                        if(!vecino)
                            return;

                        if(tramites == 0)
                        {
                            me.nm_vecino                    =   vecino.nm_vecino;
                            me.ap_paterno                   =   vecino.ap_paterno;
                            me.ap_materno                   =   vecino.ap_materno;
                            me.mail_vecino                  =   vecino.nm_mail;
                            me.tp_ubicacion_vecino          =   vecino.tp_direccion;
                            me.nr_telefono                  =   vecino.nr_telefono.slice(-8);
                            me.pre_fijo                     =   vecino.nr_prefijo;

                            me.arr_ubicacion_vecino         =    
                            {
                                value : vecino.id_ubicacion,
                                label : vecino.nm_ubicacion,
                                nr_calle : vecino.nr_calle,
                                nm_calle : vecino.nm_calle,
                                str_latitud : vecino.str_latitud,
                                str_longitud : vecino.str_longitud,
                                cod_territorial : vecino.cod_macroterritorio,
                                cod_unidadvecinal : vecino.cod_unidadvecinal,
                            };

                            if(vecino.region)
                            {
                                me.nr_region                    = {
                                    value : vecino.region.id,
                                    label : vecino.region.nm_region,
                                };

                                me.cargarComunas(vecino.region.id);
                            }
                                
                            if(vecino.comuna)
                            {
                                me.nr_comuna                    = {
                                    value : vecino.comuna.id,
                                    label : vecino.comuna.nm_comuna,
                                };
                            }
                        }
                        else
                        {
                            me.nm_vecino                    =   vecino.nm_vecino;
                            me.ap_paterno                   =   vecino.ap_paterno;
                            me.ap_materno                   =   vecino.ap_materno;
                            me.mail_vecino                  =   vecino.correo;
                            me.nr_telefono                  =   vecino.nr_telefono;
                            me.pre_fijo                     =   '+569';
                        }
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                getLabel(data)
                {
                    var valor   =   '';

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.label;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                getValue(data)
                {
                    var valor   =   0;

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.value;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                getInfo(id_solicitud)
                {
                    let me          = this;
                    var ruta        = '/solicitud/get?id_solicitud='+id_solicitud;

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta                   =   response.data.solicitud.archivos;
                        me.solicitud_actual.archivos    =   respuesta

                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                deleteFiles(ruta_file,nm_archivo)
                {
                    let me          = this;
                    var ruta        = '/files/delete';

                    axios.post(ruta,{
                        'ruta'          : ruta_file,
                        'id_consulta'   : me.id_consulta,
                        'nm_archivo'    : nm_archivo
                    }).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.getInfo(me.id_consulta)

                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cerrarModal(modelo)
                {
                    let me  =   this;

                    switch(modelo)
                    {
                        case 'archivo':
                        {
                            $('#modal_adjunto').modal('hide');
                            me.limpiarDatos(modelo);

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                cargarMotivo()
                {
                    let me  =   this;
                    var url =   '/motivo/listado';

                    axios.get(url).then(function (response)
                    {
                        var respuesta   =   response.data;
                        me.arr_motivo   =   respuesta;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarServicios()
                {
                    let me  =   this;
                    var url =   '/servicios/listado';

                    axios.get(url).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_servicio     =   respuesta.servicios;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarCalles()
                {
                    let me  =   this;
                    var url =   '/calles/index';

                    axios.get(url).then(function (response)
                    {
                        var respuesta   =   response.data;
                        me.arr_region   =   respuesta.regiones;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarDirecciones(query,tp_opcion = 1)
                {
                    let me          = this;
                    var ruta        = '/direccion/index';

                    // Crear clave de cache
                    const cacheKey  =   `${query.toLowerCase()}_${tp_opcion}`;
                    
                    // Verificar cache primero
                    if (me.searchCache.has(cacheKey)) {
                        const cachedResult  =   me.searchCache.get(cacheKey);
                        if (tp_opcion == 1) {
                            me.arr_calles_vecino    =   cachedResult;
                        }
                        if (tp_opcion == 2) {
                            me.arr_calles_solicitud =   cachedResult;
                        }
                        return;
                    }
                    
                    // Cancelar petición anterior si existe
                    if (me.cancelToken) {
                        me.cancelToken.cancel('Nueva búsqueda iniciada');
                    }
                    
                    // Crear nuevo token de cancelación
                    me.cancelToken  =   axios.CancelToken.source();
                    me.isLoading    =   true;

                    axios.post(ruta,{'nm_direccion':   query,
                    }).then(function (response)
                    {
                        var respuesta   =   response.data;

                        // Guardar en cache (expire después de 5 minutos)
                        me.searchCache.set(cacheKey, respuesta.result);

                        if(tp_opcion == 1)
                            me.arr_calles_vecino = respuesta.result;
                        
                        if(tp_opcion == 2)
                            me.arr_calles_solicitud = respuesta.result;

                        me.isLoading = false;
                    }).catch(function (error) {
                        if (!axios.isCancel(error)) 
                            console.log(error);

                        me.isLoading    =   false;
                    });
                },
                //-------------------------------------------------------------------------------------------
                asyncComuna(item)
                {
                    let me          =   this;
                    var arr         =   item;

                    if(item)
                    {
                        me.nr_region    =   item;
                        me.nr_comuna    =   null;

                        me.cargarComunas(item.value);
                    }
                    else
                    {
                        me.nr_region    =   null;
                        me.nr_comuna    =   null;
                    }
                },
                //-------------------------------------------------------------------------------------------
                asyncUbicacion(item)
                {
                    let me          =   this;
                    var arr         =   item;

                    if(item)
                    {
                        me.nr_comuna    =   item;

                        if(me.getValue(item) == 287) // San Miguel
                            me.tp_comuna    =   1;
                        else
                            me.tp_comuna    =   0;
                    }
                    else
                        me.nr_comuna    =   [];
                },
                //-------------------------------------------------------------------------------------------
                asyncUbicacionSolicitud(query)
                {
                    let me      =   this;
                    var ruta    =   '/direccion/index';

                    // Limpiar timer anterior
                    clearTimeout(me.debounceTimer);
                    
                    if (query.length >= 3) {
                        me.debounceTimer = setTimeout(() => {
                            me.cargarDirecciones(query, 2);
                        }, 300);
                    } else {
                        me.arr_calles_solicitud     =   [];
                    }
                },
                //-------------------------------------------------------------------------------------------
                asyncUbicacionVecino(query)
                {
                    let me      =   this;
                    var ruta    =   '/direccion/index';

                    // Limpiar timer anterior
                    clearTimeout(me.debounceTimer);
                    
                    if (query.length >= 3) {
                        me.debounceTimer = setTimeout(() => {
                            me.cargarDirecciones(query, 1);
                        }, 300);
                    } else {
                        me.arr_calles_vecino = [];
                    }
                },
                //-------------------------------------------------------------------------------------------
                cargarRegiones()
                {
                    let me  =   this;
                    var url =   '/regiones/listado';

                    axios.get(url).then(function (response)
                    {
                        var respuesta   =   response.data;
                        me.arr_region   =   respuesta.regiones;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarComunas(nr_region = 0, nr_provincia = 0)
                {
                    let me      =   this;
                    var ruta    =   '/comunas/listado';

                    console.log('nr_region : ' + nr_region);
                    console.log('nr_provincia : ' + nr_provincia);

                    axios.post(ruta,{
                            'nr_region'     :   nr_region,
                            'nr_provincia'  :   nr_provincia,
                    }).then(function (response) 
                    {
                        var respuesta   =   response.data;
                        me.arr_comuna   =   respuesta.comunas;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                limpiarDatos(modelo)
                {
                    let me  =   this;

                    switch(modelo)
                    {
                        case 'registrar':
                        {
                            me.arr_error        =   [];
                            me.arr_valida       =   [];
                            me.tp_error         =   [];

                            me.nr_estado        =   [];
                            me.nr_secuencia     =   [];
                            me.nr_prioridad     =   1;
                            me.tp_direccion     =   1;
                            
                            me.nr_dir_municipal =   0;
                            me.rut_vecino       =   '';
                            me.nm_vecino        =   '';
                            me.ap_paterno       =   '';
                            me.ap_materno       =   '';
                            me.nr_telefono      =   '';
                            me.mail_vecino      =   '';
                            me.str_servicio     =   '';
                            me.confirmar_mail_vecino    =   '';
                            me.nm_direccion     =   '';
                            me.nr_direccion     =   '';
                            me.str_aclaratoria_vecino   =   '';
                            me.str_observacion  =   '';
                            me.tp_activo        =   1;
                            me.arr_archivo      =   [];
                            me.solicitud_actual =   [];
                            me.arr_files_obs    =   [];
                            me.arr_files        =   [];
                            me.arr_archivo      =   [];
                            me.nr_tp_direccion_solicitud    =   1;
                            tp_ubicacion_vecino         =   1;
                            me.arr_direccion_solicitud  =   [];
                            me.arr_ubicacion_vecino     =   [];
                            me.nm_ubicacion_vecino      =   '';

                            me.nr_tipo                  =   {
                                'value' : 0,
                                'label' : 'Seleccione Servicio',
                                'id_direccion' : 0,
                            };
                            me.nr_motivo                =   {
                                value: 5,
                                label: "Solicitud",
                            };
                            me.nr_region                =   {
                                value: 13,
                                label: "Metropolitana de Santiago",
                            };
                            me.nr_comuna                =   {
                                value: 287,
                                label: "San Miguel",
                            };
                            me.tp_comuna                =   1;
                            me.tp_ubicacion             =   1;

                            break;
                        }
                        case 'archivo':
                        {
                            me.file_observacion =   '';
                            me.arr_error        =   [];
                            me.arr_valida       =   [];
                            me.tp_error         =   0;
                            me.descartarAdjunto();

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                validarAdjunto(tipo, accion)
                {
                    let me              =   this;
                    var extension       =   '';
                    var fileSize        =   0;
                    var file_adjunto    =   '';
                    var file_value      =   '';
                    var max             =   3;
                    var error           =   0;
                    me.arr_error        =   [];


                    switch(tipo)
                    {
                        case "documento":
                        {
                            file_adjunto    =   document.querySelector("#file_adjunto");
                            file_value      =   file_adjunto.value;
                            var tipo_ext    =   ['.jpeg','.jpg','.png','.doc','.docx','.xls','.xlsx',
                                                '.ppt','.pptx','.msg','.pdf','.dwg','.dgn','.rar','.zip'];

                            if(file_value != "")
                            {
                                var fileSize  = file_adjunto.files[0].size;
                                extension = (file_value.substring(file_value.lastIndexOf("."))).toLowerCase();

                                if(fileSize > 20971520 ) 
                                    me.arr_error.push("El archivo adjunto NO debe superar los 20 MB");

                                if(!tipo_ext.includes(extension))
                                    me.arr_error.push("El archivo seleccionado No es adminido");

                                if(me.arr_archivo.length == max)
                                    me.arr_error.push("Solo se pueden adjuntar "+max+" archivos maximo");

                                if(me.file_observacion.trim() == '' && me.tp_save_adjunto == 0)
                                {
                                     me.arr_error.push("No se ha ingresado la descripción del adjunto.","Desea continuar de todos modos.");
                                     me.tp_save_adjunto = 1;
                                }
                            }


                            if(me.arr_error.length && me.file_observacion.trim() != '')
                                me.descartarAdjunto();

                            if(accion == "save" && me.arr_error.length == 0 && file_value != "")
                            {
                                me.arr_files.push(file_adjunto.files[0]);
                                me.arr_files_obs.push(me.file_observacion);
                                me.arr_archivo.push({'file':file_adjunto.files[0], 'descripcion':me.file_observacion,'sizeMB':parseFloat((file_adjunto.files[0].size/1048576).toFixed(2)),'sizeKB':file_adjunto.files[0].size});                                
                                $('#modal_adjunto').modal('hide');
                                me.descartarAdjunto();
                                me.limpiarDatos('archivo');
                                me.tp_save_adjunto  =   0;

                                me.total_mb_archivos = me.arr_archivo.reduce((sum, value) => (typeof value.sizeMB == "number" ? sum + value.sizeMB : sum), 0);
                                me.total_mb_archivos = me.total_mb_archivos.toFixed(2);
                            }

                            break;
                        }
                    }

                    if(me.arr_error.length) 
                    {
                        error   =   1;
                        me.file_error   =   1;
                    }

                    return error;
                },
                //-------------------------------------------------------------------------------------------
                descartarAdjunto()
                {
                    let me              =   this;
                    var file_adjunto    =   '';

                    file_adjunto    =   document.querySelector("#file_adjunto");

                    if(file_adjunto)
                    {
                        document.querySelector("#file_adjunto").value = "";
                    }
                },
                //-------------------------------------------------------------------------------------------
                quitarAdjunto(modelo, index)
                {
                    let me          =   this;
                    me.arr_error    =   [];

                    switch(modelo)
                    {
                        case 'archivo':
                        {
                            me.arr_files.splice(index, 1);
                            me.arr_archivo.splice(index, 1);
                            me.arr_files_obs.splice(index, 1);

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                validarMail(tp_validar = 0)
                {
                    let me          =   this;
                    var valida      =   null; // Valida Mail Vecino
                    var error       =   0;

                    me.mail_vecino  =   me.mail_vecino.trim().toLowerCase();
                    me.confirmar_mail_vecino    =   me.confirmar_mail_vecino.trim().toLowerCase();

                    if(tp_validar == 0)
                        me.arr_form    =   {};

                    if(me.tp_vecino == 1)
                    {
                        if(me.mail_vecino.trim().length)
                        {                            
                            valida     =   formatoMail(me.mail_vecino.trim());

                            if(valida == false)
                                me.arr_form.mail_vecino = 'Correo electrónico no es valido';
                        }
                        else
                            me.arr_form.mail_vecino = 'Debe ingresar correo electrónico';


                        if(me.confirmar_mail_vecino.trim().length)
                        {
                            valida     =   formatoMail(me.confirmar_mail_vecino.trim());

                            if(valida == false)
                                me.arr_form.confirmar_mail = 'Correo electrónico no es valido';
                        }
                        else
                            me.arr_form.confirmar_mail = 'Debe ingresar correo electrónico';

                        if(!(me.mail_vecino.trim() === me.confirmar_mail_vecino.trim()) && 
                            (me.mail_vecino.trim().length && me.confirmar_mail_vecino.trim().length))
                                me.arr_form.confirmar_mail = 'Los correos electrónicos no coinciden, favor validar';

                        if(Object.keys(me.arr_form).length)
                            error   =   1;
                    }

                    return error;
                },
                //-------------------------------------------------------------------------------------------
                validarRut(tp_validar = 0)
                {
                    let me          =   this;
                    var valida      =   null;
                    
                    if(tp_validar == 0)
                        me.arr_form    =   {};

                    valida  =   Rut(me.rut_vecino.trim());

                    if(me.rut_vecino.trim().length && valida == false)
                        me.arr_form.rut_vecino = 'Rut ingresado no es valido';

                    if(!me.rut_vecino.trim().length)
                        me.arr_form.rut_vecino = 'Debe ingresar Rut';
                },
                //-------------------------------------------------------------------------------------------
                validarDatos(tp_validacion)
                {
                    let me          =   this;
                    var error       =   0;
                    me.str_error    =   '';
                    me.arr_form    =   {};

                    switch(tp_validacion)
                    {
                        case 'ingresar':
                        {
                            //----------------------------------------------------------
                            me.validarMail(1);
                            me.validarRut(1);                            
                            //----------------------------------------------------------
                            /*----- Valida Datos del Vecino -----*/
                            if(me.nm_vecino.trim().length < 3)
                                me.arr_form.nm_vecino   =   'El Nombre debe tener mínimo 3 caracteres';

                            if(me.ap_paterno.trim().length < 3)
                                me.arr_form.ap_paterno   =   'El Primer Apellido debe tener mínimo 3 caracteres';

                            if(me.ap_materno.trim().length < 3)
                                me.arr_form.ap_materno   =   'El Segundo Apellido debe tener mínimo 3 caracteres';

                            if(me.nr_telefono.trim().length < 8)
                                me.arr_form.nr_telefono =   'Favor verificar el número de Telefono';                          

                            if(me.getValue(me.nr_region) == 0)
                                me.arr_form.nr_region   =   'Debe seleccionar una Región';

                            if(me.getValue(me.nr_comuna) == 0)
                                me.arr_form.nr_comuna   =   'Debe seleccionar una Comuna';

                            if(me.tp_comuna == 1)
                            {
                                if(Object.keys(me.arr_ubicacion_vecino).length == 0)
                                    me.arr_form.nm_ubicacion_vecino     =   'Debe seleccionar la Dirección de residencia';
                            }
                            else
                            {
                                if(me.nm_ubicacion_vecino.trim().length < 5)
                                    me.arr_form.nm_ubicacion_vecino     =   'Debe ingresar la Dirección de residencia';
                            }
                            //----------------------------------------------------------
                            /*----- Valida Datos de la Solicitud -----*/
                            if(me.getValue(me.nr_motivo) == 0)
                                me.arr_form.nr_motivo   =   'Debe seleccionar Tipo de Requerimiento';

                            if(me.getValue(me.nr_tipo) == 0)
                                me.arr_form.nr_tipo     =   'Debe seleccionar Servicio';

                            if(Object.keys(me.arr_direccion_solicitud).length == 0 && me.tp_ubicacion == 1)
                                me.arr_form.nm_ubicacion_solicitud  =   'Debe ingresar la Dirección del Requerimiento';

                            if(tinymce.get("str_observacion").plugins.wordcount.body.getCharacterCount() <  10)
                                me.arr_form.str_observacion     =   'La Descripción de Requerimiento debe tener minimo 10 caracteres';

                            if(tinymce.get("str_observacion").plugins.wordcount.body.getCharacterCount() >  2000)
                                me.arr_form.str_observacion     =   'La Descripción del Requerimiento debe tener maximo 2000 caracteres';
                            //----------------------------------------------------------
                            if(Object.keys(me.arr_form).length)
                                error   =   1;
                            //----------------------------------------------------------
                            break;
                        }
                    }    

                    return error;
                },
                //-------------------------------------------------------------------------------------------
                ensamblarDatos(accion,tp_consulta = 0)
                {
                    let me              =   this;
                    var ruta            =   '';
                    var titulo          =   '';
                    var tiempo          =   0;
                    var error           =   0;                    
                    var formData        =   new FormData();
                    var fc_format       =   'YYYY-MM-DD';
                    var dir_vecino      =   '';
                    var dir_solicitud   =   '';
                    var nr_dir_solicitud    =   '';
                    var nr_dir_vecino       =   '';
                    me.tp_error         =   0;
                    me.arr_valida       =   [];
                    me.arr_form        =   {};               
                    titulo              =   'Registrando de Requerimiento';
                    tiempo              =   3000;                      
                    //------------------------------------
                    error   =   me.validarDatos('ingresar');

                    if(error == 1)
                    {
                        me.desplegarVentana('warning', 'Registrar Requerimiento', 'Favor revisar los datos faltantes del formulario. <br><br> ' + 
                            'Si requiere ayuda para ingresar su requerimiento favor comunicarse al <strong>Fono Ayuda: 02- 29507800</strong>');
                        return;
                    }
                    else
                    {
                        //-----------------------------------------------------------------------------------
                        ruta    =   '/solicitud/vecino/store';
                        //-----------------------------------------------------------------------------------
                        // key uuid para identificar el formulario
                        formData.append('key_uuid', me.key_uuid);
                        //-----------------------------------------------------------------------------------
                        // Datos de Vecino
                        formData.append('tp_vecino', me.tp_vecino);
                        formData.append('rut_vecino', me.rut_vecino.trim());
                        formData.append('nm_vecino', me.nm_vecino);
                        formData.append('ap_paterno', me.ap_paterno);
                        formData.append('ap_materno', me.ap_materno);
                        formData.append('nm_mail', me.mail_vecino);
                        formData.append('pre_fijo', me.pre_fijo);
                        formData.append('nr_telefono', me.nr_telefono);
                        formData.append('nr_region', me.getValue(me.nr_region));
                        formData.append('nr_comuna', me.getValue(me.nr_comuna));
                        formData.append('tp_comuna', me.tp_comuna);
                        formData.append('tp_ubicacion_vecino', me.tp_ubicacion_vecino);

                        if(me.tp_comuna == 1)
                            formData.append('arr_ubicacion_vecino[]', JSON.stringify(me.arr_ubicacion_vecino));
                        else
                            formData.append('nm_ubicacion_vecino', me.nm_ubicacion_vecino);

                        formData.append('str_aclaratoria_vecino', me.str_aclaratoria_vecino);
                        //-----------------------------------------------------------------------------------
                        // Datos de Solicitud
                        formData.append('tp_municipal', me.tp_municipal);
                        formData.append('nr_motivo', me.getValue(me.nr_motivo));
                        formData.append('nr_tipo', me.getValue(me.nr_tipo));
                        formData.append('nm_tipo', me.getLabel(me.nr_tipo ));
                        formData.append('arr_direccion_solicitud[]', JSON.stringify(me.arr_direccion_solicitud));
                        formData.append('str_aclaratoria_solicitud', me.str_aclaratoria_solicitud);
                        formData.append('str_observacion', tinymce.get("str_observacion").getContent({format: "text"}));
                        formData.append('str_observacion_html', tinymce.get("str_observacion").getContent({format: "html"}));
                        formData.append('nr_dir_municipal', me.nr_dir_municipal);
                        formData.append('nr_depto', me.nr_depto);
                        formData.append('tp_ubicacion', me.tp_ubicacion);
                        formData.append('nr_prioridad', me.nr_prioridad);
                        formData.append('tp_ingreso', 6); // audiencia
                        //-----------------------------------------------------------------------------------
                        if(me.arr_files.length != 0)
                        {
                            for (var i = 0; i < me.arr_files.length; i++) 
                            {
                                formData.append('arr_archivo[]', me.arr_files[i]);
                            }
                            for (var i = 0; i < me.arr_files_obs.length; i++) 
                            {
                                formData.append('arr_observacion[]', me.arr_files_obs[i]);
                            }
                        }
                        //-----------------------------------------------------------------------------------
                        me.registrarDatos(ruta, formData);
                        //-----------------------------------------------------------------------------------
                    }
                },
                //-------------------------------------------------------------------------------------------
                registrarDatos(ruta, formData)
                {
                    let me              =       this;
                    var tp_icon         =       '';
                    var titulo          =       '';
                    var mensaje         =       '';
                    var error           =       '';
                    me.arr_valida       =       [];
                    me.btn_envio        =        1;

                    axios.post(ruta, formData, {
                        headers: {'Content-Type': 'multipart/form-data'}
                    }).then(function (response) 
                    {
                        var result  =   response.data;
                        tp_icon     =   result.tp_icon;
                        titulo      =   result.title;
                        mensaje     =   result.msj;
                        error       =   result.error;

                        me.desplegarVentana(tp_icon, titulo, mensaje);

                        if(error == 0) {
                            me.limpiarDatos('registrar');
                            tinymce.get("str_observacion").setContent('');
                            me.key_uuid     =   me.generateUUID();
                        }

                        me.btn_envio    =   0;
                    })
                    .catch(function (error) 
                    {
                        me.btn_envio    =   0;

                        if (error.response.status == 422) {
                            me.arr_valida   =   error.response.data.errors;

                             // Error específico de UUID duplicado
                            if (me.arr_valida.key_uuid) {
                                me.desplegarVentana(
                                    'warning', 
                                    'Solicitud Ya Procesada', 
                                    me.arr_valida.key_uuid[0] + '<br><br>Su solicitud anterior fue registrada correctamente.'
                                );                                
                                // Generar nuevo UUID para próximos envíos
                                me.key_uuid     =   me.generateUUID();
                                
                            } else {
                                let erroresHtml =   '<ul style="text-align: left;">';
                                Object.keys(me.arr_valida).forEach(field => {
                                    me.arr_valida[field].forEach(error => {
                                        erroresHtml += `<li>${error}</li>`;
                                    });
                                });
                                erroresHtml += '</ul>';
                                
                                me.desplegarVentana('error', 'Errores de Validación', erroresHtml);
                            }
                        }
                    });
                },
                //-------------------------------------------------------------------------------------------
                abrirModal(modelo, accion, data = [])
                {
                    let me      =       this;

                    switch(modelo)
                    {
                        case 'archivo':
                        {
                            switch(accion)
                            {
                                case 'anexar':
                                {
                                    me.modal_adjunto        =   1;
                                    me.accion_adjunto       =   1;
                                    me.titulo_adjunto       =   'Adjuntar Documentos';
                                    me.tp_adjunto           =   'documento';
                                    me.limpiarDatos(modelo);
                                    $('#modal_adjunto').modal('show');

                                    break;
                                }
                            }

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                mostrarVideoSwal() {
                    let me  =   this;
                    let title = 'Búsqueda de servicio escribiendo una palabra';
                    const videoHtml = `
                        <div style="text-align:center;">
                            <video width="100%" height="auto" controls autoplay muted style="max-height:70vh;">
                                <source src="{{ $url_video }}" type="video/mp4">
                                Tu navegador no soporta la reproducción de video.
                            </video>
                        </div>
                    `;

                    me.desplegarVideo('info', title, videoHtml, 1);
                },
                //-------------------------------------------------------------------------------------------
                desplegarVentana(tp_icon, titulo, mensaje, tp_btn = 1)
                {
                    Swal.fire({
                        icon: tp_icon,
                        title: titulo,
                        html: mensaje,
                        backdrop:false,
                        showConfirmButton: tp_btn
                    });
                },
                //-------------------------------------------------------------------------------------------
                desplegarNotificacion(tp_icon, titulo, mensaje, tp_btn = 1)
                {
                    Swal.fire({
                        icon: tp_icon,
                        title: titulo,
                        width: 1200,
                        height: '80%',
                        html: mensaje,
                        backdrop:false,
                        showConfirmButton: tp_btn
                    });
                },
                //-------------------------------------------------------------------------------------------
                desplegarVideo(tp_icon, titulo, mensaje, tp_btn = 1) {
                    Swal.fire({
                        icon: tp_icon,
                        title: titulo,
                        width: 1200,
                        html: mensaje,
                        backdrop: true,
                        showConfirmButton: tp_btn
                    });
                },
                //-------------------------------------------------------------------------------------------
            },

            mounted() {
                let me = this;
                me.key_uuid = me.generateUUID();
                me.cargarRegiones();
                me.cargarComunas(13);
                me.cargarMotivo();
                me.cargarServicios();
                me.cargarTinyMCE();
                me.existeTextArea();
            }
        });
    </script>

    <script type="text/javascript">
        //-----------------------------------------------------------------
        $(document).ready(function(){
            /*----- Inicio - Bloquear Acciones -----*/
            $('#mail_vecino').on('cut copy paste', function(e){
                e.preventDefault();
            });

            $('#confirmar_mail_vecino').on('cut copy paste', function(e){
                e.preventDefault();
            });
            /*----- Termino - Bloquear Acciones -----*/

            /*----- Formatea Rut -----*/
            $("#rut_vecino").change(function()
            { 
                var nr_rut = $("#rut_vecino").val();
                var salida = Rut(nr_rut);

                if(salida)
                    $("#rut_vecino").val(salida);
            });
        });
        //-----------------------------------------------------------------
        function justNumbers(e)
        {
            var keynum = window.event ? window.event.keyCode : e.which;
            if (keynum == 8)
                return true;

            return /\d/.test(String.fromCharCode(keynum));
        }
        //-----------------------------------------------------------------
        function Rut(texto)
        { 
            var tmpstr = "";

            for ( i=0; i < texto.length ; i++ )   
                if ( texto.charAt(i) != ' ' && texto.charAt(i) != '.' && texto.charAt(i) != '-' )
                    tmpstr = tmpstr + texto.charAt(i);

            texto = tmpstr; 
            largo = texto.length; 

            if ( largo < 2 ) 
                return false; 

            for (i=0; i < largo ; i++ )    
                if (texto.charAt(i) !="0" && texto.charAt(i) != "1" && texto.charAt(i) !="2" && texto.charAt(i) != "3" && 
                    texto.charAt(i) != "4" && texto.charAt(i) !="5" && texto.charAt(i) != "6" && texto.charAt(i) != "7" && 
                    texto.charAt(i) !="8" && texto.charAt(i) != "9" && texto.charAt(i) !="k" && texto.charAt(i) != "K")   
                    return false;

            var invertido = "";

            for ( i=(largo-1),j=0; i>=0; i--,j++ )    
                invertido = invertido + texto.charAt(i);

            var dtexto = "";  
            dtexto = dtexto + invertido.charAt(0);  
            dtexto = dtexto + '-';  
            cnt = 0;  

            for ( i=1,j=2; i<largo; i++,j++ ) 
            { 
                if ( cnt == 3 )   
                {     
                    dtexto = dtexto + '.';      
                    j++;      
                    dtexto = dtexto + invertido.charAt(i);      
                    cnt = 1;    
                }   
                else    
                {       
                    dtexto = dtexto + invertido.charAt(i);      
                    cnt++;    
                } 
            } 

            invertido = "";

            for ( i=(dtexto.length-1),j=0; i>=0; i--,j++ )    
                invertido = invertido + dtexto.charAt(i);

            if (revisarDigito2(texto))
                return  invertido.toUpperCase();

            return false;
        }
        //-----------------------------------------------------------------
        function formatoMail(valor)
        {
            if (/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test(valor))
                return true;
            else
                return false;
        }
        //-----------------------------------------------------------------
    </script>
@endsection()


