@extends('template.home')

@section('body')
<div class="page-content">
    <div class="container-fluid" id="app">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0 font-size-18">Bandeja de Solicitudes</h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Solicitudes</a></li>
                            <li class="breadcrumb-item active">Bandeja de Solicitudes</li>
                        </ol>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-3 col-md-4 col-sm-6" style="text-align:left;">
                        <!-- Filtro por Estado -->
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-md-3">
                                    <label class="form-control-label" for="text-input">
                                        Filtro por Estado
                                    </label>
                                </div>
                                <div class="col-md-8">
                                    <select @change="cargarDatos()"  v-model="fl_mostrar" class="form-control estados">
                                        <option v-for="item in arr_mostrar" :value="item.value" v-text="item.label"></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-4 col-sm-6" style="text-align: center;">
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-md-3">
                                    <label class="form-control-label" for="text-input">
                                        Filtro por Rango de Fechas
                                    </label>
                                </div>
                                <div class="col-md-8">
                                    <div class="input-group">
                                        <input type="text" class="form-control" name="fc_desde" id="fc_desde" placeholder="Desde" />
                                        <input type="text" class="form-control" name="fc_hasta" id="fc_hasta" placeholder="Hasta" />
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-5 col-md-4 col-sm-6" style="text-align:right">
                        <button id="btn_actualizar" class="btn btn-primary btn_activo" @click="cargarDatos();">
                            <i class="fas fa-sync"></i> Actualizar
                        </button>

                        <button class="btn btn-primary btn_activo" id="btn_filtrar_datos">
                            <i class="fas fa-search"></i> Filtrar Datos
                        </button>
                    </div>
                </div>

                <div class="row">
                    <!-- Filtro de Datos -->
                    <div class="col-md-12 col-sm-12">
                        <div class="collapse" id="filtrar_datos">
                            <div class="card">
                                <div class="card-header bg--primary">
                                    <div class="col-md-12 col-sm-12 text-center">
                                        <h5>Filtro de busqueda</h5>
                                    </div>
                                </div>
                                <div class="card-body">

                                    <div class="row ml-2 mr-2">
                                        <div class="col-md-12 col-sm-12"> </div>
                                        <!-- Servicio -->
                                        <div class="col-md-4 col-sm-6">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Servicio :
                                                </label>
                                                <multiselect
                                                    :show-labels="false" 
                                                    :searchable="true" 
                                                    v-model="fl_tipo" 
                                                    :options="arr_tipos" 
                                                    :multiple="false" 
                                                    :showNoOptions="false" 
                                                    placeholder="Seleccione Servicio" 
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>

                                        <!-- Motivo -->
                                        <div class="col-md-4 col-sm-6">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Tipo Requerimiento :
                                                </label>
                                                <multiselect
                                                    :show-labels="false" 
                                                    :searchable="true" 
                                                    v-model="fl_motivo" 
                                                    :options="arr_motivo" 
                                                    :multiple="false" 
                                                    :showNoOptions="false" 
                                                    placeholder="Seleccione Tipo Requerimiento" 
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>

                                        <!-- N° Ticket -->
                                        <div class="col-md-4 col-sm-6">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    N° Ticket :
                                                </label>
                                                <multiselect 
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_ticket"
                                                    :options="arr_ticket"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="N° Ticket"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>

                                        <!-- Unidad Vecinal -->
                                        <div class="col-md-4 col-sm-6">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Unidad Vecinal :
                                                </label>
                                                <multiselect 
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_unidadvecinal"
                                                    :options="arr_unidadvecinal"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Unidad Vecinal"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>

                                        <!-- Dirección Municipal -->
                                        <div class="col-md-4 col-sm-6">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Dirección Municipal :
                                                </label>
                                                <multiselect 
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_direccion"
                                                    :options="arr_dir_municipal"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Dirección Municipal"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>

                                        <!-- Solicitante -->
                                        <div class="col-md-4 col-sm-6">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Solicitante :
                                                </label>
                                                <multiselect
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_persona"
                                                    :options="arr_persona"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Solicitante"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>

                                        <!-- Ubicación -->
                                        <div class="col-md-4 col-sm-6">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Dirección del Requerimiento :
                                                </label>
                                                <multiselect
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_ubicacion"
                                                    :options="arr_ubicaciones"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Dirección del Requerimiento"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <div style="float: right;">
                                        <button @click="limpiarFiltros()" type="button" class="btn btn-warning btn-sm btn_activo" style="color: white;">
                                            <i class="fas fa-undo"></i> Quitar Filtros
                                        </button>&nbsp;
                                        <button @click="filtrarDatos()" type="button" class="btn btn-primary btn-sm btn_activo"><i class="fas fa-search"></i>
                                            Filtrar Búsqueda
                                        </button>

                                        <button class="btn btn-secondary btn-sm btn_activo" id="close_filtrar_datos">
                                            Cerrar Filtro
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Tabla de Datos -->
                    <div class="responsive-table">
                        <table  class="table table-bordered border-info table-striped table-sm table-hover bl-1">
                            <thead class="bg-primary">
                                <th colspan="15" >
                                    <h6 class="text-center" style="color:white" >
                                        Listado de Solicitudes
                                    </h6>
                                </th>
                            </thead>
                            <thead class="bg-primary"  style="color:white">
                                <th class="text-center">#</th>
                                <th class="text-center" style="min-width:100px;">Opciones</th>
                                <th>Ticket</th>
                                <th class="text-center">Tipo de Requerimiento</th>
                                <th>Vecino Asociado</th>
                                <th>Fecha Ingreso</th>
                                <th>Tipo Solicitud</th>
                                <th>Tipo Ingreso</th>
                                <th>Dirección</th>
                                <th>Importante</th>
                                <th>Tiempo Tramitado</th>
                                <th>Tiene Publicación Parcial</th>
                                <th>Estado</th>
                            </thead>
                            <tbody>
                                <template v-if="arr_solicitudes.length">
                                    <tr v-for="(datos, index) in arr_solicitudes" :key="datos.id">
                                        <td style="text-align:center;">
                                            @{{ (index + 1) }}
                                        </td>
                                        <td style="text-align:center;">
                                            <button type="button" @click="abrirModal('solicitud', 'actualizar', datos);"
                                                    class="btn btn-primary btn-sm" 
                                                    :class="{'btn-success':datos.id_estado == 5 || datos.id_estado == 6,
                                                             'btn-warning':datos.id_estado == 3 || datos.id_estado == 4,
                                                             'btn-danger':datos.id_estado == 7,
                                                         }"
                                                    title="Revisar Solicitud">
                                                        <template v-if="datos.id_estado == 1">
                                                            <i class="fas fa-pencil-alt" style="color:white"></i>
                                                        </template>
                                                        <template v-else>
                                                            <i class="fas fa-search" style="color:white"></i>
                                                        </template>
                                            </button>
                                        </td>
                                        <td style="text-align:center;">
                                            @{{ datos.nr_ticket }}
                                        </td>
                                        <td style="text-align:center;">
                                            @{{ datos.nm_motivo }}
                                        </td>
                                        <td style="text-align:center;">
                                            @{{ datos.tp_vecino }}
                                            </td>
                                        <td style="text-align:center;">
                                            @{{ datos.fc_ingreso | formatDate }}
                                        </td>
                                        <td style="text-align:center;">
                                            @{{ datos.nm_tipo }}
                                        </td>
                                         <td style="text-align:center;">
                                            @{{ datos.nm_ingreso }}
                                        </td>
                                        <td  style="text-align:center; color: black;">
                                            @{{ datos.nm_ubicacion }}
                                        </td>
                                        <td style="text-align:center; color: black;">
                                            @{{ datos.prioridad.nm_prioridad }}
                                        </td>                                            
                                      
                                        <td style="text-align:center;">
                                            @{{ datos.tiempo_tramitado }}
                                        </td>

                                        <td style="text-align: center;">
                                            @{{ datos.tiene_pp }}
                                        </td>

                                        <td style="text-align:center;" :style="{'background-color':datos.nm_color}">
                                            <span style="font-weight: bold !important;">@{{ datos.nm_estado }}</span>
                                        </td>
                                    </tr>
                                </template>
                                <template v-else>
                                    <tr>
                                        <td colspan="15">
                                            <h5 class="text-center">
                                                No hay datos para listar
                                            </h5>
                                        </td>
                                    </tr>
                                </template>
                            </tbody>
                        </table>
                    </div>

                    <!-- Paginacion -->
                    <div class="col-md-12 col-sm-12">
                        <nav>
                            <ul class="pagination">
                                <li class="page-item" v-if="pagination.current_page > 1">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(pagination.current_page - 1)">Ant</a>
                                </li>
                                <li class="page-item" v-for="page in pagesNumber" :key="page" :class="[page == isActivedPagination ? 'active' : '']">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(page, 1)" v-text="page"></a>
                                </li>
                                <li class="page-item" v-if="pagination.current_page < pagination.last_page">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(pagination.current_page + 1)">Sig</a>
                                </li>
                            </ul>
                        </nav>
                    </div>                      
                </div>
            </div>
        </div>        

        <div class="modal" tabindex="-1" id="modal_historial">
            <div class="modal-dialog modal-dialog-scrollable modal-xl">
                <div class="modal-content">
                  <div class="modal-header bg-primary">
                    <h5 class="modal-title text-white">Historial 
                        <template v-if="nr_ticket">@{{ ' - #' + nr_ticket }}</template>
                        <template v-if="nr_ticket">@{{ ' - Estado Actual : ' + nm_estado }}</template>
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                  </div>
                  <div class="modal-body" id="historia_solicitud">
                        <ul class="verti-timeline list-unstyled">
                            <li :class="{'active':index == arr_historial.length -1}" class="event-list" v-for="(hist,index) in arr_historial">
                                <div class="event-timeline-dot">
                                    <i v-if="index == arr_historial.length -1" class="bx bx-right-arrow-circle bx-fade-right"></i>
                                    <i v-else class="bx bx-right-arrow-circle"></i>
                                </div>
                                <!-- Ingresada -->
                                <div class="d-flex" v-if="index == 0">
                                    <div class="flex-shrink-0 me-3">
                                        <i  class="bx bx-save h2 text-primary"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <div>
                                            <span style="float: right;">Duración @{{hist.fc_diferencia}} Días</span>

                                            <h5 > Solicitud ingresada a las @{{hist.fc_inicio}}</h5>
                                            <p class="text-muted">Solicitud <strong>#@{{hist.nr_ticket}}</strong> ingresada por <strong>@{{hist.nm_autor}}</strong></p>

                                            <div v-if="solicitud_actual.vecino" class="mt-2">
                                                <h5>- Vecino Asociado</h5>
                                                <p>
                                                    <strong>Nombre: </strong>  @{{nm_vecino+' '+ ap_paterno + ' '+ ap_materno}} <br>
                                                    <strong>Rut:</strong>  @{{rut_vecino}} <br>
                                                    <strong>Domicilio:</strong> <a target="_blank" :href="'https://maps.google.com/?q='+arr_ubicacion_vecino.label+'&z=15&t=m'">@{{arr_ubicacion_vecino.label}}</a> <br>
                                                    <strong>Correo:</strong>  @{{mail_vecino}}<br>
                                                    <strong>Télefono:</strong> @{{pre_fijo+nr_telefono}}
                                                </p>
                                            </div>

                                            <div class="mt-2">
                                                <h5>- Datos Solicitud</h5>
                                                <p>
                                                    <strong>Tipo de Solicitud : </strong> @{{hist.nm_tipo}}     <br>
                                                    <strong>Dirección</strong> : 
                                                        <a target="_blank" :href="'https://maps.google.com/?q='+arr_direccion_solicitud.label+'&z=15&t=m'">
                                                            @{{arr_direccion_solicitud.label}}
                                                        </a> <br>
                                                    <template v-if="solicitud_actual.str_aclaratoria">
                                                        <strong>Aclaratoria : </strong> @{{ solicitud_actual.str_aclaratoria }} <br>
                                                    </template>
                                                    <strong>Descripción : </strong> <span v-html="hist.str_solicitud_html"></span><br>
                                                </p>

                                            </div>

                                            <div v-if="solicitud_actual.archivos && solicitud_actual.archivos.length" class="table-responsive">
                                                <table class="table table-sm table-bordered">
                                                    <thead class="bg-primary">
                                                        <th colspan="3" class="text-center text-white"> Archivos Adjuntos</th>
                                                    </thead>
                                                    <thead>
                                                        <th>Opción</th>
                                                        <th>Nombre</th>
                                                        <th>Descripción</th>
                                                    </thead>
                                                    <tbody>
                                                        <tr v-for="(item,index) in solicitud_actual.archivos">
                                                            <td>
                                                                <a target="_blank" :href="'/files/get?ruta='+item.str_archivo" class="btn btn-md btn-success btn-sm" style="margin-left: 5px;"><i  class="bx bxs-download"></i>
                                                                </a>
                                                            </td>
                                                            <td>@{{item.nm_archivo}}</td>
                                                            <td>@{{item.str_observacion}}</td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Por Asignar -->
                                <div class="d-flex" v-if="hist.id_estado == 2">
                                    <div class="flex-shrink-0 me-3">
                                        <i  class="bx bx-search h2 text-primary"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <div>
                                            <!-- Datos de Cabecera -->
                                            <span style="float: right;">Duración @{{hist.fc_diferencia}} Días</span>
                                            <span>Estado :  <strong v-text="hist.nm_estado"></strong></span> 
                                            <p class="text-muted mb-0">Solicitud 
                                                <strong>#@{{hist.nr_ticket}}</strong> ingresada por 
                                                <strong>@{{hist.nm_autor}}</strong>
                                            </p>
                                            <strong>Observación Visado :</strong> <span v-text="hist.str_observacion"></span>
                                        </div>
                                    </div>
                                </div>

                                <template v-if="hist.id_estado == 3">
                                    <div class="page-break-after"></div>    
                                </template>

                                <!-- Revisión -->
                                <div class="d-flex" v-if="hist.id_estado == 3">
                                    <div class="flex-shrink-0 me-3">
                                        <i  class="bx bx-search h2 text-primary"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <div>
                                            <span style="float: right;">Duración @{{hist.fc_diferencia}} Días</span>
                                            <p class="text-muted">Solicitud <strong>#@{{hist.nr_ticket}}</strong> aprobada por <strong>@{{hist.nm_autor}}</strong></p>
                                            Estado :  <strong v-text="hist.nm_estado"></strong> <br>
                                            <strong>Observación Asignación :</strong> <span v-text="hist.str_observacion"></span> 
                                            <button type="button" @click="abrirModal('archivo', 'examinar', solicitud_actual)" 
                                                class="btn btn-primary btn-sm" title="Revisar Adjuntos" v-if="solicitud_actual.archivos_asignacion.length">
                                                    <i class="fas fa-paperclip"></i>
                                            </button>

                                            <!-- Tabla de Encargados -->
                                            <div class="col-lg-12 col-md-12 col-sm-12 table-responsive mt-2" v-if="arr_asignados.length">
                                                <table class="table table-bordered table-striped table-sm">
                                                    <thead>
                                                        <tr class="bg-primary">
                                                            <th colspan="5" class="text-center" style="color: white;">Lista de Funcionarios</th>
                                                        </tr>
                                                        <tr>
                                                            <th style="min-width:100px; text-align:center;">#</th>
                                                            <th style="min-width:150px; text-align:center;">Dirección</th>
                                                            <th style="min-width:200px; text-align:center;">Departamento</th>
                                                            <th style="min-width:100px; text-align:center;">Nombre</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <template v-if="arr_asignados.length">
                                                            <tr v-for="(asignado, index) in arr_asignados" :key="asignado.value">
                                                                <td class="text-center">@{{ (index + 1) }}</td>
                                                                <td class="text-center">@{{ asignado.nm_direccion }}</td>
                                                                <td class="text-center">@{{ asignado.nm_depto }}</td>
                                                                <td class="text-center">@{{ asignado.nm_funcionario }}</td>
                                                            </tr>
                                                        </template>
                                                        <template v-else>
                                                            <td colspan="5">
                                                                <div class="empty" empty-text="No hay datos para listar"></div>
                                                            </td>
                                                        </template>
                                                    </tbody>
                                                </table>
                                            </div>

                                            <!-- Tabla de Respuestas -->
                                            <div class="col-md-12 mt-2" v-if="arr_respuestas.length">
                                                <h6> Gestión Interna</h6>
                                                <ul class="timeline col-md-12 col-sm-12 ml-3">
                                                    <li class="mt-0 pt-0 mb-0 pb-0" v-for="(item,index) in arr_respuestas" :key="item.id">
                                                        <div class="timeline-arrow"></div>
                                                        <a class="d-block mb-0" href="#" vi>
                                                            <div class="row">
                                                                <div class="col-lg-8 col-md-6 order-md-first order-last">
                                                                    @{{ item.nm_respuesta + ' - ' + item.usuario | capitalize }} 
                                                                    <button type="button" @click="abrirModal('archivo', 'revisar', item)" 
                                                                        class="btn btn-primary btn-sm" title="Revisar Adjuntos" v-if="item.archivos.length">
                                                                        <i class="fas fa-paperclip"></i>
                                                                    </button>
                                                                </div>
                                                                <div class="col-lg-4 col-md-6 text-right">
                                                                    <i class="far fa-calendar"></i> 
                                                                    @{{ item.fc_ingreso | formatDateTime }}
                                                                </div>
                                                            </div>
                                                        </a>
                                                        <div class="not-print">
                                                            <p class="text-small font-weight-light mb-0">
                                                                <template v-if="getCantidadCaracteres(item.str_observacion) < 300">
                                                                    <span v-html="item.str_observacion_html"></span>
                                                                </template>
                                                                <template v-else>
                                                                    <template v-if="(tp_visualizar.tp_resumir == 0 || tp_visualizar.tp_resumir == 1) && tp_visualizar.nr_index != index">
                                                                            @{{ item.str_observacion | resumir }} 
                                                                            <a href="#" class="link-primary" style="float: right;" @click="setResumir(0, index)"> VER</a>
                                                                    </template>
                                                                    <template v-else>
                                                                        <span v-html="item.str_observacion_html"></span>
                                                                        <a href="#" class="link-primary" style="float: right;" @click="setResumir(1, null)"> ACOTAR</a>
                                                                    </template>
                                                                </template>
                                                            </p>
                                                        </div>
                                                        <div class="to-print-respuesta">
                                                            <p class="text-small font-weight-light mb-0" class="to-print-respuesta" style="display: none;">
                                                                <span v-html="item.str_observacion_html"></span>
                                                            </p>
                                                        </div>
                                                        <hr class="mt-1 mb-1">
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Publicada -->
                                <div class="d-flex"  v-if="hist.id_estado == 5">
                                    <div class="flex-shrink-0 me-3">
                                        <i  class="bx bx-check-shield h2 text-primary"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <span style="float: right;">Duración @{{hist.fc_diferencia}} Días</span>
                                        <h5 > Solicitud publicada a las @{{hist.fc_inicio}}</h5>
                                        <span>Estado :  <strong v-text="hist.nm_estado"></strong></span>
                                        <p class="text-muted mb-0">Solicitud 
                                            <strong>#@{{hist.nr_ticket}}</strong> publicada por 
                                            <strong>@{{hist.nm_autor}}</strong>
                                        </p>
                                        <strong>Publicación :</strong>
                                        <div class="not-print">
                                            <template v-if="getCantidadCaracteres(hist.str_observacion) < 300">
                                                <span v-html="hist.str_observacion_html"></span>
                                            </template>
                                            <template v-else>
                                                <template v-if="tp_resumir_publicacion == 1">
                                                    @{{ hist.str_observacion | resumir }} 
                                                    <a href="#" class="link-primary" style="float: right;" @click="tp_resumir_publicacion = 0"> VER</a>
                                                </template>
                                                <template v-else>
                                                    <span v-html="hist.str_observacion_html"></span>
                                                    <a href="#" class="link-primary" style="float: right;" @click="tp_resumir_publicacion = 1"> ACOTAR</a>
                                                </template>
                                            </template>
                                        </div>
                                        <div class="to-print-respuesta" style="display: none;">
                                            <span v-html="hist.str_observacion_html"></span>
                                        </div>
                                        <div class="mt-2" v-if="(index == arr_historial.length -1) && hist.tp_feedback_vecino == 1">
                                            <h5>- Feedback Vecino</h5>
                                            <strong>Fecha Feedback :</strong> 
                                                <span v-if="hist.fc_feedback_vecino" v-text="hist.fc_feedback_vecino"></span> <br>
                                            <strong>Nivel Satisfacción :</strong> 
                                                <span v-if="hist.tp_satisfaccion_vecino > 0" v-text="arr_satisfaccion[hist.tp_satisfaccion_vecino].label"></span><br>
                                            <strong>Comentario Feedback :</strong> 
                                            <span v-text="hist.str_feedback_vecino"></span>
                                        </div>
                                    </div>
                                </div>

                                <!-- Finalizada -->
                                <div class="d-flex"  v-if="hist.id_estado == 6">
                                    <div class="flex-shrink-0 me-3">
                                        <i  class="bx bx-user-check h2 text-primary"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <span style="float: right;">Duración @{{hist.fc_diferencia}} Días</span>
                                        <h5 > Solicitud finalizada a las @{{hist.fc_inicio}}</h5>
                                        <span>Estado :  <strong v-text="hist.nm_estado"></strong></span>
                                        <p class="text-muted">Solicitud <strong>#@{{hist.nr_ticket}}</strong> finalizada por <strong>@{{hist.nm_autor}}</strong></p>

                                        <div class="mt-2">
                                            <h5>- Feedback Territorial</h5>
                                            <strong>Fecha Feedback :</strong> 
                                                <span v-if="hist.fc_feedback" v-text="hist.fc_feedback"></span> <br>
                                            <strong>Nivel Satisfacción :</strong> 
                                                <span v-if="hist.tp_satisfaccion > 0" v-text="arr_satisfaccion[hist.tp_satisfaccion].label"></span> 
                                                <span v-else> Vecino no contactado</span> <br>
                                            <strong>Comentario Feedback :</strong> 
                                            <span v-text="hist.str_feedback"></span>
                                        </div>

                                        <div class="mt-2" v-if="hist.tp_feedback_vecino == 1">
                                            <h5>- Feedback Vecino</h5>
                                            <strong>Fecha Feedback :</strong> 
                                                <span v-if="hist.fc_feedback_vecino" v-text="hist.fc_feedback_vecino"></span> <br>
                                            <strong>Nivel Satisfacción :</strong> 
                                                <span v-if="hist.tp_satisfaccion_vecino > 0" v-text="arr_satisfaccion[hist.tp_satisfaccion_vecino].label"></span><br>
                                            <strong>Comentario Feedback :</strong> 
                                            <span v-text="hist.str_feedback_vecino"></span>
                                        </div>
                                    </div>
                                </div>

                                <!-- Rechazada -->
                                <div class="d-flex" v-if="hist.id_estado == 7">
                                    <div class="flex-shrink-0 me-3">
                                        <i  class="bx bx-trash-alt h2 text-primary"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <div>
                                            <span style="float: right;">Duración @{{hist.fc_diferencia}} Días</span>
                                            <span>Estado :  <strong v-text="hist.nm_estado"></strong></span>
                                            <h5 v-if="hist.id_estado == 1"> Solicitud ingresada a las @{{hist.fc_inicio}}</h5>
                                            <p class="text-muted">Solicitud <strong>#@{{hist.nr_ticket}}</strong> Rechazada por <strong>@{{hist.nm_autor}}</strong></p>
                                            <strong v-if="hist.str_observacion">Observación :</strong> <span v-text="hist.str_observacion"></span>
                                        </div>
                                    </div>
                                </div>

                                <!-- Derivada a Funcionario -->
                                <div class="d-flex" v-if="hist.id_estado == 8">
                                    <div class="flex-shrink-0 me-3">
                                        <i  class="bx bx-save h2 text-primary"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <div>
                                            <span style="float: right;">Duración @{{hist.fc_diferencia}} Días</span>
                                            <h5 > Solicitud derivada a las @{{hist.fc_inicio}}</h5>
                                            <span>Estado :  <strong v-text="hist.nm_estado"></strong></span>
                                            <p class="text-muted mb-0">Solicitud 
                                                <strong>#@{{hist.nr_ticket}}</strong> derivada por 
                                                <strong>@{{hist.nm_autor}}</strong>
                                            </p>
                                            <strong v-if="hist.str_observacion">Observación :</strong> <span v-text="hist.str_observacion"></span>
                                            
                                            <div class="mt-2">
                                                <h5>- Datos Solicitud</h5>
                                                <p>
                                                    <strong>Tipo de Solicitud : </strong> @{{hist.nm_tipo}}     <br>
                                                    <strong>Dirección</strong> : 
                                                        <a target="_blank" :href="'https://maps.google.com/?q='+arr_direccion_solicitud.label+'&z=15&t=m'">
                                                            @{{arr_direccion_solicitud.label}}
                                                        </a> <br>
                                                    <strong>Descripción</strong> : @{{hist.str_sol_observacion}}    <br>
                                                </p>
                                            </div>

                                            <!-- Tabla de Respuestas -->
                                            <div class="table-responsive" v-if="arr_respuestas.length">
                                                <table class="table table-sm table-bordered">
                                                    <thead>
                                                        <th colspan="6" class="text-center bg-primary text-white" >
                                                            Gestión Interna
                                                        </th>
                                                    </thead>
                                                    <thead class="bg-primary text-white">
                                                        <th>#</th>
                                                        <th>Usuario</th>
                                                        <th>Adjuntos</th>
                                                        <th style="min-width: 100px;">Fecha</th>
                                                        <th>Tipo</th>
                                                        <th>Mensaje</th>
                                                    </thead>
                                                    <tbody>
                                                        <tr v-for="(item,index) in arr_respuestas">
                                                            <td>@{{(index+1)}}</td>
                                                            <td>@{{item.usuario}}</td>
                                                            <td class="text-center">
                                                                <button type="button" @click="abrirModal('archivo', 'revisar', item)" 
                                                                    class="btn btn-primary btn-sm" title="Revisar Adjuntos" v-if="item.archivos.length">
                                                                    <i class="fas fa-paperclip"></i>
                                                                </button>
                                                            </td>
                                                            <td>@{{item.fc_ingreso | formatDateTime}}</td>
                                                            <td>@{{item.nm_respuesta}}</td>
                                                            <template v-if="getCantidadCaracteres(item.str_observacion) < 300">
                                                                <td>
                                                                    <span v-html="item.str_observacion_html"></span>
                                                                </td>
                                                            </template>
                                                            <template v-else>
                                                                <td>
                                                                    <template v-if="(tp_visualizar.tp_resumir == 0 || tp_visualizar.tp_resumir == 1) && 
                                                                        tp_visualizar.nr_index != index">
                                                                        @{{ item.str_observacion | resumir }} 
                                                                        <a href="#" class="link-primary" style="float: right;" @click="setResumir(0, index)"> VER</a>
                                                                    </template>
                                                                    <template v-else>
                                                                        <span v-html="item.str_observacion_html"></span>
                                                                        <a href="#" class="link-primary" style="float: right;" @click="setResumir(1, null)"> ACOTAR</a>
                                                                    </template>
                                                                </td>
                                                            </template>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Derivada a Macrozona -->
                                <div class="d-flex" v-if="hist.id_estado == 9">
                                    <div class="flex-shrink-0 me-3">
                                        <i  class="bx bx-save h2 text-primary"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <div>
                                            <span style="float: right;">Duración @{{hist.fc_diferencia}} Días</span>
                                            <h5 > Solicitud derivada a las @{{hist.fc_inicio}}</h5>
                                            <span>Estado :  <strong v-text="hist.nm_estado"></strong></span>
                                            <p class="text-muted mb-0">Solicitud 
                                                <strong>#@{{hist.nr_ticket}}</strong> derivada por 
                                                <strong>@{{hist.nm_autor}}</strong>
                                            </p>
                                            <strong v-if="hist.str_observacion">Observación :</strong> <span v-text="hist.str_observacion"></span>
                                            
                                            <div class="mt-2">
                                                <h5>- Datos Solicitud</h5>
                                                <p>
                                                    <strong>Tipo de Solicitud : </strong> @{{hist.nm_tipo}}     <br>
                                                    <strong>Dirección</strong> : 
                                                        <a target="_blank" :href="'https://maps.google.com/?q='+arr_direccion_solicitud.label+'&z=15&t=m'">
                                                            @{{arr_direccion_solicitud.label}}
                                                        </a> <br>
                                                    <strong>Descripción</strong> : @{{hist.str_sol_observacion}}    <br>
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Derivada a Asignador -->
                                <div class="d-flex" v-if="hist.id_estado == 10">
                                    <div class="flex-shrink-0 me-3">
                                        <i  class="bx bx-save h2 text-primary"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <div>
                                            <span style="float: right;">Duración @{{hist.fc_diferencia}} Días</span>
                                            <h5 > Solicitud derivada a las @{{hist.fc_inicio}}</h5>
                                            <span>Estado :  <strong v-text="hist.nm_estado"></strong></span>
                                            <p class="text-muted mb-0">Solicitud 
                                                <strong>#@{{hist.nr_ticket}}</strong> derivada por 
                                                <strong>@{{hist.nm_autor}}</strong>
                                            </p>
                                            <strong v-if="hist.str_observacion">Observación :</strong> <span v-text="hist.str_observacion"></span>
                                            
                                            <div class="mt-2">
                                                <h5>- Datos Solicitud</h5>
                                                <p>
                                                    <strong>Tipo de Solicitud : </strong> @{{hist.nm_tipo}}     <br>
                                                    <strong>Dirección</strong> : 
                                                        <a target="_blank" :href="'https://maps.google.com/?q='+arr_direccion_solicitud.label+'&z=15&t=m'">
                                                            @{{arr_direccion_solicitud.label}}
                                                        </a> <br>
                                                    <strong>Descripción</strong> : @{{hist.str_sol_observacion}}    <br>
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                        </ul>
                  </div>
                  <div class="modal-footer">
                    <div class="col-md-12 col-sm-12">
                        <button type="button" class="btn btn-md btn-secondary col-lg-2 col-md-3 col-sm-4" style="float: left;" @click="imprimirContenido('modal_historial')">Imprimir</button>
                        <button type="button" class="btn btn-md btn-secondary col-lg-2 col-md-3 col-sm-4" style="float: left; margin-left: 5px;" @click="imprimirPDF(id_consulta)">PDF</button>
                        <button type="button" class="btn btn-md btn-secondary col-lg-2 col-md-3 col-sm-4" style="float: right;" @click="cerrarModal('historial')">Cerrar</button>
                    </div>
                  </div>
                </div>
            </div>
        </div>

        <div class="modal" tabindex="-1" id="modal_derivar">
            <div class="modal-dialog modal-lg" style="margin-top: 10%">
                <div class="modal-content" style="border-color: darkgray;">
                    <div class="modal-header bg-primary">
                        <h5 class="modal-title text-white">Derivar Solicitud</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="col-md-12 col-sm-12 mt-2">
                            <div class="row-flow">
                                <!-- Tipo Servicio -->
                                <div class="col-md-12 col-sm-12">
                                    <div class="row form-group">
                                        <div class="col-lg-3 col-md-3 col-sm-4 mt-2 text-center">
                                            <label>Tipo de Servicio</label>
                                        </div>
                                        <div class="col-lg-9 col-md-9 col-sm-8">
                                            <multiselect
                                                :show-labels="false"
                                                :searchable="true"
                                                v-model="nr_derivar"
                                                :options="arr_servicio"
                                                :multiple="false"
                                                :showNoOptions ="false" 
                                                placeholder="Seleccionar Tipo de Solicitud"
                                                label="label"                                                                 
                                                track-by="label">
                                                <span slot="noResult">No se han encontrado resultados</span>
                                            </multiselect>
                                            <small class="text-error text-danger" v-if="validationErrors.nr_derivar" v-text="validationErrors.nr_derivar[0]"></small>
                                            <small class="text-error text-danger" v-if="arr_form.nr_derivar" v-text="arr_form.nr_derivar"></small>
                                        </div>
                                    </div>
                                </div>

                                <!-- Descripcion Solicitud -->
                                <div class="col-md-12 mt-2">
                                    <div class="form-group">
                                        <!-- <label>Descripción Solicitud :</label> -->
                                        <textarea maxlength="300" rows="2" v-model="str_derivar" class="form-control"></textarea>
                                        <small class="form-text text-muted" id="str_derivar"  v-if="str_derivar" 
                                            v-text="'Disponible '+(300-str_derivar.trim().length)+' caracteres'"></small>
                                        <small class="text-error text-danger" v-if="validationErrors.str_derivar" v-text="validationErrors.str_derivar[0]"></small>
                                        <small class="text-error text-danger" v-if="arr_form.str_derivar" v-text="arr_form.str_derivar"></small>
                                    </div>
                                </div>

                                <div class="mt-1" style="float: right;">
                                    <button v-if="btn_derivar == 0" @click="derivar(1)"  class="btn btn-sm btn-warning">
                                        Derivar <i class="bx bxs-send"></i> 
                                    </button>
                                    <button v-else class="btn btn-sm btn-warning">
                                        Derivando <i class="bx bx-loader-circle"></i> 
                                    </button>
                                </div>
                            </div>                          
                        </div>
                    </div>
                    <div class="modal-footer">
                        
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal Adjunto -->
        <div class="modal" tabindex="-1" id="modal_adjunto">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header bg-primary">
                        <h5 class="modal-title text-white">Ingresar Adjunto</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label>Seleccione Archivo</label>
                            <input class="form-control" accept=".jpeg,.jpg,.png,.doc,.docx,.xls,.xlsx,.ppt,.pptx,.pdf,.dwg,.dgn,.rar,.zip"
                                type="file" id="file_adjunto" >
                        </div>
                        <div class="form-group mt-2">
                            <label>Ingresar Descripcón</label>
                            <textarea maxlength="200" rows="3" v-model="file_observacion" class="form-control" placeholder="Descripción del archivo"></textarea>
                            <small id="cant_caracteres" class="form-text text-muted" v-text="'Disponible '+(200-file_observacion.trim().length)+' caracteres'" v-if="file_observacion"></small>
                        </div>
                        <template v-if="file_error">
                            <div class="text-center text-danger">
                                <div v-for="error in arr_error" :key="error" v-text="error"></div>
                            </div>
                        </template>
                    </div>
                    <div class="modal-footer">
                        <button @click="cerrarModal('archivo')" type="button" class="btn btn-light">Cerrar</button>
                        <button type="button" class="btn btn-primary" @click="validarAdjunto(tp_adjunto, 'save')">Subir</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal Archivos -->
        <div class="modal" tabindex="-1" id="modal_revisar">
            <div class="modal-dialog modal-lg" style="margin-top: 10%">
                <div class="modal-content" style="border-color: darkgray;">
                    <div class="modal-header bg-primary">
                        <h5 class="modal-title text-white" style="color: white;">Revisar Archivos</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <table class="table table-bordered table-striped table-sm">
                            <thead>
                                <tr class="bg-primary">
                                    <th colspan="4" class="text-center" style="color: white;">Archivos Adjuntos</th>    
                                </tr>
                                <tr>
                                    <th style="min-width:50px; text-align:center;">#</th>
                                    <th style="min-width:150px; text-align:center;">Nombre</th>
                                    <th style="min-width:300px; text-align:center;">Descripción</th>
                                    <th style="min-width:50px; text-align:center;">Archivo</th>
                                </tr>
                            </thead>
                            <tbody>
                                <template v-if="arr_adjuntos.length">
                                    <tr v-for="(adjunto, index) in arr_adjuntos" :key="adjunto.id">
                                        <td class="text-center">@{{ (index+1) }}</td>
                                        <td class="text-center">@{{ adjunto.nm_archivo }}</td>
                                        <td class="text-left">@{{ adjunto.str_observacion }}</td>
                                        <td class="text-center">
                                            <a :href="'/files/get?ruta='+adjunto.str_archivo" class="btn btn-primary btn-sm" title="Archivo Adjunto" v-if="adjunto.str_archivo">
                                                <template v-if="adjunto.ext_archivo == 'pdf'">
                                                    <i class="far fa-file-pdf"></i>
                                                </template>
                                                <template v-if="adjunto.ext_archivo == 'doc' || adjunto.ext_archivo == 'docx'">
                                                    <i class="far fa-file-word"></i>
                                                </template>
                                                <template v-if="adjunto.ext_archivo == 'ppt' || adjunto.ext_archivo == 'pptx'">
                                                    <i class="far fa-file-powerpoint"></i>
                                                </template>
                                                <template v-if="adjunto.ext_archivo == 'xls' || adjunto.ext_archivo == 'xlsx'">
                                                    <i class="far fa-file-excel"></i>
                                                </template>
                                                <template v-if="adjunto.ext_archivo == 'rar' || adjunto.ext_archivo == 'zip'">
                                                    <i class="far fa-file-archive"></i>
                                                </template>
                                                <template v-if="adjunto.ext_archivo == 'jpeg' || adjunto.ext_archivo == 'jpg' || adjunto.ext_archivo == 'png'">
                                                    <i class="far fa-file-image"></i>
                                                </template>
                                                <template v-if="adjunto.ext_archivo == 'dwg' || adjunto.ext_archivo == 'dgn'">
                                                    <i class="far fa-file-code"></i>
                                                </template>
                                            </a>
                                        </td>
                                    </tr>
                                </template>
                                <template v-else>
                                    <td colspan="4">
                                        <div class="empty" style="min-height:100px;" empty-text="No hay archivos para mostrar"></div>
                                    </td>
                                </template>
                            </tbody>
                        </table>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

    <script >
        Vue.component('vue-multiselect', window.VueMultiselect.default);
    

        var app = new Vue({
            el: '#app',
            data: {                
                //-------------------------------------
                btn_responder               :   1,
                btn_finalizar               :   1,
                btn_informar                :   1,
                btn_envio                   :   0,
                modal_principal             :   0,
                modal_adjunto               :   0,
                modal_mensaje               :   0,
                accion_principal            :   0,
                accion_adjunto              :   0,
                accion_mensaje              :   0,
                boton_principal             :   1,
                boton_adjunto               :   0,
                boton_mensaje               :   0,
                titulo_principal            :   '',
                titulo_adjunto              :   '',
                titulo_mensaje              :   '',
                tp_modal                    :   0,
                tp_accion                   :   0,
                arr_valida                  :   [],
                arr_form                    :   {},
                arr_error                   :   [],
                tp_error                    :   [],
                pagination                  : {
                    'total' : 0,
                    'current_page' : 0,
                    'per_page' : 0,
                    'last_page' : 0,
                    'from' : 0,
                    'to' : 0,
                },
                //-------------------------------------
                offset                      :   3,
                //-------------------------------------
                fl_tipo                     :   [],
                fl_prioridad                :   [],
                fl_funcionario              :   [],
                fl_persona                  :   [],
                fl_direccion                :   [],
                fl_unidadvecinal            :   [],
                fl_ticket                   :   [],
                fl_motivo                   :   [],
                fl_ubicacion                :   [],
                //-------------------------------------
                arr_archivo                 :   [],
                arr_files                   :   [],
                arr_files_obs               :   [],
                file_observacion            :   '',
                tp_adjunto                  :   '',
                file_error                  :   0,
                tp_save_adjunto             :   0,
                //-------------------------------------
                arr_index                   :   [],
                arr_prioridad               :   [],
                arr_motivo                  :   [],
                arr_funcionario             :   [],
                arr_persona                 :   [],
                arr_calles_vecino           :   [],
                arr_calles_solicitud        :   [],
                arr_dir_municipal           :   [],
                arr_unidadvecinal           :   [],
                arr_ticket                  :   [],
                user                        :   [],
                arr_adjuntos                :   [],
                arr_asignados               :   [],
                arr_ubicaciones             :   [],
                //-------------------------------------
                arr_solicitudes             :   [],
                //-------------------------------------
                tp_municipal                :   1,
                nr_prioridad                :   1,
                nr_funcionario              :   [],
                nr_ticket                   :   '',
                nm_estado                   :   '',
                //-------------------------------------
                tp_visualizar               :   {
                    tp_resumir : 1,
                    nr_index : null,
                },
                tp_resumir_publicacion      :   1,
                rut_vecino                  :   '',
                nm_vecino                   :   '',
                ap_paterno                  :   '',
                ap_materno                  :   '',
                str_vecino                  :   '',
                nm_direccion                :   '',
                nr_direccion                :   0,
                nr_telefono                 :   '',
                mail_vecino                 :   '',
                tp_vecino                   :   0,
                str_observacion             :   '',
                nr_tipo                     :   {
                    'value' : 0,
                    'label' : 'Seleccionar Tipo de Solicitud',
                    'id_direccion' : 0,
                },
                tp_direccion                :   1,
                str_aclaratoria             :   '',
                //Datos Solicitud
                arr_direccion_solicitud     :   [],
                arr_ubicacion_vecino        :   [],
                nr_ubicacion                :   '',
                str_longitud                :   '',
                str_latitud                 :   '',
                str_observacion             :   '',
                fc_ingreso                  :   '',
                tp_aprobado                 :   0,
                tp_activo                   :   1,
                id_consulta                 :   0,
                nr_dir_municipal            :   0,
                nr_tp_direccion_solicitud   :   1,
                str_respuestas              :  '',
                tp_respuesta                :   0,
                //-------------------------------------
                existe_vecino               :   0,
                //-------------------------------------
                validationErrors            : [],                
                solicitud_actual            : [],
                arr_data_default            : [],
                arr_tipos                   : [{
                    'value' : 0,
                    'label' : 'Seleccionar Tipo de Solicitud',
                    'id_direccion' : 0,
                }],
                arr_servicio                :   [],
                nr_dir_disabled             : 0,
                id_estado                   : 0,
                dir_1                       : 0,
                dir_2                       : 0,
                pre_fijo                    : '+569',
                //------------------------------------
                arr_historial               :   [],
                arr_respuestas              :   [],
                //------------------------------------
                colores                     : {
                    'VERDE'     : 'green',
                    'ROJO'      : 'red',
                    'NARANJA'   : 'orange',
                    'AMARILLO'  : 'yellow',
                },
                arr_mostrar                 :   [
                    {
                        'value'     :   0,
                        'label'     :   'Todos',
                    },
                    {
                        'value'     :   3,
                        'label'     :   'En Gestión',
                    }, 
                    {
                        'value'     :   4,
                        'label'     :   'En Revisión',
                    },                    
                    {
                        'value'     :   5,
                        'label'     :   'Cerrado',
                    },
                ],
                fl_mostrar                  :   0,
                //------------------------------------
                tp_feedback                 :   0,
                nr_recepcion                :   0,
                tp_recepcion                :   [
                    {
                        'value' : 0,
                        'label' : 'No Contactado',
                    }
                ],
                nr_satisfaccion             :   0,
                tp_satisfaccion             :   [],
                str_feedback                :   '',
                str_error                   :   '',
                //------------------------------------
                arr_recepcion               :   [
                    {
                        'value' : 0,
                        'label' : 'No Contactado',
                    },
                    {
                        'value' : 1,
                        'label' : 'Contactado',
                    },
                ],
                arr_satisfaccion            :   [
                    {
                        'value' : 0,
                        'label' : 'Seleccionar Nivel',
                    },
                    {
                        'value' : 1,
                        'label' : 'Muy satisfecho',
                    },
                    {
                        'value' : 2,
                        'label' : 'Satisfecho',
                    },
                    {
                        'value' : 3,
                        'label' : 'Normal',
                    },
                    {
                        'value' : 4,
                        'label' : 'Poco satisfecho',
                    },
                    {
                        'value' : 5,
                        'label' : 'Nada satisfecho',
                    }
                ],
                //------------------------------------                
                btn_derivar                 :   0,
                nr_derivar                  :   {},
                str_derivar                 :   '',
                //------------------------------------
            },

            components: {
                Multiselect: window.VueMultiselect.default,
            },

            filters:{
                resumir: function (texto, limite=300, final=' ...')
                {
                    let me  = this;
                    var largo = texto.toString().length;
                    if(largo > limite){
                        for (var i = 0; i < largo; i++) {
                            if(texto[i] == ' ' && i >= limite) {
                                texto   =   texto.substring(0,i);
                                texto   =   texto + final;
                                return texto;
                            }
                        }                    
                    }
                    return texto;
                },

                formatDate: function (fecha)
                {
                    if(fecha)
                        return moment(String(fecha)).format('DD-MM-YYYY')
                },

                formatDateTime: function (fecha)
                {
                    if(fecha)
                    {
                        return moment(String(fecha)).format('DD-MM-YYYY HH:mm')
                    }
                },

                capitalize: function (value = '') {
                    if (!value) return '';

                    value = value.toString();
                    var splitStr = value.toLowerCase().split(' ');

                    for (var i = 0; i < splitStr.length; i++) {
                        splitStr[i] = splitStr[i].charAt(0).toUpperCase() + splitStr[i].substring(1);
                    }

                    return splitStr.join(' ');
                },
            },

            computed:{
                //-------------------------------------------------------------------------------------------
                isActivedPagination: function()
                {
                    return this.pagination.current_page;
                },
                //-------------------------------------------------------------------------------------------
                pagesNumber: function()
                {
                    if(!this.pagination.to) {
                        return [];
                    }

                    var from = this.pagination.current_page - this.offset;
                    if(from < 1) {
                        from = 1;
                    }

                    var to = from + (this.offset * 2);
                    if(to >= this.pagination.last_page){
                        to = this.pagination.last_page;
                    }

                    var pagesArray = [];
                    while(from <= to) {
                        pagesArray.push(from);
                        from++;
                    }
                    return pagesArray;
                },
                //-------------------------------------------------------------------------------------------
            },

            methods: {
                //-------------------------------------------------------------------------------------------
                imprimirContenido(id) {
                    // Asegura que Vue termine de renderizar el DOM antes de continuar
                    this.$nextTick(() => {
                        // Ahora busca el modal completo
                        const modal = document.querySelector(`#${id}`);
                        if (!modal) {
                            console.warn(`No se encontró el modal con ID: ${id}`);
                            return;
                        }

                        // Clona el modal (header, body, footer)
                        const clonado = modal.cloneNode(true);
                        const wrapper = document.createElement('div');
                        wrapper.classList.add('print-area');
                        wrapper.appendChild(clonado);

                        // Imprimir
                        $(wrapper).printThis({
                            importCSS: true,
                            importStyle: true, 
                            loadCSS: ["/css/print.css"],
                            printContainer: false,
                            removeInline: true,
                            removeInlineSelector: "*",
                            formValues: true,
                            base: window.location.origin,
                            removeScripts: true,
                        });
                    });
                },
                //-------------------------------------------------------------------------------------------
                imprimirPDF(id_ticket)
                {
                    let me          =   this;
                    me.str_ruta     =   '#';
                    var ruta        =   `/pdf/solicitud/${id_ticket}`;

                    if(!id_ticket) {
                        me.desplegarVentana('warning','Exportar Información a PDF','No se ha podido encontrar el identificador del ticket');
                        return;
                    }

                    window.open(ruta, '_blank');
                },
                //-------------------------------------------------------------------------------------------
                getCantidadCaracteres(str_contenido = '')
                {
                    var cantidad    =   0;

                    if(!str_contenido)
                        return cantidad;

                    if(str_contenido.trim().length)
                        cantidad    =   str_contenido.trim().length;

                    return cantidad;
                },
                //-------------------------------------------------------------------------------------------
                activeDatetimepicker()
                {
                    let fc_format1  =   'DD-MM-YYYY';
                    let fc_format2  =   'd-m-Y';
                    let fc_date     =   moment().locale('es').format(fc_format1);
                    let fc_desde    =   '';
                    let fc_hasta    =   '';
                    //-----------------------------------
                    fc_hasta = fc_date;
                    fc_desde = moment().subtract(90, 'days').format(fc_format1);
                    //-----------------------------------

                    // Configuración base para flatpickr
                    let baseConfig = {
                        dateFormat: fc_format2,
                        locale: 'es',  // Asegúrate de tener el locale de 'es' cargado si lo necesitas.
                        allowInput: true,  // Permite la entrada manual de la fecha
                    };

                    // Configuración para "Desde"
                    let desdeConfig = Object.assign({}, baseConfig, {
                        defaultDate: fc_desde,
                    });
                    flatpickr('#fc_desde', desdeConfig);

                    // Configuración para "Hasta"
                    let hastaConfig = Object.assign({}, baseConfig, {
                        defaultDate: fc_hasta,
                        maxDate: new Date(),  // Fecha máxima es la fecha actual
                    });
                    flatpickr('#fc_hasta', hastaConfig);
                },
                //-------------------------------------------------------------------------------------------
                mostrar()
                {
                    let me  =   this;
                    var fc_desde    =   $('fc_desde').val();
                    console.log('fecha : ' + fc_desde);
                },
                //-------------------------------------------------------------------------------------------
                totalizarCampo(arr, field) 
                {
                    let total = arr.reduce((a, b) => a + (Number(b[field]) || 0), 0);
                    return total.toFixed(2);
                },
                //-------------------------------------------------------------------------------------------
                setScrollTo(tag_id)
                {
                    // var container   =   $('.modal #historia_solicitud'); // $('html, body, .main-content');
                    // var scrollTo    =   $('#' + tag_id);

                    $("#" + tag_id).animate({
                        scrollTop: $(document).height()
                    }, 500);

                    // container.animate({scrollTop : $('#' + tag_id).offset().top +1000 }, 'slow');
                },
                //-------------------------------------------------------------------------------------------
                setResumir(valor = 0, index = 0)
                {
                    let me  =   this;

                    me.tp_visualizar    =   {
                        tp_resumir : valor,
                        nr_index : index,
                    };

                    console.log(me.tp_visualizar);
                },
                //-------------------------------------------------------------------------------------------
                finalizar(opcion)
                {
                    let me          =   this;
                    var formData    =   new FormData();
                    var ruta        =   '/funcionario/respuesta';
                    me.arr_form     =   {};

                    if(tinymce.get("str_respuestas").plugins.wordcount.body.getCharacterCount() <  10)
                        me.arr_form.str_respuestas      =   'La respuesta debe tener minimo 10 caracteres';

                    if(tinymce.get("str_respuestas").plugins.wordcount.body.getCharacterCount() >  2000)
                        me.arr_form.str_respuestas      =   'La respuesta debe tener maximo 2000 caracteres';

                    console.log('-------------------------');
                    console.log(me.arr_form);
                    console.log('-------------------------');

                    if(Object.keys(me.arr_form).length != 0)
                    {
                        me.desplegarVentana('warning','Registrar Respuesta','Favor revisar los campos requeridos');
                        return;
                    }
                    //------------------------------------
                    $('.btn_finalizar').attr('disabled',true);
                    $('.btn_responder').attr('disabled',true);
                    $('.btn_informar').attr('disabled',true);
                    //------------------------------------
                    formData.append('nr_id', me.solicitud_actual.id);
                    formData.append('opcion', opcion);
                    formData.append('str_observacion', tinymce.get("str_respuestas").getContent({format: "text"}));
                    formData.append('str_observacion_html', tinymce.get("str_respuestas").getContent({format: "html"}));
                    //------------------------------------
                    if(me.arr_files.length != 0)
                    {
                        for (var i = 0; i < me.arr_files.length; i++) 
                        {
                            formData.append('arr_archivo[]', me.arr_files[i]);
                        }
                        for (var i = 0; i < me.arr_files_obs.length; i++) 
                        {
                            formData.append('arr_observacion[]', me.arr_files_obs[i]);
                        }
                    }
                    //------------------------------------
                    axios.post(ruta, formData, {
                        headers: {'Content-Type': 'multipart/form-data'}
                    }).then(function (response) 
                    {
                        var respuesta           =   response.data;

                        if(respuesta.error == 0)
                        {
                            me.desplegarVentana(respuesta.tp_icon, respuesta.title, respuesta.msj);
                            me.str_respuestas   =   '';
                            $('.btn_finalizar').removeAttr('disabled');
                            $('.btn_responder').removeAttr('disabled');
                            $('.btn_informar').removeAttr('disabled');

                            me.arr_files        =   [];
                            me.arr_archivo      =   [];
                            me.arr_files_obs    =   [];

                            tinymce.get("str_respuestas").setContent('');

                            me.refrescarDatos();
                            me.cargarHistorial(me.solicitud_actual.id);
                        }
                        else
                        {
                            me.desplegarVentana(respuesta.tp_icon, respuesta.title, respuesta.msj);
                            $('.btn_finalizar').removeAttr('disabled');
                            $('.btn_responder').removeAttr('disabled');
                            $('.btn_informar').removeAttr('disabled');
                        }                        
                    }).catch(function (error) {
                        console.log(error);
                        me.btn_finalizar    =   1;
                        me.btn_responder    =   1;
                        me.btn_informar     =   1;
                        $('.btn_responder').attr('disabled',false);
                        $('.btn_finalizar').attr('disabled',false);
                        $('.btn_informar').attr('disabled',false);
                    });
                },
                //-------------------------------------------------------------------------------------------
                refrescarDatos()
                {
                    let me  =   this;

                    me.dataDefault();
                    me.cargarDatos();
                },
                //-------------------------------------------------------------------------------------------
                asyncSugerencia(item) // Sugerir Direccion
                {
                    let me  =   this;

                    if(item) //if(Object.keys(item).length > 0)
                    {
                        me.nr_tipo              =   item;
                        me.nr_dir_municipal     =   item.id_direccion;

                        /*
                        var tipos   = me.arr_data_default.arr_tipos
                        var index   = tipos.map(function (nodo) { return nodo.value; }).indexOf(item.value);
                        me.nr_dir_municipal = tipos[index].id_direccion;
                        */
                    }
                },
                //-------------------------------------------------------------------------------------------
                getVecino()
                {
                    let me      = this;
                    var ruta    = '/get/vecino/'+me.rut_vecino
                    axios.get(ruta).then(function (response)
                    {
                        var respuesta           = response.data;
                        var vecino              = respuesta.vecino
                        var tramites            = respuesta.tramites

                        console.log(vecino)

                        if(!vecino)
                                return

                        if(tramites == 0)
                        {
                            me.nm_vecino                    =   vecino.nm_vecino;
                            me.ap_paterno                   =   vecino.ap_paterno;
                            me.ap_materno                   =   vecino.ap_materno;
                            me.mail_vecino                  =   vecino.nm_mail;
                            me.tp_direccion                 =   vecino.tp_direccion;
                            me.str_aclaratoria              =   vecino.str_aclaratoria;
                            me.nr_telefono                  =   vecino.nr_telefono.slice(-8);
                            me.pre_fijo                     =   vecino.nr_prefijo;

                            me.arr_ubicacion_vecino         =    
                            {
                                value : vecino.id_ubicacion,
                                label : vecino.nm_ubicacion,
                                nr_calle : vecino.nr_calle,
                                nm_calle : vecino.nm_calle,
                                str_latitud : vecino.str_latitud,
                                str_longitud : vecino.str_longitud,
                                cod_territorial : vecino.cod_macroterritorio,
                                cod_unidadvecinal : vecino.cod_unidadvecinal,
                            }
                        }else
                        {
                            me.nm_vecino                    =   vecino.nm_vecino;
                            me.ap_paterno                   =   vecino.ap_paterno;
                            me.ap_materno                   =   vecino.ap_materno;
                            me.mail_vecino                  =   vecino.correo;
                            me.nr_telefono                  =   vecino.nr_telefono;
                            me.pre_fijo                     =   '+569';

                        }

                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                mostrarObservaciones()
                {
                    let me  =   this;

                    $("#ver_observaciones").slideToggle(500, function () {
                            // ---------------------------
                    });
                },
                //-------------------------------------------------------------------------------------------
                getLabel(data)
                {
                    var valor   =   '';

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.label;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                getValue(data)
                {
                    var valor   =   0;

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.value;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                changeContexto()
                {
                    let me = this;

                    if(me.tp_municipal == 0)
                        {
                            me.nr_dir_municipal = 0;
                            me.nr_dir_disabled = 1;

                            me.nr_tipo = {
                                'value'         : 0,
                                'label'         : 'Seleccionar Tipo de Solicitud',
                                'id_direccion'  : 0,
                            }
                        }
                    else
                        me.nr_dir_disabled = 0;
                },
                //-------------------------------------------------------------------------------------------
                dataDefault()
                {
                    let me          = this;
                    var ruta        = '/default/data';

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta           =   response.data;
                        me.arr_data_default     =   respuesta;
                        me.arr_tipos            =   respuesta.arr_tipos;
                        me.arr_prioridad        =   respuesta.arr_prioridad;
                        me.arr_dir_municipal    =   respuesta.arr_direcciones;
                        me.arr_unidadvecinal    =   respuesta.arr_unidadvecinal;
                        me.arr_persona          =   respuesta.arr_vecinos;
                        me.arr_ticket           =   respuesta.arr_ticket;
                        me.user                 =   respuesta.user;
                        me.arr_ubicaciones      =   respuesta.arr_ubicaciones;
                        
                        $('#pendientes_funcionario').html(respuesta.nr_bandeja)
                        $('#propias_funcionario').html(respuesta.nr_propias)


                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                getInfo(id_solicitud)
                {
                    let me          = this;
                    var ruta        = '/solicitud/get?id_solicitud='+id_solicitud;

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta                   =   response.data.solicitud.archivos;
                        me.solicitud_actual.archivos    =   respuesta

                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                deleteFiles(ruta_file,nm_archivo)
                {
                    let me          = this;
                    var ruta        = '/files/delete';

                    axios.post(ruta,{
                        'ruta'          : ruta_file,
                        'id_consulta'   : me.id_consulta,
                        'nm_archivo'    : nm_archivo
                    }).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.getInfo(me.id_consulta)

                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarServicios()
                {
                    let me  =   this;
                    var url =   '/servicios/listado';
                    me.arr_servicio     =   [];

                    axios.get(url).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_servicio     =   respuesta.servicios;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarMotivo()
                {
                    let me      =   this;
                    var ruta    =   '/motivo/listado';
                    me.arr_motivo   =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta   =   response.data;
                        me.arr_motivo   =   respuesta;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarDatos(page = 1)
                {
                    let me          = this;
                    var ruta        = '/solicitud/funcionario/inicio';
                    var respuesta   = [];

                    axios.post(ruta,{
                    'fl_mostrar'        :   me.fl_mostrar,
                    'page'              :   page,
                    'fc_desde'          :   document.querySelector('#fc_desde').value,
                    'fc_hasta'          :   document.querySelector('#fc_hasta').value,
                    'fl_tipo'           :   me.getValue(me.fl_tipo),
                    'fl_prioridad'      :   me.getValue(me.fl_prioridad),
                    'fl_persona'        :   me.getValue(me.fl_persona),
                    'fl_direccion'      :   me.getValue(me.fl_direccion),
                    'fl_unidadvecinal'  :   me.getValue(me.fl_unidadvecinal),
                    'fl_ticket'         :   me.getValue(me.fl_ticket),
                    'fl_motivo'         :   me.getValue(me.fl_motivo),
                    'fl_ubicacion'      :   me.getValue(me.fl_ubicacion),
                    'propias'           :   0,
                    }).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_solicitudes  =   respuesta.info.data ;
                        me.pagination       =   respuesta.pagination;
                        me.rows             =   respuesta.info.data;
                        $('#pendientes_funcionario').html(respuesta.nr_bandeja);
                        $('#propias_funcionario').html(respuesta.nr_propias);
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                callDirecciones(query,tp_opcion = 1)
                {
                    let me          = this;
                    var ruta        = '/direccion/index';
                    var respuesta   = [];

                    axios.post(ruta,{'nm_direccion':   query,
                    }).then(function (response)
                    {
                        var respuesta   =   response.data;

                        if(tp_opcion == 1)
                                me.arr_calles_vecino = respuesta.result;
                        
                        if(tp_opcion == 2)
                                me.arr_calles_solicitud = respuesta.result;

                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                indexDireccionesSolicitud(query)
                {
                    let me          = this;
                    var ruta        = '/direccion/index';

                    if(query.length >= 3) 
                        me.callDirecciones(query,2);
                },
                //-------------------------------------------------------------------------------------------
                indexDireccionesVecino(query)
                {
                    let me          = this;
                    var ruta        = '/direccion/index';

                    if(query.length >= 3) 
                        me.callDirecciones(query,1);
                },
                //-------------------------------------------------------------------------------------------
                cambiarPagina(page)
                {
                    let me  =   this;
                    me.pagination.current_page = page;
                    me.cargarDatos(page);
                },
                //-------------------------------------------------------------------------------------------
                filtrarDatos()
                {
                    let me  =   this;
                    me.cargarDatos();
                },
                //-------------------------------------------------------------------------------------------
                limpiarFiltros()
                {
                    let me  =   this;
                    me.fl_tipo          =   [];
                    me.fl_funcionario   =   [];
                    me.fl_persona       =   [];
                    me.fl_direccion     =   [];
                    me.fl_unidadvecinal =   [];
                    me.fl_ticket        =   [];
                    me.fl_ubicacion     =   [];
                    me.fl_motivo        =   [];

                    me.cargarDatos();
                },
                //-------------------------------------------------------------------------------------------
                limpiarDatos(modelo)
                {
                    let me  =   this;

                    switch(modelo)
                    {
                        case 'registrar':
                        {
                            me.arr_error        =   [];
                            me.arr_valida       =   [];
                            me.tp_error         =   [];

                            me.nr_estado        =   [];
                            me.nr_secuencia     =   [];
                            me.nr_prioridad     =   1;
                            me.tp_direccion     =   1;
                            me.nr_dir_municipal =   0;
                            me.rut_vecino       =   '';
                            me.nm_vecino        =   '';
                            me.ap_paterno       =   '';
                            me.ap_materno       =   '';
                            me.nr_telefono      =   '';
                            me.mail_vecino      =   '';
                            me.nm_direccion     =   '';
                            me.nr_direccion     =   '';
                            me.str_aclaratoria  =   '';
                            me.str_observacion  =   '';
                            me.fc_ingreso       =   '';
                            me.tp_aprobado      =   0;
                            me.id_estado        =   0;
                            me.tp_activo        =   1;
                            me.arr_archivo      =   [];
                            me.solicitud_actual =   [];
                            me.arr_files_obs    = [];
                            me.arr_archivo      = [];
                            me.nr_tp_direccion_solicitud    =   1;
                            me.nr_tipo          =   {
                                'value' : 0,
                                'label' : 'Seleccionar Tipo de Solicitud',
                                'id_direccion' : 0,
                            };

                            break;
                        }
                        case 'archivo':
                        {
                            me.file_observacion =   '';
                            me.arr_error        =   [];
                            me.arr_valida       =   [];
                            me.tp_error         =   0;
                            me.descartarAdjunto();

                            break;
                        }
                        case 'revisar':
                        {
                            me.arr_adjuntos     =   [];

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                validarAdjunto(tipo, accion)
                {
                    let me              =   this;
                    var extension       =   '';
                    var fileSize        =   0;
                    var file_adjunto    =   '';
                    var file_value      =   '';
                    var max             =   3;
                    var error           =   0;
                    me.arr_error        =   [];

                    switch(tipo)
                    {
                        case "documento":
                        {
                            file_adjunto    =   document.querySelector("#file_adjunto");
                            file_value      =   file_adjunto.value;
                            var tipo_ext    =   ['.jpeg','.jpg','.png','.doc','.docx','.xls','.xlsx',
                                                '.ppt','.pptx','.msg','.pdf','.dwg','.dgn','.rar','.zip'];

                            if(file_value != "")
                            {
                                var fileSize  = file_adjunto.files[0].size;
                                extension = (file_value.substring(file_value.lastIndexOf("."))).toLowerCase();

                                if(fileSize > 20971520 ) 
                                    me.arr_error.push("El archivo adjunto NO debe superar los 20 MB");

                                if(!tipo_ext.includes(extension))
                                    me.arr_error.push("El archivo seleccionado No es adminido");

                                if(me.arr_archivo.length == max)
                                    me.arr_error.push("Solo se pueden adjuntar "+max+" archivos maximo");

                                if(me.file_observacion.trim() == '' && me.tp_save_adjunto == 0)
                                {
                                     me.arr_error.push("No se ha ingresado la descripción del adjunto.","Desea continuar de todos modos.");
                                     me.tp_save_adjunto = 1;
                                }
                            }


                            if(me.arr_error.length && me.file_observacion.trim() != '')
                                me.descartarAdjunto();

                            if(accion == "save" && me.arr_error.length == 0 && file_value != "")
                            {
                                me.arr_files.push(file_adjunto.files[0]);
                                me.arr_files_obs.push(me.file_observacion);
                                me.arr_archivo.push({'file':file_adjunto.files[0], 'descripcion':me.file_observacion,'sizeMB':parseFloat((file_adjunto.files[0].size/1048576).toFixed(2)),'sizeKB':file_adjunto.files[0].size});   
                                $('#modal_adjunto').modal('hide');
                                me.descartarAdjunto();
                                me.limpiarDatos('archivo');


                            }


                            break;
                        }
                    }

                    if(me.arr_error.length) 
                    {
                        error   =   1;
                        me.file_error   =   1;
                    }

                    return error;
                },
                //-------------------------------------------------------------------------------------------
                descartarAdjunto()
                {
                    let me              =   this;
                    var file_adjunto    =   '';

                    file_adjunto    =   document.querySelector("#file_adjunto");

                    if(file_adjunto)
                    {
                        document.querySelector("#file_adjunto").value = "";
                    }
                },
                //-------------------------------------------------------------------------------------------
                quitarAdjunto(modelo, index)
                {
                    let me          =   this;
                    me.arr_error    =   [];

                    switch(modelo)
                    {
                        case 'archivo':
                        {
                            me.arr_files.splice(index, 1);
                            me.arr_archivo.splice(index, 1);
                            me.arr_files_obs.splice(index, 1);

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                cargarHistorial(id_consulta)
                {
                    let me      = this;
                    var ruta    = '/historial/solicitud';

                    axios.post(ruta,{
                        'id_solicitud'  :   id_consulta,
                    }).then(function (response) 
                    {
                        var respuesta       =   response.data;
                        me.arr_respuestas   =   respuesta.respuestas;

                        if(me.tp_respuesta == 1 || me.tp_accion == 2)
                        {
                            me.arr_historial    =   respuesta.arr_historial;

                            //actualizacion estado
                            me.id_estado        =   me.arr_historial[me.arr_historial.length -1].id_estado;
                        }
                    }).catch(function (error) 
                    {
                        console.log(error);
                    });     
                },
                //-------------------------------------------------------------------------------------------
                ensamblarDatos(accion,tp_consulta = 0)
                {
                    let me              =   this;
                    var ruta            =   '';
                    var titulo          =   '';
                    var tiempo          =   0;
                    var error           =   0;                    
                    var formData        =   new FormData();
                    var fc_format       =   'YYYY-MM-DD';
                    var dir_vecino      =   '';
                    var dir_solicitud   =   '';
                    var nr_dir_solicitud    =   '';
                    var nr_dir_vecino       =   '';
                    me.tp_error         =   0;
                    me.arr_valida       =   [];                   
                    titulo              =   'Registrando de Solicitud';
                    tiempo              =   3000;                      
                    //------------------------------------
                    ruta    =   '/territorial/solicitud/registrar';

                    if(tp_consulta == 0)
                        ruta    =   '/territorial/solicitud/store';
                   

                    console.log(me.nr_tipo)
                    console.log(me.getValue(me.nr_tipo))
                    console.log(me.getLabel(me.nr_tipo))

                    me.arr_form = {};

                    if(me.tp_municipal == 1 && me.nr_tipo.id_direccion == 0)
                    {
                       me.arr_form     =   {'tipo_solicitud' : 'Ingresar Tipo Solicitud'};
                       return
                    }
                    //------------------------------------
                    console.log('----- Ubicacion Solicitud -----');
                    console.log('length : ' + me.arr_direccion_solicitud.length);
                    console.log('Obj length : ' + Object.keys(me.arr_direccion_solicitud).length);
                    console.log(me.arr_direccion_solicitud);
                    console.log('-------------------------------------------');
                    console.log('----- Ubicacion Vecino -----');
                    console.log('length : ' + me.arr_ubicacion_vecino.length);
                    console.log('Obj length : ' + Object.keys(me.arr_ubicacion_vecino).length);
                    console.log(me.arr_ubicacion_vecino);
                    console.log('-------------------------------------------');
                    //------------------------------------
                    // Datos de Solicitud
                    formData.append('tp_consulta', tp_consulta);
                    formData.append('tp_update', tp_consulta);
                    formData.append('id_consulta', me.id_consulta);
                    formData.append('nr_tipo', me.getValue(me.nr_tipo));
                    formData.append('nm_tipo', me.getLabel(me.nr_tipo ));
                    formData.append('nr_prioridad', me.nr_prioridad);
                    // ubicacion del problema
                    if(Object.keys(me.arr_direccion_solicitud).length)
                        formData.append('arr_direccion_solicitud[]', JSON.stringify(me.arr_direccion_solicitud));
                    
                    formData.append('str_observacion', me.str_observacion);
                    formData.append('fc_ingreso', me.fc_ingreso);
                    formData.append('tp_municipal', me.tp_municipal);
                    formData.append('str_observacion', me.str_observacion);
                    formData.append('nr_dir_municipal', me.nr_dir_municipal);
                    formData.append('tp_direccion_solicitud', me.nr_tp_direccion_solicitud);
                    //------------------------------------
                    // Datos de Vecino
                    formData.append('rut_vecino', me.rut_vecino.trim());
                    formData.append('nm_vecino', me.nm_vecino);
                    formData.append('ap_paterno', me.ap_paterno);
                    formData.append('ap_materno', me.ap_materno);
                    formData.append('nm_mail', me.mail_vecino);
                    formData.append('pre_fijo', me.pre_fijo);
                    formData.append('nr_telefono', me.nr_telefono);

                    if(Object.keys(me.arr_ubicacion_vecino).length)
                        formData.append('arr_ubicacion_vecino[]', JSON.stringify(me.arr_ubicacion_vecino));

                    formData.append('tp_direccion', me.tp_direccion);
                    formData.append('str_aclaratoria', me.str_aclaratoria);
                    //------------------------------------
                    if(me.arr_files.length != 0)
                    {
                        for (var i = 0; i < me.arr_files.length; i++) 
                        {
                            formData.append('arr_archivo[]', me.arr_files[i]);
                        }
                        for (var i = 0; i < me.arr_files_obs.length; i++) 
                        {
                            formData.append('arr_observacion[]', me.arr_files_obs[i]);
                        }
                    }
                    //------------------------------------
                    me.registrarDatos(ruta, formData);
                    //------------------------------------
                },
                //-------------------------------------------------------------------------------------------
                validarDatos(tp_validacion)
                {
                    let me          =   this;
                    var error       =   0;
                    me.str_error    =   '';

                    switch(tp_validacion)
                    {
                        case 'feedback':
                        {
                            if(me.id_consulta == 0)
                                me.str_error    =   me.str_error + 'No se encuentra ID de la solicitud';

                            if(me.nr_recepcion == 1 && me.nr_satisfaccion == 0)
                                me.str_error    =   me.str_error + '<br>Debe ingresar el tipo de satisfaccion';

                            if((typeof me.str_feedback === "") || (me.str_feedback === null))
                                me.str_error    =   me.str_error + '<br>Debe ingresar la observación al feedback';

                            if(!(typeof me.str_feedback === "") && !(me.str_feedback === null))
                                if(me.str_feedback.trim().length < 5)
                                    me.str_error    =   me.str_error + '<br>La observación debe tener un minimo de 5 caracteres';

                            if(!(typeof  me.str_error === "") && !( me.str_error === null))
                                if(me.str_error.trim().length)
                                    error   =   1;

                            break;
                        }
                    }

                    return error;
                },
                //-------------------------------------------------------------------------------------------
                derivar(opcion)
                {
                    let me      =   this;
                    var ruta    =   '/solicitud/derivar';
                    me.arr_form    =   {};

                    if(me.nr_solicitud == 0)
                        me.arr_form.nr_solicitud    =   'No se encuentra el Id de la Solicitud';

                    if(me.getValue(me.nr_derivar) == 0)
                        me.arr_form.nr_derivar     =   'Debe seleccionar un Servicio';

                    if(me.str_derivar.trim().length < 10)
                        me.arr_form.str_derivar     =   'La observación debe tener minimo 10 caracteres';

                    if(Object.keys(me.arr_form).length != 0)
                        return;

                    // bloquea boton
                    me.btn_derivar  =   1;
                    $('.btn_derivar').attr('disabled',true);                    

                    axios.post(ruta,{
                        'nr_solicitud'  :   me.solicitud_actual.id,
                        'nr_servicio'   :   me.getValue(me.nr_derivar),
                        'nm_servicio'   :   me.getLabel(me.nr_derivar),
                        'nr_direccion'  :   me.nr_derivar.id_direccion,
                        'nr_depto'      :   me.nr_derivar.id_depto,
                        'str_derivar'   :   me.str_derivar,
                        'tp_ingreso'    :   3, // funcionario
                    }).then(function (response)
                    {                        
                        var respuesta   =   response.data;

                        if(respuesta.error == 0)
                        {
                            me.desplegarVentana(respuesta.tp_icon, respuesta.title, respuesta.msj);
                            me.btn_derivar  =   0;
                            me.str_derivar  =   '';

                            $("#modal_derivar").modal('hide');//ocultamos el modal
                            $("#modal_historial").modal('hide');//ocultamos el modal
                            $('body').removeClass('modal-open');//eliminamos la clase del body para poder hacer scroll
                            $('.modal-backdrop').remove();//eliminamos el backdrop del modal
                        }

                        // me.cargarHistorial(me.solicitud_actual.id);
                        me.cargarDatos();                        
                    }).catch(function (error) {
                        console.log(error);
                        me.btn_derivar  =   0;
                        $('.btn_derivar').attr('disabled',false);
                    });
                },
                //-------------------------------------------------------------------------------------------
                asyncTipoRecepion(item)
                {
                    let me  =   this;

                    if(item)
                        me.nr_recepcion     =   item.value;
                    else
                        me.nr_recepcion     =   0;

                    console.log(me.nr_recepcion);
                },
                //-------------------------------------------------------------------------------------------
                asyncTipoSatisfacction(item)
                {
                    let me  =   this;

                    if(item)
                        me.nr_satisfaccion  =   item.value;
                    else
                        me.nr_satisfaccion  =   0;

                    console.log(me.nr_satisfaccion);
                },
                //-------------------------------------------------------------------------------------------
                feedback()
                {
                    let me              =   this;
                    var ruta            =   '';
                    var titulo          =   '';
                    var mensaje         =   '';
                    var tiempo          =   0;
                    var error           =   0;
                    var formData        =   new FormData();
                    //------------------------------------
                    titulo              =   'Registrando Feedback';
                    tiempo              =   3000;                      
                    //------------------------------------
                    ruta    =   '/territorial/solicitud/feedback';
                    //------------------------------------
                    error   =   me.validarDatos('feedback');

                    if(error == 1)
                    {
                        me.desplegarVentana('warning', titulo, me.str_error, 1);
                        return;
                    }
                    else
                    {
                        //------------------------------------
                        formData.append('nr_solicitud', me.id_consulta);
                        formData.append('tp_recepcion', me.getValue(me.tp_recepcion));
                        formData.append('tp_satisfaccion', me.getValue(me.tp_satisfaccion));
                        formData.append('str_feedback', me.str_feedback);
                        //------------------------------------
                        me.registrarDatos(ruta, formData);
                        //------------------------------------
                    }                    
                },
                //-------------------------------------------------------------------------------------------
                registrarDatos(ruta, formData)
                {
                    let me              =       this;
                    var tp_icon         =       '';
                    var titulo          =       '';
                    var mensaje         =       '';
                    var error           =       '';
                    me.validationErrors =       [];
                    me.btn_envio        =        1;

                    axios.post(ruta, formData, {
                        headers: {'Content-Type': 'multipart/form-data'}
                    }).then(function (response) 
                    {
                        var result  =   response.data;
                       
                        tp_icon     =   result.tp_icon;
                        titulo      =   result.title;
                        mensaje     =   result.msj;
                        error       =   result.error;

                        me.desplegarVentana(tp_icon, titulo, mensaje);

                        //Limpiar Modelos
                        if(error == 0)
                        {
                            me.limpiarDatos('registrar')
                            $('#modal_principal').modal('hide');
                            me.refrescarDatos();
                            me.btn_envio    =   0;
                        }                       
                    })
                    .catch(function (error) 
                    {
                        // Faltan campos por llenar
                         me.btn_envio        =        0;
                        if (error.response.status == 422)
                            me.validationErrors = error.response.data.errors;
                        /*// Formato de Archivo Incorrecto
                        if (error.response.status == 413)
                        {
                            //------------------------------
                        }*/
                    });
                },
                //-------------------------------------------------------------------------------------------
                cerrarModal(modelo)
                {
                    let me  =   this;

                    switch(modelo)
                    {
                        case 'historial':
                        {
                            tinymce.remove('#str_respuestas');
                            $('str_respuestas').remove();
                            $('#modal_historial').modal('hide');

                            break;
                        }
                        case 'solicitud':
                        {
                            $('#modal_principal').modal('hide');
                            me.limpiarDatos(modelo);

                            break;
                        }
                        case 'archivo':
                        {
                            $('#modal_adjunto').modal('hide');
                            me.limpiarDatos(modelo);

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                abrirModal(modelo, accion, data = [])
                {
                    let me      =       this;

                    switch(modelo)
                    {
                        case 'solicitud':
                        {
                            switch(accion)
                            {
                                case 'registrar':
                                {
                                    me.tp_modal                 =   1;
                                    me.tp_accion                =   1;
                                    me.arr_historial            =   [];
                                    me.modal_principal          =   1;
                                    me.accion_principal         =   1;
                                    me.boton_principal          =   1;
                                    me.titulo_principal         =   'Registrar Solicitud';
                                    me.solicitud_actual         =   [];
                                    me.arr_ubicacion_vecino     =   [];
                                    me.arr_direccion_solicitud  =   [];
                                    me.limpiarDatos(modelo);

                                    //$('#nav-tab a[href="#info_solicitud-tab"]').tab('show')
                                    $('#nav-tab li:first-child a').tab('show');

                                    $('#modal_principal').modal('show');

                                    break;
                                }
                                case 'actualizar':
                                {
                                    me.tp_modal                     =   2;
                                    me.tp_accion                    =   2;
                                    me.arr_historial                =   [];
                                    me.solicitud_actual             =   data;
                                    me.id_consulta                  =   data.id;
                                    me.arr_asignados                =   data.asignados;
                                   
                                    if(data.vecino)
                                    {
                                        me.rut_vecino               =   data.vecino.nr_rut;
                                        me.nm_vecino                =   data.vecino.nm_vecino;
                                        me.ap_paterno               =   data.vecino.ap_paterno;
                                        me.ap_materno               =   data.vecino.ap_materno;
                                        me.nr_telefono              =   data.vecino.nr_telefono;
                                        me.pre_fijo                 =   data.vecino.nr_prefijo;
                                        me.mail_vecino              =   data.vecino.nm_mail;
                                        me.str_aclaratoria          =   data.vecino.str_aclaratoria;

                                        me.arr_ubicacion_vecino =    
                                        {
                                            value : data.vecino.id_ubicacion,
                                            label : data.vecino.nm_ubicacion,
                                            nr_calle : data.vecino.nr_calle,
                                            nm_calle : data.vecino.nm_calle,
                                            str_latitud : data.vecino.str_latitud,
                                            str_longitud : data.vecino.str_longitud,
                                            cod_territorial : data.vecino.id_macroterritorio,
                                            cod_unidadvecinal : data.vecino.id_unidadvecinal,
                                        };
                                    }

                                    me.nr_tipo.value                =   data.id_tipo;
                                    me.nr_tipo.label                =   data.nm_tipo;
                                    me.nr_tipo.id_direccion         =   data.id_direccion_destino;
                                    me.tp_municipal                 =   data.tp_municipal;
                                    me.nr_prioridad                 =   data.id_prioridad;
                                    me.id_estado                    =   data.id_estado;
                                    me.nr_dir_municipal             =   data.id_direccion_destino;
                                    me.nr_tp_direccion_solicitud    =   data.tp_direccion;                                    
                                    me.str_observacion              =   data.str_observacion;
                                    me.tp_feedback                  =   data.tp_feedback;
                                    me.nr_recepcion                 =   data.tp_recepcion;
                                    me.nr_satisfaccion              =   data.tp_satisfaccion;
                                    me.cargarElementos('tp_recepcion', data.tp_recepcion);
                                    me.cargarElementos('tp_satisfaccion', data.tp_satisfaccion);
                                    me.str_feedback                 =   data.str_feedback;

                                    me.arr_direccion_solicitud =    {
                                        value               : data.id_ubicacion,
                                        label               : data.nm_ubicacion,
                                        nr_calle            : data.nr_direccion,
                                        nm_calle            : data.nm_direccion,
                                        str_latitud         : data.str_latitud,
                                        str_longitud        : data.str_longitud,
                                        cod_territorial     : data.cod_territorio,
                                        cod_unidadvecinal   : data.cod_unidadvecinal,
                                        id_macroterritorio  : data.id_macroterritorio,
                                    };
                                    
                                    me.titulo_principal     =   'Actualizar Solicitud';
                                    me.nr_ticket            =   data.nr_ticket;
                                    me.nm_estado            =   data.nm_estado;
                                    me.boton_principal      =   2;
                                    me.arr_archivo          =   [];
                                    me.changeContexto();
                                    $('#modal_historial').modal('show');
                                    me.cargarHistorial(data.id);

                                    break;
                                }
                                case 'derivar':
                                {
                                    me.arr_form     =   {};
                                    me.tp_modal     =   4;
                                    me.tp_accion    =   4;
                                    me.btn_derivar  =   0;
                                    me.nr_derivar   =   {
                                        'value'         : 0,
                                        'label'         : 'Seleccionar Tipo de Servicio',
                                        'id_direccion'  : 0,
                                    };
                                    me.cargarServicios();
                                    
                                    $('#modal_derivar').modal('show');
                                    break;
                                }
                            }

                            break;
                        }
                        case 'archivo':
                        {
                            switch(accion)
                            {
                                case 'anexar':
                                {
                                    me.modal_adjunto        =   1;
                                    me.accion_adjunto       =   1;
                                    me.titulo_adjunto       =   'Adjuntar Documentos';
                                    me.tp_adjunto           =   'documento';
                                    me.limpiarDatos(modelo);
                                    $('#modal_adjunto').modal('show');

                                    break;
                                }
                                case 'revisar':
                                {
                                    me.modal_adjunto        =   1;
                                    me.accion_adjunto       =   2;
                                    me.titulo_adjunto       =   'Revisar Documentos';
                                    me.tp_adjunto           =   'archivos';
                                    me.limpiarDatos(modelo);
                                    me.arr_adjuntos         =   data.archivos;
                                    $('#modal_revisar').modal('show');

                                    break;
                                }
                                case 'examinar':
                                {
                                    me.tp_modal             =   1;
                                    me.tp_accion            =   1;
                                    me.tp_btn               =   1;
                                    me.btn_envio            =   0;
                                    me.titulo_adjunto       =   'Revisar Documentos';
                                    me.tp_adjunto           =   'archivos';
                                    me.limpiarDatos(modelo);
                                    me.arr_adjuntos         =   data.archivos_asignacion;
                                    $('#modal_revisar').modal('show');

                                    break;
                                }
                            }

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                cargarElementos(tp_elemento, nr_elemento)
                {
                    let me      =   this;
                    var temp    =   [];

                    switch(tp_elemento)
                    {
                        case 'tp_recepcion':
                        {
                            me.tp_recepcion     =   [];

                            temp    =   me.arr_recepcion.filter(
                                            event   =>  event.value === nr_elemento
                                        );

                            if(me.tp_feedback == 1)
                            {
                                me.tp_recepcion     =   [{
                                    'value' : temp[0].value,
                                    'label' : temp[0].label,
                                }];
                            }
                            else
                            {
                                me.tp_recepcion     =   [{
                                        'value' : 0,
                                        'label' : 'No Contactado',
                                }];
                            }

                            break;
                        }
                        case 'tp_satisfaccion':
                        {
                            me.tp_satisfaccion  =   [];
                            temp    =   me.arr_satisfaccion.filter(
                                            event   =>  event.value === nr_elemento
                                        );

                            if(me.nr_recepcion == 1)
                            {
                                me.tp_satisfaccion  =   [{
                                    'value' : temp[0].value,
                                    'label' : temp[0].label,
                                }];
                            }

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                desplegarVentana(tp_icon, titulo, mensaje, tp_btn = 1)
                {
                    Swal.fire({
                        icon: tp_icon,
                        title: titulo,
                        html: mensaje,
                        backdrop:false,
                        showConfirmButton: tp_btn
                    });                       
                },
                //-------------------------------------------------------------------------------------------
            },

            mounted() {
                let me = this;
                me.activeDatetimepicker();
                me.cargarMotivo();
                me.cargarDatos();
                me.dataDefault();
            }
        });
    </script>

    <script type="text/javascript">
        //-----------------------------------------------------------------
        $(document).ready(function(){
            /*----- Inicio - Filtrar -----*/
            $("#btn_filtrar_datos").click(function () {
                $content = $("#filtrar_datos");
                $content.slideToggle(500, function () {
                    // ---------------------------
                });
            });

            $("#close_filtrar_datos").click(function () {
                $content = $("#filtrar_datos");
                $content.slideToggle(500, function () {
                    // ---------------------------
                });
            });
            /*----- Inicio - Modal -----*/

            $('#modal_historial').modal({backdrop: 'static', keyboard: false});
            $('#modal_derivar').modal({backdrop: 'static', keyboard: false});
            $('#modal_adjunto').modal({backdrop: 'static', keyboard: false});
            $('#modal_revisar').modal({backdrop: 'static', keyboard: false});
        });
        //-----------------------------------------------------------------
        function justNumbers(e)
        {
            var keynum = window.event ? window.event.keyCode : e.which;
            if (keynum == 8)
                return true;

            return /\d/.test(String.fromCharCode(keynum));
        }
        //-----------------------------------------------------------------
    </script>

@endsection()


