@extends('template.home')
@section('body')

<div  class="page-content " id="app">
            
    <div class="container-fluid">
        
        <div class="chat-conversation" style="height:70vh;max-height:70vh;overflow:hidden scroll"  >
            <section v-for="(item,index) in info" :key="index" :id ="'nodo_'+index" class="">

                <div class="row-fluid">

                    <div class="offset-3 col-md-6 conversation-list " v-if="item.role == 'user'">
                        
                        <div class=" text-white rounded" >
                            <div :class="{'sm spinner-grow spinner-grow-sm  ml-2':item.last == 1}" class="user-avatar rounded-circle text-center pt-1" style="color:white;background-color: #19C37D;width: 2em;height: 2em;">
                                <span>@{{name_user}}</span>
                            </div>
                        </div>
                                <p style="color:black" v-html="formatLinks(item.content[0])"></p>

                               
                            
                        </div>

                        <div class="offset-3 col-md-6 conversation-list pt-2" v-if="item.role == 'assistant'" >
                            
                            <div class=" rounded" >
                                <div  class="user-avatar rounded-circle text-center pb-3" style="width: 2em;height: 2em;">
                                    <span ><img  src="/img/openai-icon.png" alt="" style="width: 2em;height: 2em;"></span>
                                </div>

                                    <p style="color:black" v-html="formatLinks(item.content[0])"></p>
                                    <img v-if="item.image_ids"  :src="item.image_ids" width="600" alt="" class="mt-2"> <br>
                                 
                                
                            </div>
                            
                        </div>
                    
                </div>

            
            </section>
        </div>

        <div class="row mb-4">
            <div class="col-md-6 offset-3">
                <div class="hstack gap-3">
                    <textarea :disabled="escribiendo == 1"  v-model="query" class="form-control me-auto" type="text" placeholder="Ingrese su consulta..." aria-label="Ingrese su consulta..."> </textarea>
                    <button  @click="add_question()" :disabled="escribiendo == 1"     class="btn btn-success">Enviar</button>
                    <div class="vr"></div>
                    <button @click="borrar_hilo()" :disabled="escribiendo == 1"  type="button" class="btn btn-outline-danger">Eliminar</button>
                </div>
            </div>
        </div>

</div>


</div>


    

    <script type="module">

        var app = new Vue({
            el: '#app',
            data: {
                show_copy         : '', 
                tmp_text          : '',
                info              : [],
                query             : '',
                escribiendo        : 0,
                tmp_respuesta_id  : 0,
                tmp_respuesta     : '',
                tp_modal          : 1,
                str_comentario    : '',
                current_index     : [],
                filter_query      : '',
                asistentes        : [],
                tp_asistente      : 'ASIST_SOFIA',
                contenido         : [],
                name_user         : ''
            },
            components: {
                //-------------------------------------------------------------------------------------------
            },

            

            filters:{
                //-------------------------------------------------------------------------------------------
            },

            computed:{
                
            },
            watch: {
                comentario(newVal) 
                {
                    if (newVal === null) 
                        this.str_comentario = ""; // Asignar cadena vacía si el valor es null
                    else 
                        this.str_comentario = newVal;
                }
            },
            methods:{   
                fechaFormateada(timestamp) 
                {
                    return moment.unix(timestamp).format("DD-MM-YYYY HH:ss");
                },
                borrar_hilo()
                {
                    let me = this
                    axios.post('/delete/thread',
                    {
                        'asistente' : me.tp_asistente})
                        .then(response => {
                            let resp = response.data
                            me.info        = []
                            me.escribiendo = 0
                            Swal.fire(resp);

                        })
                            .catch(error => {
                            console.log(error)
                
                        });
                },
                clean_chat()
                {
                    let me = this
                    Swal.fire({
                                title: "Seguro que quieres eliminar esta conversación?",
                                icon: "warning",
                                showCancelButton: true,
                                confirmButtonColor: "#3085d6",
                                cancelButtonColor: "#d33",
                                confirmButtonText: "Si",
                                cancelButtonText: "Cancelar",

                                }).then((result) => 
                                {

                                    if (result.isConfirmed) 
                                    {
                                        me.borrar_hilo()
                                    }

                                });
                    
                },
                        copiarAlPortapapeles(id) 
                        {
                        // Selecciona el contenido del div
                        var contenidoDiv = document.getElementById(id);
                        var contenidoText = contenidoDiv.innerText;

                        // Crea un elemento de textarea temporal
                        var tempTextarea = document.createElement("textarea");
                        tempTextarea.value = contenidoText;
                        document.body.appendChild(tempTextarea);

                        // Selecciona y copia el contenido del textarea temporal al portapapeles
                        tempTextarea.select();
                        document.execCommand("copy");

                        // Elimina el textarea temporal
                        document.body.removeChild(tempTextarea);
                        this.show_copy = id
                        
                        },
                        convertirTimestampAFecha(timestamp) 
                        {
                            const fecha = moment.unix(timestamp);
                            return fecha.format('DD MMMM, YYYY h:mm A')
                        },
                        formatLinks(text) 
                        {
                            const linkRegex = /\[(.*?)\]\((.*?)\)/g;
                            const replacedText = text.replace(linkRegex, '<a target="_blank" href="$2">Enlace</a>');

                            // Reemplazar negritas
                            const boldRegex = /\*\*(.*?)\*\*/g;
                            const textWithBold = replacedText.replace(boldRegex, '<strong>$1</strong>');

                            // Reemplazar encabezados de nivel 2 (##) con h2
                            const h2Regex = /^##\s+(.*)$/gm;
                            const textWithH2 = textWithBold.replace(h2Regex, '<h3>$1</h3>');

                            // Reemplazar encabezados de nivel 1 (#) con h1
                            const h1Regex = /^#\s+(.*)$/gm;
                            const textWithH1 = textWithH2.replace(h1Regex, '<h2>$1</h2>');

                            // Reemplazar saltos de línea con <br>
                            const textWithLineBreaks = textWithH1.replace(/\n/g, '<br>');

                            return textWithLineBreaks;
                        },
                        get_hilo(run_id)
                        {
                                let me      = this;
                                axios.post('/consulta/answer',
                                {'asistente' : me.tp_asistente,'run_id':run_id,'contexto':0})
                                .then(response => {
                                
                                me.info        = response.data.response.messages
                                me.info.sort(function(a, b) {return a.created_at - b.created_at;});

                                // identifica el ultimo elmento y agrega la clave last con valor 1
                                this.$nextTick(() => {
                                    this.setIdScroll()
                                    this.scrollDown('.chat-conversation')
                                })


                                me.escribiendo   = 0
                                me.escribiendo  = 0
                            })
                                .catch(error => {
                                console.log(error);
                                me.escribiendo         = 0
                    
                            });
                    
                        },
                        add_question()
                        {
                            let me        = this;
                            let question  = me.query
                    
                            if( me.query == '' || me.escribiendo == 1 )
                                return 

                            me.escribiendo   = 1
                            me.query        = ''
                    
                            axios.post('/consulta/question',
                            { 'asistente' : me.tp_asistente,'question':question,'contexto':0})
                            .then(response => {
                                
                                me.info        = response.data.response.messages 
                                let run_id     = response.data.run_id
                                me.escribiendo  = 0


                                me.info.sort(function(a, b) {return a.created_at - b.created_at;});
                                me.info[me.info.length - 1].last = 1

                                this.$nextTick(() => {
                                    me.setIdScroll()
                                    me.scrollDown('.chat-conversation')
                                    me.get_hilo(run_id)
                                    me.escribiendo   = 0
                                })

                                



                            })
                                .catch(error => {
                                console.log(error);
                                me.escribiendo         = 0
                    
                            });
                    
                        },
                        setIdScroll()
                        {
                            // Obtén el elemento con la ID "nodo_0"
                                var nodo0 = document.getElementById('nodo_0');

                            if (nodo0) 
                                var elementoPadre = nodo0.parentElement;

                            if (elementoPadre) 
                                    elementoPadre.parentElement.id = 'scroll_chat';
                        },
                        scrollDown(element) 
                        {
                            let el = document.querySelector(element);

                            if(!el)
                                return 

                            if (el) 
                                {
                                    let px = el.scrollHeight;
                                    $(el).animate({ scrollTop: px }, 1000);
                                }
                        },
                        async get_chats()
                        {
                            let me      = this;
                            const fecha = moment();
                            me.info     = []


                            let params = {'asistente': this.tp_asistente,'contexto':0}
                            await   axios.post('/get/chats/openai',params)
                            .then(response => 
                            {

                                console.log(response)
                                if(response.data.response  )
                                    {
                                        me.info = response.data.response.messages
                                        me.info.sort(function(a, b) {return a.created_at - b.created_at;});

                                        this.$nextTick(() => 
                                        { 
                                            this.setIdScroll()
                                            this.scrollDown('.chat-conversation')
                                        })

                                    }

                            

                            }).catch(error => {
                                console.log(error);
                            });
                            
                                
                        },
                        
                },

            mounted() {
                let me  =   this;
                me.get_chats()
                
            }
        });
    </script>

<style scoped>
.chat-msg {cursor: text;}

.parent-div {
  display: flex;
  flex-direction: column;
  justify-content: flex-end;
  align-items: stretch;
  height: 92vh; /* Ajusta esta altura según sea necesario */
  background-color: white !important;
}

.nk-chat-editor {margin-top: auto;}
.nk-reply-item > div:not(.nk-reply-header) {
    margin-left: 0px;
}

</style>
@endsection()


