@extends('template.home')
@section('body')
<div class="page-content">
    <div class="container-fluid" id="app">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0 font-size-18" style="text-transform: uppercase; color: royalblue;">Bienvenido(a) {{ $rol_actual->usuario }}</h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
                            <li class="breadcrumb-item active">Bienvenida</li>
                        </ol>
                    </div>
                </div>

                <div class="x_content">
                    <div class="col-md-12 col-sm-12 mt-2">
                        <div class="row-flow">
                            <div class="col-lg-12 col-md-12 col-sm-12">
                                <div class="card">
                                    <div class="card-header bg-primary">
                                        <h5 class="text-center" style="color: white; text-transform: uppercase;">Oficina de Atención al Vecino</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="img_bienvenida" style="position: relative; display: inline-block;">
                                            <div style="position: absolute; text-align: left;">
                                                <p class="h5">Bienvenidos al módulo de <strong>Oficina de Atención al Vecino de la Municipalidad de San Miguel</strong>.</p>
                                                <p class="h5">Para comenzar debes seleccionar una opción del menú de la izquierda</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>                      
                    </div>
                </div>
            </div>           
        </div>
    </div>
</div>

    <style type="text/css">
        .img_bienvenida {
            height: 309px;
            width: 100%;
            margin-top: 0px;
            margin-right: auto;
            margin-bottom: 0px;
            margin-left: auto;
            background-image: url(/img/bienvenida_general.png);
            background-repeat: no-repeat;
            float: right;
            background-position: right top;
        }
    </style>

    <script type="text/javascript">
        Vue.component('vue-multiselect', window.VueMultiselect.default);

        var app = new Vue({
            el: '#app',
            data: {
                //-------------------------------------------------------------------------------------------
            },

            components: {

            },

            filters:{
                //-------------------------------------------------------------------------------------------
            },

            computed:{                
                //-------------------------------------------------------------------------------------------
            },

            methods: {
                //-------------------------------------------------------------------------------------------
                cargarDatos()
                {
                    let me          = this;
                    var ruta        = '/contador/solicitudes/pendientes';

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta           =   response.data;
                        $('#pendientes_mz').html(respuesta.nr_bandeja);
                        $('#propias_mz').html(respuesta.nr_propias);
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
            },

            mounted() {
                let me  =   this;
                me.cargarDatos();        
            }
        });
    </script>

    <script type="text/javascript">
        //-----------------------------------------------------------------
        $(document).ready(function(){
            //-------------------------------------------------------------------------------------------
        });
        //-----------------------------------------------------------------
        function justNumbers(e)
        {
            var keynum = window.event ? window.event.keyCode : e.which;
            if (keynum == 8)
                return true;

            return /\d/.test(String.fromCharCode(keynum));
        }
        //-----------------------------------------------------------------
        function Rut(texto)
        { 
            var tmpstr = "";

            for ( i=0; i < texto.length ; i++ )   
                if ( texto.charAt(i) != ' ' && texto.charAt(i) != '.' && texto.charAt(i) != '-' )
                    tmpstr = tmpstr + texto.charAt(i);

            texto = tmpstr; 
            largo = texto.length; 

            if ( largo < 2 ) 
                return false; 

            for (i=0; i < largo ; i++ )    
                if (texto.charAt(i) !="0" && texto.charAt(i) != "1" && texto.charAt(i) !="2" && texto.charAt(i) != "3" && 
                    texto.charAt(i) != "4" && texto.charAt(i) !="5" && texto.charAt(i) != "6" && texto.charAt(i) != "7" && 
                    texto.charAt(i) !="8" && texto.charAt(i) != "9" && texto.charAt(i) !="k" && texto.charAt(i) != "K")   
                    return false;

            var invertido = "";

            for ( i=(largo-1),j=0; i>=0; i--,j++ )    
                invertido = invertido + texto.charAt(i);

            var dtexto = "";  
            dtexto = dtexto + invertido.charAt(0);  
            dtexto = dtexto + '-';  
            cnt = 0;  

            for ( i=1,j=2; i<largo; i++,j++ ) 
            { 
                if ( cnt == 3 )   
                {     
                    dtexto = dtexto + '.';      
                    j++;      
                    dtexto = dtexto + invertido.charAt(i);      
                    cnt = 1;    
                }   
                else    
                {       
                    dtexto = dtexto + invertido.charAt(i);      
                    cnt++;    
                } 
            } 

            invertido = "";

            for ( i=(dtexto.length-1),j=0; i>=0; i--,j++ )    
                invertido = invertido + dtexto.charAt(i);

            if (revisarDigito2(texto))
                return  invertido.toUpperCase();

            return false;
        }
        //-----------------------------------------------------------------
        function formatoMail(valor)
        {
            if (/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test(valor))
                return true;
            else
                return false;
        }
        //-----------------------------------------------------------------
    </script>
@endsection()


