<!DOCTYPE html>
<html lang="es">
	<head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="csrf-token" content="{{ csrf_token() }}">
		<title>Sistema Atención al Vecino</title>
		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no, minimal-ui">
		<meta name="csrf-token" content="{{ csrf_token() }}">

		<script src="https://code.jquery.com/jquery-3.5.0.js" ></script>
		<script src="https://cdn.jsdelivr.net/npm/vue@2/dist/vue.js"></script>
		<!-- <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script> -->
		<script src="https://cdn.jsdelivr.net/npm/axios@0.26.0/dist/axios.min.js"></script>		
    	<script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
		
		
		<link href="{{asset('/css/bootstrap.min.css')}}"  rel="stylesheet">
		
		<link href="{{asset('/css/icons.min.css')}}" rel="stylesheet" type="text/css" >
		<link href="{{asset('/css/app.min.css')}}"  rel="stylesheet" type="text/css">

		<script src="{{asset('/lib/vue-quill/js/vue-quill.global.prod.js')}}"></script> 
		<link rel="stylesheet" href="{{asset('/lib/vue-quill/css/vue-quill.snow.prod.css')}}">
	</head>

	<body data-sidebar="dark">
		<!-- change role -->
		<div class="modal fade" id="modal_rol" tabindex="0" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
			<div class="modal-dialog" role="document">
			    <div class="modal-content">
			      	<div class="modal-header bg--primary">
			        	<h5 class="modal-title" id="exampleModalLabel">Cambiar Rol</h5>
			        	<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
			          		<span aria-hidden="true">&times;</span>
			        	</button>
			      	</div>
			      	<div class="modal-body">
				    	<div class="row">
		            		<div class="col-12">
		              			<div class="form-group">
		                			<label>Seleccionar Rol:</label>
		                			<select class="form-control" id="nr_rol">
		                				@foreach ($data as $roles)
		                					<option value="{{ $roles->id }}">{{ $roles->nombre }}</option>
		                				@endforeach
		                			</select>
		              			</div>
		            		</div>
		          		</div>
			      	</div>
			      	<div class="modal-footer">
	          			<button type="button" class="btn btn-light btn_activo" data-bs-dismiss="modal">Cancelar</button>
	          			<button type="button" class="btn btn-primary btn_activo" onclick="changeRol()">Guardar Cambios</button>
	        		</div>
			    </div>
			</div>
		</div>

		<!-- change password -->
		<div class="modal fade" id="modal_password" tabindex="0" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
			<div class="modal-dialog" role="document">
			    <div class="modal-content">
			      	<div class="modal-header bg--primary">
			        	<h5 class="modal-title" id="exampleModalLabel">Cambiar Contraseña</h5>
			        	<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
			          		<span aria-hidden="true">&times;</span>
			        	</button>
			      	</div>
			      	<div class="modal-body">
				    	<div class="row">
		            		<div class="col-12">
		              			<div class="form-group">
		                			<label>Ingresar Contraseña Nueva:</label>
		                			<input onkeyup="contadorClave()" onkeypress="contadorClave()" id="new_pass" maxlength="8" type="password" class="form-control tp_editar" placeholder="Contraseña">
		                			<small>Le quedan <strong id="cant_clave"></strong> caracteres por ingresar.</small>
		              			</div>
		            		</div>

		            		<div class="col-12">
		              			<div class="form-group">
		                			<label>Re Ingresar Contraseña Nueva:</label>
		                			<input id="rnew_pass" maxlength="8" type="password" class="form-control tp_editar" placeholder="Repetir Contraseña">
		              			</div>
		            		</div>

		            		<div class="row-fluid">
			            		<div class="col-md-12">
			              			<h6 style="color:red" class="text-error" id="error_pass"></h6>
			            		</div>
			          		</div>
		          		</div>
			      	</div>
			      	<div class="modal-footer">
	          			<button type="button" class="btn btn-light btn_activo" data-bs-dismiss="modal">Cancelar</button>
	          			<button type="button" class="btn btn-primary btn_activo" onclick="cambiar_clave()">Guardar Cambios</button>
	        		</div>
			    </div>
			</div>
		</div>

		@yield('content')

		<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM" crossorigin="anonymous"></script>
		<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js" integrity="sha512-qTXRIMyZIFb8iQcfjXWCO8+M5Tbc38Qi5WzdPOYZHIlZpzBHG3L3by84BBBOiRGiEb7KKtAOAs5qYdUiZiQNNQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>

    	<script src="https://cdn.jsdelivr.net/npm/echarts@5.1.1/dist/echarts.min.js"></script>
    	<script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>

		<script src="{{ asset('/js/funciones_generales.js') }}"></script>
		<script src="https://cdnjs.cloudflare.com/ajax/libs/metisMenu/3.0.7/metisMenu.min.js" integrity="sha512-o36qZrjup13zLM13tqxvZTaXMXs+5i4TL5UWaDCsmbp5qUcijtdCFuW9a/3qnHGfWzFHBAln8ODjf7AnUNebVg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
		<script src="https://cdnjs.cloudflare.com/ajax/libs/simplebar/3.1.0/simplebar.min.js" integrity="sha512-BAuu8EflZpIaGvbVQU/kEAHbiENMFlyewimZOSxV9HPqOCGuifmxxIdpeTNQSZWREeIdFdoAtRGx5yGvTzsjaQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
		<script src="https://cdnjs.cloudflare.com/ajax/libs/node-waves/0.7.6/waves.min.js" integrity="sha512-MzXgHd+o6pUd/tm8ZgPkxya3QUCiHVMQolnY3IZqhsrOWQaBfax600esAw3XbBucYB15hZLOF0sKMHsTPdjLFg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
		
		<script src="{{asset('js/app_stoke.js')}}"></script>
	</body>
</html>
