<?php


Auth::routes();

Route::get('/task/mail/respuesta_servicio', 'TaskController@mailRespuestaServicio');


Route::get('/bus', 'BusController@store');

//ruta publica de descarga
Route::get('/files/download', 'ArchivosController@getFile');
Route::get('/files/preview', 'ArchivosController@getPreview');
Route::post('/feedback/publico/store', 'TerritorialController@feedback_store_public')->name('feedback_store');


Route::get('/', 'HomeController@index')->name('home');
Route::get('/test/correos', 'EmailController@enviarNotificaciones')->name('correo');
Route::get('/test/sms', 'UtilController@testSms');
Route::get('/test/mail', 'UtilController@testMail');
Route::get('/test/telefonistas', 'UtilController@getDistribucionTicketTelefonista');
Route::get('/test/ciclo', 'UtilController@testCiclo');

Route::get('/prioridad/listado', 'GsutPrioridadController@listado')->name('prioridad_listado');
Route::get('/estado/listado', 'GsutEstadoController@listado')->name('estado_listado');
// Route::post('/subordinados/listado', 'GsutEncargadoController@listarSubordinado')->name('subordinado_listado');
Route::get('/feedback/timeout', 'GsutSolicitudController@cerrarFeedbackSolicitud');

Route::get('/solicitud/ingreso/{nr_id}/{nr_tipo}', 'GsutFlujoController@ingresoSolicitud');


Route::get('/atencion_vecino/formulario', 'GsutVecinoController@pageIngreso')->name('vecino_ingreso');
Route::get('/atencion_vecino/formulario/servicio/', 'GsutVecinoController@pageIngresoDinamico')->name('vecino_ingreso.dinamico');
// Route::get('/atencion_vecino/consulta', 'GsutVecinoController@pageConsulta')->name('vecino_consulta');
Route::get('/atencion_vecino/ticket/{nr_ticket}', 'UtilController@generarPDFTicket')->name('vecino_ticket');
Route::get('/atencion_vecino/{tp_destino}', 'GsutVecinoController@page')->name('vecino_rutas');
Route::get('/atencion_vecino/logout', 'GsutVecinoController@logoutVecino');
Route::post('/atencion_vecino/vecino/store', 'GsutVecinoController@storeVecino');

Route::get('/atencion_vecino/token/generar', 'UtilController@generarToken');

Route::get('/app_movil/formulario', 'AppMovilController@pageIngreso')->name('app_ingreso');
Route::get('/app_movil/consulta', 'AppMovilController@pageConsulta')->name('app_consulta');
Route::post('/app_movil/consulta/solicitud', 'AppMovilController@searchSolicitud');
Route::post('/solicitud/app_movil/store', 'AppMovilController@storeSolicitud');

Route::get('/invierno_seguro/sumideros', 'GsutVecinoController@pageSumiderosAgualluvias');

Route::get('/buscar', 'GsutVecinoController@buscarSolicitud');
// Route::get('/buscar/vecino/{nr_rut}', 'GsutVecinoController@getVecino');
Route::get('/buscar/data/vecino', 'UtilController@getDataSessionVecino');

Route::get('/reuniones_comunitarias/formulario', 'GsutVecinoController@pageAudiencia')->name('audiencia_ingreso');
Route::get('/redes_sociales/formulario', 'GsutVecinoController@pageRedesSociales')->name('rrss_ingreso');

Route::get('/password/reset', 'Auth\ForgotPasswordController@showLinkRequestForm')->name('password.request');
Route::post('/password/email', 'Auth\ForgotPasswordController@sendResetLinkEmail')->name('password.email');
Route::get('/password/reset/{token}', 'Auth\ResetPasswordController@showResetForm')->name('password.reset');
Route::post('/password/reset', 'Auth\ResetPasswordController@reset')->name('password.update');


Route::get('/regiones/listado', 'UtilController@listadoRegiones');
Route::post('/provincias/listado', 'UtilController@listadoProvincias');
Route::post('/comunas/listado', 'UtilController@listadoComunas');
Route::get('/motivo/listado', 'GsutMotivoController@listado');
Route::get('/servicios/listado', 'GsutTipoController@listadoServicios');
Route::get('/servicio/{nr_servicio}', 'GsutTipoController@getServicio');

//Calles
Route::get('/calles/index', 'MaestroDireccionesController@indexCalles');
//Direcciones
Route::post('/direccion/index', 'RestController@searchUbicaciones');
// ingreso solicitud vecino
Route::post('/solicitud/vecino/store', 'GsutVecinoController@storeSolicitud');
Route::post('/solicitud/vecino/search', 'GsutVecinoController@searchSolicitud');
Route::post('/solicitud/historial/vecino/search', 'GsutVecinoController@historialSolicitud');


Route::get('/clave-unica/login', 'ClaveUnicaMLCController@envia')->name('claveunica-login');
Route::get('/clave-unica/get', 'ClaveUnicaMLCController@recibe')->name('claveunica-get');

Route::get('/test/fechas', 'UtilController@testFechas');



Route::group(['middleware' => ['auth']], function() {
    Route::get('/home', 'HomeController@index')->name('home.logueado');
    Route::get('/cambiar-clave', 'HomeController@cambiar_clave')->name('cambiarclave');
    Route::post('/cambiar-clave/grabar', 'HomeController@cambiar_clave_store')->name('cambiarclave.grabar'); 
    Route::get('/logout', 'Auth\LoginController@logout');

    //Cambiar contraseña
    Route::post('/pass/update', 'HomeController@update_pass');

    //Direcciones
    //Route::post('/direccion/index', 'MaestroDireccionesController@index');

    //Calles
    //Route::get('/calles/index', 'MaestroDireccionesController@indexCalles');

    //Get File
    Route::get('/files/get', 'ArchivosController@getFile');

    //delete file
    Route::post('/files/delete', 'ArchivosController@deleteFiles');

    //delete file
    Route::get('/solicitud/get', 'GsutSolicitudController@getSolicitud');

    //data default
    Route::get('/default/data', 'GsutSolicitudController@defaultData');

    Route::get('/solicitud/page', 'GsutSolicitudController@page')->name('solicitud_home');

    Route::get('/pdf/solicitud/{id_ticket}', 'UtilController@generarPDFInformacionTicket');

    // valida rutas de acceso a las vistas
    Route::group(['middleware' => ['checkStatus']], function() {
        Route::get('territorial/{tp_destino}', 'TerritorialController@index')->name('territorial_rutas');
        Route::get('macrozona/{tp_destino}', 'MacroZonaController@index')->name('macro_zona_rutas');
        Route::get('funcionario/{tp_destino}', 'FuncionarioController@index')->name('funcionario_rutas');
        Route::get('/administrador/{tp_destino}', 'AdministradorController@page')->name('administrador_rutas');
        Route::get('/rrss/{tp_destino}', 'RedesSocialesController@page')->name('rrss_rutas');
        Route::get('/observador/{tp_destino}', 'ObservadorController@page')->name('observador_rutas');
        Route::get('/rrcc/{tp_destino}', 'ReunionesComunitariasController@page')->name('rrcc_rutas');
        Route::get('/asignador/{tp_destino}', 'AsignadorController@page')->name('asignador_rutas');
        Route::get('/concejal/{tp_destino}', 'ConcejalController@page')->name('concejal_rutas');
        Route::get('/supervisor/{tp_destino}', 'SupervisorTerritorialController@page')->name('supervisor_rutas');
        Route::get('/encuestador/{tp_destino}', 'EncuestadorController@page')->name('encuestador_rutas');
        Route::get('/visualizador/{tp_destino}', 'VisualizadorController@page')->name('visualizador_rutas');
        Route::get('/telefonista/{tp_destino}', 'TelefonistaController@page')->name('telefonista_rutas');
        Route::get('/revisor/{tp_destino}', 'RevisorController@page')->name('revisor_rutas');
        Route::get('/ia_gpt/{tp_destino}', 'GPTController@page')->name('iagpt_rutas');
        Route::get('/seguridadti/{tp_destino}', 'SeguridadTIController@page')->name('seguridadit_rutas');
    });

    //administraciones 
    // Route::get('/administrador/{tp_destino}', 'AdministradorController@page')->name('administrador_rutas');
    Route::post('/gestion/usuarios', 'UserController@index');
    Route::post('/gestion/usuarios/store', 'UserController@store');
    Route::post('/gestion/usuarios/update', 'UserController@update');
    Route::post('/gestion/usuarios/state', 'UserController@state');
    Route::post('/gestion/usuarios/permisos', 'UserController@permisos');
    Route::post('/gestion/usuarios/quitar/rol', 'UserController@quitarRol');
    Route::post('/gestion/servicios', 'GsutTipoController@index');
    Route::post('/gestion/servicios/store', 'GsutTipoController@store');
    Route::post('/gestion/servicios/update', 'GsutTipoController@update');
    Route::post('/gestion/servicios/state', 'GsutTipoController@state');
    Route::post('/gestion/servicios/add/funcionario', 'AsignadorController@store');
    Route::post('/gestion/servicios/del/funcionario', 'AsignadorController@quitarFuncionario');
    Route::post('/gestion/solicitud', 'AdministradorController@index_solicitud');
    Route::post('/gestion/anular/solicitud', 'GsutSolicitudController@anular');
    Route::post('/gestion/clonar/solicitud', 'GsutSolicitudController@clonarSolicitud');
    Route::get('/gestion/regularizar/solicitud/sin_flujo', 'GsutFlujoController@regularizarSolicitudesSinFlujo');
    Route::post('/gestion/servicios/respuestas/index', 'GsutRespuestaServicioController@index');
    Route::post('/gestion/servicios/respuestas/store', 'GsutRespuestaServicioController@store');
    Route::post('/gestion/servicios/respuestas/update', 'GsutRespuestaServicioController@update');
    Route::post('/gestion/servicios/respuestas/state', 'GsutRespuestaServicioController@state');

    // Contadores de Solicitud
    Route::get('/contador/ticket_agendados/{fc_fecha}', 'UtilController@getCantidadTicketAgendadosporFecha');

    // Redes Sociales
    Route::post('/solicitud/rrss/inicio', 'RedesSocialesController@index_solicitud');
    // Route::get('/rrss/{tp_destino}', 'RedesSocialesController@page')->name('rrss_rutas');

    // observador
    Route::post('/observador/solicitud', 'ObservadorController@index_solicitud');
    // Route::get('/observador/{tp_destino}', 'ObservadorController@page')->name('observador_rutas');
    Route::post('/observador/historial/solicitud', 'ObservadorController@getHistorial');

    // visualizador
    Route::post('/visualizador/solicitud', 'VisualizadorController@index');
    // Route::get('/visualizador/{tp_destino}', 'VisualizadorController@page');
    Route::post('/visualizador/historial/solicitud', 'VisualizadorController@getHistorial');

    // Reuniones Comunitarias
    Route::post('/rrcc/solicitud', 'ReunionesComunitariasController@index_solicitud');
    // Route::get('/rrcc/{tp_destino}', 'ReunionesComunitariasController@page')->name('rrcc_rutas');
    Route::post('/rrcc/historial/solicitud', 'ReunionesComunitariasController@getHistorial');

    // Supervisor Territorial
    Route::post('/supervisor/solicitud', 'SupervisorTerritorialController@index_solicitud');
    // Route::get('/supervisor/{tp_destino}', 'SupervisorTerritorialController@page')->name('supervisor_rutas');
    Route::post('/supervisor/historial/solicitud', 'SupervisorTerritorialController@getHistorial');

    //Cambiar password
    Route::post('/update/password', 'HomeController@update_pass');    


    // Concejales
    // Route::get('/concejal/{tp_destino}', 'ConcejalController@page')->name('concejal_rutas');
    Route::post('/concejal/solicitud', 'ConcejalController@index');

    // Asignador
    // Route::get('/asignador/{tp_destino}', 'AsignadorController@page')->name('asignador_rutas');
    Route::post('/asignador/solicitud', 'AsignadorController@index');
    Route::post('/solicitud/asignar', 'AsignadorController@asignarSolicitud');

    // Estructura Encuesta
    Route::post('/estructura/encuesta/index', 'EstructuraEncuestaController@index');
    Route::post('/estructura/encuesta/store', 'EstructuraEncuestaController@store');
    Route::post('/estructura/encuesta/update', 'EstructuraEncuestaController@update');
    Route::post('/estructura/encuesta/state', 'EstructuraEncuestaController@state');
    Route::post('/estructura/encuesta/pregunta/generar', 'EstructuraEncuestaController@generarPregunta');
    Route::post('/estructura/encuesta/alternativa/generar', 'EstructuraEncuestaController@generarAlternativa');
    Route::post('/estructura/encuesta/pregunta/update', 'EstructuraEncuestaController@updatePregunta');
    Route::post('/estructura/encuesta/pregunta/state', 'EstructuraEncuestaController@statePregunta');
    Route::post('/estructura/encuesta/pregunta/delete', 'EstructuraEncuestaController@deletePregunta');
    Route::post('/estructura/encuesta/alternativa/update', 'EstructuraEncuestaController@updateAlternativa');
    Route::post('/estructura/encuesta/alternativa/state', 'EstructuraEncuestaController@stateAlternativa');
    Route::post('/estructura/encuesta/alternativa/delete', 'EstructuraEncuestaController@deleteAlternativa');


    // Revisor
    Route::post('/revisor/solicitud/index', 'RevisorController@index');

    // Encuestador
    Route::post('/encuestador/solicitud', 'EncuestadorController@index');
    Route::post('/encuestador/llamados', 'EncuestaController@index');
    Route::post('/encuestador/llamados/vecino', 'EncuestaController@getContactoRealizados');
    Route::get('/listado/encuesta', 'UtilController@listadoEncuesta');
    Route::get('/listado/telefonistas', 'UtilController@listadoTelefonistas');
    Route::post('/encuesta/store', 'EncuestaController@store')->name('encuesta_store');
    Route::post('/encuesta/state', 'EncuestaController@state');
    Route::post('/encuestador/distribucion/ticket', 'UtilController@getDistribucionTicketTelefonista');
    Route::post('/encuestador/encuesta/respuestas', 'EncuestaController@getRespuestas');
    Route::post('/estadistica/encuestador', 'AdministradorController@index_estadistica_telefonista');
    Route::post('/gestion/encuestador', 'EncuestadorController@index_telefonistas');
    Route::post('/encuestador/agendados', 'EncuestadorController@index_agendados');
    Route::post('/encuestador/store', 'EncuestadorController@store');
    Route::post('/encuestador/delete', 'EncuestadorController@delete');
    Route::post('/encuestador/encuesta/capturar', 'EncuestaController@capturarTicket');
    Route::post('/encuestador/encuesta/liberar', 'EncuestaController@liberarTicket');
    Route::post('/encuestador/encuesta/valida', 'EncuestaController@validaCaptutaTicket');
    Route::get('/encuesta/resumen/agendados', 'EncuestaController@resumenAgendados');

    // Telefonista
    Route::post('/telefonista/solicitud/index', 'TelefonistaController@index');
    Route::post('/telefonista/historial/solicitud', 'TelefonistaController@getHistorial');

    //Rutas territorial 2.0
    //Territorial
    // Route::get('territorial/{tp_destino}', 'TerritorialController@index')->name('territorial_rutas');
    Route::post('/solicitud/inicio', 'TerritorialController@indexTerritorial')->name('solicitud_index');
    Route::post('/territorial/solicitud/store', 'GsutSolicitudController@storeSolicitud')->name('solicitud_store');
    Route::post('/feedback/store', 'TerritorialController@feedback_store')->name('feedback_store');


    //Macrozona
    // Route::get('macrozona/{tp_destino}', 'MacroZonaController@index')->name('macro_zona_rutas');
    Route::post('/solicitud/mz/inicio', 'MacroZonaController@indexMacroZona')->name('solicitud_mz_index');
    Route::post('/solicitud/mz/update', 'MacroZonaController@updateSolicitud')->name('solicitud_mz_update');
    Route::post('/macrozona/visacion', 'MacroZonaController@visacion')->name('macrozona_visacion'); 


    //Consulta generica
    Route::post('/historial/solicitud', 'TerritorialController@indexHistoria');
    Route::get('/get/vecino/{nr_rut}', 'GsutVecinoController@getVecino');
    Route::post('/solicitud/derivar', 'GsutSolicitudController@derivarSolicitud');
    Route::get('/listado/roles', 'UtilController@listadoRoles');
    Route::get('/listado/direcciones_municipales', 'UtilController@listadoDireccionesMunicipales');
    Route::post('/listado/deptos_municipales', 'UtilController@listadoDeptosMunicipales');
    Route::post('/listado/funcionario', 'UtilController@listadoFuncionarios');
    Route::post('/listado/asignados', 'AsignadorController@listadoAsignados');
    Route::post('/listado/servicios', 'GsutTipoController@listado');
    Route::get('/listado/cargos', 'UtilController@listadoCargos');
    Route::post('/listado/prioridad', 'GsutPrioridadController@listado');
    Route::get('/listado/macrozona', 'UtilController@listadoMacrozona');
    Route::get('/listar/unidadvecinales', 'GsutSolicitudController@listadoUnidadVecinal');
    Route::post('/listado/unidadvecinal', 'UtilController@listadoUnidadVecinal');
    Route::get('/listado/ticket', 'UtilController@listadoTicket');
    Route::get('/listado/ubicaciones', 'UtilController@listadoUbicaciones');
    Route::get('/listado/personas', 'UtilController@listadoPersonas');
    Route::get('/tipo_ingreso/listado', 'UtilController@listadoTipoIngreso');
    Route::post('/listado/unidadvecinal_por_macrozona', 'UtilController@listadoUnidadVecinalPorMacrozona');
    Route::get('/agrupacion/roles/{nr_user?}', 'UtilController@listarRolesUsuario');
    Route::post('/user/update/rol', 'UserController@updateRol');
    Route::post('/derivar/servicio', 'UtilController@getDerivarServicio');
    Route::get('/contador/solicitudes/pendientes', 'UtilController@getCantidadSolicitudesPendientes');


    //Funcionario
    Route::post('/funcionario/respuesta', 'FuncionarioController@storeRespuesta')->name('funcionario_respuesta');
    // Route::get('funcionario/{destino}', 'FuncionarioController@index')->name('funcionario_rutas');
    Route::post('/solicitud/funcionario/inicio', 'FuncionarioController@indexFuncionario')->name('solicitud_funcionario_index');

    //util
    Route::get('/info/usuario', 'UtilController@getDataUser')->name('get_user');

    // Exportar
    Route::get('/exportar/solicitudes','ExportarController@exportSolicitudes');
    Route::get('/exportar/encuestas','ExportarController@exportSolicitudes');

    Route::post('/dashboard/redes_sociales','DashboardController@index');
    Route::get('/dashboard/redes_sociales','DashboardController@index');

    //Integración GPT
    Route::post('api/gpt/', 'GPTController@store'); 

    //Integracion SOFIA
    Route::get('consulta', 'GPTController@index'); 
    Route::post('consulta', 'GPTController@get_query'); 
    Route::post('/comentario', 'GPTController@setComentario');

    // Base de Conocimiento
    Route::post('/preguntas', 'ConocimientoController@preguntas');
    Route::post('/preguntas/option', 'ConocimientoController@setStatus');
    Route::post('/preguntas/set', 'ConocimientoController@store');

    //Integracion GPT
    Route::post('/asistentes/openai', [App\Http\Controllers\OpenAIController::class, 'get_asistentes_openai'])->name('asistentes.openai');
    Route::get('asistentes/openai', [App\Http\Controllers\AsistentesController::class, 'get_asistentes_user'])->name('asistentes.user');


    Route::post('/consulta/question', [App\Http\Controllers\OpenAIController::class, 'set_query_openai'])->name('query.openai');
    Route::post('/get/chats/openai', [App\Http\Controllers\OpenAIController::class, 'get_chats_open_ai'])->name('chats.index.openai');
    Route::post('/consulta/answer', [App\Http\Controllers\OpenAIController::class, 'get_query_openai'])->name('query.openai');
    Route::post('/delete/thread', [App\Http\Controllers\OpenAIController::class, 'delete_thread'])->name('thread.delete');

    // PDFs
    Route::get('get/pdfs',[App\Http\Controllers\PDFController::class, 'getPDfs'])->name('pdf.get');
    Route::post('/upload/pdf',[App\Http\Controllers\PDFController::class, 'upload'])->name('pdf.upload');
    Route::get('/get/preview',[App\Http\Controllers\PDFController::class, 'getPreview'])->name('pdf.preview');
    Route::post('/consulta/pdf', [App\Http\Controllers\OpenAIController::class, 'get_query_pdf'])->name('query.openai.pdf');
    Route::post('/delete/pdf',[App\Http\Controllers\PDFController::class, 'deletePdf'])->name('pdf.delete');






});

