<!DOCTYPE html>
<html lang="es">
	<head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
		<title>Sistema Atención al Vecino</title>
		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no, minimal-ui">
		<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

		<script src="https://code.jquery.com/jquery-3.5.0.js" ></script>
		<script src="https://cdn.jsdelivr.net/npm/vue@2/dist/vue.js"></script>
		<script src="https://unpkg.com/vue-multiselect@2.1.0"></script>
		<!-- <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script> -->
		<script src="https://cdn.jsdelivr.net/npm/axios@0.26.0/dist/axios.min.js"></script>	
		<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js" integrity="sha512-qTXRIMyZIFb8iQcfjXWCO8+M5Tbc38Qi5WzdPOYZHIlZpzBHG3L3by84BBBOiRGiEb7KKtAOAs5qYdUiZiQNNQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
		
		<script src="<?php echo e(asset('/lib/tinymce/tinymce.min.js')); ?>"></script>
		
		<link rel="stylesheet" href="https://unpkg.com/vue-multiselect@2.1.0/dist/vue-multiselect.min.css">
		<link href="<?php echo e(asset('/css/bootstrap.min.css')); ?>"  rel="stylesheet">
		
		<link href="<?php echo e(asset('/css/icons.min.css')); ?>" rel="stylesheet" type="text/css" >
		<link href="<?php echo e(asset('/css/app.min.css')); ?>"  rel="stylesheet" type="text/css">

		<!-- Global site tag (gtag.js) - Google Analytics -->
		<script async src="https://www.googletagmanager.com/gtag/js?id=G-47G91ZC8L1"></script>
		<script>
		  window.dataLayer = window.dataLayer || [];
		  function gtag(){dataLayer.push(arguments);}
		  gtag('js', new Date());

		  gtag('config', 'G-47G91ZC8L1');
		</script>

		
		<style type="text/css">
			.waves-effect{
				text-decoration: none;
			}
			.sub-menu li a {
				text-decoration: none;
			}
			.modal {
			  position: fixed;
			  top: 0;
			  left: 0;
			  z-index: 1060;
			  display: none;
			  width: 100%;
			  height: 100%;
			  overflow-x: hidden;
			  overflow-y: auto;
			  outline: 0;
			}

			.multiselect--active {
			  	z-index: 10;
			}
		</style>

		<script type="text/javascript">
	        //-----------------------------------------------------------------
	        function activeTinyMCE(str_textarea)
	        {
	            setTimeout(function(){
	            	tinymce.init({
						selector: 'textarea.tinymce',
						entity_encoding:'html',
						language: 'es',
						language_url : '/lib/tinymce/langs/es.js',
						height: 200,
						plugins: 'paste ' + 
								'importcss ' + 
								'autolink ' + 
								'code ' + 
								'pagebreak ' + 
								'nonbreaking ' + 
								'anchor ' + 
								'advlist ' + 
								'lists ' + 
								'noneditable ' + 
								'wordcount ',
						menubar: '',
						toolbar: 'undo redo | ' + 
								'bold italic underline strikethrough | ' + 
								'fontselect fontsizeselect | ' + 
								'alignleft aligncenter alignright alignjustify | ' + 
								'outdent indent | ' + 
								'numlist bullist | ' + 
								'forecolor backcolor removeformat |',
						setup: function(editor) {
							var maxLength = 2000;
							editor.on('init', function(e) {
								console.log('The Editor has initialized.');
							});

							// Agrega un elemento personalizado a la barra de estado para el conteo de caracteres
					        editor.on('init', function() {
					            // Oculta el contador de palabras predeterminado
					            var wordCountEl = editor.getContainer().querySelector('.tox-statusbar__wordcount');
					            if (wordCountEl) {
					                wordCountEl.style.display = 'none';
					            }

					            // Crea y agrega el contador de caracteres personalizado
					            var statusBar = editor.getContainer().querySelector('.tox-statusbar__text-container');
					            if (statusBar) {
					                var charCountElement = document.createElement('div');
					                charCountElement.id = 'custom-character-count';
					                charCountElement.className = 'tox-statusbar__wordcount';
					                charCountElement.textContent = '0 caracteres';
					                statusBar.appendChild(charCountElement);
					            }
					        });

					        // Función para verificar si el contenido excede el límite máximo
						    function isMaxLengthExceeded() {
						        var textLength = editor.getContent({ format: 'text' }).length;
						        return textLength > maxLength;
						    }

						    // Manejador para el evento 'beforeinput'
						    editor.on('beforeinput', function(event) {
						        var textLength = editor.getContent({ format: 'text' }).length;
						        
						        // Permite acciones de edición específicas incluso después de alcanzar el límite
						        if (textLength >= maxLength && !isEditingAction(event.inputType)) {
						            event.preventDefault();
						            return false;
						        }
						    });

						    function isEditingAction(inputType) {
						        // Lista de tipos de entrada permitidos que no agregan caracteres
						        return ['deleteContentBackward', 'deleteContentForward', 'deleteWordBackward', 'deleteWordForward', 'cut'].indexOf(inputType) > -1;
						    }

					        // Función para actualizar el contador de caracteres
					        function updateCharacterCount() {
					            var textLength = editor.getContent({ format: 'text' }).length;
					            var charCountElement = document.getElementById('custom-character-count');
					            if (charCountElement) {
					                charCountElement.textContent = textLength + ' caracteres';
					            }
					        }

					        // Actualiza el contador de caracteres y verifica el límite en cada evento de entrada
					        editor.on('input keyup', function() {
					            updateCharacterCount();
					        });
						}
					});
	            }, 500);
	        }
	        //-----------------------------------------------------------------
	        function activeTextArea(str_textarea)
	        {
	            try{
	                if($('.tinymce'))
	                {
	                    // console.log('existe #'+str_textarea);
	                    // $('#'+str_textarea).attr('disabled',true);
	                    activeTinyMCE();
	                }
	                // else
	                //     console.log('NO existe #'+str_textarea);
	            }catch(error) {
	                // -------------
	            }
	        }
	        //-----------------------------------------------------------------
	    </script>
	</head>		

	<body data-sidebar="dark">
		
		<?php echo $__env->yieldContent('content'); ?>
		
		<script src="https://cdn.jsdelivr.net/npm/vue@2/dist/vue.js"></script>
		<script src="https://unpkg.com/vue-multiselect@2.1.0"></script>
		<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM" crossorigin="anonymous"></script>
		<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js" integrity="sha512-qTXRIMyZIFb8iQcfjXWCO8+M5Tbc38Qi5WzdPOYZHIlZpzBHG3L3by84BBBOiRGiEb7KKtAOAs5qYdUiZiQNNQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>


		<script src="https://cdn.jsdelivr.net/npm/vue@2/dist/vue.js"></script>
		
    	<script src="https://cdn.jsdelivr.net/npm/echarts@5.1.1/dist/echarts.min.js"></script>
    	<script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>

		<script src="<?php echo e(asset('/js/funciones_generales.js')); ?>"></script>
		<script src="https://cdnjs.cloudflare.com/ajax/libs/metisMenu/3.0.7/metisMenu.min.js" integrity="sha512-o36qZrjup13zLM13tqxvZTaXMXs+5i4TL5UWaDCsmbp5qUcijtdCFuW9a/3qnHGfWzFHBAln8ODjf7AnUNebVg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
		<script src="https://cdnjs.cloudflare.com/ajax/libs/simplebar/3.1.0/simplebar.min.js" integrity="sha512-BAuu8EflZpIaGvbVQU/kEAHbiENMFlyewimZOSxV9HPqOCGuifmxxIdpeTNQSZWREeIdFdoAtRGx5yGvTzsjaQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
		<script src="https://cdnjs.cloudflare.com/ajax/libs/node-waves/0.7.6/waves.min.js" integrity="sha512-MzXgHd+o6pUd/tm8ZgPkxya3QUCiHVMQolnY3IZqhsrOWQaBfax600esAw3XbBucYB15hZLOF0sKMHsTPdjLFg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>

		<!-- <script src="{ {asset('js/app_stoke.js')}}"></script> -->
	</body>
</html>
<?php /**PATH D:\wamp64\www\atencion_vecino\resources\views/app_movil/layout_ingreso.blade.php ENDPATH**/ ?>