<?php $__env->startSection('body'); ?>
    <div class="page-content">
        <div class="container-fluid" id="app">
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0 font-size-18">Mis Solicitudes</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Mis Solicitudes</a></li>
                                <li class="breadcrumb-item active">Solicitudes</li>
                            </ol>
                        </div>
                    </div>

                    <!-- Filtros Especificos -->
                    <div class="row mb-3 not-print">
                        <div class="col-lg-3 col-md-6 col-sm-6" style="text-align:left;">
                            <!-- Filtro por Estado -->
                            <div class="row">
                                <div class="col-md-3">
                                    <label class="form-control-label" for="text-input">
                                        Filtro por Estado
                                    </label>
                                </div>
                                <div class="col-md-8">
                                    <select @change="cargarDatos()"  v-model="fl_mostrar" class="form-control estados">
                                        <option v-for="item in arr_mostrar" :value="item.value" v-text="item.label"></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6 col-sm-6" style="text-align: left;">
                            <!-- -->
                        </div>
                        <div class="col-lg-4 col-md-6 col-sm-6" style="text-align:right;">
                            <!-- -->                          
                        </div>
                        <div class="col-lg-2 col-md-6 col-sm-6" style="text-align:right">
                            <button id="btn_actualizar" class="btn btn-primary btn_activo" @click="cargarDatos();">
                                <i class="fas fa-sync"></i> Actualizar
                            </button>
                        </div>                        
                    </div>

                    <!-- Tabla de Datos - Paginacion -->
                    <div class="row">
                        <!-- Tabla de Datos -->
                        <div class="responsive-table">
                            <table  class="table table-bordered border-info table-striped table-sm table-hover bl-1">
                                <thead class="bg-primary">
                                    <th colspan="12" >
                                        <h6 class="text-center" style="color:white" >
                                            Listado de Solicitudes
                                        </h6>
                                    </th>
                                </thead>
                                <thead class="bg-primary"  style="color:white">
                                    <th class="text-center"> # </th>
                                    <th class="text-center">Opciones</th>
                                    <th class="text-center">Ticket</th>
                                    <th class="text-center">Dirección Municipal</th>                                
                                    <th class="text-center">Servicio</th>
                                    <th class="text-center">Macrozona</th>
                                    <th class="text-center">Unidad Vecinal</th>                                
                                    <th class="text-center">Tiempo Tramitado</th>
                                    <th class="text-center">Tiene Publicación Parcial</th>
                                    <th class="text-center">Estado</th>
                                </thead>
                                <tbody>
                                    <template v-if="arr_solicitudes.length">
                                        <tr v-for="(datos, index) in arr_solicitudes" :key="datos.id">
                                            <td style="text-align:center;">
                                                {{ (index + 1) }}
                                            </td>
                                            <td style="text-align:center;">
                                                <template v-if="datos.territorial">
                                                    <!--territorial-->
                                                </template>
                                                <template v-else>
                                                    <button type="button" @click="abrirModal('solicitud', 'historial', datos);"
                                                        class="btn btn-primary btn-sm" 
                                                        :class="{'btn-success':datos.id_estado == 5 || datos.id_estado == 6,
                                                             'btn-info':datos.id_estado == 2 || datos.id_estado == 3 || datos.id_estado == 4,
                                                             'btn-danger':datos.id_estado == 7}"
                                                        title="Ver Solicitud">                                                                  
                                                        <template >
                                                           Ver Detalles y Respuestas
                                                        </template>
                                                    </button>
                                                </template>
                                            </td>
                                             <td style="text-align:center;">
                                                {{ datos.nr_ticket }}
                                            </td>
                                            <td  style="text-align:left; color: black;">
                                                {{ datos.nm_direccion_destino }}
                                            </td>
                                            <td style="text-align:left;">
                                                {{ datos.nm_tipo }}
                                            </td>
                                            <td  style="text-align:center; color: black;">
                                                {{ datos.cod_territorio }}
                                            </td>                                        
                                            <td style="text-align:center;">
                                                {{ datos.nm_unidadvecinal }}
                                            </td>
                                            <td style="text-align:center;">
                                                {{ datos.tiempo_tramitado }}
                                            </td>
                                            <td style="text-align: center;">
                                                {{ datos.tiene_pp }}
                                            </td>
                                            <td style="text-align:center;" :style="{'background-color':datos.nm_color}">
                                                {{ datos.nm_estado }}
                                            </td>
                                        </tr>
                                    </template>
                                    <template v-else>
                                        <tr>
                                            <td colspan="12">
                                                <h5 class="text-center">
                                                    No hay datos para listar
                                                </h5>
                                            </td>
                                        </tr>
                                    </template>
                                </tbody>
                            </table>
                        </div>

                        <!-- Paginacion -->
                        <div class="col-md-12 col-sm-12">
                            <nav>
                                <ul class="pagination">
                                    <li class="page-item" v-if="pagination.current_page > 1">
                                        <a class="page-link" href="#" @click.prevent="cambiarPagina(pagination.current_page - 1)">Ant</a>
                                    </li>
                                    <li class="page-item" v-for="page in pagesNumber" :key="page" :class="[page == isActivedPagination ? 'active' : '']">
                                        <a class="page-link" href="#" @click.prevent="cambiarPagina(page, 1)" v-text="page"></a>
                                    </li>
                                    <li class="page-item" v-if="pagination.current_page < pagination.last_page">
                                        <a class="page-link" href="#" @click.prevent="cambiarPagina(pagination.current_page + 1)">Sig</a>
                                    </li>
                                </ul>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Modal Historial -->
            <div class="modal" tabindex="-1" id="modal_historial">
                <div class="modal-dialog modal-xl">
                    <div class="modal-content">
                        <div class="card-body">
                            <h4 class="card-title mb-5" ></h4>
                            <div class="">
                                <ul class="verti-timeline list-unstyled">
                                    <li class="event-list">
                                        <div class="event-timeline-dot">
                                            <i class="bx bx-right-arrow-circle"></i>
                                        </div>
                                        <div class="d-flex">
                                            <div class="flex-shrink-0 me-3">
                                                <i class="bx bx-copy-alt h2 text-primary"></i>
                                            </div>
                                            <div class="flex-grow-1">
                                                <div>
                                                    <h5 v-text="arr_historial.nm_tipo+' - #'+arr_historial.nr_ticket"></h5>
                                                    <p class="text-muted"> Solicitud Ingresada el dia 
                                                        <span v-text="arr_historial.fc_creacion"></span> a las 
                                                        <span v-text="arr_historial.hr_creacion"></span> asociada al vecino 
                                                        <strong v-text="arr_historial.nm_vecino"></strong>. <br>
                                                        <strong>Descripción : </strong> <span v-html="arr_historial.str_solicitud_html"></span><br>
                                                        <strong>Estado :</strong> <span v-text="arr_historial.nm_estado"></span>
                                                    </p>

                                                    <table class="table-sm table-bordered" v-if="arr_respuestas.length">
                                                        <thead class="bg-primary text-white">
                                                            <th>#</th>
                                                            <th>Tipo Respuesta</th>
                                                            <th>Respuesta</th>
                                                            <th>Fecha Ingreso</th>
                                                            <th>Adjuntos</th>
                                                        </thead>
                                                        <tbody>
                                                        <tr v-for="(nodo,index) in arr_respuestas">
                                                            <td v-text="(index+1)"></td>
                                                            <td v-text="nodo.nm_respuesta"></td>
                                                            <td v-html="nodo.str_observacion_html"></td>
                                                            <td v-text="nodo.fc_ingreso" style="min-width:120px"></td>
                                                            <td style="min-width:120px">
                                                                <a v-for="(file,index) in nodo.archivos" target="_blank" :href="'/files/download?ruta='+file.str_archivo" 
                                                                    class="btn btn-md btn-success btn-sm" style="margin-left: 5px;">
                                                                        <i  class="bx bxs-download"></i>
                                                                </a>
                                                            </td>
                                                        </tr>
                                                        </tbody>
                                                    </table>

                                                    <div v-if="calificacion_vecino.value == 0 && (arr_historial.id_estado_solicitud == 5 || arr_historial.id_estado_solicitud == 6)" class="col-md-12 mt-2">
                                                        <h5>- Califique nuestro Servicio</h5>
                                                        <div class="row">
                                                            <div class="col-xl-3 col-sm-6">
                                                                <div class="form-group">
                                                                    <label>Nivel Satisfación :</label>
                                                                    <select  v-model="tp_satisfaccion" id="tp_satisfaccion">
                                                                        <option v-for=" nodo in arr_satisfaccion" :value="nodo.value" v-text="nodo.label"></option>
                                                                    </select>
                                                                    <p class="text-primary font-weight-bold" v-if="tp_satisfaccion != 0" v-text="nm_satisfaccion"></p>
                                                                    <small class="text-error text-danger" v-if="arr_form.nm_satisfaccion"  v-text="arr_form.nm_satisfaccion"></small>
                                                                </div>
                                                            </div>

                                                            <div class="col-sm-6 col-xl-6">
                                                                <div class="form-group">
                                                                    <label>Comentario (Opcional) : (Quedan <span v-text="(150 - str_feedback.length)"> </span> caracteres.)</label>
                                                                    <input placeholder="Máximo 150 caracteres" maxlength="150" type="text" v-model="str_feedback" class="form-control"> 
                                                                    <p class="text-primary font-weight-bold">Su opinión es importante para nosotros</p>
                                                                    <small class="text-error text-danger" v-if="arr_form.str_feedback"  v-text="arr_form.str_feedback"></small>
                                                                </div>
                                                            </div>

                                                            <div class="col-sm-3">
                                                                <div class="form-group">
                                                                    <label style="visibility:hidden">Guardar</label>
                                                                    <button @click="feedback()" class="btn btn-sm btn-success btn-block form-control"> <i class="bx bx-save"></i> Enviar Calificación </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div v-if="calificacion_vecino.value != 0">
                                                        <p class="mt-3">
                                                            <strong>Calificación Realizada</strong> <br>
                                                            Calificación : <span v-text="calificacion_vecino.label"></span> <br>
                                                            Comentario : <span v-text="arr_historial.str_feedback_vecino"></span>
                                                        </p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" @click="alertCalificacion()">Cerrar</button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Modal Adjunto -->
            <div class="modal" tabindex="-1" id="modal_adjunto">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header bg-primary">
                            <h5 class="modal-title  text-white">Ingresar Adjunto</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <div class="form-group">
                                <label>Seleccione Archivo</label>
                                <input class="form-control" accept=".jpeg,.jpg,.png,.doc,.docx,.xls,.xlsx,.ppt,.pptx,.pdf,.dwg,.dgn,.rar,.zip"
                                    type="file" id="file_adjunto" >
                            </div>
                            <div class="form-group mt-2">
                                <label>Ingresar Descripción</label>
                                <textarea maxlength="200" rows="3" v-model="file_observacion" class="form-control" placeholder="Descripción del archivo"></textarea>
                                <small id="cant_caracteres" class="form-text text-muted" v-text="'Disponible '+(200-file_observacion.trim().length)+' caracteres'" v-if="file_observacion"></small>
                            </div>
                            <template v-if="file_error">
                                <div class="text-center text-error">
                                    <div v-for="error in arr_error" :key="error" v-text="error"></div>
                                </div>
                            </template>
                        </div>
                        <div class="modal-footer">
                            <button @click="cerrarModal('archivo')" type="button" class="btn btn-light">Cerrar</button>
                            <button type="button" class="btn btn-primary" @click="validarAdjunto(tp_adjunto, 'save')">Subir</button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Modal Archivos -->
            <div class="modal" tabindex="-1" id="modal_revisar">
                <div class="modal-dialog modal-lg" style="margin-top: 10%">
                    <div class="modal-content" style="border-color: darkgray;">
                        <div class="modal-header bg-primary">
                            <h5 class="modal-title text-white" style="color: white;">Revisar Archivos</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <table class="table table-bordered table-striped table-sm">
                                <thead>
                                    <tr class="bg-primary">
                                        <th colspan="4" class="text-center" style="color: white;">Archivos Adjuntos</th>    
                                    </tr>
                                    <tr>
                                        <th style="min-width:50px; text-align:center;">#</th>
                                        <th style="min-width:150px; text-align:center;">Nombre</th>
                                        <th style="min-width:300px; text-align:center;">Descripción</th>
                                        <th style="min-width:50px; text-align:center;">Archivo</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <template v-if="arr_adjuntos.length">
                                        <tr v-for="(adjunto, index) in arr_adjuntos" :key="adjunto.id">
                                            <td class="text-center">{{ (index+1) }}</td>
                                            <td class="text-center">{{ adjunto.nm_archivo }}</td>
                                            <td class="text-left">{{ adjunto.str_observacion }}</td>
                                            <td class="text-center">
                                                <a :href="'/files/get?ruta='+adjunto.str_archivo" class="btn btn-primary btn-sm" title="Archivo Adjunto" v-if="adjunto.str_archivo">
                                                    <template v-if="adjunto.ext_archivo == 'pdf'">
                                                        <i class="far fa-file-pdf"></i>
                                                    </template>
                                                    <template v-if="adjunto.ext_archivo == 'doc' || adjunto.ext_archivo == 'docx'">
                                                        <i class="far fa-file-word"></i>
                                                    </template>
                                                    <template v-if="adjunto.ext_archivo == 'ppt' || adjunto.ext_archivo == 'pptx'">
                                                        <i class="far fa-file-powerpoint"></i>
                                                    </template>
                                                    <template v-if="adjunto.ext_archivo == 'xls' || adjunto.ext_archivo == 'xlsx'">
                                                        <i class="far fa-file-excel"></i>
                                                    </template>
                                                    <template v-if="adjunto.ext_archivo == 'rar' || adjunto.ext_archivo == 'zip'">
                                                        <i class="far fa-file-archive"></i>
                                                    </template>
                                                    <template v-if="adjunto.ext_archivo == 'jpeg' || adjunto.ext_archivo == 'jpg' || adjunto.ext_archivo == 'png'">
                                                        <i class="far fa-file-image"></i>
                                                    </template>
                                                    <template v-if="adjunto.ext_archivo == 'dwg' || adjunto.ext_archivo == 'dgn'">
                                                        <i class="far fa-file-code"></i>
                                                    </template>
                                                </a>
                                            </td>
                                        </tr>
                                    </template>
                                    <template v-else>
                                        <td colspan="4">
                                            <div class="empty" style="min-height:100px;" empty-text="No hay archivos para mostrar"></div>
                                        </td>
                                    </template>
                                </tbody>
                            </table>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .upper-text {
            text-align: right;
            font-size: 15px;
        }
    </style>

    <script type="text/javascript">
        Vue.component('vue-multiselect', window.VueMultiselect.default);
        // Vue.component( 'vue-recaptcha', VueRecaptcha );        

        var app = new Vue({
            el: '#app',
            data: {
                //------------------------------
                solicitud_actual            :   0,
                tp_feedback                 :   0,
                tp_satisfaccion             :   0,
                nm_satisfaccion             :   '',
                str_feedback                :   '',
                tp_estado                   :   0,
                //-------------------------------------
                modal_principal             :   0,
                modal_adjunto               :   0,
                accion_principal            :   0,
                accion_adjunto              :   0,
                boton_principal             :   1,
                boton_adjunto               :   0,
                titulo_principal            :   '',
                titulo_adjunto              :   '',
                tp_modal                    :   0,
                //-------------------------------------
                arr_valida                  :   [],
                arr_error                   :   [],
                arr_form                    :   {},
                tp_error                    :   [],
                //-------------------------------------
                pagination                  : {
                    'total' : 0,
                    'current_page' : 0,
                    'per_page' : 0,
                    'last_page' : 0,
                    'from' : 0,
                    'to' : 0,
                },
                //-------------------------------------
                offset                      :   3,
                //-------------------------------------
                keycaptcha                  : '6LemYhgdAAAAAC1vdAlEI1zrad6CnOLilqQITeFm',
                //-------------------------------------
                arr_archivo                 :   [],
                arr_files                   :   [],
                arr_files_obs               :   [],
                file_observacion            :   '',
                tp_adjunto                  :   '',
                file_error                  :   0,
                //-------------------------------------
                str_buscar                  :   '',
                id_solicitud                :   0,
                //-------------------------------------
                info_solicitud              :   [],
                arr_solicitudes             :   [],
                arr_historial               :   [],
                arr_respuestas              :   [],
                arr_adjuntos                :   [],
                //-------------------------------------
                arr_mostrar                 :   [
                    {
                        'value'     :   0,
                        'label'     :   'Todos',
                    },
                    {
                        'value'     :   3,
                        'label'     :   'En Revisión',
                    },
                    {
                        'value'     :   5,
                        'label'     :   'Cerrado',
                    },
                ],
                fl_mostrar                  :   0,
                //------------------------------------
                calificacion_vecino         :   [],
                arr_satisfaccion            :   [
                    {
                        'value' : 5, // 5
                        'label' : 'Nada satisfecho',
                    },
                    {
                        'value' : 4, // 4
                        'label' : 'Poco satisfecho',
                    },
                    {
                        'value' : 3, // 3
                        'label' : 'Normal',
                    },
                    {
                        'value' : 2, // 2
                        'label' : 'Satisfecho',
                    },
                    {
                        'value' : 1, // 1
                        'label' : 'Muy satisfecho',
                    }
                ],
                //------------------------------------
            },

            components: {
                Multiselect: window.VueMultiselect.default
            },

            filters:{
                resumir: function (texto, limite=90, final=' ...')
                {
                    var largo = texto.toString().length;
                    if(largo > limite){
                        for (var i = 0; i < largo; i++) {
                            if(texto[i] == ' ' && i >= limite){
                                texto = texto.substring(0,i);
                                texto = texto + final;
                                return texto;
                            }
                        }                    
                    }
                    return texto;
                },
                formatDate: function (fecha)
                {
                    if(fecha)
                        return moment(String(fecha)).format('DD-MM-YYYY')
                },

                formatDateTime: function (fecha)
                {
                    if(fecha)
                    {
                        return moment(String(fecha)).format('DD-MM-YYYY HH:mm')
                    }
                },
            },

            computed:{
                //-------------------------------------------------------------------------------------------
                isActivedPagination: function()
                {
                    return this.pagination.current_page;
                },
                //-------------------------------------------------------------------------------------------
                pagesNumber: function()
                {
                    if(!this.pagination.to) {
                        return [];
                    }

                    var from = this.pagination.current_page - this.offset;
                    if(from < 1) {
                        from = 1;
                    }

                    var to = from + (this.offset * 2);
                    if(to >= this.pagination.last_page){
                        to = this.pagination.last_page;
                    }

                    var pagesArray = [];
                    while(from <= to) {
                        pagesArray.push(from);
                        from++;
                    }
                    return pagesArray;
                },
                //-------------------------------------------------------------------------------------------
            },

            methods: {
                //-------------------------------------------------------------------------------------------
                cambiarPagina(page)
                {
                    let me  =   this;
                    me.pagination.current_page = page;
                    me.cargarDatos(page);
                },
                //-------------------------------------------------------------------------------------------
                filtrarDatos()
                {
                    let me  =   this;

                    if(me.arr_solicitudes.length)
                        me.cargarDatos();
                },
                //-------------------------------------------------------------------------------------------
                validarDatos(tp_validacion)
                {
                        let me          =   this;
                        var error       =   0;
                        me.str_error    =   '';
                        me.arr_form     =   {};

                        switch(tp_validacion)
                        {
                            case 'feedback':
                            {
                                if(me.tp_satisfaccion == 0)
                                    me.arr_form.nm_satisfaccion     =   'Favor seleccionar nivel';

                                // if(me.str_feedback.trim().length == 0)
                                //     me.arr_form.str_feedback        =   'Favor ingresar comentario';

                                if(Object.keys(me.arr_form).length)
                                    error   =   1;

                                break;
                            }
                        }

                        return error;
                },
                //-------------------------------------------------------------------------------------------
                feedback()
                {
                        let me              =   this;
                        var ruta            =   '';
                        var titulo          =   '';
                        var mensaje         =   '';
                        var tiempo          =   0;
                        var error           =   0;
                        var formData        =   new FormData();
                        //------------------------------------
                        titulo              =   'Registrando Calificación';
                        tiempo              =   3000;                      
                        //------------------------------------
                        ruta    =   '/feedback/publico/store';
                        //------------------------------------
                        error   =   me.validarDatos('feedback');

                        if(error == 1)
                            return;
                        else
                        {
                            //------------------------------------
                            axios.post(ruta,{
                                'nr_id'             : me.id_solicitud,
                                'str_observacion'   : me.str_feedback,
                                'tp_satisfaccion'   : me.tp_satisfaccion,
                            }).then(function (response)
                            {
                                var respuesta           =   response.data;

                                if(respuesta.error == 0)
                                {
                                    me.desplegarVentana(respuesta.tp_icon, respuesta.title, respuesta.msj);
                                    me.str_feedback     =   '';
                                    me.tp_satisfaccion  =   0;
                                    me.tp_feedback      =   1;
                                }

                                me.cargarHistorial(me.id_solicitud);
                                me.cargarDatos(me.pagination.current_page);
                            }).catch(function (error) {
                                console.log(error);
                            });
                            //------------------------------------
                        }                    
                },
                //-------------------------------------------------------------------------------------------
                onSubmit()
                {
                    this.$refs.invisibleRecaptcha.execute()
                },
                //-------------------------------------------------------------------------------------------
                onExpired() 
                {
                    console.log('Captcha Expirado')
                },
                //-------------------------------------------------------------------------------------------
                resetRecaptcha() 
                {
                    this.$refs.recaptcha.reset() // Direct call reset method
                },
                //-------------------------------------------------------------------------------------------
                validarRut()
                {
                    let me          =   this;
                    var valida      =   null;
                    me.arr_form     =   {};

                    valida  =   Rut(me.str_buscar.trim());

                    if(me.str_buscar.trim().length && valida == false)
                        me.arr_form.rut_vecino = 'Rut ingresado no es valido';

                    if(!me.str_buscar.trim().length)
                        me.arr_form.rut_vecino = 'Debe ingresar Rut';
                },
                //-------------------------------------------------------------------------------------------
                getVecino()
                {
                    let me      = this;
                    var ruta    = '/get/vecino/'+me.rut_vecino;

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta           = response.data;
                        var vecino              = respuesta.vecino;
                        var tramites            = respuesta.tramites;

                        if(!vecino)
                            return;

                        if(tramites == 0)
                        {
                            me.nm_vecino                    =   vecino.nm_vecino;
                            me.ap_paterno                   =   vecino.ap_paterno;
                            me.ap_materno                   =   vecino.ap_materno;
                            me.mail_vecino                  =   vecino.nm_mail;
                            me.tp_direccion                 =   vecino.tp_direccion;
                            me.nr_telefono                  =   vecino.nr_telefono.slice(-8);
                            me.pre_fijo                     =   vecino.nr_prefijo;

                            me.arr_ubicacion_vecino         =    
                            {
                                value : vecino.id_ubicacion,
                                label : vecino.nm_ubicacion,
                                nr_calle : vecino.nr_calle,
                                nm_calle : vecino.nm_calle,
                                str_latitud : vecino.str_latitud,
                                str_longitud : vecino.str_longitud,
                                cod_territorial : vecino.cod_macroterritorio,
                                cod_unidadvecinal : vecino.cod_unidadvecinal,
                            }
                        }else
                        {
                            me.nm_vecino                    =   vecino.nm_vecino;
                            me.ap_paterno                   =   vecino.ap_paterno;
                            me.ap_materno                   =   vecino.ap_materno;
                            me.mail_vecino                  =   vecino.correo;
                            me.nr_telefono                  =   vecino.nr_telefono;
                            me.pre_fijo                     =   '+569';
                        }
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                getLabel(data)
                {
                    var valor   =   '';

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.label;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                getValue(data)
                {
                    var valor   =   0;

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.value;
                    }

                    return valor;
                },                
                //-------------------------------------------------------------------------------------------
                cargarDatos(page = 1)
                {
                    let me          =   this;
                    var ruta        =   '/solicitud/vecino/search';
                    var respuesta   =   [];

                    if(Object.keys(me.arr_form).length)
                        return;

                    axios.post(ruta,{
                    'fl_mostrar'        :   me.fl_mostrar,
                    'str_buscar'        :   me.str_buscar,
                    'page'              :   page,
                    }).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_solicitudes  =   respuesta.info.data ;
                        me.pagination       =   respuesta.pagination;
                        me.rows             =   respuesta.info.data;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarHistorial(id_solicitud)
                {
                    let me      = this;
                    var ruta    = '/solicitud/historial/vecino/search';

                    axios.post(ruta,{
                        'id_solicitud'  :   id_solicitud,
                    }).then(function (response) 
                    {
                        var respuesta       =   response.data;
                        me.arr_historial    =   respuesta.arr_historial;
                        me.calificacion_vecino = respuesta.satisfaccion
                        me.arr_respuestas   =   respuesta.arr_respuestas;

                        me.setStyleCalificacion();
                    }).catch(function (error) 
                    {
                        console.log(error)
                    });     
                },
                //-------------------------------------------------------------------------------------------
                cerrarModal(modelo)
                {
                    let me  =   this;

                    switch(modelo)
                    {
                        case 'historial':
                        {
                            $('#modal_historial').modal('hide');
                            me.limpiarDatos(modelo);

                            break;
                        }
                        case 'archivo':
                        {
                            $('#modal_adjunto').modal('hide');
                            me.limpiarDatos(modelo);

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                limpiarDatos(modelo)
                {
                    let me  =   this;

                    switch(modelo)
                    {
                        case 'registrar':
                        {
                            me.arr_error        =   [];
                            me.arr_valida       =   [];
                            me.tp_error         =   [];

                            me.nr_estado        =   [];
                            me.nr_secuencia     =   [];
                            me.nr_prioridad     =   1;
                            me.tp_direccion     =   1;
                            
                            me.nr_dir_municipal =   0;
                            me.rut_vecino       =   '';
                            me.nm_vecino        =   '';
                            me.ap_paterno       =   '';
                            me.ap_materno       =   '';
                            me.nr_telefono      =   '';
                            me.mail_vecino      =   '';
                            me.confirmar_mail_vecino    =   '';
                            me.nm_direccion     =   '';
                            me.nr_direccion     =   '';
                            me.str_aclaratoria_vecino   =   '';
                            me.str_observacion  =   '';
                            me.tp_activo        =   1;
                            me.arr_archivo      =   [];
                            me.solicitud_actual =   [];
                            me.arr_files_obs    =   [];
                            me.arr_files        =   [];
                            me.arr_archivo      =   [];
                            me.nr_tp_direccion_solicitud    =   1;
                            me.nr_tipo          =   null;
                            me.nr_motivo        =   null;
                            me.nr_region        =   null;
                            me.nr_comuna        =   null;
                            me.tp_comuna        =   0;
                            me.arr_direccion_solicitud  =   [];
                            me.arr_ubicacion_vecino     =   [];
                            me.nm_ubicacion_vecino      =   '';

                            break;
                        }
                        case 'archivo':
                        {
                            me.file_observacion =   '';
                            me.arr_error        =   [];
                            me.arr_valida       =   [];
                            me.tp_error         =   0;

                            break;
                        }
                        case 'revisar':
                        {
                            me.arr_adjuntos     =   [];

                            break;
                        }
                        case 'historial':
                        {
                            me.tp_satisfaccion  =   0;
                            me.str_feedback     =   '';
                            // me.tp_feedback      =   0;
                            me.arr_form         =   {};

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                ensamblarDatos(accion,tp_consulta = 0)
                {
                    let me              =   this;
                    var ruta            =   '';
                    var titulo          =   '';
                    var tiempo          =   0;
                    var error           =   0;                    
                    var formData        =   new FormData();
                    var fc_format       =   'YYYY-MM-DD';
                    var dir_vecino      =   '';
                    var dir_solicitud   =   '';
                    var nr_dir_solicitud    =   '';
                    var nr_dir_vecino       =   '';
                    me.tp_error         =   0;
                    me.arr_valida       =   [];
                    me.arr_form        =   {};               
                    titulo              =   'Registrando de Solicitud';
                    tiempo              =   3000;                      
                    //------------------------------------
                    error   =   me.validarDatos('ingresar');

                    if(error == 1)
                    {
                        // Datos del formulario incompletos o no validos
                        return;
                    }
                    else
                    {
                        //-----------------------------------------------------------------------------------
                        ruta    =   '/solicitud/vecino/store';
                        //-----------------------------------------------------------------------------------
                        // Datos de Vecino
                        formData.append('rut_vecino', me.rut_vecino.trim());
                        formData.append('nm_vecino', me.nm_vecino);
                        formData.append('ap_paterno', me.ap_paterno);
                        formData.append('ap_materno', me.ap_materno);
                        formData.append('nm_mail', me.mail_vecino);
                        formData.append('pre_fijo', me.pre_fijo);
                        formData.append('nr_telefono', me.nr_telefono);
                        formData.append('nr_region', me.getValue(me.nr_region));
                        formData.append('nr_comuna', me.getValue(me.nr_comuna));
                        formData.append('tp_comuna', me.tp_comuna);

                        if(me.tp_comuna == 1)
                            formData.append('arr_ubicacion_vecino[]', JSON.stringify(me.arr_ubicacion_vecino));
                        else
                            formData.append('nm_ubicacion_vecino', me.nm_ubicacion_vecino);

                        formData.append('str_aclaratoria_vecino', me.str_aclaratoria_vecino);
                        //-----------------------------------------------------------------------------------
                        // Datos de Solicitud
                        formData.append('nr_motivo', me.getValue(me.nr_motivo));
                        formData.append('nr_tipo', me.getValue(me.nr_tipo));
                        formData.append('nm_tipo', me.getLabel(me.nr_tipo ));
                        formData.append('arr_direccion_solicitud[]', JSON.stringify(me.arr_direccion_solicitud));
                        formData.append('str_aclaratoria_solicitud', me.str_aclaratoria_solicitud);
                        formData.append('str_observacion', me.str_observacion);
                        formData.append('nr_dir_municipal', me.nr_dir_municipal);
                        formData.append('nr_depto', me.nr_depto);
                        //-----------------------------------------------------------------------------------
                        if(me.arr_files.length != 0)
                        {
                            for (var i = 0; i < me.arr_files.length; i++) 
                            {
                                formData.append('arr_archivo[]', me.arr_files[i]);
                            }
                            for (var i = 0; i < me.arr_files_obs.length; i++) 
                            {
                                formData.append('arr_observacion[]', me.arr_files_obs[i]);
                            }
                        }
                        //-----------------------------------------------------------------------------------
                        me.registrarDatos(ruta, formData);
                        //-----------------------------------------------------------------------------------
                    }
                },
                //-------------------------------------------------------------------------------------------
                registrarDatos(ruta, formData)
                {
                    let me              =       this;
                    var tp_icon         =       '';
                    var titulo          =       '';
                    var mensaje         =       '';
                    var error           =       '';
                    me.arr_valida       =       [];
                    me.btn_envio        =        1;

                    axios.post(ruta, formData, {
                        headers: {'Content-Type': 'multipart/form-data'}
                    }).then(function (response) 
                    {
                        var result  =   response.data;
                        tp_icon     =   result.tp_icon;
                        titulo      =   result.title;
                        mensaje     =   result.msj;
                        error       =   result.error;
                        
                        me.desplegarVentana(tp_icon, titulo, mensaje);

                        if(error == 0)
                        {
                            me.limpiarDatos('registrar');
                            me.btn_envio    =   0;                            
                        }                        
                    })
                    .catch(function (error) 
                    {
                        // Faltan campos por llenar
                         me.btn_envio        =        0;
                        if (error.response.status == 422)
                            me.arr_valida = error.response.data.errors;
                        /*// Formato de Archivo Incorrecto
                        if (error.response.status == 413)
                        {
                            //------------------------------
                        }*/
                    });
                },
                //-------------------------------------------------------------------------------------------
                abrirModal(modelo, accion, data = [])
                {
                    let me      =       this;

                    switch(modelo)
                    {
                        case 'solicitud':
                        {
                            switch(accion)
                            {
                                case 'historial':
                                {
                                    me.arr_historial                =   [];
                                    me.info_solicitud               =   [];
                                    me.info_solicitud               =   data;
                                    me.id_solicitud                 =   data.id;
                                    me.tp_feedback                  =   data.tp_feedback_vecino;
                                    me.tp_estado                    =   data.id_estado;
                                    me.cargarHistorial(data.id);
                                    $('#modal_historial').modal('show');

                                    break;
                                }
                            }

                            break;
                        }
                        case 'archivo':
                        {
                            switch(accion)
                            {
                                case 'anexar':
                                {
                                    me.modal_adjunto        =   1;
                                    me.accion_adjunto       =   1;
                                    me.titulo_adjunto       =   'Adjuntar Documentos';
                                    me.tp_adjunto           =   'documento';
                                    me.limpiarDatos(modelo);
                                    $('#modal_adjunto').modal('show');

                                    break;
                                }
                                case 'revisar':
                                {
                                    me.modal_adjunto        =   1;
                                    me.accion_adjunto       =   2;
                                    me.titulo_adjunto       =   'Revisar Documentos';
                                    me.tp_adjunto           =   'archivos';
                                    me.limpiarDatos(modelo);
                                    me.arr_adjuntos         =   data.archivos;
                                    $('#modal_revisar').modal('show');

                                    break;
                                }
                            }

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                desplegarVentana(tp_icon, titulo, mensaje, tp_btn = 1)
                {
                    Swal.fire({
                        type: tp_icon,
                        title: titulo,
                        html: mensaje,
                        backdrop:false,
                        showConfirmButton: tp_btn
                    });
                },
                //-------------------------------------------------------------------------------------------
                alertCalificacion()
                {
                    let me  =   this;

                    if((me.tp_estado != 5 || me.tp_estado != 6) && me.tp_feedback == 1)
                        me.cerrarModal('historial');
                    else if((me.tp_estado == 5 || me.tp_estado == 6) && me.tp_feedback == 0)
                        Swal.fire({
                            title : '¿No ha calificado nuestro servicio, desea salir de todos modos?',
                            type  : 'warning',
                            showCancelButton : true,
                            confirmButtonColor : '#3085d6',
                            cancelButtonColor : '$d33',
                            cancelButtonText : 'NO',
                            confirmButtonText : 'SI',
                            backdrop: false, 
                            allowOutsideClick: false
                        }).then((result) => {
                            console.log(result);
                            if(result.value === true) {
                                console.log(result.value);
                                me.cerrarModal('historial');
                            }
                        });
                    else
                        me.cerrarModal('historial');
                },
                //-------------------------------------------------------------------------------------------
                setStyleCalificacion()
                {
                    let me  =   this;

                    $(function() {
                        $('#tp_satisfaccion').barrating('show', {
                          theme: 'fontawesome-stars',
                          showValues: false,
                          onSelect: function(value, text, event) {
                            if (typeof(event) !== 'undefined') {
                              // rating was selected by a user
                              console.log(event.target);
                              me.tp_satisfaccion    =   value;
                              me.nm_satisfaccion    =   text;
                            } else {
                              // rating was selected programmatically
                              // by calling `set` method
                            }
                          }
                        });
                    });
                },
                //-------------------------------------------------------------------------------------------
            },

            mounted() {
                let me = this;
                me.cargarDatos(1);
            }
        });
    </script>

    <script type="text/javascript">
        //-----------------------------------------------------------------
        $(document).ready(function(){
            $("#rut_vecino").change(function()
            { 
                var nr_rut = $("#rut_vecino").val();
                var salida = Rut(nr_rut);

                if(salida)
                    $("#rut_vecino").val(salida);
            });

            $('#modal_historial').modal({backdrop: 'static', keyboard: false});
        });        
        //-----------------------------------------------------------------
        function justNumbers(e)
        {
            var keynum = window.event ? window.event.keyCode : e.which;
            if (keynum == 8)
                return true;

            return /\d/.test(String.fromCharCode(keynum));
        }
        //-----------------------------------------------------------------
        function Rut(texto)
        { 
            var tmpstr = "";

            for ( i=0; i < texto.length ; i++ )   
                if ( texto.charAt(i) != ' ' && texto.charAt(i) != '.' && texto.charAt(i) != '-' )
                    tmpstr = tmpstr + texto.charAt(i);

            texto = tmpstr; 
            largo = texto.length; 

            if ( largo < 2 ) 
                return false; 

            for (i=0; i < largo ; i++ )    
                if (texto.charAt(i) !="0" && texto.charAt(i) != "1" && texto.charAt(i) !="2" && texto.charAt(i) != "3" && 
                    texto.charAt(i) != "4" && texto.charAt(i) !="5" && texto.charAt(i) != "6" && texto.charAt(i) != "7" && 
                    texto.charAt(i) !="8" && texto.charAt(i) != "9" && texto.charAt(i) !="k" && texto.charAt(i) != "K")   
                    return false;

            var invertido = "";

            for ( i=(largo-1),j=0; i>=0; i--,j++ )    
                invertido = invertido + texto.charAt(i);

            var dtexto = "";  
            dtexto = dtexto + invertido.charAt(0);  
            dtexto = dtexto + '-';  
            cnt = 0;  

            for ( i=1,j=2; i<largo; i++,j++ ) 
            { 
                if ( cnt == 3 )   
                {     
                    dtexto = dtexto + '.';      
                    j++;      
                    dtexto = dtexto + invertido.charAt(i);      
                    cnt = 1;    
                }   
                else    
                {       
                    dtexto = dtexto + invertido.charAt(i);      
                    cnt++;    
                } 
            } 

            invertido = "";

            for ( i=(dtexto.length-1),j=0; i>=0; i--,j++ )    
                invertido = invertido + dtexto.charAt(i);

            if (revisarDigito2(texto))
                return  invertido.toUpperCase();

            return false;
        }
        //-----------------------------------------------------------------
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('atencion_vecino.home_vecino', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\repositorio\atencion_vecino\resources\views/atencion_vecino/bandeja_vecino.blade.php ENDPATH**/ ?>