<?php

namespace App\Http\Controllers\Auth;

use App\User;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Auth\Events\Registered;

use Illuminate\Http\Request;

class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    protected $redirectTo = '/home';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        return Validator::make($data, [
                            'name' => ['required', 'string', 'max:255'],
                            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
                            'password' => ['required', 'string', 'min:6', 'confirmed'],
                            ],
                            [
                            'min'           => 'El :attribute debe ser de al menos :min caracteres.',
                            'confirmed'     => 'La confirmación de :attribute no es correcta.',
                            'email.unique'  => 'El correo electrónico :input ya está registrado en el sistema.',
                            'email.email'   => 'El correo electrónico no tiene el formato correcto.'
                            ]

        );
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\User
     */
    protected function create(array $data)
    {
        return User::create([
            'name' => $data['name'],
            'email' => $data['email'],
            'password' => Hash::make($data['password']),
        ]);
    }

    protected function registered(Request $request, $user)
    {
        if ($request->expectsJson()) {
            $user->generateToken();

            return response()->json(['data' => $user->toArray(), 'error' => []], 201);
        }
    }
    /*
    vendor\laravel\framework\src\Illuminate\Foundation\Auth\RegistersUsers.php
    protected function registered(Request $request, $user)
    {
        //
    }
    */
    /*
    $request->expectsJson() necesita en el app la cabecera Accept:application/json
    */

    public function register(Request $request)
    {
        $validacion = $this->validator($request->all());
        //$validacion->validate();

        if($validacion->fails()){
            
            if ($request->expectsJson()) {
                return response()->json(['data' => [], 'error' => $validacion->errors()], 201);
            }else{
                return redirect()->back()->withErrors($validacion)->withInput($request->all());;
             }

        }



        $user = $this->create($request->all());


        event(new Registered($user));

        $this->guard()->login($user);

        return $this->registered($request, $user)
                        ?: redirect($this->redirectPath());
    }

    /*
    vendor\laravel\framework\src\Illuminate\Foundation\Auth\RegistersUsers.php
    public function register(Request $request)
    {
        $this->validator($request->all())->validate();

        event(new Registered($user = $this->create($request->all())));

        $this->guard()->login($user);

        return $this->registered($request, $user)
                        ?: redirect($this->redirectPath());
    }
    
    */
}
