<?php

namespace App\Http\Controllers;
use Auth;
use App\BaseConocimiento;

use Illuminate\Http\Request;

use App\Http\Controllers\UtilController;
use App\Http\Controllers\GPTController;


class ConocimientoController extends Controller
{

    #faltante
    public function setStatus(Request $request)
    {
        $nr_depto           = Auth::user()->id_depto;
        $id                 = $request->id;
        $tp_status          = $request->tp_status;
        $util               = new UtilController();

        $endpoint           = env('ENDPOINT_OPENAI').'/protected/conocimiento/update/status';
        $token              = env('BEARER_TOKEN');

        $form_parms         = [
            'id'                    => $id, 
            'tp_status'             => $tp_status,
        ];

        $res = $util->PeticionHttp($token,'POST',$endpoint,$form_parms);
        $json   = json_decode($res, true);
        
        return ['msj' => 'Pregunta actualizada correctamente','error'=>0,'color' => 'success'];
    }

    

    public function store(Request $request)
    {
        $pregunta           = $request->pregunta;
        $respuesta          = $request->respuesta;
        $id                 = $request->id;
        $tp_nueva_pregunta  = $request->tp_nueva_pregunta;
        $tp_activo          = $request->tp_activo?:1;
        //Sesion
        $id_depto           = Auth::user()->id_depto;
        $id_direccion       = Auth::user()->id_direccion;

        $util               = new UtilController();

        // Conexion a FastApi
        $endpoint           = env('ENDPOINT_OPENAI').'/protected/conocimiento/update';
        $token              = env('BEARER_TOKEN');

        $form_parms         = [
                                'id'                    => $id, 
                                'pregunta'              => $pregunta,
                                'respuesta'             => $respuesta,
                                'id_depto'              => $id_depto,
                                'id_direccion'          => $id_direccion,
                                'tp_activo'             => $tp_activo,
                            ];

        if($tp_nueva_pregunta == 1)
        {
            $endpoint           = env('ENDPOINT_OPENAI').'/protected/conocimiento/create';
            $form_parms         = [
                                    'pregunta'              => $pregunta,
                                    'respuesta'             => $respuesta,
                                    'id_depto'              => $id_depto,
                                    'id_direccion'          => $id_direccion,
                                    'tp_activo'             => $tp_activo,
                                ];
        }
        $res = $util->PeticionHttp($token,'POST',$endpoint,$form_parms);
        $json   = json_decode($res, true);

        return $json;
    }

    public function index()
    {
        $name       = Auth::user()->name;
        return view('conocimiento.conocimiento')->with('name', $name);
    }

    public function preguntas(Request $request)
    {
        // CONSIDERAR OBSOLETOS
        // CONSIDERAR BUSQUEDA TEXTO
        //$search                     = $request->search;
        //$filtro_search              = $request->filtro_search;

        $endpoint           = env('ENDPOINT_OPENAI').'/protected/conocimiento/get';
        $token              = env('BEARER_TOKEN');
        $id_depto           = Auth::user()->id_depto;
        $id_direccion       = Auth::user()->id_direccion;
        $util               = new UtilController();
        
        $pagina             = $request->pagina;
        $tp_activo          = $request->filtro_search;
        $search_pregunta    = $request->search_pregunta;

        $form_parms         =   [
                                    'id_depto'         => $id_depto,
                                    'id_direccion'     => $id_direccion,
                                    'pagina'           => $pagina,
                                    'tp_activo'        => $tp_activo,         
                                    'search_pregunta'  => $search_pregunta,         
                                ];
        
        $res = $util->PeticionHttp($token,'POST',$endpoint,$form_parms);                       
        $json   = json_decode($res, true);

        return $json; 
    }
}
