<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Solicitud;
use DB;
use Validator;
use Freshwork\ChileanBundle\Rut;
use Illuminate\Support\Facades\Auth;
use App\Prioridad;
use App\Vecino;
use App\Direccion;
use App\UnidadVecinal;
use App\Http\Requests\SolicitudRequest;
use Illuminate\Support\Carbon;
use Illuminate\Support\Str;

//Controladores
use App\Http\Controllers\GsutTipoController;
use App\Http\Controllers\GsutPrioridadController;
use App\Http\Controllers\EmailController;
use App\Http\Controllers\MaestroDireccionesController;
use App\Http\Controllers\DireccionMunicipalController;
use App\Http\Controllers\UtilController;
use App\Http\Controllers\GsutFlujoController;
use App\Http\Controllers\GsutMotivoController;

class GsutSolicitudController extends Controller
{    
    //------------------------------------------------------------
    public function defaultData()
    {
        $tipos          =   GsutTipoController::listadoServicios();
        $calles         =   MaestroDireccionesController::indexCalles();
        $prioridad      =   GsutPrioridadController::listado();
        $motivo         =   GsutMotivoController::listado();
        $ubicaciones    =   $this->getUbicacionesSolicitudes();
        $direcciones    =   DireccionMunicipalController::listadoDireccionMunicipal();
        $unidadvecinal  =   $this->listadoUnidadVecinal();
        $vecinos        =   $this->listadoVecinos();
        $ticket         =   $this->listadoTicket();
        $user           =   UtilController::getDataUser();

        return [
            'arr_tipos'         =>  $tipos['servicios'],
            'arr_prioridad'     =>  $prioridad,
            'arr_motivo'        =>  $motivo,
            'arr_direcciones'   =>  $direcciones,
            'arr_ubicaciones'   =>  $ubicaciones,
            'arr_unidadvecinal' =>  $unidadvecinal,
            'arr_vecinos'       =>  $vecinos,
            'arr_ticket'        =>  $ticket,
            'calles'            =>  $calles,
            'user'              =>  $user, 
            'nr_propias'        => UtilController::ContadorSolicitudes(0),
            'nr_bandeja'        => UtilController::ContadorSolicitudes(1),
        ];
    }
    //------------------------------------------------------------
	public function getSolicitud(Request $request)
    {
        $id_solicitud  = $request->id_solicitud;

        $sol           = Solicitud::where('id','=',$id_solicitud)
                                        ->with('archivos')
                                        ->get();

        return ['solicitud'=> $sol];
    }
    //------------------------------------------------------------
    public function page()
    {
        $prioridades = Prioridad::all();

        return view('opciones.administrador.solicitud.solicitud.index')->with('prioridades',$prioridades);
    }
    //------------------------------------------------------------
    public function index(Request $request)
    {
        
    }
    //------------------------------------------------------------
    public function anular(Request $request)
    {
        $valida     =   $this->existeRegistro($request->nr_solicitud);

        if($valida['error'] == 1)
            return $valida;
        else
            return $this->anularRegistro($request);
    }
    //------------------------------------------------------------
    public function existeRegistro($nr_id)
    {
        $data       =   [];
        $valida     =   [];
        $existe     =   0;

        try {
            $data   =   Solicitud::
                        select(DB::raw('(case when count(id) != 0 then 1 else 0 end) as existe'))
                        ->where('id','=',$nr_id)
                        ->get();

            if($data->count())
            {
                $existe     =   $data->first()->existe;
                $msj        =   ($existe == 1) ? 'La solicitud se encuentra registrada' :
                                                 'La solicitud NO se encuentra registrada';
                $valida     =   array_merge($valida, [
                                    'error'     =>  0,
                                    'existe'    =>  $existe,
                                    'tp_icon'   =>  'info',
                                    'title'     =>  'Valida Solicitud',
                                    'msj'       =>  $msj
                                ]);
            }
        } catch (Exception $e) {
            $valida     =   array_merge($valida, [
                                'error'     =>  1,
                                'existe'    =>  0,
                                'tp_icon'   =>  'error',
                                'title'     =>  'Valida Solicitud',
                                'msj'       =>  'Ha ocurrido un error al validar el registro'
                            ]);
        }

        return $valida;
    }
    //------------------------------------------------------------
    public function storeSolicitud(SolicitudRequest $request)
    {
        $valida             =   [];
        $id_rol             =   0;
        $nr_id              =   0;
        $historia           =   0;
        $key_uuid           =   $request->key_uuid;
        $tp_ingreso         =   $request->tp_ingreso; // ingreso por formulario
        $tp_vecino          =   $request->tp_vecino?:0;
        $tp_consulta        =   $request->tp_consulta;
        $id_estado          =   $request->id_estado;
        $id_consulta        =   $request->id_consulta;
        $tp_municipal       =   $request->tp_municipal;
        $id_municipio       =   Auth::user()->id_municipio;
        $id_direccion       =   Auth::user()->id_direccion;
        $id_depto           =   Auth::user()->id_depto;
        $tp_user            =   Auth::user()->tp_user_territorial;
        $nr_anio            =   Date('Y');
        $nr_mes             =   Date('m');
        $nr_dia             =   Date('d');
        $fc_actual          =   Date("Y-m-d H:i:s");
        $nr_folio           =   1;
        $nr_ticket          =   '';
        $nr_tipo            =   $request->nr_tipo;
        $nm_tipo            =   $request->nm_tipo;
        $nr_prioridad       =   $request->nr_prioridad;
        $nr_motivo          =   $request->nr_motivo;
        $nr_dir_destino     =   $request->nr_dir_municipal;
        $nr_depto_destino   =   $request->nr_depto;
        $tp_ubicacion       =   $request->tp_ubicacion;
        $tp_direccion       =   1; // frente
        $arr_dir_solicitud  =   null;
        $obj_dir_solicitud  =   null;
        $str_observacion    =   $request->str_observacion;
        $str_html           =   $request->str_observacion_html;
        $str_aclaratoria_solicitud    =   $request->str_aclaratoria_solicitud;
        $id_autor           =   ($tp_consulta == 0) ? Auth::user()->id : $request->nr_id_autor;
        $tp_visado_jmt      =   0;
        $tp_rechazado       =   0;
        $tp_activo          =   1; // Activo 
        $msj                =   '';
        $rut_municipal      =   '69070400-5';
        $rut_vecino         =   '69070400-5';
        $arr_valida         =   [
            'error'     =>  0,
            'existe'    =>  1,
            'tp_icon'   =>  'success',
            'title'     =>  'Registro de Solicitud',
            'msj'       =>  '',
        ];
        //-------------------------------------------------------------------------
        // dd(['request'=>$request->all()]);
        //-------------------------------------------------------------------------
        \Log::debug(__METHOD__ . " Ingreso Solicitud : " . print_r($request->all(), true));
        //-------------------------------------------------------------------------
        try {
            if($tp_vecino == 1)
                $rut_vecino     =   Rut::parse($request->rut_vecino)->format(Rut::FORMAT_WITH_DASH);
            //-------------------------------------------------------------------------
            if($tp_ubicacion  == 1)
            {
                $arr_dir_solicitud  =   json_decode($request->arr_direccion_solicitud[0]);

                $obj_dir_solicitud  =   [
                    'value'                 =>  $arr_dir_solicitud->value,
                    'label'                 =>  $arr_dir_solicitud->label,
                    'nr_calle'              =>  $arr_dir_solicitud->nr_calle,
                    'nm_calle'              =>  $arr_dir_solicitud->nm_calle,
                    'str_latitud'           =>  $arr_dir_solicitud->str_latitud,
                    'str_longitud'          =>  $arr_dir_solicitud->str_longitud,
                    'cod_territorial'       =>  $arr_dir_solicitud->cod_territorial,
                    'id_macroterritorio'    =>  UtilController::getIdMacroTerritorio($arr_dir_solicitud->cod_territorial),
                    'cod_unidadvecinal'     =>  $arr_dir_solicitud->cod_unidadvecinal,
                    'id_unidadvecinal'      =>  UtilController::getIdUnidadVecinal($arr_dir_solicitud->cod_unidadvecinal),
                ];
            }
            else 
            {
                $arr_dir_solicitud  =   UtilController::getUbicacionDeptoMunicipal($nr_depto_destino);

                $obj_dir_solicitud  =   [
                    'value'                 =>  $arr_dir_solicitud->value,
                    'label'                 =>  $arr_dir_solicitud->label,
                    'nr_calle'              =>  $arr_dir_solicitud->nr_calle,
                    'nm_calle'              =>  $arr_dir_solicitud->nm_calle,
                    'str_latitud'           =>  $arr_dir_solicitud->str_latitud,
                    'str_longitud'          =>  $arr_dir_solicitud->str_longitud,
                    'cod_territorial'       =>  $arr_dir_solicitud->cod_territorial,
                    'id_macroterritorio'    =>  UtilController::getIdMacroTerritorio($arr_dir_solicitud->cod_territorial),
                    'cod_unidadvecinal'     =>  $arr_dir_solicitud->cod_unidadvecinal,
                    'id_unidadvecinal'      =>  UtilController::getIdUnidadVecinal($arr_dir_solicitud->cod_unidadvecinal),
                ];
            }                
            //-------------------------------------------------------------------------
            $nr_folio           =   $this->generarNumeroFolio($nr_anio);
            $nr_ticket          =   $this->generarNumeroTicket($nr_anio, $nr_folio);
            $arr_archivo        =   $request->arr_archivo;
            $arr_observacion    =   $request->arr_observacion;
            $request['tp_comuna']   =   1;

            $info   =   [
                            'key_uuid'              =>  $key_uuid,                                          // form
                            'nr_anio'               =>  $nr_anio,                                           // interno
                            'nr_mes'                =>  $nr_mes,                                            // interno
                            'nr_dia'                =>  $nr_dia,                                            // interno
                            'nr_folio'              =>  $nr_folio,                                          // interno
                            'nr_ticket'             =>  $nr_ticket,                                         // interno
                            'id_municipio'          =>  $id_municipio,                                      // interno
                            'id_direccion'          =>  $id_direccion,                                      // interno
                            'id_depto'              =>  $id_depto,                                          // interno
                            'id_motivo'             =>  $nr_motivo,                                         // form
                            'id_tipo'               =>  $nr_tipo,                                           // form 
                            'nm_tipo'               =>  $nm_tipo,                                           // form
                            'id_prioridad'          =>  $nr_prioridad,                                      // form
                            'id_direccion_destino'  =>  $nr_dir_destino,                                    // form 
                            'id_depto_destino'      =>  $nr_depto_destino,                                  // form 
                            'id_ubicacion'          =>  $obj_dir_solicitud['value'],                        // form 
                            'id_macroterritorio'    =>  $obj_dir_solicitud['id_macroterritorio'],           // form 
                            'id_unidadvecinal'      =>  $obj_dir_solicitud['id_unidadvecinal'],             // form                         
                            'nr_direccion'          =>  $obj_dir_solicitud['nr_calle'],                     // form 
                            'nm_direccion'          =>  strtoupper(trim($obj_dir_solicitud['nm_calle'])),   // form 
                            'nm_ubicacion'          =>  strtoupper(trim($obj_dir_solicitud['label'])),      // form 
                            'str_latitud'           =>  $obj_dir_solicitud['str_latitud'],                  // form 
                            'str_longitud'          =>  $obj_dir_solicitud['str_longitud'],                 // form 
                            'tp_direccion'          =>  $tp_direccion,                                      // form 
                            'nr_rut_vecino'         =>  $rut_vecino,                                        // form 
                            'str_observacion'       =>  strtoupper(trim($str_observacion)),                 // form 
                            'str_observacion_html'  =>  trim($str_html),                                    // form 
                            'str_aclaratoria'       =>  strtoupper(trim($str_aclaratoria_solicitud)),       // form 
                            'fc_creacion'           =>  $fc_actual,                                         // interno
                            'tp_visado_mt'          =>  $tp_visado_jmt,                                     // interno
                            'tp_rechazado'          =>  $tp_rechazado,                                      // interno
                            'id_estado'             =>  $id_estado,                                         // interno
                            'contexto_municipal'    =>  $tp_municipal,                                      // form 
                            'tp_ingreso'            =>  $tp_ingreso,                                        // interno
                            'id_autor'              =>  $id_autor,                                          // interno
                            'id_rol'                =>  $id_rol,                                            // interno
                            'tp_activo'             =>  $tp_activo,                                         // Interno
                            'tp_vecino'             =>  $tp_vecino,                                         // Interno
                        ];

            $model  =   Solicitud::create($info);
            $nr_id  =   $model->id;
            $msj    =   'Se ha registrado la solicitud correctamente con el número de ticket <strong>#'.$nr_ticket .'</strong>'.
                        '<br> <center><i>Favor tomar nota del número de ticket</i></center>';

            // Carga de archivo
            ArchivosController::registrarArchivo('tb_solicitud', $nr_id, $arr_archivo, $arr_observacion);

            if($nr_id && $tp_vecino == 1)
                $valida        =   $this->registrarVecino($request);

            GsutFlujoController::ingresoSolicitud($nr_id,$nr_tipo,$tp_ingreso);

            if($rut_municipal != $rut_vecino)
                EmailController::enviarNotificacionVecino(101, $nr_id, ''); // 101. Notificación de ingreso solicitud al vecino 

            EmailController::enviarNotificaciones(50, $nr_id); // 50. Notificación de ingreso de solicitud a administrador de Atención al Vecino

            $arr_valida         =   [
                'error'     =>  0,
                'existe'    =>  1,
                'tp_icon'   =>  'success',
                'title'     =>  'Registro de Solicitud',
                'msj'       =>  $msj
            ];
        } catch (Exception $e) {
            $arr_valida         =   [
                'error'     =>  1,
                'existe'    =>  0,
                'tp_icon'   =>  'danger',
                'title'     =>  'Registro de Solicitud',
                'msj'       =>  'Ha ocurrido un problema al registrar la solicitud'
            ];
        }

        return $arr_valida;
    }
    //------------------------------------------------------------
    public function derivarSolicitud(Request $request)
    {
        $nr_solicitud   =   $request->nr_solicitud;
        $nr_servicio    =   $request->nr_servicio;
        $nm_servicio    =   $request->nm_servicio;
        $nr_direccion   =   $request->nr_direccion;
        $nr_depto       =   $request->nr_depto;
        $str_derivar    =   $request->str_derivar;
        $str_html       =   $request->str_derivar_html;
        $tp_ingreso     =   $request->tp_ingreso;
        $nr_ticket      =   '';
        $msj            =   '';
        $valida         =   [
                                'error'     =>  0,
                                'existe'    =>  0,
                                'tp_icon'   =>  'success',
                                'title'     =>  'Derivar Solicitud',
                                'msj'       =>  ''
                            ];

        try {
            $existe      =   Solicitud::where('id','=',$nr_solicitud)->count();

            if($existe) // Existe Solicitud
            {
                Solicitud::
                where('id','=',$nr_solicitud)
                ->update([
                    'id_tipo'               =>  $nr_servicio,
                    'nm_tipo'               =>  $nm_servicio,
                    'id_direccion_destino'  =>  $nr_direccion,
                    'id_depto_destino'      =>  $nr_depto,
                ]);

                GsutFlujoController::derivarSolicitud($nr_solicitud, $nr_servicio, $tp_ingreso, $str_derivar, $str_html);

                $msj    =   'Se ha realizado la derivación de la solicitud';

                $valida =   [
                                'error'     =>  0,
                                'existe'    =>  0,
                                'tp_icon'   =>  'success',
                                'title'     =>  'Derivar Solicitud',
                                'msj'       =>  $msj
                            ];
            }
            else
            {
                $msj    =   'La solicitud no se encuentra disponible en nuestros registros';

                $valida =   [
                                'error'     =>  1,
                                'existe'    =>  0,
                                'tp_icon'   =>  'warning',
                                'title'     =>  'Derivar Solicitud',
                                'msj'       =>  $msj
                            ];
            }
        } catch (Exception $e) {
            $valida         =   [
                                'error'     =>  1,
                                'existe'    =>  0,
                                'tp_icon'   =>  'danger',
                                'title'     =>  'Derivar Solicitud',
                                'msj'       =>  'Ha ocurrido un problema al realizar la derivación'
                            ];
        }
            

        return $valida;
    }
    //------------------------------------------------------------
    public function clonarSolicitud(Request $request)
    {
        $nr_solicitud   =   $request->nr_solicitud;
        $nr_servicio    =   $request->nr_servicio;
        $nm_servicio    =   $request->nm_servicio;
        $nr_direccion   =   $request->nr_direccion;
        $nr_depto       =   $request->nr_depto;
        $tp_ingreso     =   $request->tp_ingreso;
        $str_clonado    =   $request->str_clonacion;
        $str_html       =   $request->str_clonacion_html;
        $nr_ticket      =   '';
        $msj            =   '';
        $valida         =   [
                                'error'     =>  0,
                                'existe'    =>  0,
                                'tp_icon'   =>  'success',
                                'title'     =>  'Clonar Solicitud',
                                'msj'       =>  ''
                            ];
        //----------------------------------------------------------------
        // dd(['request' => $request->all()]);
        //----------------------------------------------------------------
        try {
            $data       =   Solicitud::where('id','=',$nr_solicitud)->get();

            if($data->count()) // Existe Solicitud
            {
                $key_uuid           =   Str::uuid();
                $solicitud          =   $data->first();
                $nr_autor           =   Auth::user()->id;
                $nr_rol             =   Auth::user()->id_rol;
                $nr_anio            =   Date('Y');
                $nr_mes             =   Date('m');
                $nr_dia             =   Date('d');
                $fc_actual          =   Date("Y-m-d H:i:s");
                $tp_visado_jmt      =   0;
                $tp_rechazado       =   0;
                $nr_estado          =   1;
                $tp_clonado         =   1;
                $tp_activo          =   1; // Activo 
                $nr_folio           =   $this->generarNumeroFolio($nr_anio);
                $nr_ticket          =   $this->generarNumeroTicket($nr_anio, $nr_folio);

                $info   =   [
                    'key_uuid'              =>  $key_uuid,                                      // interno
                    'nr_anio'               =>  $nr_anio,                                       // interno
                    'nr_mes'                =>  $nr_mes,                                        // interno
                    'nr_dia'                =>  $nr_dia,                                        // interno
                    'nr_folio'              =>  $nr_folio,                                      // interno
                    'nr_ticket'             =>  $nr_ticket,                                     // interno
                    'id_municipio'          =>  $solicitud->id_municipio,                       // interno
                    'id_direccion'          =>  $solicitud->id_direccion,                       // interno
                    'id_depto'              =>  $solicitud->id_depto,                           // interno
                    'id_motivo'             =>  $solicitud->id_motivo,                          // interno
                    'id_tipo'               =>  $nr_servicio,                                   // Form 
                    'nm_tipo'               =>  $nm_servicio,                                   // Form
                    'id_prioridad'          =>  $solicitud->id_prioridad,                       // interno
                    'id_direccion_destino'  =>  $nr_direccion,                                  // Form
                    'id_depto_destino'      =>  $nr_depto,                                      // Form
                    'id_ubicacion'          =>  $solicitud->id_ubicacion,                       // interno
                    'id_macroterritorio'    =>  $solicitud->id_macroterritorio,                 // interno
                    'id_unidadvecinal'      =>  $solicitud->id_unidadvecinal,                   // interno
                    'nr_direccion'          =>  $solicitud->nr_direccion,                       // interno  
                    'nm_direccion'          =>  $solicitud->nm_direccion,                       // Interno
                    'nm_ubicacion'          =>  $solicitud->nm_ubicacion,                       // Interno
                    'str_latitud'           =>  $solicitud->str_latitud,                        // Interno
                    'str_longitud'          =>  $solicitud->str_longitud,                       // Interno
                    'tp_direccion'          =>  $solicitud->tp_direccion,                       // Interno
                    'nr_rut_vecino'         =>  $solicitud->nr_rut_vecino,                      // Interno
                    'str_observacion'       =>  $solicitud->str_observacion,                    // Interno
                    'str_observacion_html'  =>  $solicitud->str_observacion_html,               // Interno
                    'str_aclaratoria'       =>  $solicitud->str_aclaratoria,                    // Interno
                    'fc_creacion'           =>  $fc_actual,                                     // Interno
                    'tp_clonado'            =>  $tp_clonado,                                    // Interno
                    'str_clonado'           =>  $str_clonado,                                   // Form
                    'str_clonado_html'      =>  $str_html,                                      // Form
                    'nr_fuente'             =>  $nr_solicitud,                                  // Form
                    'tp_visado_mt'          =>  $tp_visado_jmt,                                 // Interno
                    'tp_rechazado'          =>  $tp_rechazado,                                  // Interno
                    'id_estado'             =>  $nr_estado,                                     // Interno
                    'contexto_municipal'    =>  $solicitud->contexto_municipal,                 // Interno
                    'tp_ingreso'            =>  $tp_ingreso,                                    // Form
                    'id_autor'              =>  $nr_autor,                                      // Interno
                    'id_rol'                =>  $nr_rol,                                        // Interno
                    'tp_activo'             =>  $tp_activo,                                     // Interno   
                    'tp_vecino'             =>  $solicitud->tp_vecino,                          // Interno
                ];

                $model  =   Solicitud::create($info);
                $nr_id  =   $model->id;
                $msj    =   'Se ha registrado la solicitud correctamente con el número de ticket <strong>#'.$nr_ticket .'</strong>'.
                            '<br> <center><i>Favor tomar nota del numero de ticket</i></center>';

                GsutFlujoController::ingresoSolicitud($nr_id, $nr_servicio, $tp_ingreso);

                // Replicar Archivo adjunto de Solicitud replicarAdjunto($nr_id_old, $nr_id_new, $tp_tabla = 'tb_solicitud')
                UtilController::replicarAdjunto($nr_solicitud, $nr_id, 'tb_solicitud');

                EmailController::enviarNotificaciones(50, $nr_id); // 50. Notificación de ingreso de solicitud a administrador de Atención al Vecino

                $valida =   [
                                'error'     =>  0,
                                'existe'    =>  1,
                                'tp_icon'   =>  'success',
                                'title'     =>  'Clonar Solicitud',
                                'msj'       =>  $msj
                            ];
            }
            else
            {
                $msj    =   'La solicitud no se encuentra disponible en nuestros registros';

                $valida =   [
                                'error'     =>  1,
                                'existe'    =>  0,
                                'tp_icon'   =>  'warning',
                                'title'     =>  'Clonar Solicitud',
                                'msj'       =>  $msj
                            ];
            }
        } catch (Exception $e) {
            $valida         =   [
                                'error'     =>  1,
                                'existe'    =>  0,
                                'tp_icon'   =>  'danger',
                                'title'     =>  'Clonar Solicitud',
                                'msj'       =>  'Ha ocurrido un problema al realizar la derivación'
                            ];
        }

        return $valida;
    }
    //------------------------------------------------------------
    private function anularRegistro(Request $request)
    {
        $solicitud          =   null;
        $nr_servicio        =   0;
        $nr_solicitud       =   $request->nr_solicitud;
        $nr_ticket          =   $request->nr_ticket;
        $str_anular         =   $request->str_anular;
        $str_html           =   $request->str_anular_html;
        $fc_fecha           =   Date('Y-m-d');
        $nr_estado          =   7;
        $valida             =   [];
        $title              =   '';
        $msj                =   '';

        try {
            $solicitud      =   UtilController::getDataSolicitud($nr_solicitud);
            $nr_servicio    =   $solicitud->id_tipo;
            $title          =   'Anular Solicitud';
            $msj            =   'Se ha anulado la solicitud #'.$nr_ticket;

            Solicitud::
            where('id','=',$nr_solicitud)
            ->update([
                'tp_rechazado'  =>  1,
                'str_rechazado' =>  $str_anular,
                'id_estado'     =>  $nr_estado
            ]);

            GsutHistoriaController::registrarHistoria($nr_solicitud, $nr_servicio, $str_anular, $str_html, $nr_estado, $fc_fecha, $fc_fecha); 

            EmailController::enviarNotificacionVecino(105, $nr_solicitud, $str_anular); // 105. Notificación de anulación de solicitud

            $valida =   array_merge($valida, [
                            'error'     =>  0,
                            'existe'    =>  1,
                            'tp_icon'   =>  'success',
                            'title'     =>  $title,
                            'msj'       =>  $msj
                        ]);
        } catch (Exception $e) {
            $valida =   array_merge($valida, [
                            'error'     =>  1,
                            'existe'    =>  0,
                            'tp_icon'   =>  'error',
                            'title'     =>  $title,
                            'msj'       =>  'ha ocurrido un error en el proceso de "'. $title .'"'
                        ]);
        }

        return $valida;
    }
    //------------------------------------------------------------
    public function existeVecino($nr_rut)
    {
        // valida si existe vecino
       return Vecino::where('nr_rut','=',$nr_rut)->count();
    }
    //------------------------------------------------------------
    public function registrarVecino(Request $request)
    {
        // registra vecino
        return GsutVecinoController::setRegistrarVecino($request);
    }
    //------------------------------------------------------------
    public function getUbicacionesSolicitudes()
    {
        $data   =   Solicitud::
                    select('id_ubicacion as value','nm_ubicacion as label')
                    ->groupBy('id_ubicacion')->get();

        return $data;
    }
    //------------------------------------------------------------
    public function generarNumeroFolio($nr_anio)
    {
        $nr_folio   =   1;

        try {
            $data   =   Solicitud::
                        select('nr_folio')
                        ->where('nr_anio','=',$nr_anio)
                        ->orderBy('nr_folio','DESC')
                        ->get()->take(1);

            if($data->count())
                $nr_folio   =   $data->first()->nr_folio + 1;
        } catch (Exception $e) {
            $nr_folio   =   1;
        }

        return $nr_folio;
    }
    //------------------------------------------------------------
    public function generarNumeroTicket($nr_anio, $nr_folio)
    {
        $str_zero       =   '0';
        $str_folio      =   str_pad($nr_folio, 4, $str_zero, STR_PAD_LEFT);
        $str_ticket     =   $nr_anio.$str_folio;

        return  $str_ticket;
    }
    //------------------------------------------------------------
    public function listadoUnidadVecinal()
    {
        $data   =   UnidadVecinal::
                    select('id as value','nm_unidadvecinal as label')
                    ->where('tp_activo','=',1)
                    ->get();

        return $data;
    }
    //------------------------------------------------------------
    public function listadoTicket()
    {
        $data   =   Solicitud::
                    select('id as value','nr_ticket as label')
                    ->where('tp_activo','=',1)
                    ->get();

        return $data;
    }
    //------------------------------------------------------------
    public function listadoVecinos()
    {
        $data   =   Vecino::
                    select('nr_rut as value','nr_rut as label')
                    ->where('tp_activo','=',1)
                    ->get();

        return $data;
    }
    //------------------------------------------------------------
    public function registrarFeedback(Request $request)
    {
        $nr_solicitud   =   $request->nr_solicitud;
        $tp_recepcion   =   $request->tp_recepcion;
        $tp_satisfaccion=   $request->tp_satisfaccion;
        $str_feedback   =   $request->str_feedback;
        $tp_feedback    =   1;
        $arr_valida     =   [];
        $fc_feedback    =   Date("Y-m-d H:i:s");

        try {
            Solicitud::
            where('id','=',$nr_solicitud)
            ->update([
                'tp_feedback'       =>  $tp_feedback,
                'fc_feedback'       =>  $fc_feedback,
                'tp_recepcion'      =>  $tp_recepcion,
                'tp_satisfaccion'   =>  $tp_satisfaccion,
                'str_feedback'      =>  $str_feedback
            ]);

            $arr_valida     =   [
                                    'error'     =>  0,
                                    'existe'    =>  1,
                                    'tp_icon'   =>  'success',
                                    'title'     =>  'Feedback Vecino',
                                    'msj'       =>  'Se ha actualizado la solicitud con el feedback'
                                ];
        } catch (Exception $e) {
            $arr_valida     =   [
                                    'error'     =>  1,
                                    'existe'    =>  0,
                                    'tp_icon'   =>  'error',
                                    'title'     =>  'Feedback Vecino',
                                    'msj'       =>  'ocurrio un error al registrar el feedback'
                                ];
        }

        return $arr_valida;
    }
    //------------------------------------------------------------
    public function cerrarFeedbackSolicitud()
    {
        $nr_dias    =   env('DIAS_TIEMPO_LIMITE_FEEDBACK_SOLICITUD');
        $fc_actual  =   Carbon::createFromFormat('Y-m-d H:i:s', Date('Y-m-d H:i:s'));

        $listado    =   Solicitud::
                        select('id','tp_feedback','created_at','updated_at')
                        ->where('id_estado','=',12)
                        ->where('tp_feedback','=',0)
                        ->where('tp_activo','=',1)
                        ->get();

        foreach ($listado as $key => $value) 
        {
            $fc_solicitud               =   Carbon::createFromFormat('Y-m-d H:i:s', $value->updated_at);
            $value->dias_transcurridos  =   $fc_solicitud->floatDiffInDays($fc_actual);
            $value->cerrar_feedback     =   (round($value->dias_transcurridos,10) > round($nr_dias,10) ? 1 : 0);
        }

        $data   =   collect($listado)->where('cerrar_feedback','=',1);       

        foreach ($data as $key => $value) 
        {
            Solicitud::
            where('id','=',$value->id)
            ->update([
                'tp_feedback'   =>  1
            ]);
        }
    }
    //------------------------------------------------------------
}
