<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Tipo;

use DB;
use Validator;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\UtilController;

class GsutTipoController extends Controller
{
    //------------------------------------------------------------
    public function index(Request $request)
    {
        $tp_admin       =   Auth::user()->tp_admin;
        $nr_direccion   =   Auth::user()->id_direccion;
        $nr_depto       =   Auth::user()->id_depto;
        $fl_direccion   =   $request->fl_direccion;
        $fl_depto       =   $request->fl_depto;
        $fl_servicio    =   $request->fl_servicio;

        $data           =   Tipo::
                            join('gsut_direccion as dir','dir.id','=','gsut_tipo.id_direccion')
                            ->join('gsut_depto as depto','depto.id','=','gsut_tipo.id_depto')
                            ->select('gsut_tipo.id',
                                'gsut_tipo.nm_tipo',
                                'gsut_tipo.str_tipo',
                                'gsut_tipo.str_tipo_html',
                                'gsut_tipo.id_direccion',
                                'gsut_tipo.id_depto',
                                'dir.nm_direccion',
                                'depto.nm_depto',
                                'gsut_tipo.tp_ubicacion',
                                'gsut_tipo.tp_macrozona',
                                'gsut_tipo.tp_asignacion',
                                'gsut_tipo.tp_respuesta',
                                'gsut_tipo.tp_director',
                                'gsut_tipo.tp_depto',
                                'gsut_tipo.nr_nivel',
                                'gsut_tipo.tp_activo')
                            ->with('funcionarios');

        /*----- Inicio - Filtro -----*/
            if($tp_admin == 2) // Administrador de Dirección
                $data   =   $data->where('gsut_tipo.id_direccion','=',$nr_direccion);

            if($tp_admin == 3) // Administrador de Depto
                $data   =   $data->where('gsut_tipo.id_direccion','=',$nr_direccion)
                                 ->where('gsut_tipo.id_depto','=',$nr_depto);

            if($fl_direccion != 0)
                $data   =   $data->where('gsut_tipo.id_direccion','=',$fl_direccion);

            if($fl_depto != 0)
                $data   =   $data->where('gsut_tipo.id_depto','=',$fl_depto);

            if($fl_servicio != 0)
                $data   =   $data->where('gsut_tipo.id','=',$fl_servicio);
        /*----- Termino - Filtro -----*/

        $data   =   $data->orderBy('dir.nm_direccion','asc')
                        ->orderBy('depto.nm_depto','asc')
                        ->orderBy('gsut_tipo.nm_tipo','asc');
        $data   =   $data->paginate(20);

        return [
            'pagination' => [
                'total'        => $data->total(),
                'current_page' => $data->currentPage(),
                'per_page'     => $data->perPage(),
                'last_page'    => $data->lastPage(),
                'from'         => $data->firstItem(),
                'to'           => $data->lastItem(),
            ],
            'info' => $data
        ];
    }
    //------------------------------------------------------------
    public function store(Request $request)
    {
        $valida     =   $this->validarDatos($request);

        if($valida['error'] == 1)
            return $valida;

        $existe     =   $this->existeRegistro($request);

        if($existe == 1)
            return [
                'error'     =>  1,
                'tp_icon'   =>  'warning',
                'title'     =>  'Registrar Servicio',
                'msj'       =>  'El servicio ya existe',
            ];
        else
            return $this->registrarServicio($request);
    }
    //------------------------------------------------------------
    public function update(Request $request)
    {
        $valida     =   $this->validarDatos($request);

        if($valida['error'] == 1)
            return $valida;

        $existe     =   $this->existeIdRegistro($request);

        if($existe == 1)
            return $this->actualizarServicio($request);
        else
            return [
                'error'     =>  1,
                'tp_icon'   =>  'warning',
                'title'     =>  'Actualizar Servicio',
                'msj'       =>  'El servicio no se encuentra disponible',
            ];
    }
    //------------------------------------------------------------
    public function state(Request $request)
    {
        $existe     =   $this->existeRegistro($request);

        if($existe)
            return $this->estadoServicio($request);
        else
            return [
                'error'     =>  1,
                'tp_icon'   =>  'warning',
                'title'     =>  'Estado Servicio',
                'msj'       =>  'El servicio no se encuentra disponible',
            ];
    }
    //------------------------------------------------------------
    public static function getServicio($nr_servicio)
    {
        $data           =   Tipo::
                            select('id as value',
                                'nm_tipo as label',
                                'str_tipo',
                                'str_tipo_html',
                                'tp_ubicacion',
                                'id_direccion',
                                'id_depto')
                            ->where('tp_activo','=',1)
                            ->where('id','=',$nr_servicio)
                            ->get();

        return $data;
    }
    //------------------------------------------------------------
    public static function listado(Request $request)
    {
        $nr_direccion   =   $request->nr_direccion;
        $nr_depto       =   $request->nr_depto;

        $data           =   Tipo::
                            select('id',
                                'id as value',
                                'nm_tipo as label',
                                'id_direccion',
                                'id_depto',
                                'str_tipo',
                                'str_tipo_html',
                                'tp_ubicacion')
                            ->where('tp_activo','=',1);

        if($nr_direccion != 0)
            $data   =   $data->where('id_direccion','=',$nr_direccion);

        if($nr_depto != 0)
            $data   =   $data->where('id_depto','=',$nr_depto);

        $data   =   $data->orderBy('nm_tipo','ASC')->get();

        return $data;
    }
    //------------------------------------------------------------
    public static function listadoServicios()
    {
        $data           =   Tipo::
                            select('id',
                                'id as value',
                                'nm_tipo as label',
                                'str_tipo',
                                'str_tipo_html',
                                'tp_ubicacion',
                                'id_direccion',
                                'id_depto')
                            ->with('notificacion')
                            ->where('tp_activo','=',1)
                            ->orderBy('nm_tipo','ASC')
                            ->get();
        
        return ['servicios' => $data];
    }
    //------------------------------------------------------------
    public function registrarServicio(Request $request)
    {
        $nr_servicio    =   0;
        $id_direccion   =   $request->id_direccion; // Direccion Municipal
        $id_depto       =   $request->id_depto; // Depto Municipal
        $nm_servicio    =   trim($request->nm_servicio);
        $str_servicio   =   trim($request->str_servicio);
        $str_html       =   trim($request->str_servicio_html);
        $tp_ubicacion   =   ($request->tp_ubicacion == 'true') ? 1 : 0;
        $tp_macrozona   =   ($request->tp_macrozona == 'true') ? 1 : 0;
        $tp_asignacion  =   ($request->tp_asignacion == 'true') ? 1 : 0;
        $tp_respuesta   =   ($request->tp_respuesta == 'true') ? 1 : 0;
        $tp_director    =   0; // ($request->tp_director == 'true') ? 1 : 0;    // No se utilizara VB en Servicios
        $tp_depto       =   0; // ($request->tp_depto == 'true') ? 1 : 0;       // No se utilizara VB en Servicios
        $nr_nivel       =   $request->nr_nivel;
        $arr_persona    =   $request->arr_funcionarios;
        $tp_activo      =   1; // Activo
        $valida         =   [];

        try {
            if(count($arr_persona))
            {
                $valida     =   UtilController::validaPermisos($arr_persona);

                if($valida['error'] == 1)
                    return $valida;
            }
            else
            {
                $valida     =   [
                    'error'     =>  1,
                    'tp_icon'   =>  'warning',
                    'title'     =>  'Registrar Servicio',
                    'msj'       =>  'No se han encontrado funcionarios asignados al servicio : "'.$nm_servicio.'"',
                ];

                return $valida;
            }

            $tipo    =   new Tipo();
            $tipo->id_direccion     =   $id_direccion;
            $tipo->id_depto         =   $id_depto;
            $tipo->nm_tipo          =   $nm_servicio;
            $tipo->str_tipo         =   $str_servicio;
            $tipo->str_tipo_html    =   $str_html;
            $tipo->tp_ubicacion     =   $tp_ubicacion;
            $tipo->tp_macrozona     =   $tp_macrozona;
            $tipo->tp_asignacion    =   $tp_asignacion;
            $tipo->tp_respuesta     =   $tp_respuesta;
            $tipo->tp_director      =   $tp_director;
            $tipo->tp_depto         =   $tp_depto;
            $tipo->nr_nivel         =   $nr_nivel;
            $tipo->tp_activo        =   $tp_activo;
            $tipo->save();

            if($this->existeRegistro($request))
            {
                $request['nr_servicio']     =   $tipo->id;
                $valida     =   AsignadorController::asignarFuncionario($request);

                if($valida['error'] == 1) return $valida;

                $valida     =   [
                    'error'     =>  0,
                    'tp_icon'   =>  'success',
                    'title'     =>  'Registrar Servicio',
                    'msj'       =>  'Se ha registrado el servicio : "'.$nm_servicio.'"',
                ];
            }
            else
                $valida     =   [
                    'error'     =>  0,
                    'tp_icon'   =>  'success',
                    'title'     =>  'Registrar Servicio',
                    'msj'       =>  'No se ha podido registrar el servicio : "'.$nm_servicio.'"',
                ];
        } catch (Exception $e) {
            $valida     =   [
                'error'     =>  1,
                'tp_icon'   =>  'danger',
                'title'     =>  'Registrar Servicio',
                'msj'       =>  'Ha ocurrido un problema al registar el servicio : "'.$nm_servicio.'"',
            ];
        }

        return $valida;
    }
    //------------------------------------------------------------
    public function actualizarServicio(Request $request)
    {
        $nr_servicio    =   $request->nr_servicio; // Id Servicio
        $id_direccion   =   $request->id_direccion; // Direccion Municipal
        $id_depto       =   $request->id_depto; // Depto Municipal
        $nm_servicio    =   trim($request->nm_servicio);
        $str_servicio   =   trim($request->str_servicio);
        $str_html       =   trim($request->str_servicio_html);
        $tp_ubicacion   =   ($request->tp_ubicacion == 'true') ? 1 : 0;
        $tp_macrozona   =   ($request->tp_macrozona == 'true') ? 1 : 0;
        $tp_asignacion  =   ($request->tp_asignacion == 'true') ? 1 : 0;
        $tp_respuesta   =   ($request->tp_respuesta == 'true') ? 1 : 0;
        $tp_director    =   0; // ($request->tp_director == 'true') ? 1 : 0;    // No se utilizara VB en Servicios
        $tp_depto       =   0; // ($request->tp_depto == 'true') ? 1 : 0;       // No se utilizara VB en Servicios
        $nr_nivel       =   $request->nr_nivel;
        $arr_persona    =   (isset($request->arr_funcionarios)) ? $request->arr_funcionarios : [];
        $tp_activo      =   1; // Activo
        $arr_merge      =   [];
        $valida         =   [];

        try {
            $arr_asignados  =   AsignadorController::getFuncionariosAsignadosToServicio($nr_servicio);
            $arr_merge      =   array_merge($arr_merge, $arr_persona, $arr_asignados);

            if(count($arr_merge))
            {
                $valida         =   UtilController::validaPermisos($arr_merge);

                if($valida['error'] == 1)
                    return $valida;
            }
            else
            {
                $valida     =   [
                    'error'     =>  1,
                    'tp_icon'   =>  'warning',
                    'title'     =>  'Registrar Servicio',
                    'msj'       =>  'No se han encontrado funcionarios asignados al servicio : "'.$nm_servicio.'"',
                ];

                return $valida;
            }

            // Valida Si macrozona tiene soliciudes pendientes
            if($tp_macrozona == 0)
                $valida     =   UtilController::macrozonaTieneSolicitudPendiente($nr_servicio);

            if($valida['error'] == 1)
                return $valida;

            // Valida Si asignador tiene solicitudes pendientes
            if($tp_asignacion == 0)
                $valida     =   UtilController::asignadorTieneSolicitudPendiente($nr_servicio);

            if($valida['error'] == 1)
                return $valida;0; // 

            // No se utilizara el VB director y Jefe Depto en los Servicios, 
            // se utilizara en la definicion de cada usuario

            // Valida Si director tiene solicitudes pendientes
            // if($tp_director == 0)
            //     $valida     =   UtilController::directorTieneSolicitudPendiente($nr_servicio);

            // if($valida['error'] == 1)
            //         return $valida;

            // Valida Si jefe depto tiene solicitudes pendientes
            // if($tp_depto == 0)
            //     $valida     =   UtilController::jefeDeptoTieneSolicitudPendiente($nr_servicio);

            // if($valida['error'] == 1)
            //         return $valida;

            Tipo::
            where('id','=',$nr_servicio)
            ->update([
                'id_direccion'      =>  $id_direccion,
                'id_depto'          =>  $id_depto,
                'nm_tipo'           =>  $nm_servicio,
                'str_tipo'          =>  $str_servicio,
                'str_tipo_html'     =>  $str_html,
                'tp_ubicacion'      =>  $tp_ubicacion,
                'tp_macrozona'      =>  $tp_macrozona,
                'tp_asignacion'     =>  $tp_asignacion,
                'tp_respuesta'      =>  $tp_respuesta,
                'tp_director'       =>  $tp_director,
                'tp_depto'          =>  $tp_depto,
                'nr_nivel'          =>  $nr_nivel
            ]);

            if($this->existeRegistro($request))
            {
                if(count($arr_persona))
                    $valida     =   AsignadorController::asignarFuncionario($request);

                if($valida['error'] == 1) return $valida;

                $valida     =   AsignadorController::habilitarSolicitudes($request);

                if($valida['error'] == 1) return $valida;

                $valida     =   [
                    'error'     =>  0,
                    'tp_icon'   =>  'success',
                    'title'     =>  'Actualizar Servicio',
                    'msj'       =>  'Se han actualizado los datos del servicio "'.$nm_servicio.'"',
                ];
            }
            else
                $valida     =   [
                    'error'     =>  0,
                    'tp_icon'   =>  'success',
                    'title'     =>  'Actualizar Servicio',
                    'msj'       =>  'No se ha podido actualizar los datos del servicio "'.$nm_servicio.'"',
                ];
        } catch (Exception $e) {
            \Log::debug(__METHOD__ . " Error : " . $e->getMessage());
            $valida     =   [
                'error'     =>  1,
                'tp_icon'   =>  'danger',
                'title'     =>  'Actualizar Servicio',
                'msj'       =>  'Ha ocurrido un problema al actualizar los datos del servicio "'.$nm_servicio.'"',
            ];
        }

        return $valida;
    }
    //------------------------------------------------------------
    public function estadoServicio(Request $request)
    {
        $nr_servicio    =   $request->nr_servicio;
        $nm_servicio    =   $request->nm_servicio;
        $tp_activo      =   $request->tp_activo; // 1. Habilitar | 0. Deshabilitar
        $valida         =   [];
        $title          =   ($tp_activo == 1) ? 'Habilitar Servicio': 'Deshabilitar Servicio';
        $msj            =   ($tp_activo == 1) ? 'Se ha habilitado el servicio "'.$nm_servicio.'"': 
                                            'Se ha deshabilitado el servicio "'.$nm_servicio.'"';

        Tipo::
        where('id','=',$nr_servicio)
        ->update([
            'tp_activo'     =>  $tp_activo
        ]);

        return [
            'error'     =>  0,
            'tp_icon'   =>  'success',
            'title'     =>  $title,
            'msj'       =>  $msj,
        ];
    }
    //------------------------------------------------------------
    public function existeRegistro(Request $request)
    {
        $nm_servicio    =   trim($request->nm_servicio);
        $existe         =   Tipo::where('nm_tipo','=',$nm_servicio)->count();
        return $existe;
    }
    //------------------------------------------------------------
    public function existeIdRegistro(Request $request)
    {
        $nr_servicio    =   trim($request->nr_servicio);
        $existe         =   Tipo::where('id','=',$nr_servicio)->count();
        return $existe;
    }
    //------------------------------------------------------------
    public function validarDatos(Request $request)
    {
        $customMessages = [
            'required'          =>  'El campo :attribute es requerido.',
            'numeric'           =>  'El campo :attribute debe ser númerico.',
        ];

        $attributes = [
            'id_direccion'      =>  'Dirección Municipal',
            'id_depto'          =>  'Departamento Municipal',
            'nm_servicio'       =>  'Servicio',
            'tp_macrozona'      =>  'Requiere Macrozona',
        ];

        $validator = Validator::make($request->all(), [
            'id_direccion'      =>  'required|numeric|min:1',
            'id_depto'          =>  'required|numeric|min:1',
            'nm_servicio'       =>  'required|string|min:5',
            'tp_macrozona'      =>  'required',          
        ], $customMessages,$attributes);

        if ($validator->fails())
            return [
                'error'     =>  1,
                'tp_icon'   =>  'warning',
                'title'     =>  'Validar Datos',
                'msj'       =>  'Favor revisar los datos requeridos',
                'valida'    =>  $validator->errors(),
            ];

        return [
            'error'     =>  0,
            'tp_icon'   =>  'success',
            'title'     =>  'Validar Datos',
            'msj'       =>  'Datos validos',
            'valida'    =>  null,
        ];
    }
    //------------------------------------------------------------
}
