<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class MacroTerritorio extends Model
{
    protected $table        =   'gsut_macroterritorio';
    protected $primaryKey   =   'id';
    protected $fillable     =   ['cod_territorio',
                                'nm_territorio',
                                'tp_activo'];

    public $timestamps = true;

    public function unidadvecinal()
    {
        return $this->hasManyThrough('App\UnidadVecinal','App\UnidadVecinalMacroTerritorio',
                                    'id_macroterritorio','id',
                                    'id','id_unidadvecinal')
                    ->select(['gsut_unidadvecinal.id as value','gsut_unidadvecinal.nm_unidadvecinal as label']);
    }
}
