<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGsutVecinoTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('gsut_vecino', function(Blueprint $table)
		{
			$table->bigIncrements('id');
			$table->string('nr_rut', 20)->unique();
			$table->string('nm_vecino', 180)->default('');
			$table->string('ap_paterno', 50)->default('');
			$table->string('ap_materno', 50)->default('');
			$table->integer('id_region')->unsigned();				// id de region
			$table->integer('id_comuna')->unsigned(); 				// id de comuna
			$table->integer('id_ubicacion')->nullable();			// id del maestro direccion
            $table->integer('id_macroterritorio')->unsigned();		// id macroterritorio
            $table->integer('id_unidadvecinal')->unsigned(); 		// id unidad vecinal             
			$table->integer('nr_calle')->nullable();				// numeracion direccion
            $table->string('nm_calle')->nullable();					// nombre direccion 
            $table->string('nm_ubicacion')->nullable();				// concatenacion de numeracion y nombre direccion
            $table->integer('tp_direccion')->unsigned()->default(1);// 1- Frente | 3- Altura
            $table->string('str_latitud', 150)->nullable();			// latitud
			$table->string('str_longitud', 150)->nullable();		// longitud			
			$table->string('str_aclaratoria')->nullable();
			$table->string('nr_prefijo', 20)->default('');
			$table->string('nr_telefono', 20)->default('');
			$table->string('nm_mail', 180)->default('');
			$table->integer('tp_vecino')->default(0);
			$table->integer('id_autor')->unsigned()->default(0);
			$table->integer('tp_activo')->unsigned()->default(1);			
			$table->timestamps();
		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::dropIfExists('gsut_vecino');
	}

}
