<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateGsutEncuestaRespuestasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('gsut_encuesta_respuestas', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('id_llamada')->unsigned();
            $table->integer('id_pregunta')->unsigned();
            $table->integer('id_alternativa')->unsigned();
            $table->text('nm_pregunta')->nullable();
            $table->text('nm_alternativa')->nullable();
            $table->string('vl_alternativa',50)->nullable();
            $table->integer('tp_activo')->unsigned()->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('gsut_encuesta_respuestas');
    }
}
