<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateLogApiActividadTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('log_api_actividad', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('api_user_id')->unsigned();
            $table->string('ip_address')->nullable();
            $table->string('method')->nullable();
            $table->string('api_endpoint')->nullable();
            $table->text('request_payload')->nullable();
            $table->integer('response_status')->nullable();
            $table->text('response_payload')->nullable();
            $table->integer('duration')->nullable();
            $table->integer('tp_activo')->unsigned()->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('log_api_actividad');
    }
}
