<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePdfUploads extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pdf_uploads', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('nombre_real');
            $table->string('nombre_guardado');
            $table->string('ruta');
            $table->string('tipo');
            $table->string('tamano');
            $table->string('extension');
            $table->string('id_usuario');
            $table->string('index_qdrant')->nullable();
            $table->datetime('fc_subida')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pdf_uploads');
    }
}
