<?php

if ( !function_exists('greeting') )
{
	function greeting($name){
		return 'Howdy ' . $name;
	}
}

if ( !function_exists('f_num') )
{
	function f_num($value){
		return number_format ( $value , /*decimals*/ 0 , /*dec_point*/  "," , /*$thousands_sep*/ "." );
	}
}

if ( !function_exists('limpia_rut') )
{
	function limpia_rut($value){
		$value = str_replace('.', '', $value);//quita puntos
		$value = str_replace('-', '', $value);//quita guion
		$value = str_replace(' ', '', $value);//espacios		
        $value = substr($value,0,-1).'-'.substr($value,-1);

		return strtoupper($value);
	}
}

if ( !function_exists('f_rut') )
{
	function f_rut($value){
		$value = str_replace('.', '', $value);//quita puntos
        $value = str_replace('-', '', $value);//quita guion
        $value = f_num(substr($value,0,-1)).'-'.substr($value,-1);

		return $value;
	}
}

if ( !function_exists('mes_espanol') )
{
	function mes_espanol(int $num){

		$meses = ['','enero','febrero','marzo','abril','mayo','junio','julio','agosto','septiembre','octubre','noviembre','diciembre'];

		return $meses[$num];
	}
}

if ( !function_exists('mayusc') )
{
	function mayusc($txt){

		return strtoupper($txt);
	}
}

if ( !function_exists('minusc') )
{
	function minusc($txt){

		return strtolower($txt);
	}
}