<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Solicitud;
use App\EncuestaPregunta;
use App\EncuestaLlamada;
use App\EncuestaRespuesta;
use App\User;
use App\Vecino;

use DB;
use Validator;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Facades\Excel;

class EncuestaController extends Controller
{
    //------------------------------------------------------------
    public function index(Request $request)
    {
        $id_user        =   Auth::user()->id;
        $id_rol         =   Auth::user()->id_rol;
        $tp_admin       =   Auth::user()->tp_admin;
        $nr_direccion   =   Auth::user()->id_direccion;
        $nr_depto       =   Auth::user()->id_depto;
        $fl_mostrar     =   $request->fl_mostrar;
        $fl_estado      =   [1,2,3,6]; // $request->fl_estado;
        $fl_direccion   =   $request->fl_direccion;
        $fl_depto       =   $request->fl_depto;
        $fl_servicio    =   $request->fl_servicio;
        $fl_macrozona   =   $request->fl_macrozona;
        $fl_undvecinal  =   $request->fl_unidadvecinal;
        $fl_ticket      =   $request->fl_ticket;
        $fl_vecino      =   $request->fl_persona;
        $fl_motivo      =   $request->fl_motivo;
        $fl_ubicacion   =   $request->fl_ubicacion;
        $tp_criterio    =   $request->tp_criterio;
        $tp_orden       =   $request->tp_orden;
        $page           =   $request->page;
        $fc_desde       =   $request->fc_desde;
        $fc_hasta       =   $request->fc_hasta;
        $tp_validar     =   $request->tp_validar;

        $data           =   Solicitud:: 
                            join('gsut_prioridad as prioridad','prioridad.id','=','gsut_solicitud.id_prioridad')
                            ->join('gsut_motivo as motivo','motivo.id','=','gsut_solicitud.id_motivo')
                            ->join('gsut_tipo as tipo','tipo.id','=','gsut_solicitud.id_tipo')
                            ->join('gsut_estado as estado','estado.id','=','gsut_solicitud.id_estado')
                            ->join('gsut_estado_encuesta as estado_encuesta','estado_encuesta.id','=','gsut_solicitud.id_estado_encuesta')
                            ->join('gsut_direccion as dir_destino','dir_destino.id','=','gsut_solicitud.id_direccion_destino')
                            ->join('gsut_depto as depto_destino','depto_destino.id','=','gsut_solicitud.id_depto_destino')
                            ->leftjoin('gsut_macroterritorio as mt','mt.id','=','gsut_solicitud.id_macroterritorio')
                            ->leftjoin('gsut_unidadvecinal as uv','uv.id','=','gsut_solicitud.id_unidadvecinal')
                            ->join('gsut_tipo_ingreso as ti','ti.id','=','gsut_solicitud.tp_ingreso')
                            ->select('gsut_solicitud.id',
                                'gsut_solicitud.nr_ticket',
                                'gsut_solicitud.id_municipio',
                                'gsut_solicitud.id_direccion',
                                'gsut_solicitud.id_depto',
                                'gsut_solicitud.id_tipo',
                                'gsut_solicitud.nm_tipo',
                                'gsut_solicitud.id_prioridad',
                                'gsut_solicitud.id_motivo',
                                'prioridad.nm_prioridad',
                                'motivo.nm_motivo',
                                'gsut_solicitud.id_direccion_destino',
                                'dir_destino.nm_direccion as nm_direccion_destino',
                                'gsut_solicitud.id_depto_destino',
                                'depto_destino.nm_depto as nm_depto_destino',
                                'gsut_solicitud.id_ubicacion',
                                'gsut_solicitud.id_macroterritorio',
                                'mt.cod_territorio',
                                'gsut_solicitud.id_unidadvecinal',
                                'uv.cod_unidadvecinal',
                                'uv.nm_unidadvecinal',
                                'gsut_solicitud.tp_direccion',
                                'gsut_solicitud.nr_direccion',
                                'gsut_solicitud.nm_direccion',
                                'gsut_solicitud.nm_ubicacion',
                                'gsut_solicitud.str_latitud',
                                'gsut_solicitud.str_longitud',
                                'gsut_solicitud.nr_rut_vecino',
                                'gsut_solicitud.str_observacion',
                                'gsut_solicitud.str_observacion_html',
                                'gsut_solicitud.str_aclaratoria',
                                'gsut_solicitud.tp_visado_mt',
                                'gsut_solicitud.tp_rechazado',
                                'gsut_solicitud.id_estado',
                                'gsut_solicitud.id_estado_encuesta',
                                'estado.nm_estado',
                                'estado.nm_color',
                                'gsut_solicitud.contexto_municipal',
                                'gsut_solicitud.tp_ingreso',
                                'ti.nm_ingreso',
                                'estado_encuesta.nm_estado as nm_estado_encuesta',
                                'gsut_solicitud.id_autor',
                                'gsut_solicitud.tp_activo',
                                'gsut_solicitud.tp_feedback',
                                'gsut_solicitud.tp_recepcion',
                                'gsut_solicitud.tp_satisfaccion',
                                'gsut_solicitud.str_feedback',
                                'gsut_solicitud.fc_creacion as fc_ingreso',
                                'gsut_solicitud.created_at',
                                'gsut_solicitud.fc_publicado',
                                'gsut_solicitud.fc_finalizado',
                                'gsut_solicitud.updated_at as fc_tramitacion')
                            ->selectRaw("(case when tp_vecino = 1 then 'SI' else 'NO' end) as tp_vecino")
                            ->where('gsut_solicitud.tp_activo','=',1)
                            ->whereIn('gsut_solicitud.id_estado',[5,6])
                            ->whereNotIn('gsut_solicitud.id_estado_encuesta',[7])
                            ->whereIn('gsut_solicitud.id_estado_encuesta',$fl_estado)
                            ->whereExists(function ($query) {
                                $query->select(DB::raw('1'))
                                    ->from('gsut_vecino')
                                    ->whereRaw('gsut_vecino.nr_rut = gsut_solicitud.nr_rut_vecino');
                            })
                            ->whereExists(function ($query) {
                                $query->select(DB::raw('1'))
                                    ->from('gsut_encuesta_llamada as llamada')
                                    ->whereRaw('llamada.id_solicitud', 'gsut_solicitud.id')
                                    ->whereRaw('llamada.tp_activo = 1');
                            })
                            ->with('tipo','vecino','publicacion');

        /* ----- Inicio - Filtro por Rol ----- */
            // if(in_array($id_rol,[25]))
            //     $data   =   $data->where('gsut_solicitud.id_telefonista','=',$id_user);
        /* ----- Termino - Filtro por Rol ----- */
        
        /* ----- Inicio - Filtro ----- */
            // if(isset($fl_estado))
            //      $data   =   $data->whereIn('gsut_solicitud.id_estado_encuesta',$fl_estado);

            if(isset($fl_direccion)) 
                $data   =   $data->where('gsut_solicitud.id_direccion_destino','=',$fl_direccion);

            if(isset($fl_depto)) 
                $data   =   $data->where('gsut_solicitud.id_depto_destino','=',$fl_depto);

            if(isset($fl_servicio))
                $data   =   $data->where('gsut_solicitud.id_tipo','=',$fl_servicio);

            if(isset($fl_macrozona))
                $data   =   $data->where('gsut_solicitud.id_macroterritorio','=',$fl_macrozona);

            if(isset($fl_undvecinal))
                $data   =   $data->where('gsut_solicitud.id_unidadvecinal','=',$fl_undvecinal);

            if(isset($fl_ticket))
                $data   =   $data->where('gsut_solicitud.nr_ticket','=',$fl_ticket);

            if(isset($fl_vecino))
                $data   =   $data->where('gsut_solicitud.nr_rut_vecino','=',$fl_vecino);

            if(isset($fl_motivo))
                $data   =   $data->where('gsut_solicitud.id_motivo','=',$fl_motivo);

            if(isset($fl_ubicacion))
                $data   =   $data->where('gsut_solicitud.id_ubicacion','=',$fl_ubicacion);
        /* ----- Termino - Filtro ----- */

        /*----- Inicio - Orden por Campos -----*/
            if(in_array($tp_criterio, ['id','id_macroterritorio','id_unidadvecinal','created_at']))
                $data   =   $data->orderBy('gsut_solicitud.'.$tp_criterio, $tp_orden);

            if($tp_criterio === 'nm_direccion')
                $data   =   $data->orderBy('dir_destino.nm_direccion',$tp_orden);

            if($tp_criterio === 'nm_depto')
                $data   =   $data->orderBy('depto_destino.nm_depto',$tp_orden);

            if($tp_criterio === 'nm_estado')
                $data   =   $data->orderBy('estado.nm_estado',$tp_orden);
        /*----- Termino - Orden por Campos -----*/

        $data   =   $data->groupBy('gsut_solicitud.id')->paginate(20);

        $data->getCollection()->transform(function ($value) use ($id_rol, $tp_admin) {
            $value->tiempo_tramitado        =   UtilController::getTiempoTramitacion($value->fc_ingreso, $value->fc_publicado, $value->id_estado);
            $value->tp_obs_encuesta         =   UtilController::isTicketTieneObservacionEncuesta($value->id);
            $value->tiene_obs_encuesta      =   (UtilController::isTicketTieneObservacionEncuesta($value->id) == 1) ? "SI" : "NO";
            return $value;
        });

        return [
            'pagination' => [
                'total'         =>  $data->total(),
                'current_page'  =>  $data->currentPage(),
                'per_page'      =>  $data->perPage(),
                'last_page'     =>  $data->lastPage(),
                'from'          =>  $data->firstItem(),
                'to'            =>  $data->lastItem(),
            ],
            'info' => $data,
            'nr_atendidos'      =>  UtilController::getCantidadTicketAtendidosPorTelefonista($id_user),
            'nr_pendientes'     =>  UtilController::getCantidadSolicitudTelefonistasEstado($id_user, 1),
            'nr_agendados'      =>  UtilController::getCantidadTicketAgendadosporFecha(Date('Y-m-d')),
        ];
    }
    //------------------------------------------------------------
    public function store(Request $request)
    {
        // return $request->all();
        //-------------------------------------------------------------------------
        $tp_parcial     =   $request->tp_parcial;
        $nr_solicitud   =   $request->nr_solicitud;
        $nr_ticket      =   $request->nr_ticket;
        $nr_rut         =   $request->nr_rut;
        $nr_prefijo     =   $request->nr_prefijo;
        $nr_telefono    =   $request->nr_telefono;
        $nr_estado      =   $request->nr_estado;
        $str_detalle    =   ($request->str_observacion) ? strtoupper($request->str_observacion) : null;
        $arr_encuesta   =   json_decode($request->arr_encuesta[0]);
        $arr_fechas     =   json_decode($request->info_fechas[0]);
        $nr_autor       =   Auth::user()->id;
        $nr_registro    =   0;
        //-------------------------------------------------------------------------
        $arr_valida     =   [
                                'error'     =>  0,
                                'existe'    =>  1,
                                'tp_icon'   =>  'success',
                                'title'     =>  'Registro de Encuesta',
                                'msj'       =>  '',
                            ];
        $arr_error      =   [];
        //-------------------------------------------------------------------------
        $arr_log        =   [
                                'tp_parcial'    =>  $tp_parcial,
                                'nr_estado'     =>  $nr_estado,
                                'arr_encuesta'  =>  $arr_encuesta,
                                'arr_fechas'    =>  $arr_fechas,
                            ];
        \Log::debug(__METHOD__ . " Registro Encuesta : " . print_r($arr_log, true));
        //-------------------------------------------------------------------------
        // dd(['request' => $request->all()]);
        //-------------------------------------------------------------------------
        try {
            $arr_llamada    =   [
                                    'id_solicitud'          =>  $nr_solicitud,
                                    'id_autor'              =>  $nr_autor,
                                    'nr_rut'                =>  $nr_rut,
                                    'nr_prefijo'            =>  $nr_prefijo,
                                    'nr_telefono'           =>  $nr_telefono,
                                    'str_observacion'       =>  $str_detalle,
                                    'fc_inicio'             =>  ($arr_fechas->fc_inicio) ? Carbon::createFromFormat('Y-m-d H:i:s', $arr_fechas->fc_inicio) : null,
                                    'fc_termino'            =>  ($arr_fechas->fc_termino) ? Carbon::createFromFormat('Y-m-d H:i:s', $arr_fechas->fc_termino) : null,
                                    'fc_inicio_ring'        =>  ($arr_fechas->fc_inicio_ring) ? Carbon::createFromFormat('Y-m-d H:i:s', $arr_fechas->fc_inicio_ring) : null,
                                    'fc_termino_ring'       =>  ($arr_fechas->fc_termino_ring) ? Carbon::createFromFormat('Y-m-d H:i:s', $arr_fechas->fc_termino_ring) : null,
                                    'fc_inicio_contacto'    =>  ($arr_fechas->fc_inicio_contacto) ? Carbon::createFromFormat('Y-m-d H:i:s', $arr_fechas->fc_inicio_contacto) : null,
                                    'fc_termino_contacto'   =>  ($arr_fechas->fc_termino_contacto) ? Carbon::createFromFormat('Y-m-d H:i:s', $arr_fechas->fc_termino_contacto) : null,
                                    'fc_inicio_servicio'    =>  ($arr_fechas->fc_inicio_servicio) ? Carbon::createFromFormat('Y-m-d H:i:s', $arr_fechas->fc_inicio_servicio) : null,
                                    'fc_termino_servicio'   =>  ($arr_fechas->fc_termino_servicio) ? Carbon::createFromFormat('Y-m-d H:i:s', $arr_fechas->fc_termino_servicio) : null,
                                    'id_estado'             =>  $nr_estado,
                                ];
            $llamada    =   EncuestaLlamada::create($arr_llamada);

            if($llamada->id)
            {
                $nr_registro    =   $llamada->id;

                foreach ($arr_encuesta as $key => $value) {
                    $arr_respuesta  =   [
                                            'id_llamada'        =>  $nr_registro,
                                            'id_pregunta'       =>  $value->nr_pregunta,
                                            'id_alternativa'    =>  $value->nr_alternativa,
                                            'nm_pregunta'       =>  $value->actual_str_pregunta,
                                            'nm_alternativa'    =>  $value->str_alternativa,
                                            'vl_alternativa'    =>  $value->nr_valor,
                                        ];

                    EncuestaRespuesta::create($arr_respuesta);
                }

                // Actualiza el estado de la encuesta en la solicitud
                Solicitud::where('id','=',$nr_solicitud)
                ->update([
                    'id_telefonista'            =>  $nr_autor,
                    'id_estado_encuesta'        =>  $nr_estado
                ]);
            }

            $arr_valida     =   [
                                    'error'     =>  0,
                                    'existe'    =>  1,
                                    'tp_icon'   =>  'success',
                                    'title'     =>  'Registro de Encuesta',
                                    'msj'       =>  'Se ha registrado la encuesta',
                                ];
        } catch (Exception $e) {
            $arr_valida     =   [
                                    'error'     =>  1,
                                    'existe'    =>  0,
                                    'tp_icon'   =>  'warning',
                                    'title'     =>  'Registro de Encuesta',
                                    'msj'       =>  'Ha ocurrido un problema al registrar la encuesta',
                                ];

            $arr_error      =   [
                                    'msj'       =>  'Se ha producido una exepción, no se ha competado el registro ',
                                    'error'     =>  $e->getMessage(),
                                    'toString'  =>  $e->__toString(),
                                ];

            \Log::debug(__METHOD__ . " Registro de Encuesta : " . print_r($arr_error, true));
        }

        return $arr_valida;
    }
    //------------------------------------------------------------
    public function state(Request $request)
    {
        $nr_solicitud   =   $request->nr_solicitud;
        $nr_ticket      =   $request->nr_ticket;
        $nr_rut         =   $request->nr_rut;
        $nr_estado      =   $request->nr_estado;
        $str_obs        =   $request->str_observacion;
        $str_title      =   'Estado Encuesta del Servicio';
        $str_msj        =   '';
        $arr_valida     =   ['error' => 0,'tp_icon' => 'success', 'title' => '','msj' => ''];

        $data_ticket    =   Solicitud::where('id','=',$nr_solicitud)->get();

        if($data_ticket->count())
        {
            Solicitud::where('id','=',$nr_solicitud)
            ->update([
                'id_estado_encuesta'    =>  $nr_estado,
                'str_estado_encuesta'   =>  $str_obs
            ]);

            $str_msj        =   'Se ha actualizado el estado de la encuesta para el Ticket #'.$nr_ticket;

            $arr_valida     =   [
                                    'error'     =>  0,
                                    'tp_icon'   =>  'success',
                                    'title'     =>  $str_title,
                                    'msj'       =>  $str_msj,
                                ];
        }
        else
        {
            $str_msj        =   'No se ha podido actualizar el estado de la encuesta para el Ticket #'.$nr_ticket;

            $arr_valida     =   [
                                    'error'     =>  0,
                                    'tp_icon'   =>  'success',
                                    'title'     =>  $str_title,
                                    'msj'       =>  $str_msj,
                                ];
        }

        return $arr_valida;
    }
    //------------------------------------------------------------
    public function resumenAgendados()
    {
        $nr_total       =   0;
        $agrupar        =   [];
        $fc_actual      =   date('Y-m-d');
        $nr_anio        =   intval(Date('Y'));
        $nr_mes         =   intval(Date('m'));
        $nr_dia         =   intval(Date('d'));
        $anio_actual    =   [];
        $mes_actual     =   [];
        $dia_actual     =   [];
        $arr_mes        =   [
                                '-',
                                'Enero', 
                                'Febrero', 
                                'Marzo', 
                                'Abril', 
                                'Mayo', 
                                'Junio', 
                                'Julio', 
                                'Agosto', 
                                'Septiembre', 
                                'Octubre', 
                                'Noviembre', 
                                'Diciembre'
                            ];
        /*
        $data       =   Solicitud::
                        join('gsut_encuesta_llamada as llamada','llamada.id_solicitud','=','gsut_solicitud.id')
                        ->join('gsut_encuesta_respuestas as respuesta','respuesta.id_llamada','=','llamada.id')
                        ->join('gsut_encuesta_pregunta as pregunta','pregunta.id','=','respuesta.id_pregunta')
                        ->select(DB::raw('year(respuesta.nm_alternativa) as nr_anio'),
                            DB::raw('month(respuesta.nm_alternativa) as nr_mes'),
                            DB::raw('day(respuesta.nm_alternativa) as nr_dia'),
                            DB::raw('date_format(max(str_to_date(respuesta.nm_alternativa,"%Y-%m-%d")),"%d-%m-%Y") as fc_calendario'),
                            DB::raw('count(gsut_solicitud.id) as nr_cantidad'))
                        ->where('gsut_solicitud.tp_activo','=','1')
                        ->whereIn('gsut_solicitud.id_estado',[5,6])
                        ->whereIn('gsut_solicitud.id_estado_encuesta',[3])
                        ->where('pregunta.tp_pregunta','=','4')
                        ->whereNotExists(function ($query) {
                            $query->select(DB::raw(1))
                                ->from('gsut_encuesta_llamada as llamada2')
                                ->join('gsut_encuesta_respuestas as respuesta2','respuesta2.id_llamada','=','llamada2.id')
                                ->whereColumn('llamada2.id_solicitud','llamada.id_solicitud')
                                ->where(DB::raw('date_format(respuesta2.nm_alternativa,"%Y-%m-%d %H:%i")'),'>',DB::raw('date_format(respuesta.nm_alternativa,"%Y-%m-%d %H:%i")'));
                        })
                        ->groupBy(DB::raw('date_format(respuesta.nm_alternativa,"%d-%m-%Y")'))
                        ->orderBy(DB::raw('date_format(respuesta.nm_alternativa,"%d-%m-%Y")'),'ASC')
                        ->get();
        */

        $data_llamadas  =   DB::table('gsut_encuesta_llamada as llamada2')
                            ->join('gsut_encuesta_respuestas as respuesta2', 'respuesta2.id_llamada', '=', 'llamada2.id')
                            ->select('llamada2.id_solicitud',
                                DB::raw('MAX(respuesta2.nm_alternativa) as ultima_fecha'))
                            ->groupBy('llamada2.id_solicitud');

        $data           =   Solicitud::query()
                            ->join('gsut_encuesta_llamada as llamada', 'llamada.id_solicitud', '=', 'gsut_solicitud.id')
                            ->join('gsut_encuesta_respuestas as respuesta', 'respuesta.id_llamada', '=', 'llamada.id')
                            ->join('gsut_encuesta_pregunta as pregunta', 'pregunta.id', '=', 'respuesta.id_pregunta')
                            ->joinSub($data_llamadas, 'ultimas', function ($join) {
                                $join->on('ultimas.id_solicitud', '=', 'llamada.id_solicitud')
                                     ->on('ultimas.ultima_fecha', '=', 'respuesta.nm_alternativa');
                            })
                            ->select(
                                DB::raw('YEAR(respuesta.nm_alternativa) as nr_anio'),
                                DB::raw('MONTH(respuesta.nm_alternativa) as nr_mes'),
                                DB::raw('DAY(respuesta.nm_alternativa) as nr_dia'),
                                DB::raw('DATE(respuesta.nm_alternativa) as fc_calendario'),
                                DB::raw('COUNT(gsut_solicitud.id) as nr_cantidad')
                            )
                            ->where('gsut_solicitud.tp_activo', '1')
                            ->whereIn('gsut_solicitud.id_estado', [5, 6])
                            ->whereIn('gsut_solicitud.id_estado_encuesta', [3])
                            ->where('pregunta.tp_pregunta', '4')
                            ->groupBy('fc_calendario')
                            ->orderBy('fc_calendario', 'ASC')
                            ->get();

        if($data->count())
        {
            //  Se contabiliza la cantidad de encuestas agendadas
            $nr_total   =   $data->sum('nr_cantidad');

            //  Se realiza una agrupación por Año y Mes
            $agrupar    =   $data->groupBy('nr_anio')
                                ->map(function ($itemsPorAnio) use ($arr_mes) {
                                    $nr_subtotal    =   $itemsPorAnio->sum('nr_cantidad');

                                    $itemsPorMes    =   $itemsPorAnio->groupBy('nr_mes')
                                                        ->map(function ($items, $mes) use ($arr_mes) {
                                                            return  [
                                                                'nr_mes'        =>  $mes, 
                                                                'nm_mes'        =>  $arr_mes[$mes],
                                                                'nr_subtotal'   =>  $items->sum('nr_cantidad'), 
                                                                'arr_detalle'   =>  $items->toArray()
                                                            ];
                                                        })->values()->toArray();
                                    return  [
                                        'nr_anio'       =>  $itemsPorAnio->first()->nr_anio,
                                        'nr_subtotal'   =>  $nr_subtotal,
                                        'arr_detalle'   =>  $itemsPorMes
                                    ];
                                })->values()->toArray();

            //  Se obtienen los items del año actual
            $anio_actual    =   array_filter($agrupar, function($item) use ($nr_anio) {
                                    return  $item['nr_anio'] == $nr_anio;
                                });
            $anio_actual    =   reset($anio_actual);

            //  Se obtienen los items del mes actual del año
            $mes_actual     =   array_filter($anio_actual['arr_detalle'], function ($item) use ($nr_mes) {
                                    return  $item['nr_mes'] == $nr_mes;
                                });
            $mes_actual     =   reset($mes_actual);

            //  Se obtienen los items del dia actual 
            $dia_actual     =   array_filter($mes_actual['arr_detalle'], function ($item) use ($nr_dia) {
                                    return  $item['nr_dia'] == $nr_dia;
                                });
            $dia_actual     =   reset($dia_actual);
        }
            

        return  [
            'nr_total'  =>  $nr_total,
            'resumen'   =>  $agrupar,
            'nr_anio'   =>  $nr_anio,
            'nr_mes'    =>  $nr_mes,
            'nr_dia'    =>  $nr_dia,
            'arr_anio'  =>  $anio_actual,
            'arr_mes'   =>  $mes_actual,
            'arr_dia'   =>  $dia_actual,
        ];
    }
    //------------------------------------------------------------
    public function capturarTicket(Request $request)
    {
        $nr_solicitud   =   intval($request->nr_solicitud);
        $nr_autor       =   Auth::user()->id;
        $tp_utilizar    =   1;
        $str_title      =   'Encuesta de Servicio de Atención Vecino';
        $str_msj        =   '';
        $arr_valida     =   ['error' => 2, 'tp_icon' => 'success', 'title' => $str_title, 'msj' => $str_msj];

        if($nr_solicitud)
        {
            Solicitud::where('id','=',$nr_solicitud)
            ->update([
                'tp_utilizar_encuesta'      =>  $tp_utilizar,
                'tp_utilizar_telefonista'   =>  $nr_autor
            ]);

            $str_msj        =   'Se ha capturado el Ticket';
            $arr_valida     =   ['error' => 2, 'tp_icon' => 'warning', 'title' => $str_title, 'msj' => $str_msj];
        }

        return $arr_valida;
    }
    //------------------------------------------------------------
    public function liberarTicket(Request $request)
    {
        $nr_solicitud   =   intval($request->nr_solicitud);
        $nr_autor       =   0;
        $tp_utilizar    =   0;
        $str_title      =   'Encuesta de Servicio de Atención Vecino';
        $str_msj        =   '';
        $arr_valida     =   ['error' => 2, 'tp_icon' => 'success', 'title' => $str_title, 'msj' => $str_msj];

        if($nr_solicitud)
        {
            Solicitud::where('id','=',$nr_solicitud)
            ->update([
                'tp_utilizar_encuesta'      =>  $tp_utilizar,
                'tp_utilizar_telefonista'   =>  $nr_autor
            ]);

            $str_msj        =   'Se ha liberado el Ticket';
            $arr_valida     =   ['error' => 2, 'tp_icon' => 'warning', 'title' => $str_title, 'msj' => $str_msj];
        }

        return $arr_valida;
    }
    //------------------------------------------------------------
    public function validaCaptutaTicket(Request $request)
    {
        $nr_solicitud   =   intval($request->nr_solicitud);
        $str_title      =   'Encuesta de Servicio de Atención Vecino';
        $str_msj        =   '';
        $arr_valida     =   ['error' => 2, 'tp_icon' => 'success', 'title' => $str_title, 'msj' => $str_msj];
        
        $data           =   User::
                            join('gsut_solicitud as solicitud','solicitud.tp_utilizar_telefonista','=','users.id')
                            ->select('solicitud.nr_ticket',
                                'users.nombre',
                                'users.ap_paterno',
                                'users.ap_materno',
                                DB::raw('concat(users.nombre," ",users.ap_paterno," ",users.ap_materno) as nm_encuestador'))
                            ->where('solicitud.tp_utilizar_encuesta','=','1')
                            ->where('solicitud.id','=',$nr_solicitud)
                            ->get();

        if($data->count())
        {
            $info           =   $data->first();
            $str_msj        =   'El Nro. de Ticket #'.$info->nr_ticket.' se encuentra siendo gestionado por "'.$info->nm_encuestador.'"';
            $arr_valida     =   ['error' => 1, 'tp_icon' => 'warning', 'title' => $str_title, 'msj' => $str_msj];
        }

        return $arr_valida;
    }
    //------------------------------------------------------------
    public function getRespuestas(Request $request)
    {
        $id_user        =   Auth::user()->id;
        $nr_solicitud   =   $request->nr_solicitud;

        $data   =   EncuestaLlamada::
                    join('users as telefonista','telefonista.id','=','gsut_encuesta_llamada.id_autor')
                    ->join('gsut_estado_encuesta as estado','estado.id','=','gsut_encuesta_llamada.id_estado')
                    ->select('gsut_encuesta_llamada.id',
                        'gsut_encuesta_llamada.id_solicitud',
                        'gsut_encuesta_llamada.id_autor',
                        'telefonista.nombre',
                        'telefonista.ap_paterno',
                        'telefonista.ap_materno',
                        DB::raw('concat(telefonista.nombre," ",telefonista.ap_paterno," ",telefonista.ap_materno) as nm_telefonista'),
                        'gsut_encuesta_llamada.nr_rut',
                        'gsut_encuesta_llamada.nr_prefijo',
                        'gsut_encuesta_llamada.nr_telefono',
                        'gsut_encuesta_llamada.str_observacion',
                        'gsut_encuesta_llamada.fc_inicio',
                        'gsut_encuesta_llamada.fc_termino',
                        'gsut_encuesta_llamada.fc_inicio_ring',
                        'gsut_encuesta_llamada.fc_termino_ring',
                        'gsut_encuesta_llamada.fc_inicio_contacto',
                        'gsut_encuesta_llamada.fc_termino_contacto',
                        'gsut_encuesta_llamada.fc_inicio_servicio',
                        'gsut_encuesta_llamada.fc_termino_servicio',
                        'gsut_encuesta_llamada.id_estado',
                        'estado.nm_estado',
                        'gsut_encuesta_llamada.tp_activo')
                    ->where('gsut_encuesta_llamada.id_solicitud','=',$nr_solicitud)
                    ->where('gsut_encuesta_llamada.tp_activo','1')
                    ->with('respuestas','vecino');

        $data   =   $data->groupBy('gsut_encuesta_llamada.id')->paginate(20);

        $data->getCollection()->transform(function ($value) {
            $value->tiempo_encuesta     =   UtilController::getTiempoTramitacionEncuesta($value->fc_inicio, $value->fc_termino);
            $value->tiempo_ring         =   UtilController::getTiempoTramitacionEncuesta($value->fc_inicio_ring, $value->fc_termino_ring);
            $value->tiempo_contacto     =   UtilController::getTiempoTramitacionEncuesta($value->fc_inicio_contacto, $value->fc_termino_contacto);
            $value->tiempo_servicio     =   UtilController::getTiempoTramitacionEncuesta($value->fc_inicio_servicio, $value->fc_termino_servicio);
            $value->tp_obs_encuesta     =   UtilController::isTicketTieneObservacionEncuesta($value->id_solicitud);
            $value->tiene_obs_encuesta  =   (UtilController::isTicketTieneObservacionEncuesta($value->id_solicitud) == 1) ? "SI" : "NO";

            if(in_array($value->id_estado,[3,4,6]))
                $value->tiempo_guardado     =   UtilController::getTiempoTramitacionEncuesta($value->fc_termino_contacto, $value->fc_termino);
            else if(in_array($value->id_estado,[5]))
                $value->tiempo_guardado     =   UtilController::getTiempoTramitacionEncuesta($value->fc_termino_servicio, $value->fc_termino);
            else
                $value->tiempo_guardado     =   '';
            return $value;
        });

        return [
            'pagination' => [
                'total'        => $data->total(),
                'current_page' => $data->currentPage(),
                'per_page'     => $data->perPage(),
                'last_page'    => $data->lastPage(),
                'from'         => $data->firstItem(),
                'to'           => $data->lastItem(),
            ],
            'info' => $data,
            'nr_atendidos'      =>  UtilController::getCantidadTicketAtendidosPorTelefonista($id_user),
            'nr_pendientes'     =>  UtilController::getCantidadSolicitudTelefonistasEstado($id_user, 1),
        ];
    }
    //------------------------------------------------------------
    public function getContactoRealizados(Request $request)
    {
        $nr_rut     =   $request->nr_rut;
        $vecino     =   null;

        $data       =   EncuestaLlamada::
                        join('users as telefonista','telefonista.id','=','gsut_encuesta_llamada.id_autor')
                        ->join('gsut_estado_encuesta as estado','estado.id','=','gsut_encuesta_llamada.id_estado')
                        ->join('gsut_solicitud as solicitud','solicitud.id','=','gsut_encuesta_llamada.id_solicitud')
                        ->join('gsut_direccion as dir','dir.id','=','solicitud.id_direccion_destino')
                        ->select('gsut_encuesta_llamada.id',
                            'gsut_encuesta_llamada.id_solicitud',
                            'gsut_encuesta_llamada.nr_rut',
                            'gsut_encuesta_llamada.id_autor',
                            'gsut_encuesta_llamada.id_estado',
                            'solicitud.nr_ticket',
                            'dir.nm_direccion',
                            'solicitud.nm_tipo as nm_servicio',
                            DB::raw('concat(telefonista.nombre," ",telefonista.ap_paterno," ",telefonista.ap_materno) as nm_telefonista'),
                            'gsut_encuesta_llamada.nr_prefijo',
                            'gsut_encuesta_llamada.nr_telefono',
                            'gsut_encuesta_llamada.fc_inicio',
                            'gsut_encuesta_llamada.str_observacion',
                            'estado.nm_estado',
                            'gsut_encuesta_llamada.tp_activo')
                        ->where('gsut_encuesta_llamada.nr_rut','=',$nr_rut)
                        ->get();

        $vecino     =   Vecino::
                        leftjoin('cut_region as region','region.id','=','gsut_vecino.id_region')
                        ->leftjoin('cut_comuna as comuna','comuna.id','=','gsut_vecino.id_comuna')
                        ->leftjoin('gsut_macroterritorio as mt','mt.id','=','gsut_vecino.id_macroterritorio')
                        ->leftjoin('gsut_unidadvecinal as uv','uv.id','=','gsut_vecino.id_unidadvecinal')
                        ->select('gsut_vecino.id',
                            'gsut_vecino.nr_rut',
                            'gsut_vecino.nm_vecino',
                            'gsut_vecino.ap_paterno',
                            'gsut_vecino.ap_materno',
                            DB::raw('(concat(gsut_vecino.nm_vecino," ",gsut_vecino.ap_paterno," ",gsut_vecino.ap_materno)) as nmc_vecino'),
                            'gsut_vecino.id_region',
                            'gsut_vecino.id_comuna',
                            'gsut_vecino.id_ubicacion',
                            'gsut_vecino.id_macroterritorio',
                            'gsut_vecino.id_unidadvecinal',
                            'region.nm_region',
                            'comuna.nm_comuna',
                            'mt.cod_territorio',
                            'mt.nm_territorio',
                            'uv.nm_unidadvecinal',
                            'gsut_vecino.nr_calle',
                            'gsut_vecino.nm_calle',
                            'gsut_vecino.nm_ubicacion',
                            'gsut_vecino.tp_direccion',
                            'gsut_vecino.str_latitud',
                            'gsut_vecino.str_longitud',
                            'gsut_vecino.str_aclaratoria',
                            'gsut_vecino.nr_prefijo',
                            'gsut_vecino.nr_telefono',
                            'gsut_vecino.nm_mail',
                            'gsut_vecino.tp_vecino',
                            'gsut_vecino.id_autor',
                            'gsut_vecino.tp_activo')
                        ->where('gsut_vecino.nr_rut','=',$nr_rut)
                        ->get();

        return ['llamados' => $data, 'vecino' => ($vecino->count()) ? $vecino->first() : null];
    }
    //------------------------------------------------------------
}
