<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Exports\ExportSolicitudes;
use Maatwebsite\Excel\Facades\Excel;

class ExportarController extends Controller
{
    //------------------------------------------------------------
    public function exportSolicitudes(Request $request)
    {
        set_time_limit(0);
        ini_set('memory_limit','-1');
        $fecha_actual   =   date("dmYHis");

        $fl_mostrar         =   (isset($request->fl_mostrar) && $request->fl_mostrar != 'undefined') ? $request->fl_mostrar : 0;
        $fl_direccion       =   (isset($request->fl_direccion) && $request->fl_direccion != 'undefined') ? $request->fl_direccion : 0;
        $fl_depto           =   (isset($request->fl_depto) && $request->fl_depto != 'undefined') ? $request->fl_depto : 0;
        $fl_servicio        =   (isset($request->fl_servicio) && $request->fl_servicio != 'undefined') ? $request->fl_servicio : 0;
        $fl_macrozona       =   (isset($request->fl_macrozona) && $request->fl_macrozona != 'undefined') ? $request->fl_macrozona : 0;
        $fl_unidadvecinal   =   (isset($request->fl_unidadvecinal) && $request->fl_unidadvecinal != 'undefined') ? $request->fl_unidadvecinal : 0;
        $fl_ticket          =   (isset($request->fl_ticket) && $request->fl_ticket != 'undefined') ? $request->fl_ticket : 0;
        $fl_motivo          =   (isset($request->fl_motivo) && $request->fl_motivo != 'undefined') ? $request->fl_motivo : 0;
        $fl_ubicacion       =   (isset($request->fl_ubicacion) && $request->fl_ubicacion != 'undefined') ? $request->fl_ubicacion : 0;
        $fl_persona         =   (isset($request->fl_persona) && $request->fl_persona != 'undefined') ? $request->fl_persona : 0;
        $tp_criterio        =   (isset($request->tp_criterio) && $request->tp_criterio != 'undefined') ? $request->tp_criterio : '';
        $tp_orden           =   (isset($request->tp_orden) && $request->tp_orden != 'undefined') ? $request->tp_orden : '';
        $fc_desde           =   (isset($request->fc_desde) && $request->fc_desde != 'undefined') ? $request->fc_desde : Date('d-m-Y',(strtotime('-90 day', strtotime(Date('d-m-Y')))));
        $fc_hasta           =   (isset($request->fc_hasta) && $request->fc_hasta != 'undefined') ? $request->fc_hasta : Date('d-m-Y');

        return Excel::download(new ExportSolicitudes(
            $tp_criterio, 
            $tp_orden, 
            $fl_mostrar, 
            $fc_desde, 
            $fc_hasta, 
            $fl_direccion, 
            $fl_depto, 
            $fl_servicio, 
            $fl_macrozona, 
            $fl_unidadvecinal, 
            $fl_ticket, 
            $fl_motivo, 
            $fl_ubicacion,
            $fl_persona
        ), 'solicitudes_hasta_'.$fecha_actual.'.xlsx');
    }
    //------------------------------------------------------------
}
