<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Solicitud;
use DB;
use Validator;
use Freshwork\ChileanBundle\Rut;
use Illuminate\Support\Facades\Auth;
use App\Prioridad;
use App\Vecino;
use App\Direccion;
use App\UnidadVecinal;
use App\User;
use App\Historial;
use App\Respuesta;

use App\Http\Requests\SolicitudRequest;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Session;

//Controladores
use App\Http\Controllers\GsutTipoController;
use App\Http\Controllers\GsutPrioridadController;
use App\Http\Controllers\EmailController;
use App\Http\Controllers\MaestroDireccionesController;
use App\Http\Controllers\DireccionMunicipalController;
use App\Http\Controllers\UtilController;
use App\Http\Controllers\GsutFlujoController;
use App\Http\Controllers\GsutHistoriaController;


class FuncionarioController extends Controller
{
    public function storeRespuesta(Request $request)
    {
        $opcion             =   $request->opcion;
        $str_observacion    =   $request->str_observacion;
        $str_html           =   $request->str_observacion_html;
        $nr_id              =   $request->nr_id;
        $tp_validar         =   $request->tp_validar;
        $id_user            =   Auth::user()->id;
        $id_dir_autor       =   Auth::user()->id_direccion;
        $id_depto_autor     =   Auth::user()->id_depto;
        $id_rol             =   Auth::user()->id_rol;
        $tp_admin           =   Auth::user()->tp_admin;
        $nr_nivel           =   Auth::user()->nr_nivel;
        $hoy                =   Date("Y-m-d H:i:s");
        $tp_ingreso         =   4;
        $max_historia       =   1;
        $new_estado         =   4; // En Revision
        $arr_archivo        =   $request->arr_archivo;
        $arr_observacion    =   $request->arr_observacion;
        $id_tb_respuesta    =   0;
        $tp_respuesta       =   0;
        $tp_validado        =   0;
        $nr_fuente          =   $request->nr_fuente;
        $valida             =   ['error' => 0];
        //---------------------------------------------------------------------------------
        $title  =   ''; // ($opcion == 0) ? 'Registrar Respuesta' : 'Registrar Publicación';
        $msj    =   ''; // ($opcion == 0) ? 'Respuesta Ingresada Exitosamente' : 'Publicación Ingresada Exitosamente';
        //---------------------------------------------------------------------------------
        /*
        dd([
            'request'  =>  $request->all(),
        ]);
        */
        try {
            //---------------------------------------------------------------------------------
            // Si ingresa una publicación o un rechazo, se resetean los campos
            if(in_array($opcion, [1,2,5,6,8,9,10,11]) && !in_array($id_rol, [7,21])) // if(in_array($opcion, [1,2,5,6,8,9,10,11]) && in_array($tp_admin, [0,3]))
            {
                Solicitud::
                where('id','=',$nr_id)
                ->update([
                    'tp_director'   =>  0,
                    'fc_director'   =>  null,
                    'tp_jefedepto'  =>  0,
                    'fc_jefedepto'  =>  null
                ]);
            }

            $max_historia   =   Historial::where('id','=',$nr_id)->max('nr_historia');
            $solicitud      =   UtilController::getDataSolicitud($nr_id);
            $servicio       =   UtilController::getDataServicio($solicitud->id_tipo);
            $usuario        =   UtilController::getDataUser();
            $respuesta      =   UtilController::getDataRespuesta($nr_fuente);
            $vb_director    =   UtilController::directorTieneSolicitudPendiente($solicitud->id);
            $vb_depto       =   UtilController::jefeDeptoTieneSolicitudPendiente($solicitud->id);
            $valida         =   UtilController::solicitudTieneGestionesSinValidar($id_rol, $solicitud, $respuesta);

            if(in_array($solicitud->id_estado, [5,6]) && !in_array($opcion, [7]))
            {
                $nm_opcion  =   ($solicitud->id_estado == 5) ? 'Cerrada' : 'Terminada';
                $valida     =   [
                    'error'     =>  0,
                    'existe'    =>  1,
                    'tp_icon'   =>  'warning',
                    'title'     =>  'Comprobación de Estado de Solicitud',
                    'msj'       =>  'No es posible registrar la respuesta, ya que la Solicitud #'.$solicitud->nr_ticket.' se encuentra "'.$nm_opcion.'". <br>'
                                    .'Si requiere ingresar alguna información adicional a la solicitud, esta debe ser ingresada como "Expediente".',
                ];

                return $valida;
            }

            // Si no es una Respuesta Interna, valida si Existen Publicaciones Parciales o Difinitivas sin Validar por el Encargado de la Unidad
            // if($valida['error'] == 1 && $id_rol != 7 && in_array($opcion, [8,9]) && $tp_validar != 1 && !in_array($solicitud->id_estado, [5,6,7])) 
            if($valida['error'] == 1 && !in_array($id_rol, [7,21,23]) && in_array($opcion, [8,9]) && $tp_validar != 1 && !in_array($solicitud->id_estado, [5,6,7])) 
                return $valida;
            // if($vb_depto['error'] == 1 && ($id_rol == 7 && $tp_admin == 3 && $tp_validar != 1) && !in_array($solicitud->id_estado, [5,6,7]))
            if($vb_depto['error'] == 1 && (in_array($id_rol, [23]) && $tp_validar != 1) && !in_array($solicitud->id_estado, [5,6,7]))
                return $vb_depto;
            // if($vb_director['error'] == 1 && ($id_rol == 7 && $tp_admin == 2 && $tp_validar != 1) && !in_array($solicitud->id_estado, [5,6,7]))
            if($vb_director['error'] == 1 && (in_array($id_rol, [21]) && $tp_validar != 1) && !in_array($solicitud->id_estado, [5,6,7]))
                return $vb_director;

            /*
                tp_respuesta    
                0.  Respuesta Interna
                1.  Publicación Definitiva
                2.  Publicación Parcial
                3.  Pre-Publicación Definitiva
                4.  Pre-Publicación Parcial 
                5.  Rechazo Pre-Publicación Definitiva
                6.  Rechazo Pre-Publicación Parcial
                7.  Expediente 
                8.  VB Jefatura
                9.  VB Director 
                10. Rechazo VB Jefactura
                11. Rechazo VB Director
                12. Respuesta Automatica - Enviada
                13. Respuesta Automatica - Fallida
            */

            //---------------------------------------------------------------------------------
            // Valida permisos del Usuario
            //---------------------------------------------------------------------------------
            // if($opcion == 1 && $tp_validar == 1 && $id_rol == 7 && $usuario->tp_finalizar == 0 && $usuario->tp_vb_director == 1)
            if($opcion == 1 && $tp_validar == 1 && in_array($id_rol, [7,21,23]) && $usuario->tp_finalizar == 0 && $usuario->tp_vb_director == 1)
                $tp_respuesta   =   9;
            else
                $tp_respuesta   =   $opcion;          
            //---------------------------------------------------------------------------------
            $arr_log    =   [
                'tp_respuesta'  =>  $tp_respuesta,
                'request'       =>  $request->all(),
                'usuario'       =>  ($usuario) ? $usuario->toArray() : null,
                'solicitud'     =>  [
                                        'nr_solicitud'  =>  $solicitud->id,
                                        'nr_ticket'     =>  $solicitud->nr_ticket,
                                        'nr_estado'     =>  $solicitud->id_estado,
                                        'tp_director'   =>  $solicitud->tp_director,
                                        'fc_director'   =>  $solicitud->fc_director,
                                        'tp_jefedepto'  =>  $solicitud->tp_jefedepto,
                                        'fc_jefedepto'  =>  $solicitud->fc_jefedepto,
                                    ],
                'servicio'      =>  $servicio->toArray(),
                'respuesta'     =>  ($respuesta) ? $respuesta->toArray() : null,
                'Funcionario'   =>  $valida,
                'director'      =>  $vb_director,
                'depto'         =>  $vb_depto,
            ];
            //---------------------------------------------------------------------------------
            \Log::debug(__METHOD__ . " datos de respuesta : " . print_r($arr_log, true));
            // dd(['arr_log' => $arr_log]);
            //---------------------------------------------------------------------------------
            $arr_respuestas     =   $this->getTipoRespuesta($tp_respuesta);
            $title  =   $arr_respuestas->title;
            $msj    =   $arr_respuestas->msj;

            $valida =   [
                'error'     =>  0,
                'existe'    =>  1,
                'tp_icon'   =>  'success',
                'title'     =>  $title,
                'msj'       =>  $msj,
            ];
            //---------------------------------------------------------------------------------
            //Ingreso de respuesta
            $modelo                         =   new Respuesta();
            $modelo->id_solicitud           =   $nr_id;
            $modelo->id_direccion           =   $id_dir_autor;
            $modelo->id_depto               =   $id_depto_autor;
            $modelo->id_autor               =   $id_user;
            $modelo->fc_ingreso             =   $hoy;
            $modelo->str_observacion        =   $str_observacion;
            $modelo->str_observacion_html   =   $str_html;
            $modelo->id_historia            =   $max_historia;
            $modelo->str_ruta_adjunto       =   ''; // faltante
            $modelo->tp_respuesta           =   $tp_respuesta;

            if(in_array($id_rol, [7,21,23])) // Si es Administrador // if($id_rol == 7) // Si es Administrador
            {
                $modelo->tp_validado    =   $tp_validado;
                $modelo->nr_fuente      =   $nr_fuente;
            }

            $modelo->save();
            $id_tb_respuesta            =   $modelo->id;
            //---------------------------------------------------------------------------------
            // Si la publicación la valida el Director, se actualizan las tablas correspondientes
            // if(($solicitud->tp_director == 0 && $usuario->tp_vb_director == 1) && ($id_rol == 7 && in_array($tp_admin, [2,3])) || $vb_director['error'] == 1)
            if(($solicitud->tp_director == 0 && $usuario->tp_vb_director == 1) && in_array($id_rol, [21,23]) || $vb_director['error'] == 1)
            {
                if(!in_array($tp_respuesta, [5,6]))
                    Solicitud::
                    where('id','=',$nr_id)
                    ->update([
                        'tp_director'   =>  1,
                        'fc_director'   =>  $hoy
                    ]);

                Respuesta::
                where('id','=',$nr_fuente)
                ->update([
                    'tp_validado'   =>  1
                ]);
            }
            //---------------------------------------------------------------------------------
            // Si la publicación la valida el Encargado del Depto., se actualizan las tablas correspondientes
            // if(($solicitud->tp_jefedepto == 0 && $usuario->tp_vb_depto == 1) && ($id_rol == 7 && in_array($tp_admin, [2,3])) || $vb_depto['error'] == 1)
            if(($solicitud->tp_jefedepto == 0 && $usuario->tp_vb_depto == 1) && in_array($id_rol, [21,23]) || $vb_depto['error'] == 1)
            {
                if(!in_array($tp_respuesta, [5,6]))
                    Solicitud::
                    where('id','=',$nr_id)
                    ->update([
                        'tp_jefedepto'  =>  1,
                        'fc_jefedepto'  =>  $hoy
                    ]);

                Respuesta::
                where('id','=',$nr_fuente)
                ->update([
                    'tp_validado'   =>  1
                ]);
            }
            //---------------------------------------------------------------------------------
            $solicitud      =   UtilController::getDataSolicitud($nr_id);
            //---------------------------------------------------------------------------------
            // Se actualiza el estado de la solicictud
            //---------------------------------------------------------------------------------
            // if(($usuario->tp_vb_director == 0 && $usuario->tp_vb_depto == 0) || 
            //     ($usuario->tp_vb_director == 1 && $solicitud->tp_director == 1) || 
            //     ($usuario->tp_vb_depto == 1 && $solicitud->tp_jefedepto == 1) || 
            //     ($id_rol == 7 && in_array($tp_admin, [1,2])))
            if(in_array($id_rol, [5,7,21,23,33]) && $tp_respuesta == 1)
            {
                $tp_vecino  =   $solicitud->tp_vecino;

                if($tp_vecino == 1)
                    $new_estado  = 5; // Publicada
                else
                    $new_estado  = 6; // Finalizada

                GsutHistoriaController::registrarHistoria($nr_id, $solicitud->id_tipo, $str_observacion, $str_html, $new_estado, $hoy, $hoy);

                Solicitud::
                where('id','=',$nr_id)
                ->update([
                    'fc_publicado'  =>  $hoy,
                ]);
            }

            if($tp_respuesta != 7)
            {
                if($solicitud->tp_revisado == 0)
                {
                    Solicitud::
                    where('id','=',$nr_id)
                    ->update([
                        'tp_revisado'   =>  1,
                        'fc_revisado'   =>  $hoy,
                        'id_estado'     =>  $new_estado
                    ]);
                }
                else
                {
                    Solicitud::
                    where('id','=',$nr_id)
                    ->update([
                        'id_estado'     =>  $new_estado
                    ]);
                }
            }

            // Carga de archivo
            ArchivosController::registrarArchivo('tb_respuesta', $id_tb_respuesta, $arr_archivo, $arr_observacion);

            // Replicar Archivo adjunto de Respuesta replicarAdjunto($nr_id_old, $nr_id_new, $tp_tabla = 'tb_respuesta')
            UtilController::replicarAdjunto($nr_fuente, $id_tb_respuesta, 'tb_respuesta');
            //---------------------------------------------------------------------------------
            /*
            $arr_log    =   [
                'id_rol'        =>  $id_rol,
                'tp_respuesta'  =>  $tp_respuesta,
                'request'       =>  $request->all(),
                'usuario'       =>  ($usuario) ? $usuario->toArray() : null,
                'solicitud'     =>  [
                                        'nr_solicitud'  =>  $solicitud->id,
                                        'nr_ticket'     =>  $solicitud->nr_ticket,
                                        'nr_estado'     =>  $solicitud->id_estado,
                                        'tp_director'   =>  $solicitud->tp_director,
                                        'fc_director'   =>  $solicitud->fc_director,
                                        'tp_jefedepto'  =>  $solicitud->tp_jefedepto,
                                        'fc_jefedepto'  =>  $solicitud->fc_jefedepto,
                                    ],
                'respuesta'     =>  ($respuesta) ? $respuesta->toArray() : null,
                'valida'        =>  $valida,
            ];
            */
            //---------------------------------------------------------------------------------
            // \Log::debug(__METHOD__ . " Se envia notificación para : " . print_r($arr_log, true));
            //---------------------------------------------------------------------------------
            // Notificación de Mail
            //---------------------------------------------------------------------------------
            if($tp_respuesta == 1)
            {
                EmailController::enviarNotificacionVecino(103, $nr_id, $str_html); // Notificación a Vecino

                if($solicitud->id_tipo != 51) // Servicio de Podas y Arbolado Urbano
                    EmailController::enviarNotificaciones($tp_ingreso, $nr_id); // Notificación via mail
            }
            else if($tp_respuesta == 2)
            {
                EmailController::enviarNotificacionVecino(102, $nr_id, $str_html); // Notificación a Vecino

                if($solicitud->id_tipo != 51) // Servicio de Podas y Arbolado Urbano
                    EmailController::enviarNotificaciones($tp_ingreso, $nr_id); // Notificación via mail
            }
            else if($tp_respuesta == 7)
            {
                $tp_notificar   =   10; // Notificación de Expediente
                EmailController::enviarNotificaciones(10, $nr_id);
            }
            else if($tp_respuesta == 8)
            {
                $tp_notificar   =   15; // // Notificación VB Jefatura
                EmailController::enviarNotificaciones($tp_notificar, $nr_id);
            }
            else if($tp_respuesta == 9)
            {
                $tp_notificar   =   16; // Notificación VB Director
                EmailController::enviarNotificaciones($tp_notificar, $nr_id);
            }
            else
            {
                EmailController::enviarNotificaciones($tp_ingreso, $nr_id); // Notificación via mail
            }
            //---------------------------------------------------------------------------------
        } catch (Exception $e) {
            $msj    =   ($tp_respuesta == 0) ? 
                            'Ha ocurrido un problema al registrar la respuesta' : 
                            'Ha ocurrido un problema al registrar la publicación';

            $valida =   [
                'error'     =>  1,
                'existe'    =>  1,
                'tp_icon'   =>  'danger',
                'title'     =>  $title,
                'msj'       =>  $msj,
            ];
        }

        return $valida;
    }

    public function indexFuncionario(Request $request)
    {
        $id_user        =   Auth::user()->id;
        $id_depto       =   Auth::user()->id_depto; 
        $id_direccion   =   Auth::user()->id_direccion;
        $nr_nivel       =   Auth::user()->nr_nivel;
        $fl_mostrar     =   $request->fl_mostrar;
        $fl_tipo        =   $request->fl_tipo;
        $fl_vecino      =   $request->fl_persona;
        $fl_dir         =   $request->fl_direccion;
        $fl_uv          =   $request->fl_unidadvecinal;
        $fl_ticket      =   $request->fl_ticket;
        $fl_ubicacion   =   $request->fl_ubicacion;
        $page           =   $request->page;
        $propias        =   $request->propias;
        $fc_desde       =   $request->fc_desde;
        $fc_hasta       =   $request->fc_hasta;

        $data           =   Solicitud:: 
                            join('gsut_prioridad as prioridad','prioridad.id','=','gsut_solicitud.id_prioridad')
                            ->join('gsut_motivo as motivo','motivo.id','=','gsut_solicitud.id_motivo')
                            ->join('gsut_tipo as tipo','tipo.id','=','gsut_solicitud.id_tipo')
                            ->join('gsut_estado as estado','estado.id','=','gsut_solicitud.id_estado')
                            ->join('gsut_direccion as dir_destino','dir_destino.id','=','gsut_solicitud.id_direccion_destino')
                            ->join('gsut_depto as depto_destino','depto_destino.id','=','gsut_solicitud.id_depto_destino')
                            ->leftjoin('gsut_macroterritorio as mt','mt.id','=','gsut_solicitud.id_macroterritorio')
                            ->leftjoin('gsut_unidadvecinal as uv','uv.id','=','gsut_solicitud.id_unidadvecinal')
                            ->join('gsut_tipo_ingreso as ti','ti.id','=','gsut_solicitud.tp_ingreso')
                            ->select('gsut_solicitud.id',
                                'gsut_solicitud.nr_ticket',
                                'gsut_solicitud.id_municipio',
                                'gsut_solicitud.id_direccion',
                                'gsut_solicitud.id_depto',
                                'gsut_solicitud.id_tipo',
                                'gsut_solicitud.nm_tipo',
                                'gsut_solicitud.id_prioridad',
                                'gsut_solicitud.id_motivo',
                                'motivo.nm_motivo',
                                'gsut_solicitud.tp_clonado',
                                'gsut_solicitud.str_clonado',
                                'gsut_solicitud.str_clonado_html',
                                'gsut_solicitud.nr_fuente',
                                'gsut_solicitud.id_direccion_destino',
                                'dir_destino.nm_direccion as nm_direccion_destino',
                                'gsut_solicitud.id_depto_destino',
                                'depto_destino.nm_depto as nm_depto_destino',
                                'gsut_solicitud.id_ubicacion',
                                'gsut_solicitud.id_macroterritorio',
                                'mt.cod_territorio',
                                'gsut_solicitud.id_unidadvecinal',
                                'uv.cod_unidadvecinal',
                                'uv.nm_unidadvecinal',
                                'gsut_solicitud.tp_direccion',
                                'gsut_solicitud.nr_direccion',
                                'gsut_solicitud.nm_direccion',
                                'gsut_solicitud.nm_ubicacion',
                                'gsut_solicitud.str_latitud',
                                'gsut_solicitud.str_longitud',
                                'gsut_solicitud.nr_rut_vecino',
                                'gsut_solicitud.str_observacion',
                                'gsut_solicitud.str_observacion_html',
                                'gsut_solicitud.str_aclaratoria',
                                'gsut_solicitud.tp_visado_mt',
                                'gsut_solicitud.tp_rechazado',
                                'gsut_solicitud.id_estado',
                                'estado.nm_estado',
                                'estado.nm_color',
                                'gsut_solicitud.contexto_municipal',
                                'gsut_solicitud.tp_ingreso',
                                'ti.nm_ingreso',
                                'gsut_solicitud.id_autor',
                                'gsut_solicitud.tp_activo',
                                'gsut_solicitud.tp_feedback',
                                'gsut_solicitud.tp_recepcion',
                                'gsut_solicitud.tp_satisfaccion',
                                'gsut_solicitud.str_feedback',
                                'gsut_solicitud.fc_publicado',
                                'gsut_solicitud.fc_creacion as fc_ingreso',
                                'gsut_solicitud.created_at',
                                'gsut_solicitud.updated_at as fc_tramitacion')
                            ->selectRaw("(case when tp_vecino = 1 then 'SI' else 'NO' end) as tp_vecino")
                            ->where('gsut_solicitud.tp_activo','=',1)
                            //->orderBy('gsut_solicitud.created_at','DESC')
                            ->with('tipo','prioridad','vecino','archivos','ubicacion','asignados','archivos_asignacion','solicitud','derivacion');

        /* ----- Inicio - Filtro Bandeja ----- */
            if($propias == 1)
                $data   =   $data->where('gsut_solicitud.id_autor','=',$id_user);
            else
                $data   =   $data->join('gsut_encargado_solicitud as es','es.id_solicitud','=','gsut_solicitud.id')
                                 ->where('es.id_encargado','=',$id_user)
                                 ->where('es.tp_activo','=',1)
                                 ->whereNotIn('gsut_solicitud.id_autor',[$id_user]);
        /* ----- Termino - Filtro Bandeja ----- */

        /* ----- Inicio - Filtro ----- */
            if($fl_mostrar != 0)
            {
                if($fl_mostrar != 5)
                    $data   =   $data->where('gsut_solicitud.id_estado','=',$fl_mostrar);
                else
                    $data   =   $data->whereIn('gsut_solicitud.id_estado',[5,6]);
            }

            if(isset($fl_direccion)) 
                $data   =   $data->where('gsut_solicitud.id_direccion_destino','=',$fl_direccion);

            if(isset($fl_depto)) 
                $data   =   $data->where('gsut_solicitud.id_depto_destino','=',$fl_depto);

            if(isset($fl_ingreso))
                $data   =   $data->where('gsut_solicitud.tp_ingreso','=',$fl_ingreso);

            if(isset($fl_servicio))
                $data   =   $data->where('gsut_solicitud.id_tipo','=',$fl_servicio);

            if(isset($fl_macrozona))
                $data   =   $data->where('gsut_solicitud.id_macroterritorio','=',$fl_macrozona);

            if(isset($fl_undvecinal))
                $data   =   $data->where('gsut_solicitud.id_unidadvecinal','=',$fl_undvecinal);

            if(isset($fl_ticket))
                $data   =   $data->where('gsut_solicitud.nr_ticket','=',$fl_ticket);

            if(isset($fl_vecino))
                $data   =   $data->where('gsut_solicitud.nr_rut_vecino','=',$fl_vecino);

            if(isset($fl_motivo))
                $data   =   $data->where('gsut_solicitud.id_motivo','=',$fl_motivo);

            if(isset($fl_ubicacion))
                $data   =   $data->where('gsut_solicitud.id_ubicacion','=',$fl_ubicacion);

            if(isset($fc_desde) && isset($fc_hasta))
            {
                $fc_desde   =   Carbon::parse($fc_desde)->format('Y-m-d');
                $fc_hasta   =   Carbon::parse($fc_hasta)->format('Y-m-d');
                $data       =   $data->whereDate('gsut_solicitud.created_at','>=',$fc_desde)
                                     ->whereDate('gsut_solicitud.created_at','<=',$fc_hasta);
            }
        /* ----- Termino - Filtro ----- */

        $data   =   $data->groupBy('gsut_solicitud.id')->paginate(20);

        $data->getCollection()->transform(function ($value) {
            $value->tiempo_tramitado    =   UtilController::getTiempoTramitacion($value->fc_ingreso, $value->fc_publicado, $value->id_estado);
            $value->tiene_pp            =   (UtilController::getCantidadRespuestas(2, $value->id) != 0) ? 'SI' : 'NO'; // Tiene Publicaciones Parciales
            return $value;
        });

        return [
            'pagination' => [
                'total'        => $data->total(),
                'current_page' => $data->currentPage(),
                'per_page'     => $data->perPage(),
                'last_page'    => $data->lastPage(),
                'from'         => $data->firstItem(),
                'to'           => $data->lastItem(),
            ],
            'info'          => $data,
            'nr_propias'    => UtilController::ContadorSolicitudes(0),
            'nr_bandeja'    => UtilController::ContadorSolicitudes(1),
        ];
    }

    public function index($tp_destino)
    {
        $destino    =   '';
        $id_usuario =   Auth::user()->id;
        $id_rol     =   Auth::user()->id_rol;
        $rol_actual =   UtilController::getRolActivo($id_usuario);
        $roles      =   UtilController::listarRolesUsuario($id_usuario);

        if($tp_destino == 'inicio')
            $destino = 'funcionario.inicio_funcionario';

        if($tp_destino == 'ingreso')
            $destino = 'funcionario.ingreso_funcionario';

        if($tp_destino == 'listado')
            $destino = 'funcionario.mis_solicitudes_funcionario';

        if($tp_destino == 'bandeja')
            $destino = 'funcionario.bandeja_funcionario';

        if($tp_destino == 'consulta')
            $destino = 'funcionario.consulta_funcionario';

        if($tp_destino == 'dashboard_rrss')
            $destino = 'funcionario.dashboard_redes_sociales';

        return view($destino)
                ->with('id_rol',$id_rol)
                ->with('rol_actual',$rol_actual)
                ->with('data',$roles)
                ->with('count',count($roles));        
    }

    private function getTipoRespuesta($tp_respuesta)
    {
        $title  =   'Registrar Respuesta';
        $msj    =   'Respuesta Ingresada Exitosamente';

        switch($tp_respuesta)
        {
            case 0: // 0 => Respuesta Interna
            {
                $title  =   'Registro de Respuesta';
                $msj    =   'Se ha registrado exitosamente la respuesta interna.';

                break;
            }
            case 1: // 1 => Publicación Definitiva
            {
                $title  =   'Registro de Publicación Definitiva';
                $msj    =   'Se ha registrado exitosamente la publicación definitiva al vecino.';

                break;
            }
            case 2: // 2 => Publicación Parcial
            {
                $title  =   'Registro de Publicación Parcial';
                $msj    =   'Se ha registrado exitosamente la publicación parcial al vecino.';

                break;
            }
            case 3: // 3 => Pre-Publicación Definitiva
            {
                $title  =   'Registro de Pre-Publicación Definitiva';
                $msj    =   'Se ha registrado exitosamente la pre-publicación definitiva.';

                break;
            }
            case 4: // 4 => Pre-Publicación Parcial
            {
                $title  =   'Registro de Pre-Publicación Parcial';
                $msj    =   'Se ha registrado exitosamente la pre-publicación parcial.';

                break;
            }
            case 5: // 5 => Rechazo de Pre-Publicación Definitiva
            {
                $title  =   'Rechazo de Pre-Publicación Definitiva';
                $msj    =   'Se ha registrado el rechazo de la pre-publicación definitiva.';

                break;
            }
            case 6: // 6 => Rechazo de Pre-Publicación Parcial
            {
                $title  =   'Rechazo de Pre-Publicación Parcial';
                $msj    =   'Se ha registrado el rechazo de la pre-publicación parcial.';

                break;
            }
            case 7: // 7 => Expediente
            {
                $title  =   'Registro de Expediente';
                $msj    =   'Se ha registrado exitosamente el expediente.';

                break;
            }
            case 8: // 7 => VB Jefatura
            {
                $title  =   'Registro de VB Jefatura';
                $msj    =   'Se ha registrado exitosamente el VB Jefatura.';

                break;
            }
            case 9: // 7 => VB Director
            {
                $title  =   'Registro de VB Director';
                $msj    =   'Se ha registrado exitosamente el VB Director.';

                break;
            }
            case 10: // 7 => Rechazo VB Jefatura
            {
                $title  =   'Registro de Rechazo VB';
                $msj    =   'Se ha registrado exitosamente el rechazo VB Jefatura.';

                break;
            }
            case 11: // 7 => Rechazo VB Director
            {
                $title  =   'Registro de Rechazo VB';
                $msj    =   'Se ha registrado exitosamente el rechazo VB Director.';

                break;
            }
        }

        return ( (Object) [
            'title'     =>  $title,
            'msj'       =>  $msj,
        ]);
    }
}
