<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Estado;

class GsutEstadoController extends Controller
{
    public function index()
    {
        $data   =   Estado::
                    select('gsut_tipo.id',
                        'nm_estado',
                        'tp_activo');

        $data   =   $data->paginate(50);

        return [
            'pagination' => [
                'total'        => $data->total(),
                'current_page' => $data->currentPage(),
                'per_page'     => $data->perPage(),
                'last_page'    => $data->lastPage(),
                'from'         => $data->firstItem(),
                'to'           => $data->lastItem(),
            ],
            'info' => $data
        ];
    }

    public function listado()
    {
        $data   =   Estado::
                    select('id as value','nm_estado as label')
                    ->where('tp_activo','=',1)
                    ->get();

        return ['estado' => $data];
    }
}
