<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\MessageBag;
use Illuminate\Support\Facades\Hash;
use App\User;
use Auth;
use DB;
use Illuminate\Support\Facades\Session;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function update_pass(Request $request)
    {
        $new_pass  = $request->new_pass;
        $rnew_pass = $request->rnew_pass;
        $user_id   = Auth::user()->id;


        if($rnew_pass == $new_pass)
        {
            $user            = User::findOrFail($user_id);
            $user->password  = bcrypt($new_pass);
            $user->save();

            return ['error'=>0,'mensaje'=>'Contraseña Actualizada'];
        }
        
        return ['error'=>1,'mensaje'=>'Error al actualizar Contraseña'];       
    }

    public function index()
    {
        $destino    =   '';
        $id_user    =   Auth::user()->id;
        $id_rol     =   Auth::user()->id_rol;
        $propias    =   0;
        $bandeja    =   0;
        $rol_actual =   UtilController::getRolActivo($id_user);
        $roles      =   UtilController::listarRolesUsuario($id_user);

        if($id_rol == 1) // Territorial
            $destino    =   'territorial.inicio_territorial';

        if($id_rol == 3) // Macrozona
            $destino    =   'macro_zona.inicio_macrozona';

        if($id_rol == 5) // Funcionario
            $destino    =   'funcionario.inicio_funcionario';
    
        if($id_rol == 7) // Administrador
            $destino    =   'administrador.inicio_administrador';

        if($id_rol == 11) // Concejal
            $destino    =   'concejal.inicio_concejal';

        if($id_rol == 9) // Asignador
            $destino    =   'asignador.inicio_asignador';

        if($id_rol == 13) // Observador
            $destino    =   'observador.inicio_observador';

        if($id_rol == 15) // Redes Sociales
            $destino    =   'redes_sociales.inicio_rrss';

        if($id_rol == 17) // Reuniones Comunitarias
            $destino    =   'audiencias.inicio_rrcc';

        if($id_rol == 19) // Supervisor Territorial
            $destino    =   'supervisor_territorial.inicio_supervisor';

        if($id_rol == 21) // Administrador Director
            $destino    =   'administrador.inicio_administrador';

        if($id_rol == 23) // Administrador Depto
            $destino    =   'administrador.inicio_administrador';

        if($id_rol == 25) // Encuestador
            $destino    =   'encuestador.inicio_encuestador';

        if($id_rol == 27) // Visualizador Dirección
            $destino    =   'visualizador.inicio_visualizador';

        if($id_rol == 29) // Visualizador Depto
            $destino    =   'visualizador.inicio_visualizador';

        if($id_rol == 31) // Telefonista
            $destino    =   'telefonista.inicio_telefonista';

        if($id_rol == 33) // Revisor
            $destino    =   'revisor.inicio_revisor';

        if($id_rol == 35) // IA Atenció Vecino
            $destino    =   'ia_gpt.inicio_ia';

        if($id_rol == 37) // Seguridad Informática
            $destino    =   'seguridad_ti.inicio_seguridad_ti';

        return view($destino)
                ->with('id_rol',$id_rol)
                ->with('rol_actual',$rol_actual)
                ->with('data',$roles)
                ->with('count',count($roles));
    }

    public function cambiar_clave()
    {
        return view('opciones.all.cambiar_clave.create');
    }

    public function cambiar_clave_store(Request $request)
    {
        //return redirect()->route('home');
        $message_bag = new MessageBag;

        $customMessages = [
            'required'  => 'El campo es requerido.',
            'clave_nueva_repetir.same' => 'El correo debe ser igual al anterior.',
        ];

        $validator = Validator::make($request->all(), [
            'clave_actual'          => 'required',
            'clave_nueva'           => 'required',
            'clave_nueva_repetir'   => 'required|same:clave_nueva',
        ],$customMessages);

        if ($validator->fails())
            return redirect()->back()->withErrors($validator)->withInput($request->all());

        $usuario = User::where('id',\Auth::user()->id)->first();

        if (! Hash::check($request->clave_actual, $usuario->password) )
            $message_bag->add('clave_actual', 'La Clave actual no coincide');


        if (count($message_bag))
            return redirect()->back()->withErrors($message_bag)->withInput($request->all());

        //Si no cayó en ninguna validacion se procede al cambio
        $usuario->update([
            'password'          => Hash::make($request->clave_nueva) 
        ]);

        // Redirecting to index view
        return redirect()->route('cambiarclave')->with([
            'message' => "La Clave ha sido cambiada correctamente.",
            'level' => 'success'
        ]);
    }
    
    public function app_home()
    {
        die("BIENVENIDO A LA APP");
    }
}
