<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Solicitud;
use DB;
use Validator;
use Freshwork\ChileanBundle\Rut;
use Illuminate\Support\Facades\Auth;
use App\Prioridad;
use App\Vecino;
use App\Direccion;
use App\UnidadVecinal;
use App\User;
use App\Historial;
use App\Respuesta;
use App\Http\Requests\SolicitudRequest;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Session;

//Controladores
use App\Http\Controllers\GsutTipoController;
use App\Http\Controllers\GsutPrioridadController;
use App\Http\Controllers\EmailController;
use App\Http\Controllers\MaestroDireccionesController;
use App\Http\Controllers\DireccionMunicipalController;
use App\Http\Controllers\UtilController;
use App\Http\Controllers\GsutFlujoController;

class TerritorialController extends Controller
{

    public function feedback_store_public(Request $request)
    {
        $fc_inicio          = Date("Y-m-d H:i:s");
        $nr_id              = $request->nr_id;
        $str_observacion    = $request->str_observacion;
        $tp_satisfaccion    = $request->tp_satisfaccion;       

        Solicitud::
        where('id','=',$nr_id)
        ->update([
            'tp_feedback_vecino'        =>  1,
            'str_feedback_vecino'       =>  $str_observacion,
            'fc_feedback_vecino'        =>  $fc_inicio,
            'tp_satisfaccion_vecino'    =>  $tp_satisfaccion
        ]);

        return [
            'error'     =>  0,
            'existe'    =>  1,
            'tp_icon'   =>  'success',
            'title'     =>  'Calificación Vecino',
            'msj'       =>  'Calificación registrada Exitosamente.'
        ];
    }

    public function feedback_store(Request $request)
    {
        $solicitud          =   null;
        $fc_actual          =   Date("Y-m-d H:i:s");
        $nr_id              =   $request->nr_id;
        $str_observacion    =   $request->str_observacion;
        $tp_satisfaccion    =   $request->tp_satisfaccion;
        $tp_recepcion       =   $request->tp_recepcion;
        $id_estado          =   6; // Finalizado
        $id_territorial     =   Auth::user()->id;

        $solicitud          =   UtilController::getDataSolicitud($nr_id);
        $nr_servicio        =   $solicitud->id_tipo;

        //historia final
        GsutHistoriaController::registrarHistoria($nr_id, $nr_servicio, $str_observacion, '', $id_estado, $fc_actual, $fc_actual);

        // sin nivel de satisfaccion
        if($tp_recepcion == 0)
            $tp_satisfaccion    =   0;

        Solicitud::
        where('id','=',$nr_id)
        ->update([
            'id_estado'         =>  $id_estado,
            'fc_finalizado'     =>  $fc_actual,
            'tp_feedback'       =>  1,
            'str_feedback'      =>  $str_observacion,
            'fc_feedback'       =>  $fc_actual,
            'tp_satisfaccion'   =>  $tp_satisfaccion,
            'tp_recepcion'      =>  $tp_recepcion,
            'id_territorial'    =>  $id_territorial
        ]);

        return [
            'error'     =>  0,
            'existe'    =>  1,
            'tp_icon'   =>  'success',
            'title'     =>  'Calificación territorial',
            'msj'       =>  'Calificación registrada Exitosamente.'
        ];
    }

    public function getSolicitudGestionada($id_solicitud)
    {
        $tp_gestionar   =   0;

        try {
            $data   =   Encargado::
                        join('gsut_despacho as despacho', function ($join) use ($id_solicitud)
                        {
                            $join->on('despacho.id','=','gsut_encargado.id_despacho')
                                 ->where('despacho.id_solicitud','=',$id_solicitud);
                        })
                        ->select(DB::raw('count(gsut_encargado.id) as tp_gestionar'))                        
                        ->where('gsut_encargado.tp_revisar','=',1)                        
                        ->where(function ($query) 
                        {
                            $query->where('gsut_encargado.tp_responsable','=',1)
                                  ->orWhere('gsut_encargado.tp_participante','=',1);
                        })
                        ->where('gsut_encargado.tp_activo','=',1)
                        ->get();

            if($data->count())
                $tp_gestionar   =   ($data->first()->tp_gestionar) ? 1 : 0;
        } catch (Exception $e) {
            $tp_gestionar   =   0;
        }

        return $tp_gestionar;
    }

    public function getRespuestas($id_solicitud)
    {
        $data   =   Respuesta::
                    select('gsut_respuesta.id',
                        'gsut_respuesta.id_solicitud',
                        'gsut_respuesta.id_autor',
                        'gsut_respuesta.fc_ingreso',
                        'gsut_respuesta.str_observacion',
                        'gsut_respuesta.str_observacion_html',
                        'gsut_respuesta.id_historia',
                        'gsut_respuesta.str_ruta_adjunto',
                        'depto.nm_depto',
                        'dir.nm_direccion',
                        'gsut_respuesta.tp_validado',
                        'gsut_respuesta.tp_activo',
                        'gsut_respuesta.tp_respuesta')
                    ->selectRaw("(case 
                        when tp_respuesta = 1 then 'Publicación Definitiva' 
                        when tp_respuesta = 2 then 'Publicación Parcial' 
                        when tp_respuesta = 3 then 'Pre-Publicación Definitiva' 
                        when tp_respuesta = 4 then 'Pre-Publicación Parcial' 
                        when tp_respuesta = 5 then 'Pre-Publicación Definitiva Rechazada' 
                        when tp_respuesta = 6 then 'Pre-Publicación Parcial Rechazada' 
                        when tp_respuesta = 7 then 'Expediente' 
                        when tp_respuesta = 8 then 'VB Jefatura' 
                        when tp_respuesta = 9 then 'VB Director' 
                        when tp_respuesta = 10 then 'Rechazo VB Jefatura' 
                        when tp_respuesta = 11 then 'Rechazo VB Director' 
                        when tp_respuesta = 12 then 'Respuesta Automática Enviada' 
                        when tp_respuesta = 13 then 'Respuesta Automática Fallida' 
                        else 'Respuesta Interna' end) as nm_respuesta")
                    ->selectRaw('CONCAT(nombre," ",ap_paterno) as usuario')
                    ->join('users as autor','autor.id','=','gsut_respuesta.id_autor')
                    ->join('gsut_direccion as dir','dir.id','=','autor.id_direccion')
                    ->join('gsut_depto as depto','depto.id','=','autor.id_depto')
                    ->with('archivos')
                    ->where('id_solicitud','=',$id_solicitud)
                    ->where('gsut_respuesta.tp_activo','=',1)
                    ->orderBy('gsut_respuesta.created_at','asc')
                    ->get();

        return $data;
    }

    public function indexHistoria(Request $request)
    {
        $id_solicitud       =   $request->id_solicitud;
        $respuestas         =   $this->getRespuestas($id_solicitud);

        $data   =   Historial::
                    join('gsut_solicitud as solicitud','solicitud.id','=','gsut_historial.id_solicitud')
                    ->join('users as autor','autor.id','=','gsut_historial.id_autor')
                    ->join('gsut_direccion as dir','dir.id','=','gsut_historial.id_direccion')
                    ->join('gsut_depto as depto','depto.id','=','gsut_historial.id_depto')
                    ->join('gsut_estado as estado','estado.id','=','gsut_historial.id_estado')
                    ->leftjoin('gsut_vecino as vecino','vecino.nr_rut','=','solicitud.nr_rut_vecino')
                    ->join('gsut_prioridad as prioridad','prioridad.id','=','solicitud.id_prioridad')
                    ->join('gsut_tipo as tipo','tipo.id','=','gsut_historial.id_tipo')
                    ->select('gsut_historial.id',
                        'tipo.nm_tipo',
                        'gsut_historial.id_solicitud',
                        'gsut_historial.id_tipo',
                        'gsut_historial.nr_historia',
                        'solicitud.id_direccion',
                        'solicitud.nr_ticket',
                        'solicitud.tp_feedback',
                        DB::raw('date_format(solicitud.fc_feedback, "%d-%m-%Y %H:%i") as fc_feedback'),
                        'solicitud.str_feedback',
                        'solicitud.tp_recepcion',
                        'solicitud.tp_satisfaccion',
                        'solicitud.tp_feedback_vecino',
                        DB::raw('date_format(solicitud.fc_feedback_vecino, "%d-%m-%Y %H:%i") as fc_feedback_vecino'),
                        'solicitud.tp_satisfaccion_vecino',
                        'solicitud.str_feedback_vecino',
                        'solicitud.id_direccion_destino',
                        'solicitud.id_estado as id_estado_solicitud',
                        'prioridad.id as id_prioridad_solicitud',
                        'prioridad.nm_prioridad as nm_prioridad_solicitud',
                        DB::raw('concat(autor.nombre," ",autor.ap_paterno," ",autor.ap_materno) as nm_autor'),
                        DB::raw('concat(vecino.nm_vecino," ",vecino.ap_paterno," ",vecino.ap_materno) as nm_vecino'),
                        'dir.nm_direccion',
                        'depto.nm_depto',
                        DB::raw('date_format(gsut_historial.fc_inicio, "%d-%m-%Y %H:%i") as fc_inicio'),
                        DB::raw('date_format(gsut_historial.fc_termino, "%d-%m-%Y %H:%i") as fc_termino'),
                        DB::raw('(case when gsut_historial.fc_termino
                                        then timestampdiff(day, gsut_historial.fc_inicio, gsut_historial.fc_termino) 
                                        else timestampdiff(day, gsut_historial.fc_inicio, now()) 
                                        end) as fc_diferencia'),
                        'gsut_historial.str_observacion',
                        'gsut_historial.str_observacion_html',
                        'solicitud.str_observacion as str_sol_observacion',
                        'solicitud.str_observacion_html as str_solicitud_html',
                        'gsut_historial.id_estado',
                        'gsut_historial.id_accion',
                        'solicitud.tp_visado_mt',
                        'solicitud.tp_rechazado',
                        'estado.nm_estado',
                        'gsut_historial.tp_activo')
                    ->with('servicio')
                    ->where('gsut_historial.tp_activo','=','1')
                    ->where('gsut_historial.id_solicitud','=',$id_solicitud)
                    ->orderBy('gsut_historial.nr_historia')
                    ->get();

        return ['arr_historial' => $data,'respuestas'=>$respuestas];
    }

    public function index($tp_destino)
    {
        $destino    =   '';
        $id_usuario =   Auth::user()->id;
        $id_rol     =   Auth::user()->id_rol;
        $rol_actual =   UtilController::getRolActivo($id_usuario);
        $roles      =   UtilController::listarRolesUsuario($id_usuario);

        if($tp_destino == 'inicio')
            $destino = 'territorial.inicio_territorial';

        if($tp_destino == 'ingreso')
            $destino = 'territorial.ingreso_territorial';

        if($tp_destino == 'listado')
            $destino = 'territorial.mis_solicitudes_territorial';

        if($tp_destino == 'bandeja')
            $destino = 'territorial.bandeja_territorial';


        return view($destino)
                ->with('id_rol',$id_rol)
                ->with('rol_actual',$rol_actual)
                ->with('data',$roles)
                ->with('count',count($roles));        
    }

    public function indexTerritorial(Request $request)
    {
        $id_user            =   Auth::user()->id;
        $id_unidadvecinal   =   UtilController::getIdUnidadVecinalUser($id_user);

        $fl_mostrar         =   $request->fl_mostrar;
        $fl_tipo            =   $request->fl_tipo;
        $fl_vecino          =   $request->fl_persona;
        $fl_dir             =   $request->fl_direccion;
        $fl_uv              =   $request->fl_unidadvecinal;
        $fl_ticket          =   $request->fl_ticket;
        $fl_ubicacion       =   $request->fl_ubicacion;
        $page               =   $request->page;
        $propias            =   $request->propias;
        $fc_desde           =   $request->fc_desde;
        $fc_hasta           =   $request->fc_hasta;
        $mis_solicitudes    =   0;
        $bandeja_solicitud  =   0;

        $data           =   Solicitud:: 
                            join('gsut_prioridad as prioridad','prioridad.id','=','gsut_solicitud.id_prioridad')
                            ->join('gsut_motivo as motivo','motivo.id','=','gsut_solicitud.id_motivo')
                            ->join('gsut_tipo as tipo','tipo.id','=','gsut_solicitud.id_tipo')
                            ->join('gsut_estado as estado','estado.id','=','gsut_solicitud.id_estado')
                            ->join('gsut_direccion as dir_destino','dir_destino.id','=','gsut_solicitud.id_direccion_destino')
                            ->join('gsut_depto as depto_destino','depto_destino.id','=','gsut_solicitud.id_depto_destino')
                            ->leftjoin('gsut_macroterritorio as mt','mt.id','=','gsut_solicitud.id_macroterritorio')
                            ->leftjoin('gsut_unidadvecinal as uv','uv.id','=','gsut_solicitud.id_unidadvecinal')
                            ->join('gsut_tipo_ingreso as ti','ti.id','=','gsut_solicitud.tp_ingreso')
                            ->select('gsut_solicitud.id',
                                'gsut_solicitud.nr_ticket',
                                'gsut_solicitud.id_municipio',
                                'gsut_solicitud.id_direccion',
                                'gsut_solicitud.id_depto',
                                'gsut_solicitud.id_tipo',
                                'gsut_solicitud.nm_tipo',
                                'gsut_solicitud.id_prioridad',
                                'gsut_solicitud.id_motivo',
                                'motivo.nm_motivo',
                                'gsut_solicitud.tp_clonado',
                                'gsut_solicitud.str_clonado',
                                'gsut_solicitud.str_clonado_html',
                                'gsut_solicitud.nr_fuente',
                                'gsut_solicitud.id_direccion_destino',
                                'dir_destino.nm_direccion as nm_direccion_destino',
                                'gsut_solicitud.id_depto_destino',
                                'depto_destino.nm_depto as nm_depto_destino',
                                'gsut_solicitud.id_ubicacion',
                                'gsut_solicitud.id_macroterritorio',
                                'mt.cod_territorio',
                                'gsut_solicitud.id_unidadvecinal',
                                'uv.cod_unidadvecinal',
                                'uv.nm_unidadvecinal',
                                'gsut_solicitud.tp_direccion',
                                'gsut_solicitud.nr_direccion',
                                'gsut_solicitud.nm_direccion',
                                'gsut_solicitud.nm_ubicacion',
                                'gsut_solicitud.str_latitud',
                                'gsut_solicitud.str_longitud',
                                'gsut_solicitud.nr_rut_vecino',
                                'gsut_solicitud.str_observacion',
                                'gsut_solicitud.str_observacion_html',
                                'gsut_solicitud.str_aclaratoria',
                                'gsut_solicitud.tp_visado_mt',
                                'gsut_solicitud.tp_rechazado',
                                'gsut_solicitud.id_estado',
                                'estado.nm_estado',
                                'estado.nm_color',
                                'gsut_solicitud.contexto_municipal',
                                'gsut_solicitud.tp_ingreso',
                                'ti.nm_ingreso',
                                'gsut_solicitud.id_autor',
                                'gsut_solicitud.tp_activo',
                                'gsut_solicitud.tp_feedback',
                                'gsut_solicitud.tp_recepcion',
                                'gsut_solicitud.tp_satisfaccion',
                                'gsut_solicitud.str_feedback',
                                'gsut_solicitud.fc_publicado',
                                'gsut_solicitud.fc_creacion as fc_ingreso',
                                'gsut_solicitud.created_at',
                                'gsut_solicitud.updated_at as fc_tramitacion')
                            ->selectRaw("(case when tp_vecino = 1 then 'SI' else 'NO' end) as tp_vecino")
                            ->where('gsut_solicitud.tp_activo','=',1)
                            //->orderBy('gsut_solicitud.created_at','DESC')
                            ->with('tipo','prioridad','vecino','archivos','ubicacion','asignados','archivos_asignacion','solicitud','derivacion');

            // Se consulta por las solicitudes que se encuentran pendientes de feedback
            $mis_solicitudes    =   UtilController::getCantidadSolicitudesPorEstado(1); // (id_estado, tipo_cosulta)
            $bandeja_solicitud  =   UtilController::getCantidadSolicitudesPorEstado(2); // (id_estado, tipo_cosulta)

            Session::put('propias', $mis_solicitudes);
            Session::put('bandeja', $bandeja_solicitud);

        /* ----- Inicio - Filtro Bandeja ----- */
            if($propias == 1)
                $data   =   $data->where('gsut_solicitud.id_autor','=',$id_user);

            if($propias == 0)
                $data   =   $data->whereIn('gsut_solicitud.id_unidadvecinal',$id_unidadvecinal)
                                 ->whereNotIn('gsut_solicitud.id_autor',[$id_user]);
        /* ----- Termino - Filtro Bandeja ----- */

        /* ----- Inicio - Filtro ----- */
            if($fl_mostrar != 0)
            {
                if($fl_mostrar != 5)
                    $data   =   $data->where('gsut_solicitud.id_estado','=',$fl_mostrar);
                else
                    $data   =   $data->whereIn('gsut_solicitud.id_estado',[5,6]);
            }

            if(isset($fl_direccion)) 
                $data   =   $data->where('gsut_solicitud.id_direccion_destino','=',$fl_direccion);

            if(isset($fl_depto)) 
                $data   =   $data->where('gsut_solicitud.id_depto_destino','=',$fl_depto);

            if(isset($fl_ingreso))
                $data   =   $data->where('gsut_solicitud.tp_ingreso','=',$fl_ingreso);

            if(isset($fl_servicio))
                $data   =   $data->where('gsut_solicitud.id_tipo','=',$fl_servicio);

            if(isset($fl_macrozona))
                $data   =   $data->where('gsut_solicitud.id_macroterritorio','=',$fl_macrozona);

            if(isset($fl_undvecinal))
                $data   =   $data->where('gsut_solicitud.id_unidadvecinal','=',$fl_undvecinal);

            if(isset($fl_ticket))
                $data   =   $data->where('gsut_solicitud.nr_ticket','=',$fl_ticket);

            if(isset($fl_vecino))
                $data   =   $data->where('gsut_solicitud.nr_rut_vecino','=',$fl_vecino);

            if(isset($fl_motivo))
                $data   =   $data->where('gsut_solicitud.id_motivo','=',$fl_motivo);

            if(isset($fl_ubicacion))
                $data   =   $data->where('gsut_solicitud.id_ubicacion','=',$fl_ubicacion);

            if(isset($fc_desde) && isset($fc_hasta))
            {
                $fc_desde   =   Carbon::parse($fc_desde)->format('Y-m-d');
                $fc_hasta   =   Carbon::parse($fc_hasta)->format('Y-m-d');
                $data       =   $data->whereDate('gsut_solicitud.created_at','>=',$fc_desde)
                                     ->whereDate('gsut_solicitud.created_at','<=',$fc_hasta);
            }
        /* ----- Termino - Filtro ----- */

        $data   =   $data->groupBy('gsut_solicitud.id')->paginate(20);

        $data->getCollection()->transform(function ($value) {
            $value->tiempo_tramitado    =   UtilController::getTiempoTramitacion($value->fc_ingreso, $value->fc_publicado, $value->id_estado);
            $value->tiene_pp            =   (UtilController::getCantidadRespuestas(2, $value->id) != 0) ? 'SI' : 'NO'; // Tiene Publicaciones Parciales
            return $value;
        });

        return [
            'pagination' => [
                'total'        => $data->total(),
                'current_page' => $data->currentPage(),
                'per_page'     => $data->perPage(),
                'last_page'    => $data->lastPage(),
                'from'         => $data->firstItem(),
                'to'           => $data->lastItem(),
            ],
            'info' => $data
        ];
    }
}
