<?php
 
namespace App\Http\Controllers;

use App\User;
use App\Roles;
use App\User_rol;
use App\DistribucionTerritorio;

use Illuminate\Http\Request;
use DB;
use Validator;
use Illuminate\Support\Facades\Auth;
use Freshwork\ChileanBundle\Rut;
 
class UserController extends Controller
{
    //------------------------------------------------------------
    public function index(Request $request)
    {
        $tp_admin       =   Auth::user()->tp_admin;
        $nr_direccion   =   Auth::user()->id_direccion;
        $nr_depto       =   Auth::user()->id_depto;
        $tp_buscar      =   $request->tp_buscar;
        $tp_criterio    =   $request->tp_criterio;

        $data   =   User::
                    join('gsut_direccion as dir','dir.id','=','users.id_direccion')
                    ->join('gsut_depto as depto','depto.id','=','users.id_depto')
                    ->join('gsut_roles as rol','rol.id','=','users.id_rol')
                    ->select('users.id',
                        'users.rut as nr_rut',
                        'users.name as nm_usuario',
                        'users.nombre',
                        'users.ap_paterno',
                        'users.ap_materno',
                        'users.movil',
                        'users.email',
                        'users.id_direccion',
                        'users.id_depto',
                        'users.id_rol',
                        'dir.nm_direccion',
                        'depto.nm_depto',
                        'rol.nombre as nm_rol',
                        'users.tp_admin',
                        'users.nr_nivel',
                        'users.tp_finalizar as tp_publicar',
                        'users.tp_responder',
                        'users.tp_informar',
                        'users.tp_derivar',
                        'users.tp_vb_director',
                        'users.tp_vb_depto',
                        'users.tp_activo')
                    ->with('macrozona','unidadvecinal','roles')
                    ->where('users.id','!=',0);

        /*----- Inicio - Filtro -----*/
            if($tp_admin == 2) // Administrador de Dirección
                $data   =   $data->where('users.id_direccion','=',$nr_direccion);

            if($tp_admin == 3) // Administrador de Depto
                $data   =   $data->where('users.id_direccion','=',$nr_direccion)
                                 ->where('users.id_depto','=',$nr_depto);

            if($tp_buscar !='' && $tp_criterio !='' && $tp_criterio != 'id_direccion')
                $data     =   $data->where('users.'.$tp_criterio, 'like', '%'. $tp_buscar . '%');

            if($tp_buscar !='' && $tp_criterio !='' && $tp_criterio == 'id_direccion')
                $data     =   $data->where('users.'.$tp_criterio,'=',$tp_buscar);
        /*----- Termino - Filtro -----*/

        $data   =   $data->orderBy('dir.nm_direccion')
                        ->orderBy('depto.nm_depto')
                        ->orderBy('users.ap_paterno');
        $data   =   $data->paginate(15);

        return [
            'pagination' => [
                'total'        => $data->total(),
                'current_page' => $data->currentPage(),
                'per_page'     => $data->perPage(),
                'last_page'    => $data->lastPage(),
                'from'         => $data->firstItem(),
                'to'           => $data->lastItem(),
            ],
            'info' => $data
        ];
    }
    //------------------------------------------------------------
    public function store(Request $request)
    {
        $valida     =   $this->validarDatos($request);

        if($valida['error'] == 1)
            return $valida;

        if($this->existeRegistro($request))
            return [
                    'error'     =>  1,
                    'tp_icon'   =>  'warning',
                    'title'     =>  'Registrar Usuario',
                    'msj'       =>  'Ya se encuentra registrado un usuario con el rut: "'.$request->nr_rut.'"',
                ];
        else
            return $this->registrarUsuario($request);
    }
    //------------------------------------------------------------
    public function update(Request $request)
    {
        $valida     =   $this->validarDatos($request);

        if($valida['error'] == 1)
            return $valida;

        $existe     =   $this->existeRegistro($request);

        if($existe == 1)
            return $this->actualizarUsuario($request);
        else
            return [
                'error'     =>  1,
                'tp_icon'   =>  'warning',
                'title'     =>  'Actualizar Usuario',
                'msj'       =>  'El usuario no se encuentra disponible',
            ];
    }
    //------------------------------------------------------------
    public function state(Request $request)
    {
        $existe     =   $this->existeRegistro($request);

        if($existe)
            return $this->estadoUsuario($request);
        else
            return [
                'error'     =>  1,
                'tp_icon'   =>  'warning',
                'title'     =>  'Estado Usuario',
                'msj'       =>  'El usuario no se encuentra disponible',
            ];
    }
    //------------------------------------------------------------
    public function permisos(Request $request)
    {
        $existe     =   $this->existeRegistro($request);

        if($existe)
            return $this->permisosUsuario($request);
        else
            return [
                'error'     =>  1,
                'tp_icon'   =>  'warning',
                'title'     =>  'Permisos de Usuario',
                'msj'       =>  'El usuario no se encuentra disponible',
            ];
    }
    //------------------------------------------------------------
    public function registrarUsuario(Request $request)
    {
        $id_municipio   =   2; // Municipalidad de Las Condes
        $id_direccion   =   $request->id_direccion; // Direccion Municipal
        $id_depto       =   $request->id_depto; // Depto Municipal
        $nr_rut         =   Rut::parse(strtoupper(trim($request->nr_rut)))->format(Rut::FORMAT_WITH_DASH);
        $nm_usuario     =   '';
        $nombre         =   strtoupper(trim($request->nombre));
        $ap_paterno     =   strtoupper(trim($request->ap_paterno));
        $ap_materno     =   strtoupper(trim($request->ap_materno));
        $nr_prefijo     =   $request->nr_prefijo;
        $nr_telefono    =   ($request->nr_telefono) ? ($nr_prefijo.' '.$request->nr_telefono) : ($nr_prefijo.' '.'29507000');
        $nm_email       =   $request->nm_email;
        $password       =   bcrypt($request->password);
        $tp_admin       =   0; // $request->tp_admin;
        $tp_activo      =   1; // Activo
        $id_rol         =   5; // $request->id_rol;
        $tp_rol         =   $request->tp_rol;
        $arr_roles      =   [];
        $nr_nivel       =   $request->nr_nivel;
        $valida         =   [];

        try {
            if($tp_rol == 1)
            {
                $arr_roles  =   json_decode($request->arr_roles[0]);
                $id_rol     =   $arr_roles[0]->id_rol;
            }
            else
            {
                $valida     =   [
                    'error'     =>  1,
                    'tp_icon'   =>  'danger',
                    'title'     =>  'Registrar Usuario',
                    'msj'       =>  'No se han encontrado roles ha asignar para el nuevo usuario : "'.$nm_usuario.'"',
                ];

                return $valida;
            }

            // dd([
            //     'request'   =>  $request->all(),
            //     'arr_roles' =>  $arr_roles,
            //     'id_rol'    =>  $id_rol,
            // ]);


            $nm_usuario =   ($nombre . (($ap_paterno) ? ' ' . $ap_paterno : '') . (($ap_materno) ? ' ' . $ap_materno : ''));

            $usuario    =   new User();
            $usuario->id_municipio      =   $id_municipio;
            $usuario->id_direccion      =   $id_direccion;
            $usuario->id_depto          =   $id_depto;
            $usuario->rut               =   $nr_rut;
            $usuario->nombre            =   $nombre;
            $usuario->ap_paterno        =   $ap_paterno;
            $usuario->ap_materno        =   $ap_materno;
            $usuario->name              =   $nm_usuario;
            $usuario->movil             =   $nr_telefono;
            $usuario->email             =   $nm_email;
            $usuario->password          =   $password;
            $usuario->tp_admin          =   $tp_admin;
            $usuario->tp_activo         =   $tp_activo;
            $usuario->id_rol            =   $id_rol;
            $usuario->nr_nivel          =   $nr_nivel;
            $usuario->save();

            if($this->existeRegistro($request))
            {
                $request['nr_usuario']  =   $usuario->id;

                if($tp_rol == 1) // registra roles
                {
                    foreach ($arr_roles as $key => $value) {
                        $user_rol   =   new User_rol();
                        $user_rol->id_user  =   $usuario->id;
                        $user_rol->id_rol   =   $value->id_rol;
                        $user_rol->save();

                        if(in_array($value->id_rol, [1,3]))
                        {
                            $request['id_rol']              =   $value->id_rol;
                            $request['tp_tabla']            =   $value->tp_tabla;
                            $request['arr_distribucion']    =   $value->arr_distribucion;

                            if(isset($request->arr_distribucion))
                                $this->storeDistribucion($request);
                        }
                    }
                }

                $valida     =   [
                    'error'     =>  0,
                    'tp_icon'   =>  'success',
                    'title'     =>  'Registrar Usuario',
                    'msj'       =>  'Se ha registrado el usuario : "'.$nm_usuario.'"',
                ];
            }
            else
                $valida     =   [
                    'error'     =>  0,
                    'tp_icon'   =>  'success',
                    'title'     =>  'Registrar Usuario',
                    'msj'       =>  'No se ha podido registrar al usuario : "'.$nm_usuario.'"',
                ];
        } catch (Exception $e) {
            $valida     =   [
                'error'     =>  1,
                'tp_icon'   =>  'danger',
                'title'     =>  'Registrar Usuario',
                'msj'       =>  'Ha ocurrido un problema al registar al usuario : "'.$nm_usuario.'"',
            ];
        }

        return $valida;
    }
    //------------------------------------------------------------
    public function actualizarUsuario(Request $request)
    {
        $id_direccion   =   $request->id_direccion; // Direccion Municipal
        $id_depto       =   $request->id_depto; // Depto Municipal
        $nr_usuario     =   $request->nr_usuario;
        $nr_rut         =   Rut::parse(strtoupper(trim($request->nr_rut)))->format(Rut::FORMAT_WITH_DASH);
        $nm_usuario     =   '';
        $nombre         =   strtoupper(trim($request->nombre));
        $ap_paterno     =   strtoupper(trim($request->ap_paterno));
        $ap_materno     =   strtoupper(trim($request->ap_materno));
        $nr_prefijo     =   $request->nr_prefijo;
        $nr_telefono    =   ($request->nr_telefono) ? ($nr_prefijo.' '.$request->nr_telefono) : ($nr_prefijo.' '.'29507000');
        $nm_email       =   $request->nm_email;
        $password       =   bcrypt($request->password);
        $id_rol         =   0; // $request->id_rol;
        $tp_admin       =   0; // $request->tp_admin;
        $tp_rol         =   $request->tp_rol;
        $tp_accion      =   $request->tp_accion;
        $arr_roles      =   [];
        $nr_nivel       =   $request->nr_nivel;
        $valida         =   [];

        try {
            $nm_usuario =   ($nombre . (($ap_paterno) ? ' ' . $ap_paterno : '') . (($ap_materno) ? ' ' . $ap_materno : ''));

            if($tp_rol == 1)
            {
                $arr_roles  =   json_decode($request->arr_roles[0]);
                $id_rol     =   $arr_roles[0]->id_rol;
            }            
            if($tp_rol == 0 && $tp_accion == 1)
            {
                $valida     =   [
                    'error'     =>  1,
                    'tp_icon'   =>  'danger',
                    'title'     =>  'Actualizar Usuario',
                    'msj'       =>  'No se han encontrado roles ha asignar para el nuevo usuario : "'.$nm_usuario.'"',
                ];

                return $valida;
            }

            if($id_rol == 0) {
                User::
                where('rut','=',$nr_rut)
                ->update([
                    'id_direccion'      =>  $id_direccion,
                    'id_depto'          =>  $id_depto,
                    'nombre'            =>  $nombre,
                    'ap_paterno'        =>  $ap_paterno,
                    'ap_materno'        =>  $ap_materno,
                    'name'              =>  $nm_usuario,
                    'movil'             =>  $nr_telefono,
                    'email'             =>  $nm_email,
                    'tp_admin'          =>  $tp_admin,
                    'nr_nivel'          =>  $nr_nivel
                ]);
            } else {
                User::
                where('rut','=',$nr_rut)
                ->update([
                    'id_direccion'      =>  $id_direccion,
                    'id_depto'          =>  $id_depto,
                    'nombre'            =>  $nombre,
                    'ap_paterno'        =>  $ap_paterno,
                    'ap_materno'        =>  $ap_materno,
                    'name'              =>  $nm_usuario,
                    'movil'             =>  $nr_telefono,
                    'email'             =>  $nm_email,
                    'id_rol'            =>  $id_rol,
                    'tp_admin'          =>  $tp_admin,
                    'nr_nivel'          =>  $nr_nivel
                ]);
            }

            if(isset($request->password))
                User::where('rut','=',$nr_rut)->update(['password' => $password, 'api_token' => null]);

            if($this->existeRegistro($request))
            {
                if($tp_rol == 1) // registra roles
                {
                    foreach ($arr_roles as $key => $value) {
                        $user_rol   =   new User_rol();
                        $user_rol->id_user  =   $nr_usuario;
                        $user_rol->id_rol   =   $value->id_rol;
                        $user_rol->save();

                        if(in_array($value->id_rol, [1,3]))
                        {
                            $request['id_rol']              =   $value->id_rol;
                            $request['tp_tabla']            =   $value->tp_tabla;
                            $request['arr_distribucion']    =   $value->arr_distribucion;

                            if(isset($request->arr_distribucion))
                                $this->storeDistribucion($request);
                        }
                    }
                }

                $valida     =   [
                    'error'     =>  0,
                    'tp_icon'   =>  'success',
                    'title'     =>  'Actualizar Usuario',
                    'msj'       =>  'Se han actualizado los datos del usuario "'.$nm_usuario.'"',
                ];
            }
            else
                $valida     =   [
                    'error'     =>  0,
                    'tp_icon'   =>  'success',
                    'title'     =>  'Actualizar Usuario',
                    'msj'       =>  'No se ha podido actualizar los datos del usuario "'.$nm_usuario.'"',
                ];
        } catch (Exception $e) {
            $valida     =   [
                'error'     =>  1,
                'tp_icon'   =>  'danger',
                'title'     =>  'Actualizar Usuario',
                'msj'       =>  'Ha ocurrido un problema al actualizar los datos del usuario "'.$nm_usuario.'"',
            ];
        }

        return $valida;
    }
    //------------------------------------------------------------
    public function estadoUsuario(Request $request)
    {
        $nr_rut     =   Rut::parse($request->nr_rut)->format(Rut::FORMAT_WITH_DASH);
        $nm_usuario =   $request->nm_usuario;
        $tp_activo  =   $request->tp_activo; // 1. Habilitar | 0. Deshabilitar
        $valida     =   [];
        $title      =   ($tp_activo == 1) ? 'Habilitar Usuario': 'Deshabilitar Usuario';
        $msj        =   ($tp_activo == 1) ? 'Se ha habilitado al usuario "'.$nm_usuario.'"': 
                                            'Se ha deshabilitado al usuario "'.$nm_usuario.'"';

        User::
        where('rut','=',$nr_rut)
        ->update([
            'tp_activo'     =>  $tp_activo
        ]);

        return [
            'error'     =>  0,
            'tp_icon'   =>  'success',
            'title'     =>  $title,
            'msj'       =>  $msj,
        ];
    }
    //------------------------------------------------------------
    public function permisosUsuario(Request $request)
    {
        $nr_rut     =   Rut::parse($request->nr_rut)->format(Rut::FORMAT_WITH_DASH);
        $tp_permiso =   $request->tp_permiso;
        $nr_valor   =   $request->nr_valor; // (1. Habilitar | 0. Deshabilitar) || VB (0. NO requiere VB | 1. SI requiere VB)
        $usuario    =   null;
        $permisos   =   [
                            'tp_finalizar'      =>  'Publicar',
                            'tp_responder'      =>  'Responder',
                            'tp_informar'       =>  'Informar',
                            'tp_derivar'        =>  'Derivar',
                            'tp_vb_director'    =>  'VB° Director',
                            'tp_vb_depto'       =>  'VB° Jefatura'
                        ];
        $valida     =   [];
        $title      =   ($nr_valor == 1) ? 'Habilitar Permiso': 'Deshabilitar Permiso';
        $msj        =   ($nr_valor == 1) ? 'Se ha habilitado el permiso de "'.$permisos[$tp_permiso].'"': 
                                           'Se ha deshabilitado el permiso de "'.$permisos[$tp_permiso].'"';
        try {
            if($tp_permiso == 'tp_vb_director' && $nr_valor == 1)
            {
                $usuario    =   UtilController::getUsuario('rut', $nr_rut);
                $existe     =   UtilController::isUserAdminDirectorExiste($usuario->id_direccion);

                if($existe == 0)
                    return [
                        'error'     =>  1,
                        'tp_icon'   =>  'warning',
                        'title'     =>  $title,
                        'msj'       =>  'No es posible habilitar permiso "'.$permisos[$tp_permiso].'", ' . 
                                        'ya que no se encuentra ningún usuario con el perfil "Administrador de Dirección"',
                    ];
            }
            if($tp_permiso == 'tp_vb_depto' && $nr_valor == 1)
            {
                $usuario    =   UtilController::getUsuario('rut', $nr_rut);
                $existe     =   UtilController::isUserAdminDeptoExiste($usuario->id_depto);

                if($existe == 0)
                    return [
                        'error'     =>  1,
                        'tp_icon'   =>  'warning',
                        'title'     =>  $title,
                        'msj'       =>  'No es posible habilitar permiso "'.$permisos[$tp_permiso].'", ' . 
                                        'ya que no se encuentra ningún usuario con el perfil "Administrador de Depto."',
                    ];
            }

            User::
            where('rut','=',$nr_rut)
            ->update([
                ''.$tp_permiso.''   =>  $nr_valor
            ]);

            $valida     =   [
                'error'     =>  0,
                'tp_icon'   =>  'success',
                'title'     =>  $title,
                'msj'       =>  $msj,
            ];
        } catch (Exception $e) {
            $valida     =   [
                'error'     =>  1,
                'tp_icon'   =>  'danger',
                'title'     =>  $title,
                'msj'       =>  'Ha ocurrido un problema al "'.$title.'" de "'.$permisos[$tp_permiso].'"',
            ];
        }            

        return $valida;
    }
    //------------------------------------------------------------
    public function quitarRol(Request $request)
    {
        $nr_usuario     =   $request->nr_usuario;
        $nr_rol         =   $request->nr_rol;
        $nm_usuario     =   $request->nm_usuario;
        $nm_rol         =   $request->nm_rol;
        $arr_roles      =   [];
        $arr_valida     =   $arr_valida     =   [
                                'error'     =>  0,
                                'tp_icon'   =>  'success',
                                'title'     =>  'Desasignar Rol',
                                'mensaje'   =>  '',
                            ];

        if($nr_usuario && $nr_rol)
        {
            User_rol::
            where('id_user','=',$nr_usuario)
            ->where('id_rol','=',$nr_rol)
            ->delete();

            if($nr_rol == 1) // Territorial
            {
                $distribucion   =   $this->getDistribucion('tb_unidadvecinal', $nr_usuario);

                if(count($distribucion))
                {
                    $del_uv =   collect($distribucion)->pluck('nr_id')->toArray();
                    $this->quitarDistribucion('tb_unidadvecinal', $del_uv, $nr_usuario);
                }
            }
            if($nr_rol == 3) // Macrozona
            {
                $distribucion   =   $this->getDistribucion('tb_macroterritorio', $nr_usuario);

                if(count($distribucion))
                {
                    $del_mz =   collect($dt_mz)->pluck('nr_id')->toArray();
                    $this->quitarDistribucion('tb_macroterritorio', $del_mz, $nr_usuario);
                }
            }

            $arr_roles  =   UtilController::listarRolesUsuario($nr_usuario);

            if($arr_roles->count())
            {
                $nr_rol     =   $arr_roles->first()->id;
                User::where('id','=',$nr_usuario)->update(['id_rol' => $nr_rol]);
            }

            $arr_valida     =   [
                'error'     =>  0,
                'tp_icon'   =>  'success',
                'title'     =>  'Desasignar Rol',
                'mensaje'   =>  'Se ha desasignado el rol "'.$nm_rol.'" para el usuario "'.$nm_usuario.'"',
            ];
        }
        else{
            $arr_valida     =   [
                'error'     =>  1,
                'tp_icon'   =>  'warning',
                'title'     =>  'Desasignar Rol',
                'mensaje'   =>  'No se ha posido desasignar el rol "'.$nm_rol.'"',
            ];
        }

        return $arr_valida;
    }
    //------------------------------------------------------------
    private function storeDistribucion(Request $request)
    {
        // dd([
        //     'nr_usuario'        =>  $request->nr_usuario,
        //     'id_rol'            =>  $request->id_rol,
        //     'tp_tabla'          =>  $request->tp_tabla,
        //     'arr_distribucion'  =>  $request->arr_distribucion,
        // ]);

        $arr_distribucion   =   $request->arr_distribucion;
        $tp_tabla           =   $request->tp_tabla;
        $nr_usuario         =   $request->nr_usuario;
        $nr_rol             =   $request->id_rol;
        $distribucion       =   ['tb_macroterritorio' => 'Macrozona', 'tb_unidadvecinal' => 'Unidad Vecinal'];
        $arr_valida         =   ['error' => 0, 'title' => '', 'mensaje' => ''];

        if($nr_usuario && count($arr_distribucion))
        {
            
            if($nr_rol == 1) // Territorial
            {
                $dt_actual  =   []; // $this->getDistribucion('tb_unidadvecinal', $nr_usuario);
                $dt_mz      =   []; // $this->getDistribucion('tb_macroterritorio', $nr_usuario);

                if(count($dt_actual))
                {
                    $new_dt     =   collect($arr_distribucion)->pluck('value')->toArray();
                    $old_dt     =   collect($dt_actual)->pluck('nr_id')->toArray();
                    $add_dt     =   [];
                    $del_dt     =   [];

                    foreach ($new_dt as $value) {
                        if(!in_array($value, $old_dt))
                            array_push($add_dt, $value);
                    }

                    foreach ($old_dt as $value) {
                        if(!in_array($value, $new_dt))
                            array_push($del_dt, $value);
                    }

                    $this->registrarDistribucion('tb_unidadvecinal', $add_dt, $nr_usuario);
                    $this->quitarDistribucion('tb_unidadvecinal', $del_dt, $nr_usuario);

                    $arr_valida     =   [
                        'error'     =>  0,
                        'title'     =>  'Registro de '.$distribucion[$tp_tabla],
                        'mensaje'   =>  'Se ha registrado la "'.$distribucion[$tp_tabla].'" correctamente',
                    ];
                }
                else
                {
                    $new_dt     =   collect($arr_distribucion)->pluck('value')->toArray();
                    $this->registrarDistribucion('tb_unidadvecinal', $new_dt, $nr_usuario);
                }

                if(count($dt_mz))
                {
                    $del_mz =   collect($dt_mz)->pluck('nr_id')->toArray();
                    $this->quitarDistribucion('tb_macroterritorio', $del_mz, $nr_usuario);
                }
            }
            else if($nr_rol == 3) // Macrozona
            {
                $dt_actual  =   []; // $this->getDistribucion('tb_macroterritorio', $nr_usuario);
                $dt_uv      =   []; // $this->getDistribucion('tb_unidadvecinal', $nr_usuario);

                if(count($dt_actual))
                {
                    $new_dt     =   collect($arr_distribucion)->pluck('value')->toArray();
                    $old_dt     =   collect($dt_actual)->pluck('nr_id')->toArray();
                    $add_dt     =   [];
                    $del_dt     =   [];

                    foreach ($new_dt as $value) {
                        if(!in_array($value, $old_dt))
                            array_push($add_dt, $value);
                    }

                    foreach ($old_dt as $value) {
                        if(!in_array($value, $new_dt))
                            array_push($del_dt, $value);
                    }                    

                    $this->registrarDistribucion('tb_macroterritorio', $add_dt, $nr_usuario);
                    $this->quitarDistribucion('tb_macroterritorio', $del_dt, $nr_usuario);

                    $arr_valida     =   [
                        'error'     =>  0,
                        'title'     =>  'Registro de '.$distribucion[$tp_tabla],
                        'mensaje'   =>  'Se ha registrado la "'.$distribucion[$tp_tabla].'" correctamente',
                    ];
                }
                else
                {
                    $new_dt     =   collect($arr_distribucion)->pluck('value')->toArray();
                    $this->registrarDistribucion('tb_macroterritorio', $new_dt, $nr_usuario);
                }

                if(count($dt_uv))
                {
                    $del_uv =   collect($dt_uv)->pluck('nr_id')->toArray();
                    $this->quitarDistribucion('tb_unidadvecinal', $del_uv, $nr_usuario);
                }
            }            
        }
        else
        {
            $this->quitarTodaDistribucion($nr_usuario);

            $arr_valida     =   [
                    'error'     =>  0,
                    'title'     =>  'Registro de Distribucion de Territorio',
                    'mensaje'   =>  'No es posible realizar el proceso',
                ];
        }

        return $arr_valida;
    }
    //------------------------------------------------------------
    private function getDistribucion($tp_tabla, $nr_usuario)
    {
        $data   =   DistribucionTerritorio::
                        select('tp_tabla','nr_id','id_user')
                        ->where('id_user','=',$nr_usuario)
                        ->where('tp_tabla','=',$tp_tabla)
                        ->get();

        return $data;
    }
    //------------------------------------------------------------
    private function registrarDistribucion($tp_tabla, $arr_distribucion = [], $nr_usuario)
    {
        foreach ($arr_distribucion as $key => $value) 
        {
            $model  =   new DistribucionTerritorio();
            $model->tp_tabla    =   $tp_tabla;
            $model->nr_id       =   $value;
            $model->id_user     =   $nr_usuario;            
            $model->save();
        }
    }
    //------------------------------------------------------------
    private function quitarDistribucion($tp_tabla, $arr_distribucion = [], $nr_usuario)
    {
        foreach ($arr_distribucion as $key => $value) 
        {
            DistribucionTerritorio::
            where('id_user','=',$nr_usuario)
            ->where('tp_tabla','=',$tp_tabla)
            ->where('nr_id','=',$value)
            ->delete();
        }
    }
    //------------------------------------------------------------
    private function quitarTodaDistribucion($nr_usuario)
    {
        DistribucionTerritorio::
        where('id_user','=',$nr_usuario)
        ->delete();
    }
    //------------------------------------------------------------
    public function existeRegistro(Request $request)
    {
        $nr_rut     =   Rut::parse(strtoupper(trim($request->nr_rut)))->format(Rut::FORMAT_WITH_DASH);
        $existe     =   User::where('rut','=',$nr_rut)->count();
        return $existe;
    }
    //------------------------------------------------------------
    public function validarDatos(Request $request)
    {

        // dd([
        //     'request'   =>  $request->all(),
        // ]);

        $customMessages = [
            'required'          =>  'El campo :attribute es requerido.',
            'numeric'           =>  'El campo :attribute debe ser númerico.',
        ];

        $attributes = [
            'id_direccion'      =>  'Dirección Municipal',
            'id_depto'          =>  'Departamento Municipal',
            'nr_rut'            =>  'Rut',
            'nombre'            =>  'Nombre',           
            'ap_paterno'        =>  'Apellido Materno',
            'ap_materno'        =>  'Apellido Paterno',         
            'nm_email'          =>  'Correo Electronico',
            'tp_rol'            =>  'Rol',
        ];

        $validator = Validator::make($request->all(), [
            'id_direccion'      =>  'required|numeric|min:1',
            'id_depto'          =>  'required|numeric|min:1',
            'nr_rut'            =>  'required|cl_rut',
            'nombre'            =>  'required|string|min:3',
            'ap_paterno'        =>  'required|string|min:3',
            'ap_materno'        =>  'required|string|min:3',
            'nm_email'          =>  'required|string|email:rfc,dns',
            'tp_rol'            =>  'required_if:tp_accion,==,1|numeric',
        ], $customMessages,$attributes);

        if ($validator->fails())
            return [
                'error'     =>  1,
                'tp_icon'   =>  'warning',
                'title'     =>  'Validar Datos',
                'msj'       =>  'Favor revisar los datos requeridos',
                'valida'    =>  $validator->errors(),
            ];

        return [
            'error'     =>  0,
            'tp_icon'   =>  'success',
            'title'     =>  'Validar Datos',
            'msj'       =>  'Datos validos',
            'valida'    =>  null,
        ];
    }
    //------------------------------------------------------------
    public function selectRolesUser($tp_consulta = 1,$id_user = 0)
    {

        if($tp_consulta == 1)
          $id_user      = Auth::user()->id;

        $roles= User_rol::select('id_rol')
                         ->join('gsut_roles','gsut_user_rol.id_rol','=','gsut_roles.id')
                         ->where('id_user', '=', $id_user)
                         ->where('gsut_roles.condicion','=',1)
                         ->get()
                         ->pluck('id_rol');

        $head  = User_rol::select('id_rol','nombre','tp_agrupacion')
                         ->join('gsut_roles','gsut_user_rol.id_rol','=','gsut_roles.id')
                         ->where('id_user', '=', $id_user)
                         ->where('gsut_roles.condicion','=',1)
                         ->where('tp_agrupacion', '!=', 0)
                         ->get()
                         ->pluck('tp_agrupacion');

        $cabecera = Roles::select('nombre','tp_agrupacion')
                      ->where('condicion','=',1)
                      ->where('tp_cabecera','=',1)
                      ->whereIn('tp_agrupacion',$head)
                      ->orderby('tp_agrupacion')
                      ->groupBy('nombre','tp_agrupacion')
                      ->get();



          for ($i=0; $i <count($cabecera) ; $i++) 
          { 
              $tp_agrupacion = $cabecera[$i]['tp_agrupacion'];
              $items         = Roles::select('nombre','tp_agrupacion','tp_cabecera','id as id_rol')
                                   ->where('tp_cabecera','!=',1)
                                   ->where('tp_agrupacion','=',$tp_agrupacion)
                                   ->whereIn('id',$roles)
                                   ->get();

              $cabecera[$i]['items'] = $items;
          }


        return ['cabecera'=> $cabecera];
    }
    //------------------------------------------------------------
    public function updateRol(Request $request)
    {
        $server     =   $request->root();
        $destino    =   $server . '/home';
        $nr_user    =   Auth::user()->id;
        $nr_rol     =   $request->nr_rol;
        
        $valida     =   DB::update('update users set id_rol='.$nr_rol.' where id='.$nr_user);

        return ['str_destino' => $destino];
    }
    //------------------------------------------------------------
}