<?php

namespace App\Http\Middleware;

use Closure;

use App\ApiUser;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Database\Eloquent\ModelNotFoundException;

class ApiUserAuth
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $api_token  =   $request->header('api-token', null);
        $app_token  =   $request->header('app-token', null);

        if (!$api_token) {
            return response()->json(['message' => 'api-token es requerido'], 401);
        }

        try {
            $user   =   ApiUser::
                        where('api_token', $api_token)
                        ->where('tp_activo','=','1')
                        ->firstOrFail();

            Auth::setUser($user);
            
            $request->attributes->add(['api-token' => $api_token]);
            $request->attributes->add(['app-token' => $app_token]);
        } catch (ModelNotFoundException $e) {
            return response()->json(['message' => 'api-token invalido'], 401);
        }

        return $next($request);
    }
}
