<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class SolicitudRequest extends FormRequest
{
    
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return  [
            'key_uuid'                  =>  [
                'required',
                'uuid',
                Rule::unique('gsut_solicitud', 'key_uuid')->whereNotNull('key_uuid')
            ],
            'tp_vecino'                 =>  'required|numeric',
            'nr_tipo'                   =>  'required|numeric',
            'nr_prioridad'              =>  'required|numeric',
            'nr_dir_municipal'          =>  'required|numeric',
            'tp_municipal'              =>  'required|numeric',
            'str_observacion'           =>  'required|string|min:5',
            'arr_direccion_solicitud'   =>  'required_if:tp_ubicacion,1|array|min:1',
            'arr_direccion_solicitud.[*]["value"]'              =>  'required_if:tp_ubicacion,1|numeric',
            'arr_direccion_solicitud.[*]["label"]'              =>  'required_if:tp_ubicacion,1|string|min:3',
            'arr_direccion_solicitud.[*]["nr_calle"]'           =>  'required_if:tp_ubicacion,1|numeric',
            'arr_direccion_solicitud.[*]["nm_calle"]'           =>  'required_if:tp_ubicacion,1|string|min:3',
            'arr_direccion_solicitud.[*]["str_latitud"]'        =>  'required_if:tp_ubicacion,1|string',
            'arr_direccion_solicitud.[*]["str_longitud"]'       =>  'required_if:tp_ubicacion,1|string',
            'arr_direccion_solicitud.[*]["cod_territorial"]'    =>  'required_if:tp_ubicacion,1|string',
            'arr_direccion_solicitud.[*]["cod_unidadvecinal"]'  =>  'required_if:tp_ubicacion,1|string',
            'rut_vecino'                =>  'required_if:tp_vecino,1|cl_rut|nullable',
            'nm_vecino'                 =>  'required_if:tp_vecino,1',
            'ap_paterno'                =>  'required_if:tp_vecino,1',
            'ap_materno'                =>  'required_if:tp_vecino,1',
            'nm_mail'                   =>  'required_if:tp_vecino,1|email|nullable',
            'nr_telefono'               =>  'required_if:tp_vecino,1|digits:8|nullable',

            'tp_comuna'                 =>  'required|numeric',
            'nr_region'                 =>  'required_if:tp_comuna,==,0|numeric|min:1',
            'nr_comuna'                 =>  'required_if:tp_comuna,==,0|numeric|min:1',
            'nm_ubicacion_vecino'       =>  'required_if:tp_comuna,==,0|string|min:5',

            'arr_ubicacion_vecino'      =>  'required_if:tp_comuna,==,1|array|min:1',
            'arr_ubicacion_vecino.[*]["value"]'              =>  'required_if:tp_comuna,==,1|numeric',
            'arr_ubicacion_vecino.[*]["label"]'              =>  'required_if:tp_comuna,==,1|string|min:3',
            'arr_ubicacion_vecino.[*]["nr_calle"]'           =>  'required_if:tp_comuna,==,1|numeric',
            'arr_ubicacion_vecino.[*]["nm_calle"]'           =>  'required_if:tp_comuna,==,1|string|min:3',
            'arr_ubicacion_vecino.[*]["str_latitud"]'        =>  'required_if:tp_comuna,==,1|string',
            'arr_ubicacion_vecino.[*]["str_longitud"]'       =>  'required_if:tp_comuna,==,1|string',
            'arr_ubicacion_vecino.[*]["cod_territorial"]'    =>  'required_if:tp_comuna,==,1|string',
            'arr_ubicacion_vecino.[*]["cod_unidadvecinal"]'  =>  'required_if:tp_comuna,==,1|string',
        ];
    }

    public function messages()
    {
        return [
            'key_uuid.required' =>  'Se requiere un identificador único para la solicitud.',
            'key_uuid.uuid'     =>  'El identificador debe ser un UUID válido.',
            'key_uuid.unique'   =>  'Esta solicitud ya fue procesada anteriormente.',
            'required'          =>  'El campo :attribute es requerido.',
            'required_if'       =>  'El campo :attribute es requerido.',
            'numeric'           =>  'El campo :attribute debe ser númerico.',
            'email'             =>  'El campo :attribute debe ser en formato email.',
            'digits'            =>  'El campo :attribute debe tener 8 dígitos.',
            'cl_rut'            =>  'El campo :attribute no posee formato de rut correcto.',
        ];
    }

    public function attributes()
    {
        return [
            'key_uuid'                  =>  'Identificador Único',
            'nr_tipo'                   =>  'Tipo Solicitud',
            'nr_prioridad'              =>  'Importancia',
            'nr_dir_municipal'          =>  'Dirección Municipal',
            'tp_municipal'              =>  'Es Asunto Municipal',
            'str_observacion'           =>  'Observación',                
            'arr_direccion_solicitud'   =>  'Ubicación Problema',
            'arr_direccion_solicitud.value'              =>  'Id Ubicación',
            'arr_direccion_solicitud.label'              =>  'Dirección Ubicación',
            'arr_direccion_solicitud.nr_calle'           =>  'Numeración Ubicación',
            'arr_direccion_solicitud.nm_calle'           =>  'Dirección Ubicación Solicitud',
            'arr_direccion_solicitud.str_latitud'        =>  'Latitud',
            'arr_direccion_solicitud.str_longitud'       =>  'Longitud',
            'arr_direccion_solicitud.cod_territorial'    =>  'Codigo Macro-Territorio',
            'arr_direccion_solicitud.cod_unidadvecinal'  =>  'Codigo Unidad Vecinal',                
            'rut_vecino'                =>  'Rut Vecino',
            'nm_vecino'                 =>  'Nombre Vecino',
            'ap_paterno'                =>  'Apellido Paterno',
            'ap_materno'                =>  'Apellido Materno',
            'nr_telefono'               =>  'Teléfono',
            'nm_mail'                   =>  'Email',
            'nr_region'                 =>  'Región',
            'nr_comuna'                 =>  'Comuna',
            'nm_ubicacion_vecino'       =>  'Dirección del Vecino',
            'arr_ubicacion_vecino'      =>  'Dirección del Vecino',
            'arr_ubicacion_vecino.value'                =>  'Id Ubicación',
            'arr_ubicacion_vecino.label'                =>  'Dirección Ubicación',
            'arr_ubicacion_vecino.nr_calle'             =>  'Numeración Ubicación',
            'arr_ubicacion_vecino.nm_calle'             =>  'Dirección Ubicación Solicitud',
            'arr_ubicacion_vecino.str_latitud'          =>  'Latitud',
            'arr_ubicacion_vecino.str_longitud'         =>  'Longitud',
            'arr_ubicacion_vecino.cod_territorial'      =>  'Codigo Macro-Territorio',
            'arr_ubicacion_vecino.cod_unidadvecinal'    =>  'Codigo Unidad Vecinal',                
        ];
    }
}
