<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Respuesta extends Model
{
    protected $table        =   'gsut_respuesta';
    protected $primaryKey   =   'id';
    protected $fillable     =   [
                                    'id_solicitud',
                                    'fc_ingreso',
                                    'str_observacion',
                                    'str_observacion_html',
                                    'id_historia',
                                    'str_ruta_adjunto',
                                    'id_direccion',
                                    'id_depto',
                                    'id_autor',
                                    'tp_respuesta',
                                    'tp_validado',
                                    'nr_fuente',
                                    'tp_activo'
                                ];

    public $timestamps = true;
    //-----------------------------------------------------------
    public function archivos()
    {
        return  $this->hasMany('App\Archivos','nr_id','id')
                     ->where('tp_tabla','=','tb_respuesta');
    }
    //-----------------------------------------------------------
}
