<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Roles extends Model
{
    protected $table        =   'gsut_roles';
    protected $primaryKey   =   'id';
    protected $fillable     =   ['id',
                                 'nombre',
                                 'descripcion', 
                                 'condicion',
                                 'str_sidebar',
                                 'nm_cabecera',
                                 'tp_agrupacion'];

    public $timestamps = true;

    public function agrupacion()
    {
        return $this->belongsTo('App\Roles','tp_agrupacion','tp_agrupacion')
                    ->select(['id as value','nombre as label','tp_agrupacion'])
                    ->where('condicion','=','1')
                    ->where('tp_cabecera','=','0');
    }

}
