<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use DB;

class Tipo extends Model
{
    protected $table        =   'gsut_tipo';
    protected $primaryKey   =   'id';
    protected $fillable     =   [
                                    'id_direccion',
                                    'id_depto',
                                    'nm_tipo',
                                    'str_tipo',
                                    'str_tipo_html',
                                    'tp_ubicacion',
                                    'tp_macrozona',
                                    'tp_asignacion',
                                    'tp_respuesta',
                                    'tp_director',
                                    'tp_depto',
                                    'nr_nivel',
                                    'tp_visualizar',
                                    'tp_activo'
                                ];

    public $timestamps = true;
    //-----------------------------------------------------------
    public function funcionarios()
    {
        return  $this->hasManyThrough('App\User','App\ServicioTieneUsuarios',
                                    'id_servicio','id',
                                    'id','id_usuario')
                    ->join('gsut_direccion as dir','dir.id','=','users.id_direccion')
                    ->join('gsut_depto as depto','depto.id','=','users.id_depto')
                    ->select(['users.id as value',
                        DB::raw('concat(depto.nm_depto," - ",users.name) as label'),
                        'users.name',
                        'dir.nm_direccion',
                        'depto.nm_depto'])
                    ->where('gsut_servicio_tiene_usuario.tp_activo','=',1);
    }
    //-----------------------------------------------------------
    public function respuestas()
    {
        return  $this->hasMany('App\RespuestaServicio','id_tipo','id')
                    ->where('tp_activo','=','1');
    }
    //-----------------------------------------------------------
    public function unidadvecinal()
    {
        return $this->hasManyThrough('App\UnidadVecinal','App\UnidadVecinalMacroTerritorio',
                                    'id_macroterritorio','id',
                                    'id','id_unidadvecinal')
                    ->select(['gsut_unidadvecinal.id as value','gsut_unidadvecinal.nm_unidadvecinal as label']);
    }
    //-----------------------------------------------------------
    public function notificacion()
    {
        return $this->belongsTo('App\NotificacionServicio','id','id_tipo')
                ->where('tp_activo','=','1');
    }
    //-----------------------------------------------------------
}
