<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGsutDeptoTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('gsut_depto', function(Blueprint $table)
		{
			$table->bigIncrements('id');
			$table->integer('id_municipio')->unsigned();
			$table->integer('id_direccion')->unsigned();
			$table->string('nm_depto', 150);
			$table->string('nm_ubicacion', 250)->default('Apoquindo 3400');
			$table->integer('tp_activo')->unsigned()->default(1);
			$table->timestamps();
		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::dropIfExists('gsut_depto');
	}

}
