<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGsutArchivoTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('gsut_archivo', function(Blueprint $table)
		{
			$table->bigIncrements('id');
			$table->string('tp_tabla');
			$table->bigInteger('nr_id');
			$table->string('nm_archivo', 100);
			$table->string('str_observacion', 200)->nullable()->default('');
			$table->text('str_archivo', 65535);
			$table->string('ext_archivo', 20);
			$table->integer('tp_activo')->unsigned()->default(1);
			$table->timestamps();
		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::dropIfExists('gsut_archivo');
	}

}
