<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGsutSolicitudTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('gsut_solicitud', function(Blueprint $table)
		{
			$table->bigIncrements('id');
			$table->integer('nr_anio')->nullable();							// anio
            $table->integer('nr_mes')->nullable();							// mes
            $table->integer('nr_dia')->nullable();							// dia
            $table->integer('nr_folio')->nullable();						// nr folio
            $table->string('nr_ticket')->nullable();						// nr ticket
			$table->integer('id_municipio')->unsigned(); 					// municipalidad
			$table->integer('id_direccion')->unsigned(); 					// direccion municipal
            $table->integer('id_depto')->unsigned(); 	 					// depto municipal
            $table->integer('id_tipo')->unsigned(); 						// tipo solicitud
            $table->string('nm_tipo')->nullable();							// nombre solicitud
            $table->integer('id_prioridad')->unsigned(); 					// tipo prioridad 
            $table->integer('id_motivo')->unsigned(); 						// motivo de solicitud
            $table->integer('id_direccion_destino')->unsigned(); 			// solicitud dirigida a direccion municipal 
            $table->integer('id_depto_destino')->unsigned(); 				// solicitud dirigida a direccion municipal 
            $table->integer('id_ubicacion')->nullable();					// id del maestro direccion
            $table->integer('id_macroterritorio')->unsigned();				// id macroterritorio
            $table->integer('id_unidadvecinal')->unsigned(); 				// id unidad vecinal 
            $table->integer('tp_direccion')->unsigned()->default(1);		// 1- Frente | 3- Altura
			$table->integer('nr_direccion')->nullable();					// numeracion direccion
            $table->string('nm_direccion')->nullable();						// nombre direccion 
            $table->string('nm_ubicacion')->nullable();						// concatenacion de numeracion y nombre direccion
            $table->string('str_latitud', 150)->nullable();					// latitud
			$table->string('str_longitud', 150)->nullable();				// longitud
			$table->string('nr_rut_vecino', 20);							// rut vecino
			$table->text('str_observacion', 65535)->nullable();				// obervacion
			$table->text('str_observacion_html', 65535)->nullable();		// obervacion
			$table->text('str_aclaratoria', 65535)->nullable();				// obervacion
			$table->dateTime('fc_creacion')->nullable();					// fecha creacion solicitud
			$table->integer('tp_visado_mt')->unsigned()->default(0);		// visado macroterritorio
			$table->dateTime('fc_visado_mt')->nullable();					// fecha visado macroterritorio
			$table->integer('tp_asignador')->unsigned()->default(0);		// visado por Asignador
			$table->dateTime('fc_asignador')->nullable();					// fecha visado Asignador
			$table->dateTime('fc_derivado')->nullable();					// fecha derivación
			$table->dateTime('fc_finalizado')->nullable();					// fecha finalizacion
			$table->integer('tp_revisado')->unsigned()->default(0);			// visado de revision
			$table->dateTime('fc_revisado')->nullable();					// fecha de revision
			$table->integer('tp_director')->unsigned()->default(0);			// visado de revision
			$table->dateTime('fc_director')->nullable();					// fecha de revision
			$table->integer('tp_jefedepto')->unsigned()->default(0);		// visado de revision
			$table->dateTime('fc_jefedepto')->nullable();					// fecha de revision
			$table->integer('tp_rechazado')->unsigned()->default(0);		// rechazo
			$table->text('str_rechazado')->nullable();						// rechazo
			$table->integer('id_estado')->unsigned();						// is estado solicitud
			$table->integer('contexto_municipal')->unsigned()->default(1);	// indica si la solicitud es de contexto municipal
			$table->integer('tp_ingreso')->unsigned()->default(1);	   		// 1. Formulario | 2. Territorial | 3. Funcionario | 4. Macrozona | 6. Audiencia | 7. Redes Sociales
			$table->integer('id_autor')->unsigned();						// autor del registro de solicitud	
			$table->integer('id_rol')->unsigned();							// identifica con que rol se realizo la solicitud	
			$table->integer('tp_vecino')->nullable();						// existe un vecino asociado a la solicitud		
			$table->integer('tp_feedback')->default(0); 					// tiene feedback
            $table->integer('tp_recepcion')->default(0);					// se contacto vecino
            $table->integer('tp_satisfaccion')->default(0);					// nivel de satisfaccion
            $table->text('str_feedback')->nullable();						// observacion feedback
            $table->dateTime('fc_feedback')->nullable();					// fecha del feedback
            $table->integer('tp_feedback_vecino')->default(0);				// tiene feedback de vecino
            $table->integer('tp_satisfaccion_vecino')->default(0);			// nidel de satisfaccion del vecino
            $table->text('str_feedback_vecino')->nullable();				// observacion feedback vecino
            $table->dateTime('fc_feedback_vecino')->nullable();				// fecha feedback vecino
            $table->integer('tp_activo')->unsigned()->default(1);			// soft-delete			
            $table->timestamps();
		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::dropIfExists('gsut_solicitud');
	}

}
