<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateGsutEncuestaPreguntaTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('gsut_encuesta_pregunta', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('id_encuesta')->unsigned();
            $table->string('tp_categoria',50)->nullable();
            $table->integer('nr_pregunta')->unsigned()->default(0);
            $table->string('cod_pregunta',50)->nullable();
            $table->integer('tp_pregunta')->unsigned()->default(0);
            $table->integer('tp_obligatorio')->unsigned()->default(0);
            $table->string('str_formdata',50)->nullable();
            $table->text('str_pregunta', 65535)->nullable();
            $table->integer('tp_activo')->unsigned()->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('gsut_encuesta_pregunta');
    }
}
