<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateGsutNotificacionServicioTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('gsut_notificacion_servicio', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('nr_notificacion')->unsigned()->default(1);
            $table->integer('id_direccion')->unsigned();
            $table->integer('id_depto')->unsigned();
            $table->integer('id_tipo')->unsigned();
            $table->text('str_notificacion')->nullable();
            $table->text('str_notificacion_html')->nullable();
            $table->date('fc_inicio')->nullable();
            $table->date('fc_termino')->nullable();
            $table->integer('tp_activo')->unsigned()->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('gsut_notificacion_servicio');
    }
}
