@extends('Template.adminlte')

@section('main-title')
    {{ 'Dashboard' }}
@endsection

@section('main-navigation')
    <li class="">Administración</li>
    <li class="">Inicio</li>
@endsection

@push('styles')
    <style>
        .chart-container {
            height: 600px;
        }

        @media screen and (min-width: 1200px) {
            .chart-container {
              height: 800px;
            }
        }

        .mt-5 {
            margin-top: 2rem;
        }

        .div-error{
            display: flex;
            justify-content: center;
        }

        .text-error{
            color: red !important;
            font-weight: bold;
        }

        .switch {
            position: relative;
            display: inline-block;
            width: 60px;
            height: 34px;
        }

        .switch input { 
            opacity: 0;
            width: 0;
            height: 0;
        }

        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            -webkit-transition: .4s;
            transition: .4s;
        }

        .slider:before {
            position: absolute;
            content: "";
            height: 26px;
            width: 26px;
            left: 4px;
            bottom: 4px;
            background-color: white;
            -webkit-transition: .4s;
            transition: .4s;
        }

        input:checked + .slider {
            background-color: #2196F3;
        }

        input:focus + .slider {
            box-shadow: 0 0 1px #2196F3;
        }

        input:checked + .slider:before {
            -webkit-transform: translateX(26px);
            -ms-transform: translateX(26px);
            transform: translateX(26px);
        }

        /* Rounded sliders */
        .slider.round {
            border-radius: 34px;
        }

        .slider.round:before {
            border-radius: 50%;
        }
    </style>
@endpush()

@section('main-content')
    <div class="box" id="app">
        <div class="box-body">
            <div class="x_title">
                <div class="col-md-12 col-sm-12">
                    <div class="text-right">
                        <button class="btn btn-primary" @click="cargarDatos();">
                            <i class="fas fa-sync"></i> Actualizar
                        </button>

                        <button class="btn btn-primary btn_activo" id="btn_filtrar_datos">
                            <i class="fas fa-search"></i> Filtrar Datos
                        </button>
                    </div>
                </div>
            </div>

            <div class="x_content">
                <div class="col-md-12 col-sm-12 mt-3">
                    <!-- Filtro -->
                    <div class="col-md-12 col-sm-12">
                        <div class="collapse" id="filtrar_datos">
                            <div class="card">
                                <div class="card-header bg--primary">
                                    <div class="col-md-12 col-sm-12 text-center">
                                        <h5>Filtro de busqueda</h5>
                                    </div>
                                </div>
                                <div class="card-body">

                                    <div class="row ml-2 mr-2">
                                        <div class="col-md-12 col-sm-12"> </div>
                                        <!-- Departamento -->
                                        <div class="col-md-4 col-sm-6">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Departamento :
                                                </label>
                                                <multiselect 
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_depto"
                                                    :options="arr_depto"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Departmento"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>

                                        <!-- Rut -->
                                        <div class="col-md-4 col-sm-6">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Rut :
                                                </label>
                                                <multiselect 
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_rut"
                                                    :options="arr_rut"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Rut"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>

                                        <!-- Funcionario -->
                                        <div class="col-md-4 col-sm-6">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Funcionario :
                                                </label>
                                                <multiselect 
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_usuario"
                                                    :options="arr_usuario"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Funcionario"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <div style="float: right;">
                                        <button @click="limpiarFiltros()" type="button" class="btn btn-warning btn-sm btn_activo" style="color: white;">
                                            <i class="fas fa-undo"></i> Quitar Filtros
                                        </button>&nbsp;
                                        <button @click="filtrarDatos()" type="button" class="btn btn-primary btn-sm btn_activo"><i class="fas fa-search"></i>
                                            Filtrar Búsqueda
                                        </button>

                                        <button class="btn btn-secondary btn-sm btn_activo" id="close_filtrar_datos">
                                            Cerrar Filtro
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Tabla -->
                    <div class="ml-1 mr-1  table-responsive">
                        <table class="table table-bordered table-striped table-sm">
                            <thead class="bg--primary">
                                <th colspan="12" class="bg-indigo">
                                    <h6 class="text-center">
                                        Listado de Solicitudes
                                    </h6>
                                </th>
                            </thead>
                            <thead>
                                <th style="min-width:100px; text-align:center;">Opciones</th>
                                <th style="min-width:100px; text-align:center;">Departamento</th>
                                <th style="min-width:200px; text-align:center;">Funcionario</th>
                                <th style="min-width:200px; text-align:center;">E-Mail</th>
                                <th style="min-width:200px; text-align:center;">Perfil</th>
                            </thead>
                            <tbody>
                                <template v-if="arr_index.length">
                                    <tr v-for="datos in arr_index" :key="datos.id">
                                        <td style="text-align:center;">
                                            <button class="btn btn-sm btn-secondary" 
                                                @click="abrirModal('usuarios', 'informacion', datos)">
                                                    <i class="fas fa-search"></i>
                                            </button>
                                        </td>
                                        <td style="text-align:left;">
                                            @{{ datos.nm_depto }}
                                        </td>
                                        <td style="text-align:left;">
                                            @{{ datos.nm_usuario }}
                                        </td>
                                        <td style="text-align:left;">
                                            @{{ datos.email }}
                                        </td>
                                        <td style="text-align:center;">
                                            <template v-if="datos.id_rol == 4">Administración</template>
                                            <template v-if="datos.id_rol == 6">Gestor</template>
                                            <template v-else-if="datos.id_rol == 5 && datos.tp_cargo == 1">Director</template>
                                            <template v-else-if="datos.id_rol == 5 && (datos.tp_cargo == 2 || datos.tp_cargo == 3)">Ejecutivo</template>
                                            <template v-else-if="datos.id_rol == 3">Jefe Territorial</template>
                                            <template v-else-if="datos.id_rol == 2">Macro Zonal</template>
                                            <template v-else-if="datos.id_rol == 1">Territorial</template>
                                        </td>
                                    </tr>
                                </template>
                                <template v-else>
                                    <tr>
                                        <td colspan="12">
                                            <h5 class="text-center">
                                                No hay datos para listar
                                            </h5>
                                        </td>
                                    </tr>
                                </template>
                            </tbody>
                        </table>
                    </div>

                    <!-- Paginacion -->
                    <div class="col-md-12 col-sm-12">
                        <nav>
                            <ul class="pagination">
                                <li class="page-item" v-if="pagination.current_page > 1">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(pagination.current_page - 1)">Ant</a>
                                </li>
                                <li class="page-item" v-for="page in pagesNumber" :key="page" :class="[page == isActivedPagination ? 'active' : '']">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(page, 1)" v-text="page"></a>
                                </li>
                                <li class="page-item" v-if="pagination.current_page < pagination.last_page">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(pagination.current_page + 1)">Sig</a>
                                </li>
                            </ul>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
        <!-- - - - - - - - - - - - - - - - - - - - -  Inicio de Modal - - - - - - - - - - - - - - - - - - - - -->
            <!-- Modal Principal -->
            <div id="modal_principal" class="modal scroll_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                <!-- Inicio - Informacion -->
                <div class="modal-dialog modal-xl" role="document" >
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">
                                <strong class="text-center">@{{ titulo_principal }}</strong>
                            </h5>
                            <button type="button" @click="cerrarModal('informacion');" class="close btn_activo" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>

                        <div class="modal-body lg_modal_body">
                            <ul class="nav nav-tabs nav-fill" id="nav-tab" role="tablist">
                                <li class="nav-item active">
                                    <a class="nav-link active" id="info_funcionario-tab" data-toggle="tab" href="#info_funcionario" role="tab" 
                                        aria-controls="info_funcionario" aria-selected="false">
                                        <i class="far fa-list-alt"></i> Información Funcionario
                                    </a>
                                </li>
                            </ul>

                            <div class="tab-content">
                                <div class="tab-pane active" id="info_funcionario" role="tabpanel">
                                    <div class="row-flow">
                                        <!-- Datos Funcionario -->
                                        <div class="card mt-4">
                                            <div class="card-header bg--primary" style="color:white">
                                                <h4 class="text-center">Datos Funcionario</h4>
                                            </div>
                                            <div class="card-body">
                                                <div class="row">
                                                    <!-- Rut -->
                                                    <div class="col-md-3 col-sm-6">
                                                        <div class="form-group">
                                                            <label>Rut</label>
                                                            <input type="text" class="form-control tp_bloquear" v-model="str_rut" >
                                                            <small v-if="arr_valida.str_rut" v-text="arr_valida.str_rut[0]"></small>
                                                        </div>
                                                    </div>

                                                    <!-- Nombre -->
                                                    <div class="col-md-3 col-sm-6">
                                                        <div class="form-group">
                                                            <label>Nombre</label>
                                                            <input type="text" class="form-control tp_bloquear" v-model="str_nombre" >
                                                            <small v-if="arr_valida.str_nombre" v-text="arr_valida.str_nombre[0]"></small>
                                                        </div>
                                                    </div>

                                                    <!-- Ap. Paterno -->
                                                    <div class="col-md-3 col-sm-6">
                                                        <div class="form-group">
                                                            <label>Ap. Paterno</label>
                                                            <input type="text" class="form-control tp_bloquear" v-model="str_ap_paterno" >
                                                            <small v-if="arr_valida.str_ap_paterno" v-text="arr_valida.str_ap_paterno[0]"></small>
                                                        </div>
                                                    </div>

                                                    <!-- Ap. Materno -->
                                                    <div class="col-md-3 col-sm-6">
                                                        <div class="form-group">
                                                            <label>Ap. Materno</label>
                                                            <input type="text" class="form-control tp_bloquear" v-model="str_ap_materno" >
                                                            <small v-if="arr_valida.str_ap_materno" v-text="arr_valida.str_ap_materno[0]"></small>
                                                        </div>
                                                    </div>

                                                    <!-- Mail -->
                                                    <div class="col-md-4 col-sm-6">
                                                        <div class="form-group">
                                                            <label>Mail</label>
                                                            <input type="text" class="form-control tp_bloquear" v-model="str_email" >
                                                            <small v-if="arr_valida.str_email" v-text="arr_valida.str_email[0]"></small>
                                                        </div>
                                                    </div>

                                                    <!-- Direccion Municipal -->
                                                    <div class="col-md-4 col-sm-6">
                                                        <div class="form-group">
                                                            <label >Dirección Municipal</label>
                                                            <multiselect 
                                                                :disabled="true"
                                                                :show-labels="false"
                                                                :searchable="true"
                                                                v-model="nr_direccion"
                                                                :options="arr_direccion"
                                                                :multiple="false"
                                                                :showNoOptions ="false" 
                                                                placeholder="Dirección Municipal"
                                                                label="label"                                                                 
                                                                track-by="label">
                                                                <span slot="noResult">No se han encontrado resultados</span>
                                                            </multiselect>
                                                            <small v-if="arr_valida.nr_direccion" v-text="arr_valida.nr_direccion[0]"></small>
                                                        </div>
                                                    </div>

                                                    <!-- Departamento -->
                                                    <div class="col-md-4 col-sm-6">
                                                        <div class="form-group">
                                                            <label>Departamento</label>
                                                            <multiselect 
                                                                :disabled="true"
                                                                :show-labels="false"
                                                                :searchable="true"
                                                                v-model="nr_depto"
                                                                :options="arr_depto"
                                                                :multiple="false"
                                                                :showNoOptions ="false" 
                                                                placeholder="Departmento"
                                                                label="label"                                                                 
                                                                track-by="label">
                                                                <span slot="noResult">No se han encontrado resultados</span>
                                                            </multiselect>
                                                            <small v-if="arr_valida.nr_depto" v-text="arr_valida.nr_depto[0]"></small>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Datos Solicitud -->
                                        <div class="card mt-4">
                                            <div class="card-header bg--primary" style="color:white">
                                                <h4 class="text-center">Datos Solicitud  </h4>
                                            </div>
                                            <div class="card-body">
                                                <div class="row">
                                                    <template v-if="is_user_territorial == 1">
                                                        <!-- MacroZona -->
                                                        <div class="col-md-6 col-sm-12">
                                                            <div class="form-group">
                                                                <label >Macro Zona</label>
                                                                <multiselect 
                                                                    :disabled="true"
                                                                    :show-labels="false"
                                                                    :searchable="true"
                                                                    v-model="nr_macrozona"
                                                                    :options="arr_macrozona"
                                                                    :multiple="true"
                                                                    :showNoOptions ="false" 
                                                                    placeholder="Macro Zona"
                                                                    label="label"                                                                 
                                                                    track-by="label">
                                                                    <span slot="noResult">No se han encontrado resultados</span>
                                                                </multiselect>
                                                                <small v-if="arr_valida.nr_macrozona" v-text="arr_valida.nr_macrozona[0]"></small>
                                                            </div>
                                                        </div>

                                                        <!-- Unidad Vecinal -->
                                                        <div class="col-md-6 col-sm-12">
                                                            <div class="form-group">
                                                                <label >Unidad Vecinal</label>
                                                                <multiselect 
                                                                    :disabled="true"
                                                                    :show-labels="false"
                                                                    :searchable="true"
                                                                    v-model="nr_unidadvecinal"
                                                                    :options="arr_unidadvecinal"
                                                                    :multiple="true"
                                                                    :showNoOptions ="false" 
                                                                    placeholder="Unidad Vecinal"
                                                                    label="label"                                                                 
                                                                    track-by="label">
                                                                    <span slot="noResult">No se han encontrado resultados</span>
                                                                </multiselect>
                                                                <small v-if="arr_valida.nr_unidadvecinal" v-text="arr_valida.nr_unidadvecinal[0]"></small>
                                                            </div>
                                                        </div>
                                                    </template>

                                                    <!-- Solicitudes Pendientes -->
                                                    <div class="col-md-3 col-sm-6">
                                                        <div class="form-group">
                                                            <label>Solicitudes Pendientes</label>
                                                            <input type="text" class="form-control tp_bloquear" v-model="cant_sp" >
                                                        </div>
                                                    </div>

                                                    <template v-if="is_user_territorial == 1">
                                                        <!-- Solicitudes Pendientes Por Visar -->
                                                        <div class="col-md-3 col-sm-6">
                                                            <div class="form-group">
                                                                <label>Solicitudes Por Visar</label>
                                                                <input type="text" class="form-control tp_bloquear" v-model="cant_sppv" >
                                                            </div>
                                                        </div>
                                                    </template>                                                        
                                                    </div>
                                            </div>
                                        </div>

                                        <!-- Datos Solicitud -->
                                        <div class="card mt-4">
                                            <div class="card-header bg--primary" style="color:white">
                                                <h4 class="text-center">Restablecer Contraseña</h4>
                                            </div>
                                            <div class="card-body">
                                                <div class="row">
                                                    <!-- Nueva Contraseña -->
                                                    <div class="col-md-3 col-sm-6">
                                                        <div class="form-group">
                                                            <label>Nueva Constraseña</label>
                                                            <input type="text" class="form-control" v-model="str_password">
                                                            <small v-if="arr_valida.str_email" v-text="arr_valida.str_email[0]"></small>
                                                        </div>
                                                    </div>

                                                    <!-- -->
                                                    <div class="col-md-3 col-sm-6">
                                                        <button class="btn btn-sm btn-secondary" 
                                                            @click="ensamblarDatos('reset_pass')">
                                                                <i class="fas fa-search"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary btn_activo" @click="cerrarModal('informacion');">Cerrar</button>
                        </div>
                    </div>
                </div>
            </div>          
        <!-- - - - - - - - - - - - - - - - - - - - - Termino de Modal - - - - - - - - - - - - - - - - - - - - -->        
    </div>
    </div>

    <script type="text/javascript">
        Vue.component('vue-multiselect', window.VueMultiselect.default);

        var app = new Vue({
            el: '#app',
            data: {
                //-------------------------------------
                modal_principal             :   0,
                modal_mensaje               :   0,
                accion_principal            :   0,
                accion_mensaje              :   0,
                boton_principal             :   0,
                boton_mensaje               :   0,
                titulo_principal            :   '',
                titulo_mensaje              :   '',
                //-------------------------------------
                arr_valida                  :   [],
                arr_error                   :   [],
                str_error                   :   '',
                tp_error                    :   0,
                //-------------------------------------
                pagination                  : {
                    'total' : 0,
                    'current_page' : 0,
                    'per_page' : 0,
                    'last_page' : 0,
                    'from' : 0,
                    'to' : 0,
                },
                //-------------------------------------
                offset                      :   3,
                //-------------------------------------
                fl_direccion                :   [],
                fl_depto                    :   [],
                fl_rut                      :   [],
                fl_usuario                  :   [],
                fl_perfil                   :   [],
                //-------------------------------------
                arr_index                   :   [],
                arr_info                    :   [],
                //-------------------------------------
                arr_direccion               :   [],
                arr_depto                   :   [],
                arr_rut                     :   [],
                arr_usuario                 :   [],
                arr_perfil                  :   [],
                arr_macrozona               :   [],
                arr_unidadvecinal           :   [],
                //-------------------------------------
                nr_direccion                :   [],
                nr_depto                    :   [],
                nr_perfil                   :   [],
                nr_unidadvecinal            :   [],
                nr_macrozona                :   [],
                //-------------------------------------
                nr_id_usuario               :   0,
                //-------------------------------------
                str_rut                     :   '',
                str_nombre                  :   '',
                str_ap_paterno              :   '',
                str_ap_materno              :   '',
                str_nm_usuario              :   '',
                str_email                   :   '',
                str_direccion               :   '',
                str_depto                   :   '',
                str_password                :   '',
                //-------------------------------------
                is_user_territorial         :   0,  // Es Usuario Territorial                
                cant_sp                     :   0,  // Cantidad de Solicitud Pendientes
                cant_sppv                   :   0,  // Cantidad de Solicitud Pendientes por Visar
                //-------------------------------------
            },

            components: {
                //-------------------------------------------------------------------------------------------
                Multiselect: window.VueMultiselect.default,
                //-------------------------------------------------------------------------------------------
            },

            computed:{
                //-------------------------------------------------------------------------------------------
                isActivedPagination: function()
                {
                    return this.pagination.current_page;
                },
                //-------------------------------------------------------------------------------------------
                pagesNumber: function()
                {
                    if(!this.pagination.to) {
                        return [];
                    }

                    var from = this.pagination.current_page - this.offset;
                    if(from < 1) {
                        from = 1;
                    }

                    var to = from + (this.offset * 2);
                    if(to >= this.pagination.last_page){
                        to = this.pagination.last_page;
                    }

                    var pagesArray = [];
                    while(from <= to) {
                        pagesArray.push(from);
                        from++;
                    }
                    return pagesArray;
                },
                //-------------------------------------------------------------------------------------------
            },

            methods: {
                //-------------------------------------------------------------------------------------------
                cambiarPagina(page)
                {
                    let me = this;
                    //Actualiza la página actual
                    me.pagination.current_page = page;
                    //Envia la petición para visualizar la data de esa página
                    me.cargarDatos(page);
                },
                //-------------------------------------------------------------------------------------------
                filtrarDatos()
                {
                    let me  =   this;
                    me.cargarIndex();
                },
                //-------------------------------------------------------------------------------------------
                limpiarFiltros()
                {
                    let me  =   this;

                    me.fl_depto         =   [];
                    me.fl_rut           =   [];
                    me.fl_usuario       =   [];

                    me.cargarDatos();
                },
                //-------------------------------------------------------------------------------------------
                getValue(data)
                {
                    var valor   =   0;

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.value;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                getLabel(data)
                {
                    var valor   =   '';

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.label;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                cargarEstadoUsuario(id_usuario)
                {
                    let me      =   this;
                    var ruta    =   '/territorial/admin/estado/usuario';

                    axios.post(ruta,{
                            'id_usuario'        :   id_usuario,
                    }).then(function (response)
                    {
                        var respuesta           =   response.data;
                        me.is_user_territorial  =   respuesta.is_usuario_territorial;
                        me.nr_unidadvecinal     =   respuesta.arr_unidadvecinal;
                        me.nr_macrozona         =   respuesta.arr_macrozona;
                        me.cant_sp              =   respuesta.solicitudes_pendientes;
                        me.cant_sppv            =   respuesta.pendiente_por_visar;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarDatos(page)
                {
                    let me      =   this;
                    me.cargarIndex(page);
                },
                //-------------------------------------------------------------------------------------------
                cargarIndex(page = 1)
                {
                    let me      =   this;
                    var ruta    =   '/territorial/admin/listado/usuarios';

                    axios.post(ruta,{
                            'page'              :   page,
                            'fl_depto'          :   me.getValue(me.fl_depto),
                            'fl_rut'            :   me.getValue(me.fl_rut),
                            'fl_usuario'        :   me.getValue(me.fl_usuario),
                    }).then(function (response)
                    {
                        var respuesta           =   response.data;
                        me.arr_index            =   respuesta.info.data;
                        me.pagination           =   respuesta.pagination;
                        me.rows                 =   respuesta.info.data;
                        me.arr_rut              =   respuesta.arr_rut;
                        me.arr_usuario          =   respuesta.arr_usuarios;
                        me.arr_direccion        =   respuesta.arr_direccion;
                        me.arr_depto            =   respuesta.arr_depto;
                        me.arr_macrozona        =   respuesta.arr_macrozona;
                        me.arr_unidadvecinal    =   respuesta.arr_unidadvecinal;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                validarDatos(accion)
                {
                    let me  =   this;

                    switch(accion)
                    {
                        case 'reset_pass':
                        {
                            if(me.str_password.trim().length > 5)
                                me.arr_valida.push({'new_password' : 'La contraseña ingresada debe tener minimo 5 caracteres'});

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                ensamblarDatos(accion)
                {
                    let me          =   this;
                    var formData    =   new FormData();

                    switch(accion)
                    {
                        case 'reset_pass':
                        {
                            titulo      =   'Registrando Etapa';
                            tiempo      =   3000;
                            error       =   me.validar('tarea');

                            if(error == 1)
                            {
                                me.abrirModal('mensaje','alerta');
                            }
                            else
                            {
                                //------------------------------------
                                ruta    =   '/proyecto/tarea/store';
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('nr_proyecto', me.nr_proyecto);
                                formData.append('nm_proyecto', me.nm_proyecto);
                                formData.append('nm_tarea', me.nm_tarea);
                                formData.append('nr_valorar', (me.nr_valorar));
                                formData.append('nr_progreso', me.nr_progreso);
                                formData.append('fc_inicio', moment(String(me.fc_inicio_tarea)).format(fc_format));
                                formData.append('fc_termino', moment(String(me.fc_termino_tarea)).format(fc_format));
                                formData.append('tp_agrupacion', me.tp_agrupacion);
                                formData.append('tp_arr',0);
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                registrarDatos()
                {
                    let me  =   this;

                },
                //-------------------------------------------------------------------------------------------
                abrirModal(modelo, accion, data = [])
                {
                    let me  =   this;

                    switch(modelo)
                    {
                        case 'usuarios':
                        {
                            me.tp_modal     =   1;

                            switch(accion)
                            {
                                case 'informacion':
                                {
                                    me.arr_info.push(data);
                                    me.cargarEstadoUsuario(data.id);
                                    me.str_rut          =   data.nr_rut;
                                    me.str_nombre       =   data.nombre;
                                    me.str_ap_paterno   =   data.ap_paterno;
                                    me.str_ap_materno   =   data.ap_materno;
                                    me.str_nm_usuario   =   data.nm_usuario;
                                    me.str_email        =   data.email;
                                    me.str_direccion    =   data.nm_direccion;
                                    me.str_depto        =   data.nm_depto;
                                    me.nr_direccion     =   data.direccion;
                                    me.nr_depto         =   data.depto;

                                    $('#modal_principal').modal('show');

                                    break;
                                }
                            }

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                cerrarModal(modelo)
                {
                    let me  =   this;

                    switch(modelo)
                    {
                        case 'informacion':
                        {
                            me.modal_principal        =   0;
                            me.accion_principal       =   0;
                            me.boton_principal        =   0;
                            me.titulo_principal       =   '';
                            $('#modal_principal').modal('hide');

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                limpiarDatos(accion)
                {
                    let me  =   this;

                    switch(accion)
                    {
                        case 'informacion':
                        {
                            me.arr_info             =   [];
                            me.str_rut              =   '';
                            me.str_nombre           =   '';
                            me.str_ap_paterno       =   '';
                            me.str_ap_materno       =   '';
                            me.str_nm_usuario       =   '';
                            me.str_email            =   '';
                            me.str_direccion        =   '';
                            me.str_depto            =   '';
                            me.nr_direccion         =   '';
                            me.nr_depto             =   '';
                            me.is_user_territorial  =   0;
                            me.arr_unidadvecinal    =   [];
                            me.nr_macrozona         =   0;
                            me.cant_sp              =   0;
                            me.cant_sppv            =   0;

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                zonaDeEspera(titulo, tiempo)
                {
                    Swal.fire({
                        title : '<h5>'+titulo+'</h5>',
                        html: '<strong> </strong>',
                        showConfirmButton: false,
                        timer: tiempo,
                        onBeforOpen: () => {
                            Swal.showLoading()
                        },
                    }).then((result) => {
                        if(result.dismiss == Swal.DismissReason.timer)
                        {
                            //----------------------------------------
                        }
                    });
                },
                //-------------------------------------------------------------------------------------------
                desplegarVentana(tp_icon, titulo, mensaje)
                {
                    let me          =   this;
                    var tp_btn      =   true;

                    /*
                        icon list
                        - success 
                        - error 
                        - warning 
                        - info 
                        - question
                    */

                    Swal.fire({
                        type: tp_icon,
                        title: titulo,
                        text: mensaje,
                        showConfirmButton: tp_btn
                    });
                },
                //-------------------------------------------------------------------------------------------
            },

            mounted() {
              let me = this;
              me.cargarDatos();
              $('.tp_bloquear').prop('disabled',true);
            }
        });
    </script>

    <script type="text/javascript">
        //-----------------------------------------------------------------
        $(document).ready(function(){
            /*----- Inicio - Filtrar -----*/
            $("#btn_filtrar_datos").click(function () {
                $content = $("#filtrar_datos");
                $content.slideToggle(500, function () {
                    // ---------------------------
                });
            });

            $("#close_filtrar_datos").click(function () {
                $content = $("#filtrar_datos");
                $content.slideToggle(500, function () {
                    // ---------------------------
                });
            });
            /*----- Inicio - Modal -----*/
        });
        //-----------------------------------------------------------------
        function justNumbers(e)
        {
            var keynum = window.event ? window.event.keyCode : e.which;
            if (keynum == 8)
                return true;

            return /\d/.test(String.fromCharCode(keynum));
        }
        //-----------------------------------------------------------------
    </script>
@endsection()


