@extends('Template.adminlte')

@section('main-title')
    {{ 'Ingreso de Solicitud' }}
@endsection

@section('main-navigation')
    <li class="">Administración</li>
    <li class="active">Ingreso de Solicitud</li>
@endsection

@push('styles')
    <style>
        .chart-container {
            height: 600px;
        }

        @media screen and (min-width: 1200px) {
            .chart-container {
              height: 800px;
            }
        }

        .mt-5 {
            margin-top: 2rem;
        }
    </style>
@endpush()

@section('main-content')
    <div class="box" id="app">
        <div class="box-body">
            <div class="x_title">
                <div class="col-md-12 col-sm-12">
                    <span style="float:left;">
                        <!-- -->
                    </span>
                    <span style="float:right;">
                        <button class="btn btn-primary" @click="refrescarDatos();">
                            <i class="fas fa-sync"></i> Actualizar
                        </button>

                        <button class="btn btn-primary btn_activo" id="btn_filtrar_datos">
                            <i class="fas fa-search"></i> Filtrar Datos
                        </button>

                        <button type="button" @click="abrirModal('solicitud','registrar')" class="btn btn-success">
                            <i class="fa fa-plus" aria-hidden="true"></i>&nbsp;Crear Solicitud
                        </button>
                    </span>
                </div>
            </div>

            <div class="x_content">
                <div class="col-md-12 col-sm-12 mt-5">
                    <!-- Filtro -->
                    <div class="col-md-12 col-sm-12">
                        <div class="collapse" id="filtrar_datos">
                            <div class="card">
                                <div class="card-header bg--primary">
                                    <div class="col-md-12 col-sm-12 text-center">
                                        <h5>Filtro de busqueda</h5>
                                    </div>
                                </div>
                                <div class="card-body">

                                    <div class="row ml-2 mr-2">
                                        <div class="col-md-12 col-sm-12"> </div>
                                        <!-- Tipo -->
                                        <div class="col-md-4 col-sm-6">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Tipo Solicitud :
                                                </label>
                                                <multiselect
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_tipo"
                                                    :options="arr_tipos"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Tipo Solicitud"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>

                                        <!-- Prioridad -->
                                        <div class="col-md-4 col-sm-6">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Prioridad :
                                                </label>
                                                <multiselect 
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_prioridad"
                                                    :options="arr_prioridad"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Prioridad"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>

                                        <!-- N° Ticket -->
                                        <div class="col-md-4 col-sm-6">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    N° Ticket :
                                                </label>
                                                <multiselect 
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_ticket"
                                                    :options="arr_ticket"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="N° Ticket"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>

                                        <!-- Unidad Vecinal -->
                                        <div class="col-md-4 col-sm-6">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Unidad Vecinal :
                                                </label>
                                                <multiselect 
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_unidadvecinal"
                                                    :options="arr_unidadvecinal"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Unidad Vecinal"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>

                                        <!-- Dirección Municipal -->
                                        <div class="col-md-4 col-sm-6">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Dirección Municipal :
                                                </label>
                                                <multiselect 
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_direccion"
                                                    :options="arr_dir_municipal"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Dirección Municipal"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>

                                        <!-- Persona -->
                                        <div class="col-md-4 col-sm-6">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Persona :
                                                </label>
                                                <multiselect
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_persona"
                                                    :options="arr_persona"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Persona"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <div style="float: right;">
                                        <button @click="limpiarFiltros()" type="button" class="btn btn-warning btn-sm" style="color: white;">
                                            <i class="fas fa-undo"></i> Quitar Filtros
                                        </button>&nbsp;
                                        <button @click="filtrarDatos()" type="button" class="btn btn-primary btn-sm"><i class="fas fa-search"></i>
                                            Filtrar Búsqueda
                                        </button>

                                        <button class="btn btn-secondary btn-sm" id="close_filtrar_datos">
                                            Cerrar Filtro
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Tabla -->
                    <div class="col-md-12 col-sm-12 mt-5">
                        <div class="col-md-4 mt-2 mb-4">
                            <div class="fom-group">
                                <label >Estados :</label>
                                <select @change="cargarDatos()"  v-model="fl_mostrar" class="form-control">
                                            <option v-for="item in arr_mostrar" :value="item.value" v-text="item.label"></option>
                                </select>
                            </div>                    
                        </div>

                        <div class="ml-1 mr-1 table-responsive">
                            <table class="table table-bordered table-striped table-sm">
                                <thead class="bg--primary">
                                    <th colspan="12" class="bg-indigo">
                                        <h6 class="text-center">
                                            Listado de Solicitudes
                                        </h6>
                                    </th>
                                </thead>
                                <thead class="bg--primary">
                                    <th style="min-width:50px; text-align:center;"> # </th>
                                    <th style="min-width:100px; text-align:center;">Opciones</th>
                                    <th style="min-width:100px; text-align:center;">Ticket</th>
                                    <th style="min-width:200px; text-align:center;">Fecha Ingreso</th>
                                    <th style="min-width:200px; text-align:center;">Tipo Solicitud</th>
                                    <th style="min-width:200px; text-align:center;">Dirección</th>
                                    <th style="min-width:200px; text-align:center;">Prioridad</th>
                                    <th style="min-width:200px; text-align:center;">Solicitante</th>
                                    <th style="min-width:200px; text-align:center;">Tiempo Tramitado</th>
                                    <th style="min-width:200px; text-align:center;">Estado</th>
                                </thead>
                                <tbody>
                                    <template v-if="arr_solicitudes.length">
                                        <tr v-for="(datos, index) in arr_solicitudes" :key="datos.id">
                                            <td style="text-align:center;">
                                                @{{ (index + 1) }}
                                            </td>
                                            <td style="text-align:center;">
                                                <button type="button" @click="abrirModal('solicitud', 'actualizar', datos);"
                                                        class="btn btn-secondary btn-sm" 
                                                        :class="{'btn-success':datos.id_estado == 12,
                                                                 'btn-danger':datos.id_estado == 13}"
                                                        title="Actualizar Solicitud">
                                                            <template v-if="datos.id_estado == 1">
                                                                <i class="fas fa-pencil-alt" style="color:white"></i>
                                                            </template>
                                                            <template v-else>
                                                                <i class="fas fa-search" style="color:white"></i>
                                                            </template>
                                                </button>
                                            </td>
                                            <td style="text-align:center;">
                                                @{{ datos.nr_ticket }}
                                            </td>
                                            <td style="text-align:center;">
                                                @{{ datos.fc_ingreso | formatDate }}
                                            </td>
                                            <td style="text-align:center;">
                                                @{{ datos.nm_tipo }}
                                            </td>
                                            <td  style="text-align:center; color: black;">
                                                @{{ datos.nm_ubicacion }}
                                            </td>
                                            <td style="text-align:center; color: black;" :style="{'background-color':datos.prioridad.color_prioridad}">
                                                @{{ datos.prioridad.nm_prioridad }}
                                            </td>                                            
                                            <td style="text-align:center;">
                                                @{{ datos.vecino.nmc_vecino }}
                                            </td>
                                            <td style="text-align:center;">
                                                @{{ datos.tiempo_tramitado }}
                                            </td>
                                            <td style="text-align:center;">
                                                @{{ datos.nm_estado }}
                                            </td>
                                        </tr>
                                    </template>
                                    <template v-else>
                                        <tr>
                                            <td colspan="12">
                                                <h5 class="text-center">
                                                    No hay datos para listar
                                                </h5>
                                            </td>
                                        </tr>
                                    </template>
                                </tbody>
                            </table>

                            <nav>
                                <ul class="pagination">
                                    <li class="page-item" v-if="pagination.current_page > 1">
                                        <a class="page-link" href="#" @click.prevent="cambiarPagina(pagination.current_page - 1)">Ant</a>
                                    </li>
                                    <li class="page-item" v-for="page in pagesNumber" :key="page" :class="[page == isActivedPagination ? 'active' : '']">
                                        <a class="page-link" href="#" @click.prevent="cambiarPagina(page)" v-text="page"></a>
                                    </li>
                                    <li class="page-item" v-if="pagination.current_page < pagination.last_page">
                                        <a class="page-link" href="#" @click.prevent="cambiarPagina(pagination.current_page + 1)">Sig</a>
                                    </li>
                                </ul>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- - - - - - - - - - - - - - - - - - - - -  Inicio de Modal - - - - - - - - - - - - - - - - - - - - -->
            <!-- Modal Principal -->
            <div class="modal scroll_modal" tabindex="-1" role="dialog" id="modal_principal">
                <!-- Inicio - Registrar -->
                <div class="modal-dialog modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">
                                <strong class="text-center" v-text="titulo_principal"></strong>
                            </h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                              <span aria-hidden="true">&times;</span>
                            </button>
                        </div>

                        <div class="modal-body lg_modal_body" id="registro_solicitud">
                            <ul class="nav nav-tabs nav-fill" id="nav-tab" role="tablist">
                                <li class="nav-item active">
                                    <a class="nav-link active" id="info_solicitud-tab" data-toggle="tab" href="#info_solicitud" role="tab" aria-controls="info_solicitud" aria-selected="false">
                                        <i class="far fa-list-alt"></i> Solicitud
                                    </a>
                                </li>
                                <li class="nav-item" v-if="tp_modal == 2 && tp_municipal == 1">
                                    <a class="nav-link" id="hito_solicitud-tab" data-toggle="tab" href="#hito_solicitud" role="tab" aria-controls="hito_solicitud" aria-selected="false">
                                        <i class="far fa-list-alt"></i>
                                        Historial
                                    </a>
                                </li>
                                <div class="text-right mb-1" v-if="tp_modal == 2">
                                    <button class="btn btn--primary" @click="cargarHistorial(id_consulta)">
                                        <i class="fas fa-sync"></i> Actualizar
                                    </button>
                                </div>
                            </ul>

                            <div class="tab-content">
                                <div class="tab-pane active" id="info_solicitud" role="tabpanel">
                                    <div class="row-flow">
                                        <!-- Datos usuarios -->
                                        <div class="card mt-4">
                                            <div class="card-header bg--primary" style="color:white">
                                                <h4 class="text-center">Datos Vecino</h4>
                                            </div>
                                            <div class="card-body">
                                                <div class="row">
                                                    <!-- Rut Vecino -->
                                                    <div class="col-md-3 col-sm-6">
                                                        <div class="form-group">
                                                            <label>Rut Vecino</label>
                                                            <input @change="getVecino()" type="text" class="form-control" v-model="rut_vecino" :disabled="(id_estado >= 8)">
                                                            <small v-if="validationErrors.rut_vecino" v-text="validationErrors.rut_vecino[0]"></small>
                                                        </div>
                                                    </div>
                                                    <!-- Nombre -->
                                                    <div class="col-md-3 col-sm-6">
                                                        <div class="form-group">
                                                            <label>Nombre</label>
                                                            <input type="text" maxlength="50" class="form-control" v-model="nm_vecino" :disabled="(id_estado >= 8)">
                                                            <small v-if="validationErrors.nm_vecino" v-text="validationErrors.nm_vecino[0]"></small>
                                                        </div>
                                                    </div>
                                                    <!-- Ap Paterno -->
                                                    <div class="col-md-3 col-sm-6">
                                                        <div class="form-group">
                                                            <label>Apellido Paterno</label>
                                                            <input type="text" maxlength="50" class="form-control" v-model="ap_paterno" :disabled="(id_estado >= 8)">
                                                            <small v-if="validationErrors.ap_paterno" v-text="validationErrors.ap_paterno[0]"></small>
                                                        </div>
                                                    </div>
                                                    <!-- Ap Materno -->
                                                    <div class="col-md-3 col-sm-6">
                                                        <div class="form-group">
                                                            <label>Apellido Materno</label>
                                                            <input type="text" maxlength="50" class="form-control" v-model="ap_materno" :disabled="(id_estado >= 8)">
                                                            <small v-if="validationErrors.ap_materno" v-text="validationErrors.ap_materno[0]"></small>
                                                        </div>
                                                    </div>
                                                    <!-- Telfono -->                                                    
                                                    <div class="col-md-3" >
                                                        <div class="form-group">
                                                            <label>Teléfono</label>
                                                            <div class=" input-group mb-3">
                                                              <div class="input-group-prepend">
                                                                
                                                                <div class="input-group-text">
                                                                 <select v-model="pre_fijo" :disabled="(id_estado >= 8)">
                                                                     <option value="+569">+569</option>
                                                                     <option value="+562">+562</option>
                                                                 </select>
                                                                </div>
                                                              </div>
                                                              <input v-model="nr_telefono" type="text"  maxlength="8" type="text" class="form-control" 
                                                                    onkeypress="return justNumbers(event);" :disabled="(id_estado >= 8)">
                                                               <small v-if="validationErrors.nr_telefono" v-text="validationErrors.nr_telefono[0]"></small>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!-- Mail -->
                                                    <div class="col-md-3 col-sm-6">
                                                        <div class="form-group">
                                                            <label>Mail</label>
                                                            <input type="text" maxlength="50" class="form-control" v-model="mail_vecino" :disabled="(id_estado >= 8)">
                                                            <small v-if="validationErrors.nm_mail" v-text="validationErrors.nm_mail[0]"></small>
                                                        </div>
                                                    </div>
                                                    <!-- Direccion Vecino -->
                                                    <div class="col-md-4 ">
                                                        <div class="form-group">
                                                            <label>Dirección del Vecino</label>
                                                            <multiselect 
                                                                :disabled="(id_estado >= 8)"
                                                                :show-labels="false"
                                                                :searchable="true"
                                                                v-model="arr_ubicacion_vecino"
                                                                :options="arr_calles_vecino"
                                                                :multiple="false"
                                                                :showNoOptions =false
                                                                placeholder="Ingresar Ubicacion"
                                                                @search-change="indexDireccionesVecino"
                                                                label="label" track-by="label">
                                                                    <span slot="noResult">No se han encontrado resultados</span>
                                                            </multiselect>
                                                            <small v-if="validationErrors.nm_direccion_vecino" v-text="validationErrors.nm_direccion_vecino[0]"></small>

                                                        </div>
                                                    </div>
                                                    <!-- Clasificacion de ubicacion vecino -->
                                                    <div class="col-md-2 col-sm-6">
                                                        <div class="form-group">
                                                            <label>Casa/Depto/Oficina</label>
                                                            <select v-model="tp_direccion" class="form-control" :disabled="(id_estado >= 8)">
                                                                <option value="1">Casa</option>
                                                                <option value="2">Depto</option>
                                                                <option value="3">Oficina</option>
                                                            </select>
                                                            <small v-if="validationErrors.tp_direccion" v-text="validationErrors.tp_direccion[0]"></small>
                                                        </div>
                                                    </div>
                                                    <!-- Aclaratoria -->
                                                    <div class="col-md-4 col-sm-6">
                                                        <div class="form-group">
                                                            <label>Aclaratoria</label>
                                                            <input type="text" maxlength="50" class="form-control" v-model="str_aclaratoria" :disabled="(id_estado >= 8)">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Datos Solicitud -->
                                        <div class="card mt-4">
                                            <div class="card-header bg--primary" style="color:white">
                                                <h4 class="text-center">Datos Solicitud  </h4>
                                            </div>
                                            <div class="card-body">
                                                <div class="row">
                                                    <!-- Contexto Municipal -->
                                                    <div class="col-md-2 col-sm-6">
                                                        <div class="form-group">
                                                            <label>Contexto Municipal :</label>
                                                            <select @change="changeContexto()" class="form-control" v-model="tp_municipal" :disabled="(id_estado >= 8)">
                                                                <option value="1">SI</option>
                                                                <option value="0">NO</option>
                                                            </select>
                                                            <small v-if="validationErrors.tp_municipal" v-text="validationErrors.tp_municipal[0]"></small>
                                                        </div>
                                                    </div>
                                                    <!-- Tipo Solicitud -->
                                                    <div class="col-md-4 col-sm-6">
                                                        <div class="form-group">
                                                            <label>Tipo Solicitud</label>
                                                            <multiselect
                                                                :disabled="(id_estado >= 8 || tp_municipal == 0)"
                                                                :show-labels="false"
                                                                :searchable="true"
                                                                v-model="nr_tipo"
                                                                :options="arr_tipos"
                                                                :multiple="false"
                                                                :showNoOptions ="false" 
                                                                @select="asyncSugerencia" 
                                                                placeholder="Seleccionar Tipo de Solicitud"
                                                                label="label"                                                                 
                                                                track-by="label">
                                                                <span slot="noResult">No se han encontrado resultados</span>
                                                            </multiselect>
                                                            <small v-if="validationErrors.nr_tipo" v-text="validationErrors.nr_tipo[0]"></small>
                                                            <small v-if="errorForm.tipo_solicitud"  v-text="errorForm.tipo_solicitud"></small>
                                                        </div>
                                                    </div>
                                                    <!-- tipo aclaracion direccion -->
                                                    <div class="col-md-2 col-sm-6">
                                                        <div class="form-group">
                                                            <label >Frente/Altura</label>
                                                            <select class="form-control" v-model="nr_tp_direccion_solicitud" :disabled="(id_estado >= 8 || tp_municipal == 0)">
                                                               <option value="1">Frente</option>
                                                               <option value="3">Altura</option>
                                                            </select>
                                                            <small v-if="validationErrors.tp_direccion_solicitud" v-text="validationErrors.tp_direccion_solicitud[0]"></small>
                                                        </div>
                                                    </div>
                                                    <!-- Ubicacion problema -->
                                                    <div class="col-md-4" v-if="nr_tp_direccion_solicitud == 1 || nr_tp_direccion_solicitud == 3">
                                                        <div class="form-group">
                                                            <label>Ubicación Problema :</label>
                                                            <multiselect
                                                                :disabled="(id_estado >= 8)"
                                                                :show-labels="false"
                                                                :searchable="true"
                                                                v-model="arr_direccion_solicitud"
                                                                :options="arr_calles_solicitud"
                                                                :multiple="false"
                                                                :showNoOptions =false
                                                                placeholder="Seleccionar Ubicación"
                                                                label="label" 
                                                                @search-change="indexDireccionesSolicitud"
                                                                track-by="label">
                                                                    <span slot="noResult">No se han encontrado resultados</span>
                                                            </multiselect>
                                                            <small v-if="validationErrors.arr_direccion_solicitud" v-text="validationErrors.arr_direccion_solicitud[0]"></small>

                                                        </div>
                                                    </div>
                                                    <!-- Calles -->
                                                    <div class="col-md-6" v-else>
                                                        <label for="">Ingresar Calles</label>
                                                        <div class="input-group">
                                                          <div class="input-group-prepend">
                                                            <span class="input-group-text">Intersecciones</span>
                                                          </div>
                                                            <select v-model="dir_1" class="form-control buscador" :disabled="(id_estado >= 8)">
                                                                <option v-text="calle.label" :value="calle.label" v-for="calle in arr_data_default.calles"></option>
                                                             
                                                            </select>
                                                            <select v-model="dir_2" class="form-control buscador" :disabled="(id_estado >= 8)">
                                                                <option v-text="calle.label" :value="calle.label" v-for="calle in arr_data_default.calles"></option>
                                                             
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <!-- Prioridad -->
                                                    <div class="col-md-2 col-sm-6">
                                                        <div class="form-group">
                                                            <label >Prioridad</label>
                                                            <select class="form-control" v-model="nr_prioridad" :disabled="(id_estado >= 8 || tp_municipal == 0)">
                                                                   <option v-for="nodo in arr_data_default.arr_prioridad" :value="nodo.value" v-text="nodo.label"></option>
                                                            </select>
                                                            <small v-if="validationErrors.nr_prioridad" v-text="validationErrors.nr_prioridad[0]"></small>
                                                        </div>
                                                    </div>
                                                    <!-- Direccion Municipal -->
                                                    <div class="col-md-4 col-sm-6">
                                                        <div class="form-group">
                                                            <label >Dirección Municipal :</label>
                                                            <select v-model="nr_dir_municipal" class="form-control" :disabled="(id_estado >= 8 || nr_dir_disabled == 1)">
                                                                <option value="0">Seleccionar Dirección</option>
                                                                <option v-for="nodo in arr_data_default.arr_direcciones" :value="nodo.value" v-text="nodo.label"></option>
                                                            </select>
                                                            <small v-if="validationErrors.nr_dir_municipal" v-text="validationErrors.nr_dir_municipal[0]"></small>
                                                        </div>
                                                    </div>
                                                    <!-- Descripcion Solicitud -->
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label>Descripción Solicitud :</label>
                                                            <textarea maxlength="2000" rows="2" v-model="str_observacion" class="form-control" :disabled="(id_estado >= 8)"></textarea>
                                                            <small class="form-text text-muted" id="str_observacion"  v-if="str_observacion" 
                                                                v-text="'Disponible '+(2000-str_observacion.trim().length)+' caracteres'"></small>
                                                            <small v-if="validationErrors.str_observacion" v-text="validationErrors.str_observacion[0]"></small>
                                                        </div>
                                                    </div>
                                                    <!-- Tabla de Archivos Adjuntos -->
                                                    <div class="table-responsive">
                                                        <table  class="table table-bordered table-striped table-sm" style="width: 100%">
                                                            <thead>
                                                                <tr class="bg--primary">
                                                                    <th class="text-center" colspan="4">Documentos Adjuntos 
                                                                        <button @click="abrirModal('archivo','anexar')" class="btn btn-primary btn-sm" 
                                                                            :disabled="(id_estado >= 8 || tp_municipal == 0)"> 
                                                                            <i class="fas fa-plus"></i>
                                                                        </button>
                                                                    </th>
                                                                </tr>
                                                                <tr v-if="arr_archivo.length || ( solicitud_actual.archivos && solicitud_actual.archivos.length)">
                                                                    <th>#</th>
                                                                    <th>Nombre</th>
                                                                    <th>Descripción</th>
                                                                    <th>Opción</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <template v-if="arr_archivo.length">
                                                                    <tr>
                                                                        <th class="text-center bg--primary" colspan="4" style="color:white">Archivos por Cargar</th>
                                                                        
                                                                    </tr>
                                                                    <tr v-for="(archivo, index) in arr_archivo" :key="index">
                                                                        <td class="text-center">@{{ (index+1) }}</td>
                                                                        <td>@{{ archivo.file.name }}</td>
                                                                        <td>@{{ archivo.descripcion }}</td>
                                                                        <td class="text-center">
                                                                            <button type="button" class="btn btn-sm btn-danger" title="Quitar Documento" @click="quitarAdjunto('archivo', index);">
                                                                                <i class="fas fa-times-circle"></i> Quitar
                                                                            </button>
                                                                        </td>
                                                                    </tr>
                                                                </template>
                                                                <template v-if="solicitud_actual.archivos && solicitud_actual.archivos.length">
                                                                    <tr>
                                                                        <th class="text-center bg-success" colspan="4" style="color:white">Archivos Cargados</th>
                                                                        
                                                                    </tr>
                                                                    <tr v-for="archivo in solicitud_actual.archivos" >
                                                                        <td>
                                                                            <a target=_blank :href="'/files/get/?ruta='+archivo.str_archivo">@{{ archivo.nm_archivo }}</a>
                                                                        </td>
                                                                        <td>@{{ archivo.str_observacion }}</td>
                                                                        <td class="text-center">
                                                                            <button @click="deleteFiles(archivo.str_archivo,archivo.nm_archivo)" type="button" class="btn btn-sm btn-danger" title="Quitar Documento">
                                                                                <i class="fas fa-times-circle"></i> Eliminar
                                                                            </button>
                                                                        </td>
                                                                    </tr>
                                                                </template>
                                                               
                                                                <template v-if="!solicitud_actual.archivos && !arr_archivo.length">
                                                                    <td colspan="4">
                                                                        <div class="empty" empty-text="No hay archivos adjuntos para listar"></div>
                                                                    </td>
                                                                </template>                                                
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Feedback Vecino -->
                                        <template v-if="id_estado === 12">
                                            <div class="card mt-4">
                                                <div class="card-header bg--primary" style="color:white">
                                                    <h4 class="text-center">Feedback Vecino</h4>
                                                </div>
                                                <div class="card-body">
                                                    <div class="row">
                                                        <!-- Tipo Recepción -->
                                                        <div class="col-md-6 col-sm-6">
                                                            <div class="form-group">
                                                                <label>Tipo Recepción</label>
                                                                <multiselect 
                                                                    :disabled="(tp_feedback == 1)"
                                                                    :allow-empty="false" 
                                                                    :show-labels="false"
                                                                    :searchable="true"
                                                                    v-model="tp_recepcion"
                                                                    :options="arr_recepcion"
                                                                    :multiple="false"
                                                                    :showNoOptions ="false" 
                                                                    placeholder="Seleccionar Tipo Recepción" 
                                                                    @select="asyncTipoRecepion" 
                                                                    label="label"                                                                 
                                                                    track-by="label">
                                                                    <span slot="noResult">No se han encontrado resultados</span>
                                                                </multiselect>
                                                            </div>
                                                        </div>

                                                        <!-- Tipo Satisfacción -->
                                                        <template v-if="(nr_recepcion == 1)">
                                                            <div class="col-md-6 col-sm-6">
                                                                <div class="form-group">
                                                                    <label>Tipo Satisfacción</label>
                                                                    <multiselect 
                                                                        :disabled="(tp_feedback == 1)"
                                                                        :allow-empty="false" 
                                                                        :show-labels="false"
                                                                        :searchable="true"
                                                                        v-model="tp_satisfaccion"
                                                                        :options="arr_satisfaccion"
                                                                        :multiple="false"
                                                                        :showNoOptions ="false" 
                                                                        placeholder="Seleccionar Tipo Satisfacción" 
                                                                        @select="asyncTipoSatisfacction" 
                                                                        label="label"                                                                 
                                                                        track-by="label">
                                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                                    </multiselect>
                                                                </div>
                                                            </div>
                                                        </template>                                                            

                                                        <!-- Descripcion Feedback -->
                                                        <div class="col-md-12">
                                                            <div class="form-group">
                                                                <label>Observación Feedback:</label>
                                                                <textarea maxlength="2000" rows="2" v-model="str_feedback" class="form-control" 
                                                                    placeholder="Observación del feedback del vecino" :disabled="(tp_feedback == 1)"></textarea>
                                                                <small class="form-text text-muted" id="str_feedback"  v-if="str_feedback" 
                                                                    v-text="'Disponible '+(2000-str_feedback.trim().length)+' caracteres'"></small>
                                                            </div>
                                                        </div>

                                                        <div class="col-md-12 text-right">
                                                            <template v-if="tp_feedback != 1">
                                                                <button type="button" id="btnRegistrar" class="btn btn-primary" @click="feedback()">
                                                                    <i class="fas fa-comment"></i> Guardar Feedback
                                                                </button>
                                                            </template>                                                                
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </template>
                                    </div>
                                </div>

                                <div class="tab-pane" id="hito_solicitud" role="tabpanel">
                                    <div class="form-group mt-3">
                                        <ul style="list-style-type: none;" class="timeline">
                                            <li v-for="(hito, index) in arr_historial" :key="hito.id">
                                                <div class="row">
                                                    <div class="form-group col-md-12 col-sm-12" style="padding-left:30px;">
                                                        <!-- Titulo Hito -->
                                                        <div class="row" style="padding-left: 20px;">
                                                            <div class="col-md-10 col-sm-9">
                                                                <a href="#" vi>
                                                                    <template v-if="hito.id_estado == 1">
                                                                        @{{ (index+1) + '.- ' + 'Funcionario Municipal - ' + hito.nm_autor }}
                                                                    </template>
                                                                    <template v-if="hito.id_estado == 2 || hito.id_estado == 3 || hito.id_estado == 4">
                                                                        @{{ (index+1) + '.- ' + 'Jefe Macro Zona' }}
                                                                    </template>
                                                                    <template v-if="hito.id_estado == 5 || hito.id_estado == 6 || hito.id_estado == 7">
                                                                        @{{ (index+1) + '.- ' + 'Jefe Territorial' }}
                                                                    </template>
                                                                    <template v-if="hito.id_estado == 8 || hito.id_estado == 9 || hito.id_estado == 10 || hito.id_estado == 11">
                                                                        @{{ (index+1) + '.- ' + hito.unidad_destino[0]['nm_direccion'] }}
                                                                    </template>
                                                                    <template v-if="hito.id_estado == 12 || hito.id_estado == 13">
                                                                        @{{ (index+1) + '.- ' + 'Unidad Territorial - ' }}
                                                                    </template>
                                                                </a>
                                                            </div>
                                                            <div class="col-md-2 col-sm-3">
                                                                <a href="#"> 
                                                                    @{{'Duración ' + hito.fc_diferencia + ' días'}}
                                                                </a>
                                                            </div>
                                                        </div>

                                                        <!-- Detalle Hito -->
                                                        <div class="col-md-12 col-sm-12">
                                                            <p style="margin-bottom: 0px">
                                                                <strong>Fecha Inicio :</strong><span v-if="hito.fc_inicio">@{{ hito.fc_inicio }}</span><br>
                                                                <strong>Fecha Término :</strong><span v-if="hito.fc_termino">@{{ hito.fc_termino }}</span><br>
                                                                <span v-if="hito.str_observacion">
                                                                    <strong>Observación :</strong> @{{ hito.str_observacion.trim() }} <br>
                                                                </span>
                                                                <template v-if="hito.visador.length">
                                                                    <div v-for="(visador, indice) in hito.visador" :key="indice">
                                                                        <span v-if="visador.nm_visador">
                                                                            <strong>Visador : </strong> @{{ visador.nm_visador }} <br>
                                                                        </span>
                                                                        <span v-if="visador.str_observacion">
                                                                            <strong>Observación Visado :</strong> @{{ visador.str_observacion }} <br>
                                                                        </span>
                                                                    </div>
                                                                </template>
                                                                <template v-if="hito.id_estado == 9">
                                                                    <span v-if="hito.unidad_destino.length">
                                                                        <strong>Unidad Destino : </strong> @{{ hito.unidad_destino[0]['nm_direccion'] }} <br>
                                                                    </span>                                                                        
                                                                </template>
                                                            </p>                                                                
                                                        </div>

                                                        <!-- Menu de acciones y Observaciones -->
                                                        <div v-if="(hito.id_estado == 8 || hito.id_estado == 9 || hito.id_estado == 10)">
                                                            <div class="row col-md-12 col-sm-12">
                                                                <button  class="btn btn-primary ml-2 mt-2" id="btn_ver_observaciones"
                                                                    @click="mostrarObservaciones()">
                                                                    <i class="fas fa-comments"></i> Ver Observaciones
                                                                </button>
                                                            </div>

                                                            <!-- Tabla de Encargados y Observaciones -->
                                                            <template v-if="hito.encargado.length">
                                                                <!-- Tabla de encargados -->
                                                                <div class="table-responsive pr-5">
                                                                    <table class="table table-bordered table-striped table-sm mr-5 mt-2 ">
                                                                        <thead class="bg--primary">
                                                                            <tr class="bg-info">
                                                                                <th colspan="5" class="text-center">Lista de Funcionarios</th>
                                                                            </tr>
                                                                            <tr>
                                                                                <th style="min-width:100px; text-align:center;">#</th>
                                                                                <th style="min-width:100px; text-align:center;">Fecha Asignado</th>
                                                                                <th style="min-width:100px; text-align:center;">Nombre</th>
                                                                                <th style="min-width:100px; text-align:center;">Contestado</th>
                                                                                <th style="min-width:100px; text-align:center;">Fecha Contestado</th>
                                                                            </tr>
                                                                        </thead>
                                                                        <tbody>
                                                                            <template v-if="hito.encargado.length">
                                                                                <tr v-for="(funcionario, index) in hito.encargado" :key="funcionario.id">
                                                                                    <td class="text-center">@{{ (index + 1) }}</td>
                                                                                    <td class="text-center">@{{ funcionario.fc_asignado }}</td>
                                                                                    <td class="text-center">@{{ funcionario.nm_encargado }}</td>
                                                                                    <td class="text-center">
                                                                                        <template v-if="funcionario.tp_validado == 1">
                                                                                            <button class="btn btn-sm btn-success">
                                                                                                <i class="fas fa-check"></i>
                                                                                            </button>
                                                                                        </template>
                                                                                        <template v-else>
                                                                                            <button class="btn btn-sm btn-danger">
                                                                                                <i class="fas fa-ban"></i>
                                                                                            </button>
                                                                                        </template>
                                                                                    </td>
                                                                                    <td class="text-center">@{{ funcionario.fc_validado }}</td>
                                                                                </tr>
                                                                            </template>
                                                                            <template v-else>
                                                                                <td colspan="5">
                                                                                    <div class="empty" empty-text="No hay datos para listar"></div>
                                                                                </td>
                                                                            </template>
                                                                        </tbody>
                                                                    </table>
                                                                </div>

                                                                <!-- Listado de Observaciones -->                                                            
                                                                <div class="collapse" id="ver_observaciones">
                                                                    <div class="col-md-12 col-sm-12 mt-1" style="padding-left: 0px;margin-left: 0px;">
                                                                            <div class="col-md-12 col-sm-12" style="padding-left: 0px;margin-left: 0px;">
                                                                                <div class="bg-info text-center">
                                                                                    <h5 style="color:white">Observaciones</h5>
                                                                                </div>
                                                                            </div>
                                                                        <div class="row">
                                                                            <template v-if="hito.observaciones.length">
                                                                                <ul class=" list-style-type: none col-md-12 col-sm-12 ml-3">
                                                                                    <li style="list-style-type: none" v-for="obs in hito.observaciones" :key="obs.id"
                                                                                        style="margin-bottom:5px; margin-top:5px;">
                                                                                        <div class="row">
                                                                                            <div class="timeline-arrow"></div>
                                                                                            <div class="col-md-11 col-sm-11 ml-4">
                                                                                                <a class="row" href="#" vi>
                                                                                                    <div class="col-md-6 col-sm-6">
                                                                                                        <template v-if="obs.tp_observacion == 1">
                                                                                                            @{{ 'Respuesta de Cierre - ' + obs.nm_autor  }}
                                                                                                        </template>
                                                                                                        <template v-if="obs.tp_observacion == 2">
                                                                                                            @{{ 'Respuesta - ' + obs.nm_autor  }}
                                                                                                        </template>
                                                                                                        <template v-if="obs.tp_observacion == 3">
                                                                                                            @{{ 'Observación - ' + obs.nm_autor  }}
                                                                                                        </template>
                                                                                                    </div>
                                                                                                    <div class="col-md-6 col-sm-6 text-right">
                                                                                                        <i class="far fa-calendar"></i>
                                                                                                        @{{ obs.fc_observacion }}
                                                                                                    </div>
                                                                                                </a>
                                                                                            </div>
                                                                                            <div class="row col-md-12 col-sm-12">
                                                                                                <div class="col-md-9 col-sm-9 ml-4">
                                                                                                    <p class="text-small mt-1 font-weight-light"
                                                                                                    style="margin-bottom:0px; margin-top:2px;">
                                                                                                        @{{ obs.str_observacion }}
                                                                                                    </p>
                                                                                                </div>
                                                                                            </div>
                                                                                            <div class="col-md-11 col-sm-11 ml-3">
                                                                                                <hr class="my-2">
                                                                                            </div>
                                                                                        </div>
                                                                                    </li>
                                                                                </ul>
                                                                            </template>
                                                                            <template v-else>
                                                                                <div class="col-md-12 col-sm-12 text-center">
                                                                                    <label class="form-control-label" for="input-text">
                                                                                        No hay observaciones disponibles
                                                                                    </label>
                                                                                </div>
                                                                            </template>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </template>
                                                        </div>
                                                    </div>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" @click="cerrarModal('solicitud');">Cerrar</button>
                            
                            <template v-if="boton_principal === 1">
                                <button v-if="btn_envio == 0" type="button" id="btnRegistrar" class="btn btn-primary" @click="ensamblarDatos('registrar',0)">
                                    <i class="fas fa-save"></i> Registrar
                                </button>
                                
                             <button v-else type="button"  class="btn btn-success ">Registrando <i  class="fas fa-spin fa-spinner"></i></button>

                            </template>
                            <template v-if="boton_principal === 2 && id_estado == 1">
                                <button type="button" id="btnActualizar" class="btn btn-warning" @click="ensamblarDatos('actualizar',1)">
                                    <i class="fas fa-pen"></i> Actualizar
                                </button>
                            </template>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Modal Adjunto -->
            <div class="modal" tabindex="-1" role="dialog" id="modal_adjunto">
                <!-- Aduntar Archivos -->
                <div class="modal-dialog modal-lg" role="document" v-if="accion_adjunto == 1">
                    <div class="modal-content">
                        <div class="modal-header bg--primary">
                            <h5 class="modal-title" v-text="titulo_adjunto"></h5>
                            <button type="button" class="close" @click="cerrarModal('archivo')" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="form-group">
                                <input accept=".jpeg,.jpg,.png,.doc,.docx,.xls,.xlsx,.ppt,.pptx,.pdf,.dwg,.dgn,.rar,.zip"
                                    type="file" id="file_adjunto" >
                            </div>
                            <div class="form-group">
                                <textarea maxlength="200" rows="3" v-model="file_observacion" class="form-control" placeholder="Descripción del archivo"></textarea>
                                <small id="cant_caracteres" class="form-text text-muted" v-text="'Disponible '+(200-file_observacion.trim().length)+' caracteres'" v-if="file_observacion"></small>
                            </div>
                            <template v-if="file_error">
                                <div class="text-center text-error">
                                    <div v-for="error in arr_error" :key="error" v-text="error"></div>
                                </div>
                            </template>
                        </div>
                        <div class="modal-footer">
                            <button @click="cerrarModal('archivo')" type="button" class="btn btn-light">Cerrar</button>
                            <button type="button" class="btn btn-primary" @click="validarAdjunto(tp_adjunto, 'save')">Subir</button>
                        </div>
                    </div>
                </div>

                <!-- Revisar Archivos -->
                <div class="modal-dialog modal-lg" role="document" v-if="accion_adjunto == 2">
                    <div class="modal-content">
                        <div class="modal-header bg--primary">
                            <h5 class="modal-title" v-text="titulo_adjunto"></h5>
                            <button type="button" class="close" @click="cerrarModal('archivo')" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped table-sm">
                                    <thead>
                                        <tr class="bg--primary">
                                            <th colspan="4" class="text-center">Archivos Adjuntos</th>
                                        </tr>
                                        <tr>
                                            <th style="min-width:50px; text-align:center;">#</th>
                                            <th style="min-width:150px; text-align:center;">Nombre</th>
                                            <th style="min-width:300px; text-align:center;">Descripción</th>
                                            <th style="min-width:50px; text-align:center;">Archivo</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <template v-if="arr_archivo.length">
                                            <tr v-for="(adjunto, index) in arr_archivo" :key="adjunto.id">
                                                <td class="text-center">@{{ (index+1) }}</td>
                                                <td class="text-center">@{{ adjunto.nm_archivo }}</td>
                                                <td class="text-left">@{{ adjunto.descripcion }}</td>
                                                <td class="text-center">
                                                    <a :href="'/storage?ruta='+adjunto.str_archivo" class="btn btn--primary btn-sm" title="Archivo Adjunto" v-if="adjunto.str_archivo">
                                                        <template v-if="adjunto.ext_archivo == 'pdf'">
                                                            <i class="far fa-file-pdf"></i>
                                                        </template>
                                                        <template v-if="adjunto.ext_archivo == 'doc' || adjunto.ext_archivo == 'docx'">
                                                            <i class="far fa-file-word"></i>
                                                        </template>
                                                        <template v-if="adjunto.ext_archivo == 'ppt' || adjunto.ext_archivo == 'pptx'">
                                                            <i class="far fa-file-powerpoint"></i>
                                                        </template>
                                                        <template v-if="adjunto.ext_archivo == 'xls' || adjunto.ext_archivo == 'xlsx'">
                                                            <i class="far fa-file-excel"></i>
                                                        </template>
                                                        <template v-if="adjunto.ext_archivo == 'rar' || adjunto.ext_archivo == 'zip'">
                                                            <i class="far fa-file-archive"></i>
                                                        </template>
                                                        <template v-if="adjunto.ext_archivo == 'jpeg' || adjunto.ext_archivo == 'jpg' || adjunto.ext_archivo == 'png'">
                                                            <i class="far fa-file-image"></i>
                                                        </template>
                                                        <template v-if="adjunto.ext_archivo == 'dwg' || adjunto.ext_archivo == 'dgn'">
                                                            <i class="far fa-file-code"></i>
                                                        </template>
                                                    </a>
                                                </td>
                                            </tr>
                                        </template>
                                        <template v-else>
                                            <td colspan="4">
                                                <div class="empty" empty-text="No hay archivos para mostrar"></div>
                                            </td>
                                        </template>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button @click="cerrarModal('archivo')" type="button" class="btn btn-light">Cerrar</button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Modal Mensaje -->
            <div class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog modal-primary modal-lg" role="document" v-if="accion_mensaje == 1">
                    <div class="modal-content">
                        <div class="modal-header">
                            <div class="col-md-11 col-sm-11 ml-3 text-center">
                                <h4 class="modal-title" v-text="titulo_mensaje"></h4>
                            </div>
                            <button type="button" class="close" @click="modal_mensaje = 0;" aria-label="Close">
                                <span aria-hidden="true">×</span>
                            </button>
                        </div>
                        <div class="modal-body" id="msj_error">
                            <!-- Mensaje de Alertas -->
                            <div class="col-md-12 col-sm-12 text-center">
                                <div class="row-fluid m-5">
                                    <div v-show="tp_error" class="form-group row div-error">
                                        <div class="text-center text-error">
                                            <div v-for="error in errors" :key="error" v-text="error">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" @click="modal_mensaje = 0;">
                                Cerrar
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        <!-- - - - - - - - - - - - - - - - - - - - - Termino de Modal - - - - - - - - - - - - - - - - - - - - -->
    </div>

    <script type="text/javascript">
        Vue.component('vue-multiselect', window.VueMultiselect.default);


        var app = new Vue({
            el: '#app',
            data: {
                //-------------------------------------
                btn_envio                   :   0,
                modal_principal             :   0,
                modal_adjunto               :   0,
                modal_mensaje               :   0,
                accion_principal            :   0,
                accion_adjunto              :   0,
                accion_mensaje              :   0,
                boton_principal             :   0,
                boton_adjunto               :   0,
                boton_mensaje               :   0,
                titulo_principal            :   '',
                titulo_adjunto              :   '',
                titulo_mensaje              :   '',
                tp_modal                    :   0,
                //-------------------------------------
                arr_valida                  :   [],
                arr_error                   :   [],
                tp_error                    :   [],
                //-------------------------------------
                pagination                  : {
                    'total' : 0,
                    'current_page' : 0,
                    'per_page' : 0,
                    'last_page' : 0,
                    'from' : 0,
                    'to' : 0,
                },
                //-------------------------------------
                offset                      :   3,
                //-------------------------------------
                fl_tipo                     :   [],
                fl_prioridad                :   [],
                fl_funcionario              :   [],
                fl_persona                  :   [],
                fl_direccion                :   [],
                fl_unidadvecinal            :   [],
                fl_ticket                   :   [],
                //-------------------------------------
                arr_archivo                 :   [],
                arr_files                   :   [],
                arr_files_obs               :   [],
                file_observacion            :   '',
                tp_adjunto                  :   '',
                file_error                  :   0,
                //-------------------------------------
                arr_index                   :   [],
                arr_prioridad               :   [],
                arr_funcionario             :   [],
                arr_persona                 :   [],
                arr_calles_vecino           :   [],
                arr_calles_solicitud        :   [],
                arr_dir_municipal           :   [],
                arr_unidadvecinal           :   [],
                arr_ticket                  :   [],
                //-------------------------------------
                arr_solicitudes             :   [],
                //-------------------------------------
                tp_municipal                :   1,
                nr_prioridad                :   1,
                nr_funcionario              :   [],
                //-------------------------------------
                rut_vecino                  :   '',
                nm_vecino                   :   '',
                ap_paterno                  :   '',
                ap_materno                  :   '',
                str_vecino                  :   '',
                nm_direccion                :   '',
                nr_direccion                :   0,
                nr_telefono                 :   '',
                mail_vecino                 :   '',
                tp_vecino                   :   0,
                str_observacion             :   '',
                nr_tipo                     :   {
                    'value' : 0,
                    'label' : 'Seleccionar Tipo de Solicitud',
                    'id_direccion' : 0,
                },
                tp_direccion                :   1,
                str_aclaratoria             :   '',
                //Datos Solicitud
                arr_direccion_solicitud     :   [],
                arr_ubicacion_vecino        :   [],
                nr_ubicacion                :   '',
                str_longitud                :   '',
                str_latitud                 :   '',
                str_observacion             :   '',
                fc_ingreso                  :   '',
                tp_aprobado                 :   0,
                tp_activo                   :   1,
                id_consulta                 :   0,
                nr_dir_municipal            :   0,
                nr_tp_direccion_solicitud   :   1,
                //-------------------------------------
                existe_vecino               :   0,
                //-------------------------------------
                validationErrors            : [],
                errorForm                   : {},
                solicitud_actual            : [],
                arr_data_default            : [],
                arr_tipos                   : [{
                    'value' : 0,
                    'label' : 'Seleccionar Tipo de Solicitud',
                    'id_direccion' : 0,
                }],
                nr_dir_disabled             : 0,
                id_estado                   : 0,
                dir_1                       : 0,
                dir_2                       : 0,
                pre_fijo                    : '+569',
                //------------------------------------
                arr_historial               :   [],
                //------------------------------------
                colores                     : {
                    'VERDE'     : 'green',
                    'ROJO'      : 'red',
                    'NARANJA'   : 'orange',
                    'AMARILLO'  : 'yellow',
                },
                arr_mostrar                 :   [
                    {
                        'value'     :   0,
                        'label'     :   'Todos',
                    },
                    {
                        'value'     :   1,
                        'label'     :   'Ingresadas',
                    },
                    {
                        'value'     :   13,
                        'label'     :   'No Municipal',
                    },
                    {
                        'value'     :   4,
                        'label'     :   'Rechazadas',
                    },
                    {
                        'value'     :   8,
                        'label'     :   'Despachado',
                    },
                    {
                        'value'     :   12,
                        'label'     :   'Finalizado',
                    },
                ],
                fl_mostrar                  :   1,
                //------------------------------------
                tp_feedback                 :   0,
                nr_recepcion                :   0,
                tp_recepcion                :   [
                    {
                        'value' : 0,
                        'label' : 'No Contactado',
                    }
                ],
                nr_satisfaccion             :   0,
                tp_satisfaccion             :   [],
                str_feedback                :   '',
                str_error                   :   '',
                //------------------------------------
                arr_recepcion               :   [
                    {
                        'value' : 0,
                        'label' : 'No Contactado',
                    },
                    {
                        'value' : 1,
                        'label' : 'Contactado',
                    },
                ],
                arr_satisfaccion            :   [
                    {
                        'value' : 5,
                        'label' : 'Muy satisfecho',
                    },
                    {
                        'value' : 4,
                        'label' : 'Satisfecho',
                    },
                    {
                        'value' : 3,
                        'label' : 'Normal',
                    },
                    {
                        'value' : 2,
                        'label' : 'Poco satisfecho',
                    },
                    {
                        'value' : 1,
                        'label' : 'Nada satisfecho',
                    },
                ],
                //------------------------------------
            },

            components: {
                //-------------------------------------------------------------------------------------------
                Multiselect: window.VueMultiselect.default
                //-------------------------------------------------------------------------------------------
            },

            filters:{
                resumir: function ($texto, $limite=90, $final=' ...->')
                {
                    var largo = $texto.toString().length;
                    if(largo > $limite){
                        for (var i = 0; i < largo; i++) {
                            if($texto[i] == ' ' && i >= $limite){
                                $texto = $texto.substring(0,i);
                                $texto = $texto + $final;
                                return $texto;
                            }
                        }                    
                    }
                    return $texto;
                },

                formatDate: function (fecha)
                {
                    if(fecha)
                    {
                        return moment(String(fecha)).format('DD-MM-YYYY')
                    }
                },

                formatDateTime: function (fecha)
                {
                    if(fecha)
                    {
                        return moment(String(fecha)).format('DD-MM-YYYY HH:mm')
                    }
                },
            },

            computed:{
                //-------------------------------------------------------------------------------------------
                isActivedPagination: function()
                {
                    return this.pagination.current_page;
                },
                //-------------------------------------------------------------------------------------------
                pagesNumber: function()
                {
                    if(!this.pagination.to) {
                        return [];
                    }

                    var from = this.pagination.current_page - this.offset;
                    if(from < 1) {
                        from = 1;
                    }

                    var to = from + (this.offset * 2);
                    if(to >= this.pagination.last_page){
                        to = this.pagination.last_page;
                    }

                    var pagesArray = [];
                    while(from <= to) {
                        pagesArray.push(from);
                        from++;
                    }
                    return pagesArray;
                },
                //-------------------------------------------------------------------------------------------
            },

            methods: {
                //-------------------------------------------------------------------------------------------
                refrescarDatos()
                {
                    let me  =   this;

                    me.dataDefault();
                    me.cargarDatos();
                },
                //-------------------------------------------------------------------------------------------
                asyncSugerencia(item) // Sugerir Direccion
                {
                    let me  =   this;

                    if(item) //if(Object.keys(item).length > 0)
                    {
                        me.nr_tipo              =   item;
                        me.nr_dir_municipal     =   item.id_direccion;

                        /*
                        var tipos   = me.arr_data_default.arr_tipos
                        var index   = tipos.map(function (nodo) { return nodo.value; }).indexOf(item.value);
                        me.nr_dir_municipal = tipos[index].id_direccion;
                        */
                    }
                },
                //-------------------------------------------------------------------------------------------
                getVecino()
                {
                    let me      = this;
                    var ruta    = '/get/vecino/'+me.rut_vecino
                    axios.get(ruta).then(function (response)
                    {
                        var respuesta           = response.data;
                        var vecino              = respuesta.vecino
                        var tramites            = respuesta.tramites

                        console.log(vecino)

                        if(!vecino)
                                return

                        if(tramites == 0)
                        {
                            me.nm_vecino                    =   vecino.nm_vecino;
                            me.ap_paterno                   =   vecino.ap_paterno;
                            me.ap_materno                   =   vecino.ap_materno;
                            me.mail_vecino                  =   vecino.nm_mail;
                            me.tp_direccion                 =   vecino.tp_direccion;
                            me.str_aclaratoria              =   vecino.str_aclaratoria;
                            me.nr_telefono                  =   vecino.nr_telefono.slice(-8);
                            me.pre_fijo                     =   vecino.nr_prefijo;

                            me.arr_ubicacion_vecino         =    
                            {
                                value : vecino.id_ubicacion,
                                label : vecino.nm_ubicacion,
                                nr_calle : vecino.nr_calle,
                                nm_calle : vecino.nm_calle,
                                str_latitud : vecino.str_latitud,
                                str_longitud : vecino.str_longitud,
                                cod_territorial : vecino.cod_macroterritorio,
                                cod_unidadvecinal : vecino.cod_unidadvecinal,
                            }
                        }else
                        {
                            me.nm_vecino                    =   vecino.nm_vecino;
                            me.ap_paterno                   =   vecino.ap_paterno;
                            me.ap_materno                   =   vecino.ap_materno;
                            me.mail_vecino                  =   vecino.correo;
                            me.nr_telefono                  =   vecino.nr_telefono;
                            me.pre_fijo                     =   '+569';

                        }

                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                mostrarObservaciones()
                {
                    let me  =   this;

                    $("#ver_observaciones").slideToggle(500, function () {
                            // ---------------------------
                    });
                },
                //-------------------------------------------------------------------------------------------
                getLabel(data)
                {
                    var valor   =   '';

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.label;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                getValue(data)
                {
                    var valor   =   0;

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.value;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                changeContexto()
                {
                    let me = this;

                    if(me.tp_municipal == 0)
                        {
                            me.nr_dir_municipal = 0;
                            me.nr_dir_disabled = 1;

                            me.nr_tipo = {
                                'value'         : 0,
                                'label'         : 'Seleccionar Tipo de Solicitud',
                                'id_direccion'  : 0,
                            }
                        }
                    else
                        me.nr_dir_disabled = 0;
                },
                //-------------------------------------------------------------------------------------------
                dataDefault()
                {
                    let me          = this;
                    var ruta        = '/default/data';

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta           =   response.data;
                        me.arr_data_default     =   respuesta;
                        me.arr_tipos            =   respuesta.arr_tipos;
                        me.arr_prioridad        =   respuesta.arr_prioridad;
                        me.arr_dir_municipal    =   respuesta.arr_direcciones;
                        me.arr_unidadvecinal    =   respuesta.arr_unidadvecinal;
                        me.arr_persona          =   respuesta.arr_vecinos;
                        me.arr_ticket           =   respuesta.arr_ticket;

                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                getInfo(id_solicitud)
                {
                    let me          = this;
                    var ruta        = '/solicitud/get?id_solicitud='+id_solicitud;

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta                   =   response.data.solicitud.archivos;
                        me.solicitud_actual.archivos    =   respuesta

                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                deleteFiles(ruta_file,nm_archivo)
                {
                    let me          = this;
                    var ruta        = '/files/delete';

                    axios.post(ruta,{
                        'ruta'          : ruta_file,
                        'id_consulta'   : me.id_consulta,
                        'nm_archivo'    : nm_archivo
                    }).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.getInfo(me.id_consulta)

                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cerrarModal(modelo)
                {
                    let me  =   this;

                    switch(modelo)
                    {
                        case 'solicitud':
                        {
                            $('#modal_principal').modal('hide');
                            me.limpiarDatos(modelo);

                            break;
                        }
                        case 'archivo':
                        {
                            $('#modal_adjunto').modal('hide');
                            me.limpiarDatos(modelo);

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                cargarDatos(page = 1)
                {
                    let me          = this;
                    var ruta        = '/territorial/solicitud/inicio';
                    var respuesta   = [];

                    axios.post(ruta,{
                    'fl_mostrar'        :   me.fl_mostrar,
                    'page'              :   page,
                    'fl_tipo'           :   me.getValue(me.fl_tipo),
                    'fl_prioridad'      :   me.getValue(me.fl_prioridad),
                    'fl_persona'        :   me.getValue(me.fl_persona),
                    'fl_direccion'      :   me.getValue(me.fl_direccion),
                    'fl_unidadvecinal'  :   me.getValue(me.fl_unidadvecinal),
                    'fl_ticket'         :   me.getValue(me.fl_ticket),
                    }).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_solicitudes  =   respuesta.info.data ;
                        me.pagination       =   respuesta.pagination;

                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                callDirecciones(query,tp_opcion = 1)
                {
                    let me          = this;
                    var ruta        = '/direccion/index';
                    var respuesta   = [];

                    axios.post(ruta,{'nm_direccion':   query,
                    }).then(function (response)
                    {
                        var respuesta   =   response.data;

                        if(tp_opcion == 1)
                                me.arr_calles_vecino = respuesta.result;
                        
                        if(tp_opcion == 2)
                                me.arr_calles_solicitud = respuesta.result;

                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                indexDireccionesSolicitud(query)
                {
                    let me          = this;
                    var ruta        = '/direccion/index';

                    if(query.length >= 3) 
                        me.callDirecciones(query,2);
                },
                //-------------------------------------------------------------------------------------------
                indexDireccionesVecino(query)
                {
                    let me          = this;
                    var ruta        = '/direccion/index';

                    if(query.length >= 3) 
                        me.callDirecciones(query,1);
                },
                //-------------------------------------------------------------------------------------------
                cambiarPagina(page)
                {
                    let me  =   this;
                    me.pagination.current_page = page;
                    me.cargarDatos(page);
                },
                //-------------------------------------------------------------------------------------------
                filtrarDatos()
                {
                    let me  =   this;
                    me.cargarDatos();
                },
                //-------------------------------------------------------------------------------------------
                limpiarFiltros()
                {
                    let me  =   this;
                    me.fl_tipo          =   [];
                    me.fl_prioridad     =   [];
                    me.fl_funcionario   =   [];
                    me.fl_persona       =   [];
                    me.fl_direccion     =   [];
                    me.fl_unidadvecinal =   [];
                    me.fl_ticket        =   [];

                    me.cargarDatos();
                },
                //-------------------------------------------------------------------------------------------
                limpiarDatos(modelo)
                {
                    let me  =   this;

                    switch(modelo)
                    {
                        case 'solicitud':
                        {
                            me.arr_error        =   [];
                            me.arr_valida       =   [];
                            me.tp_error         =   [];

                            me.nr_estado        =   [];
                            me.nr_secuencia     =   [];
                            me.nr_prioridad     =   1;
                            me.tp_direccion     =   1;
                            me.nr_tipo          =   {
                                'value' : 0,
                                'label' : 'Seleccionar Tipo de Solicitud',
                                'id_direccion' : 0,
                            };
                            me.nr_dir_municipal =   0;

                            me.rut_vecino       =   '';
                            me.nm_vecino        =   '';
                            me.ap_paterno       =   '';
                            me.ap_materno       =   '';
                            me.nr_telefono      =   '';
                            me.mail_vecino      =   '';
                            me.nm_direccion     =   '';
                            me.nr_direccion     =   '';
                            me.str_aclaratoria  =   '';
                            me.str_observacion  =   '';
                            me.fc_ingreso       =   '';
                            me.tp_aprobado      =   0;
                            me.id_estado        =   0;
                            me.tp_activo        =   1;

                            me.arr_archivo      =   [];
                            me.solicitud_actual =   [];
                            me.nr_tp_direccion_solicitud    =   1;

                            break;
                        }
                        case 'archivo':
                        {
                            me.file_observacion =   '';
                            me.arr_error        =   [];
                            me.arr_valida       =   [];
                            me.tp_error         =   0;
                            me.descartarAdjunto();

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                validarAdjunto(tipo, accion)
                {
                    let me              =   this;
                    var extension       =   '';
                    var fileSize        =   0;
                    var file_adjunto    =   '';
                    var file_value      =   '';
                    var max             =   3;
                    var error           =   0;
                    me.arr_error        =   [];

                    switch(tipo)
                    {
                        case "documento":
                        {
                            file_adjunto    =   document.querySelector("#file_adjunto");
                            file_value      =   file_adjunto.value;
                            var tipo_ext    =   ['.jpeg','.jpg','.png','.doc','.docx','.xls','.xlsx',
                                                '.ppt','.pptx','.msg','.pdf','.dwg','.dgn','.rar','.zip'];

                            if(file_value != "")
                            {
                                var fileSize  = file_adjunto.files[0].size;
                                extension = (file_value.substring(file_value.lastIndexOf("."))).toLowerCase();

                                if(fileSize > 20971520 ) 
                                    me.arr_error.push("El archivo adjunto NO debe superar los 20 MB");

                                if(!tipo_ext.includes(extension))
                                    me.arr_error.push("El archivo seleccionado No es adminido");

                                if(me.arr_archivo.length == max)
                                    me.arr_error.push("Solo se pueden adjuntar "+max+" archivos maximo");

                                if(me.file_observacion.trim() == '' )
                                     me.arr_error.push("Favor Ingresar Descripción de Adjunto.");
                            }


                            if(me.arr_error.length)
                                me.descartarAdjunto();

                            if(accion == "save" && me.arr_error.length == 0 && file_value != "")
                            {
                                me.arr_files.push(file_adjunto.files[0]);
                                me.arr_files_obs.push(me.file_observacion);
                                me.arr_archivo.push({'file':file_adjunto.files[0], 'descripcion':me.file_observacion});                                
                                $('#modal_adjunto').modal('hide');
                                me.descartarAdjunto();
                                me.limpiarDatos('archivo');
                            }


                            break;
                        }
                    }

                    if(me.arr_error.length) 
                    {
                        error   =   1;
                        me.file_error   =   1;
                    }

                    return error;
                },
                //-------------------------------------------------------------------------------------------
                descartarAdjunto()
                {
                    let me              =   this;
                    var file_adjunto    =   '';

                    file_adjunto    =   document.querySelector("#file_adjunto");

                    if(file_adjunto)
                    {
                        document.querySelector("#file_adjunto").value = "";
                    }
                },
                //-------------------------------------------------------------------------------------------
                quitarAdjunto(modelo, index)
                {
                    let me          =   this;
                    me.arr_error    =   [];

                    switch(modelo)
                    {
                        case 'archivo':
                        {
                            me.arr_files.splice(index, 1);
                            me.arr_archivo.splice(index, 1);
                            me.arr_files_obs.splice(index, 1);

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                cargarHistorial(id_consulta)
                {
                    let me      = this;
                    var ruta    = '/territorial/historial/solicitud';

                    axios.post(ruta,{
                        'id_solicitud'  :   id_consulta,
                    }).then(function (response) 
                    {
                        var respuesta       =   response.data;
                        me.arr_historial    =   respuesta.arr_historial;
                    }).catch(function (error) 
                    {
                        console.log(error)
                    });     
                },
                //-------------------------------------------------------------------------------------------
                ensamblarDatos(accion,tp_consulta = 0)
                {
                    let me              =   this;
                    var ruta            =   '';
                    var titulo          =   '';
                    var tiempo          =   0;
                    var error           =   0;                    
                    var formData        =   new FormData();
                    var fc_format       =   'YYYY-MM-DD';
                    var dir_vecino      =   '';
                    var dir_solicitud   =   '';
                    var nr_dir_solicitud    =   '';
                    var nr_dir_vecino       =   '';
                    me.tp_error         =   0;
                    me.arr_valida       =   [];                   
                    titulo              =   'Registrando de Solicitud';
                    tiempo              =   3000;                      
                    //------------------------------------
                    ruta    =   '/territorial/solicitud/registrar';
                    //------------------------------------
                    /*
                    if(me.nr_tp_direccion_solicitud == 2)
                        {
                            dir_solicitud       = me.dir_1+' && '+me.dir_2;
                            nr_dir_solicitud    = 1
                        }


                    if(me.arr_direccion_solicitud.label && me.nr_tp_direccion_solicitud !=2 )
                        {
                            dir_solicitud       =   me.arr_direccion_solicitud.label;
                            nr_dir_solicitud    =   me.arr_direccion_solicitud.value;
                        }

                    if(me.arr_ubicacion_vecino.label)
                        {
                            dir_vecino      =   me.arr_ubicacion_vecino.label;
                            nr_dir_vecino   =   me.arr_ubicacion_vecino.value;
                        }
                    */


                    console.log(me.nr_tipo)
                    console.log(me.getValue(me.nr_tipo))
                    console.log(me.getLabel(me.nr_tipo))

                    me.errorForm = {};

                    if(me.tp_municipal == 1 && me.nr_tipo.id_direccion == 0)
                    {
                       me.errorForm     =   {'tipo_solicitud' : 'Ingresar Tipo Solicitud'};
                       return
                    }
                    //------------------------------------
                    console.log('----- Ubicacion Solicitud -----');
                    console.log('length : ' + me.arr_direccion_solicitud.length);
                    console.log('Obj length : ' + Object.keys(me.arr_direccion_solicitud).length);
                    console.log(me.arr_direccion_solicitud);
                    console.log('-------------------------------------------');
                    console.log('----- Ubicacion Vecino -----');
                    console.log('length : ' + me.arr_ubicacion_vecino.length);
                    console.log('Obj length : ' + Object.keys(me.arr_ubicacion_vecino).length);
                    console.log(me.arr_ubicacion_vecino);
                    console.log('-------------------------------------------');
                    //------------------------------------
                    // Datos de Solicitud
                    formData.append('tp_consulta', tp_consulta);
                    formData.append('tp_update', tp_consulta);
                    formData.append('id_consulta', me.id_consulta);
                    formData.append('nr_tipo', me.getValue(me.nr_tipo));
                    formData.append('nm_tipo', me.getLabel(me.nr_tipo ));
                    formData.append('nr_prioridad', me.nr_prioridad);
                    // ubicacion del problema
                    if(Object.keys(me.arr_direccion_solicitud).length)
                        formData.append('arr_direccion_solicitud[]', JSON.stringify(me.arr_direccion_solicitud));
                    
                    formData.append('str_observacion', me.str_observacion);
                    formData.append('fc_ingreso', me.fc_ingreso);
                    formData.append('tp_municipal', me.tp_municipal);
                    formData.append('str_observacion', me.str_observacion);
                    formData.append('nr_dir_municipal', me.nr_dir_municipal);
                    formData.append('tp_direccion_solicitud', me.nr_tp_direccion_solicitud);
                    //------------------------------------
                    // Datos de Vecino
                    formData.append('rut_vecino', me.rut_vecino.trim());
                    formData.append('nm_vecino', me.nm_vecino);
                    formData.append('ap_paterno', me.ap_paterno);
                    formData.append('ap_materno', me.ap_materno);
                    formData.append('nm_mail', me.mail_vecino);
                    formData.append('pre_fijo', me.pre_fijo);
                    formData.append('nr_telefono', me.nr_telefono);

                    if(Object.keys(me.arr_ubicacion_vecino).length)
                        formData.append('arr_ubicacion_vecino[]', JSON.stringify(me.arr_ubicacion_vecino));

                    formData.append('tp_direccion', me.tp_direccion);
                    formData.append('str_aclaratoria', me.str_aclaratoria);
                    //------------------------------------
                    if(me.arr_files.length != 0)
                    {
                        for (var i = 0; i < me.arr_files.length; i++) 
                        {
                            formData.append('arr_archivo[]', me.arr_files[i]);
                        }
                        for (var i = 0; i < me.arr_files_obs.length; i++) 
                        {
                            formData.append('arr_observacion[]', me.arr_files_obs[i]);
                        }
                    }
                    //------------------------------------
                    me.registrarDatos(ruta, formData);
                    //------------------------------------
                },
                //-------------------------------------------------------------------------------------------
                validarDatos(tp_validacion)
                {
                    let me          =   this;
                    var error       =   0;
                    me.str_error    =   '';

                    switch(tp_validacion)
                    {
                        case 'feedback':
                        {
                            if(me.id_consulta == 0)
                                me.str_error    =   me.str_error + 'No se encuentra ID de la solicitud';

                            if(me.nr_recepcion == 1 && me.nr_satisfaccion == 0)
                                me.str_error    =   me.str_error + '<br>Debe ingresar el tipo de satisfaccion';

                            if((typeof me.str_feedback === "") || (me.str_feedback === null))
                                me.str_error    =   me.str_error + '<br>Debe ingresar la observación al feedback';

                            if(!(typeof me.str_feedback === "") && !(me.str_feedback === null))
                                if(me.str_feedback.trim().length < 5)
                                    me.str_error    =   me.str_error + '<br>La observación debe tener un minimo de 5 caracteres';

                            if(!(typeof  me.str_error === "") && !( me.str_error === null))
                                if(me.str_error.trim().length)
                                    error   =   1;

                            break;
                        }
                    }

                    return error;
                },
                //-------------------------------------------------------------------------------------------
                asyncTipoRecepion(item)
                {
                    let me  =   this;

                    if(item)
                        me.nr_recepcion     =   item.value;
                    else
                        me.nr_recepcion     =   0;

                    console.log(me.nr_recepcion);
                },
                //-------------------------------------------------------------------------------------------
                asyncTipoSatisfacction(item)
                {
                    let me  =   this;

                    if(item)
                        me.nr_satisfaccion  =   item.value;
                    else
                        me.nr_satisfaccion  =   0;

                    console.log(me.nr_satisfaccion);
                },
                //-------------------------------------------------------------------------------------------
                feedback()
                {
                    let me              =   this;
                    var ruta            =   '';
                    var titulo          =   '';
                    var mensaje         =   '';
                    var tiempo          =   0;
                    var error           =   0;
                    var formData        =   new FormData();
                    //------------------------------------
                    titulo              =   'Registrando Feedback';
                    tiempo              =   3000;                      
                    //------------------------------------
                    ruta    =   '/territorial/solicitud/feedback';
                    //------------------------------------
                    error   =   me.validarDatos('feedback');

                    if(error == 1)
                    {
                        me.desplegarVentana('warning', titulo, me.str_error, 1);
                        return;
                    }
                    else
                    {
                        //------------------------------------
                        formData.append('nr_solicitud', me.id_consulta);
                        formData.append('tp_recepcion', me.getValue(me.tp_recepcion));
                        formData.append('tp_satisfaccion', me.getValue(me.tp_satisfaccion));
                        formData.append('str_feedback', me.str_feedback);
                        //------------------------------------
                        me.registrarDatos(ruta, formData);
                        //------------------------------------
                    }                    
                },
                //-------------------------------------------------------------------------------------------
                registrarDatos(ruta, formData)
                {
                    let me              =       this;
                    var tp_icon         =       '';
                    var titulo          =       '';
                    var mensaje         =       '';
                    var error           =       '';
                    me.validationErrors =       [];
                    me.btn_envio        =        1;

                    axios.post(ruta, formData, {
                        headers: {'Content-Type': 'multipart/form-data'}
                    }).then(function (response) 
                    {
                        var result  =   response.data;
                       
                        tp_icon     =   result.tp_icon;
                        titulo      =   result.title;
                        mensaje     =   result.msj;
                        error       =   result.error;

                        me.desplegarVentana(tp_icon, titulo, mensaje);

                        //Limpiar Modelos
                        if(error == 0)
                        {
                            me.limpiarDatos('registrar')
                            $('#modal_principal').modal('hide');
                            me.refrescarDatos();
                            me.btn_envio        =        0;

                        }
                        else
                        {
                            me.limpiarDatos('registrar')
                            $('#modal_principal').modal('hide');
                            me.refrescarDatos();
                            me.btn_envio        =        0;
                        }
                    })
                    .catch(function (error) 
                    {
                        // Faltan campos por llenar
                         me.btn_envio        =        0;
                        if (error.response.status == 422)
                            me.validationErrors = error.response.data.errors;
                        /*// Formato de Archivo Incorrecto
                        if (error.response.status == 413)
                        {
                            //------------------------------
                        }*/
                    });
                },
                //-------------------------------------------------------------------------------------------
                abrirModal(modelo, accion, data = [])
                {
                    let me      =       this;

                    switch(modelo)
                    {
                        case 'solicitud':
                        {
                            switch(accion)
                            {
                                case 'registrar':
                                {
                                    me.tp_modal                 =   1;
                                    me.arr_historial            =   [];
                                    me.modal_principal          =   1;
                                    me.accion_principal         =   1;
                                    me.boton_principal          =   1;
                                    me.titulo_principal         =   'Registrar Solicitud';
                                    me.solicitud_actual         =   [];
                                    me.arr_ubicacion_vecino     =   [];
                                    me.arr_direccion_solicitud  =   [];
                                    me.limpiarDatos(modelo);

                                    //$('#nav-tab a[href="#info_solicitud-tab"]').tab('show')
                                    $('#nav-tab li:first-child a').tab('show');

                                    $('#modal_principal').modal('show');

                                    break;
                                }

                                case 'actualizar':
                                {
                                    me.tp_modal                     =   2;
                                    me.arr_historial                =   [];
                                    console.log(data);
                                    me.cargarHistorial(data.id);

                                    me.solicitud_actual             =   data;
                                    me.id_consulta                  =   data.id;
                                    me.rut_vecino                   =   data.vecino.nr_rut;
                                    me.nm_vecino                    =   data.vecino.nm_vecino;
                                    me.ap_paterno                   =   data.vecino.ap_paterno;
                                    me.ap_materno                   =   data.vecino.ap_materno;
                                    me.nr_telefono                  =   data.vecino.nr_telefono;
                                    me.pre_fijo                     =   data.vecino.nr_prefijo;
                                    me.mail_vecino                  =   data.vecino.nm_mail;
                                    me.str_aclaratoria              =   data.vecino.str_aclaratoria;
                                    me.nr_tipo.value                =   data.id_tipo;
                                    me.nr_tipo.label                =   data.nm_tipo;
                                    me.nr_tipo.id_direccion         =   data.id_direccion_destino;
                                    me.tp_municipal                 =   data.tp_municipal;
                                    me.nr_prioridad                 =   data.prioridad.id;
                                    me.id_estado                    =   data.id_estado;
                                    me.nr_dir_municipal             =   data.id_direccion_destino;
                                    me.nr_tp_direccion_solicitud    =   data.tp_direccion;                                    
                                    me.str_observacion              =   data.str_observacion;
                                    me.tp_feedback                  =   data.tp_feedback;
                                    me.nr_recepcion                 =   data.tp_recepcion;
                                    me.nr_satisfaccion              =   data.tp_satisfaccion;
                                    me.cargarElementos('tp_recepcion', data.tp_recepcion);
                                    me.cargarElementos('tp_satisfaccion', data.tp_satisfaccion);
                                    me.str_feedback                 =   data.str_feedback;


                                    /*
                                    if(me.nr_tp_direccion_solicitud == 2)
                                    {
                                        var intersecciones = data.nm_ubicacion;
                                        console.log(intersecciones)                                        

                                        if(intersecciones.length)
                                        {
                                            me.dir_1 = intersecciones.split('con')[0].trim();
                                            me.dir_2 = intersecciones.split('con')[1].trim();
                                        }                                        
                                    }else
                                    {
                                         me.arr_direccion_solicitud = {
                                                label : data.nm_ubicacion,
                                                value : data.nr_ubicacion,
                                            }
                                    }
                                    */

                                    me.arr_direccion_solicitud =    {
                                        value               : data.id_ubicacion,
                                        label               : data.nm_ubicacion,
                                        nr_calle            : data.nr_direccion,
                                        nm_calle            : data.nm_direccion,
                                        str_latitud         : data.str_latitud,
                                        str_longitud        : data.str_longitud,
                                        cod_territorial     : data.cod_territorio,
                                        cod_unidadvecinal   : data.cod_unidadvecinal,
                                        id_macroterritorio  : data.id_macroterritorio,
                                    }

                                    me.arr_ubicacion_vecino =    {
                                        value : data.vecino.id_ubicacion,
                                        label : data.vecino.nm_ubicacion,
                                        nr_calle : data.vecino.nr_calle,
                                        nm_calle : data.vecino.nm_calle,
                                        str_latitud : data.vecino.str_latitud,
                                        str_longitud : data.vecino.str_longitud,
                                        cod_territorial : data.vecino.id_macroterritorio,
                                        cod_unidadvecinal : data.vecino.id_unidadvecinal,
                                    }
                                    
                                    me.titulo_principal     =   'Actualizar Solicitud';
                                    me.boton_principal      =   2;
                                    me.arr_archivo          =   [];
                                    me.changeContexto();
                                    
                                    $('#modal_principal').modal('show');
                                    break;
                                }
                            }

                            break;
                        }
                        case 'archivo':
                        {
                            switch(accion)
                            {
                                case 'anexar':
                                {
                                    me.modal_adjunto        =   1;
                                    me.accion_adjunto       =   1;
                                    me.titulo_adjunto       =   'Adjuntar Documentos';
                                    me.tp_adjunto           =   'documento';
                                    me.limpiarDatos(modelo);
                                    $('#modal_adjunto').modal('show');

                                    if(data.nr_prioridad)
                                        me.nr_prioridad = data.nr_prioridad.id

                                    if(data.nr_afectado)
                                    me.nr_afectado  = data.nr_afectado

                                    break;
                                }
                            }

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                cargarElementos(tp_elemento, nr_elemento)
                {
                    let me      =   this;
                    var temp    =   [];

                    switch(tp_elemento)
                    {
                        case 'tp_recepcion':
                        {
                            me.tp_recepcion     =   [];

                            temp    =   me.arr_recepcion.filter(
                                            event   =>  event.value === nr_elemento
                                        );

                            if(me.tp_feedback == 1)
                            {
                                me.tp_recepcion     =   [{
                                    'value' : temp[0].value,
                                    'label' : temp[0].label,
                                }];
                            }
                            else
                            {
                                me.tp_recepcion     =   [{
                                        'value' : 0,
                                        'label' : 'No Contactado',
                                }];
                            }

                            break;
                        }
                        case 'tp_satisfaccion':
                        {
                            me.tp_satisfaccion  =   [];
                            temp    =   me.arr_satisfaccion.filter(
                                            event   =>  event.value === nr_elemento
                                        );

                            if(me.nr_recepcion == 1)
                            {
                                me.tp_satisfaccion  =   [{
                                    'value' : temp[0].value,
                                    'label' : temp[0].label,
                                }];
                            }

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                desplegarVentana(tp_icon, titulo, mensaje, tp_btn = 1)
                {
                    Swal.fire({
                        type: tp_icon,
                        title: titulo,
                        html: mensaje,
                        showConfirmButton: tp_btn
                    });                       
                },
                //-------------------------------------------------------------------------------------------
            },

            mounted() {
                let me = this;
                me.cargarDatos();
                me.dataDefault();                
            }
        });
    </script>

    <script type="text/javascript">
        //-----------------------------------------------------------------
        $(document).ready(function(){
            /*----- Inicio - Filtrar -----*/
            $("#btn_filtrar_datos").click(function () {
                $content = $("#filtrar_datos");
                $content.slideToggle(500, function () {
                    // ---------------------------                    
                });
            });

            $("#close_filtrar_datos").click(function () {
                $content = $("#filtrar_datos");
                $content.slideToggle(500, function () {
                    // ---------------------------                    
                });
            });
            /*----- Inicio - Modal -----*/            
        });
        //-----------------------------------------------------------------
        function justNumbers(e)
        {
            var keynum = window.event ? window.event.keyCode : e.which;
            if (keynum == 8)
                return true;

            return /\d/.test(String.fromCharCode(keynum));
        }
        //-----------------------------------------------------------------
    </script>
@endsection()


