@extends('Template.Template2.layout_consulta')

@section('main-title')
    {{ 'Consultar Solicitud' }}
@endsection

@section('main-navigation')
    <li class="">Consulta</li>
    <li class="active">Solicitud</li>
@endsection

@push('styles')
    <style>
        .chart-container {
            height: 600px;
        }

        @media screen and (min-width: 1200px) {
            .chart-container {
              height: 800px;
            }
        }

        .mt-5 {
            margin-top: 2rem;
        }

        .div-error{
            display: flex;
            justify-content: center;
        }

        .text-error{
            color: red !important;
            font-weight: bold;
        }       
    </style>
@endpush()

@section('main-content')

    <div class="box" id="app">
        <div class="box-body">
            <div class="row">

                <div class="col-md-3 offset-4 mt-4">
                    <form @submit.prevent="onSubmit" class="form-inline">
                        <div class="">
                            <label class="form-label" for="rut">Ingresar Rut :</label>
                            <input for="rut" v-model="buscar" type="text" maxlength="20" class="form-control">
                        </div>

                        <vue-recaptcha
                            ref="invisibleRecaptcha"
                            @verify="cargarIndex"
                            @expired="onExpired"
                            size="invisible"
                            :sitekey="keycaptcha">

                            <button  type="submit"  class="btn btn-primary btn_buscar ml-4 mt-4">
                                <i class="fa fa-search"></i>Buscar
                            </button>
                        </vue-recaptcha>
                    </form>
                </div>

            </div>
        </div>

        <div class="row">
            <div class="col-md-10 offset-1">
                <div class="card mt-4">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped table-sm pb-4">
                        <thead class="bg--primary">
                            <th colspan="9" class="bg-indigo">
                                <h6 class="text-center">
                                    Listado de Solicitudes
                                </h6>
                            </th>
                        </thead>
                        <thead>
                            <th style="min-width:50px; text-align:center;"> # </th>
                            <th style="min-width:100px; text-align:center;">Ticket</th>
                            <th style="min-width:200px; text-align:center;">Fecha Ingreso</th>
                            <th style="min-width:200px; text-align:center;">Tipo Solicitud</th>
                            <th style="min-width:200px; text-align:center;">Ubicacion</th>
                            <th style="min-width:200px; text-align:center;">Tiempo Tramitado</th>
                            <th style="min-width:200px; text-align:center;">Estado Solicitud</th>
                        </thead>
                        <tbody>
                            <template v-if="arr_index.length">
                                <tr v-for="(datos, index) in arr_index" :key="datos.id">
                                    <td style="text-align:center;">
                                        @{{ (index + 1) }}
                                    </td>
                                    
                                    <td style="text-align:center;">
                                        @{{ datos.nr_ticket  }}
                                    </td>
                                    <td style="text-align:center;">
                                        @{{ datos.fc_ingreso | formatDate }}
                                    </td>
                                    <td style="text-align:center;">
                                        @{{ datos.tipo.nm_tipo }}
                                    </td>
                                    <td style="text-align:center;">
                                        @{{ datos.nm_ubicacion }}
                                    </td>
                                                                       
                                    <td style="text-align:center;">
                                        @{{ datos.tiempo_tramitado }}
                                    </td>
                                    <td style="text-align:center;">
                                        <template v-if="datos.id_estado <= 11">
                                            <span>En Proceso</span>
                                        </template>
                                        <template v-else="datos.id_estado == 12">
                                            <span>Finalizado</span>
                                        </template>
                                    </td>
                                </tr>
                            </template>
                            <template v-else>
                                <tr>
                                    <td colspan="9">
                                        <h5 class="text-center">
                                            No hay datos para listar
                                        </h5>
                                    </td>
                                </tr>
                            </template>
                        </tbody>
                </table>
                </div>
            </div>
        </div>
    </div>
</div>
       
    </div>

    <script type="text/javascript">
        Vue.component('vue-multiselect', window.VueMultiselect.default);
        Vue.component( 'vue-recaptcha', VueRecaptcha )

        var app = new Vue({
            el: '#app',
            data: {
                keycaptcha                  : '6Lf9gMsbAAAAAKzBAqN8WU6xP-MRFUHZjp7rx2g4',
                //-------------------------------------
                arr_valida                  :   [],
                arr_error                   :   [],
                tp_error                    :   [],
                arr_calles_vecino           :   [],
                arr_data_default            :   [],
                //-------------------------------------
                pagination                  : {
                    'total' : 0,
                    'current_page' : 0,
                    'per_page' : 0,
                    'last_page' : 0,
                    'from' : 0,
                    'to' : 0,
                },
                //-------------------------------------
                offset                      :   3,
                //-------------------------------------
                arr_archivo                 :   [],
                arr_files                   :   [],
                arr_files_obs               :   [],
                solicitud_actual            :   [],
                file_observacion            :   '',
                //-------------------------------------
                arr_mostrar                 :   [
                    {
                        'value'     :   0,
                        'label'     :   'Todos',
                    },
                    {
                        'value'     :   11,
                        'label'     :   'Asignados',
                    },
                    {
                        'value'     :   13,
                        'label'     :   'Finalizados',
                    },
                ],
                fl_mostrar                  :   11,
                //-------------------------------------
                fl_tipo                     :   [],
                fl_prioridad                :   [],
                fl_ubicacion                :   [],
                //-------------------------------------
                arr_info                    :   [],
                //-------------------------------------
                arr_index                   :   [],
                arr_historial               :   [],
                arr_tipo                    :   [],
                arr_prioridad               :   [],
                arr_ubicacion               :   [],
                arr_carga_data              :   [],
                arr_subordinados            :   [],
                //-------------------------------------
                nr_tipo                     :   1,
                nr_prioridad                :   [],
                nr_direccion                :   [],
                nr_subordinados             :   [],
                //-------------------------------------
                tp_rechazar                 :   0,
                nr_id_solicitud             :   0,
                nr_id_historia              :   0,
                nr_id_despacho              :   0,
                nr_id_dir_destino           :   0,
                nr_id_estado                :   0,
                tp_observacion              :   0,
                str_observacion             :   '',
                arr_funcionarios            :   [],
                validationErrors            :   [],
                str_obs_asignar             :   '',
                nr_tp_direccion_solicitud   :    1,
                nr_dir_disabled             :    0,
                nr_dir_municipal            :    1,
                //-------------------------------------
                buscar                      :   '',
                //-------------------------------------
            },

            components: {
                //-------------------------------------------------------------------------------------------
                Multiselect: window.VueMultiselect.default,
                //-------------------------------------------------------------------------------------------
            },

            filters:{
                resumir: function ($texto, $limite=90, $final=' ...->')
                {
                    var largo = $texto.toString().length;
                    if(largo > $limite){
                        for (var i = 0; i < largo; i++) {
                            if($texto[i] == ' ' && i >= $limite){
                                $texto = $texto.substring(0,i);
                                $texto = $texto + $final;
                                return $texto;
                            }
                        }                    
                    }
                    return $texto;
                },

                formatDate: function (fecha)
                {
                    if(fecha)
                    {
                        return moment(String(fecha)).format('DD-MM-YYYY')
                    }
                },

                formatDateTime: function (fecha)
                {
                    if(fecha)
                    {
                        return moment(String(fecha)).format('DD-MM-YYYY HH:mm')
                    }
                },
            },

            computed:{
                //-------------------------------------------------------------------------------------------
                isActivedPagination: function()
                {
                    return this.pagination.current_page;
                },
                //-------------------------------------------------------------------------------------------
                pagesNumber: function()
                {
                    if(!this.pagination.to) {
                        return [];
                    }

                    var from = this.pagination.current_page - this.offset;
                    if(from < 1) {
                        from = 1;
                    }

                    var to = from + (this.offset * 2);
                    if(to >= this.pagination.last_page){
                        to = this.pagination.last_page;
                    }

                    var pagesArray = [];
                    while(from <= to) {
                        pagesArray.push(from);
                        from++;
                    }
                    return pagesArray;
                },
                //-------------------------------------------------------------------------------------------
            },

            methods: {
                onSubmit: function () 
                {
                    this.$refs.invisibleRecaptcha.execute()
                },
                
                onExpired: function () 
                {
                    console.log('Captcha Expirado')
                },
                resetRecaptcha() {
                this.$refs.recaptcha.reset() // Direct call reset method
                },
                //-------------------------------------------------------------------------------------------
                dataDefault()
                {
                    let me          = this;
                    var ruta        = '/consulta/datos/listado';

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_data_default = respuesta

                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                validaRut()
                {
                    let me  =   this;
                    var rut =   me.buscar;

                    var valida  =   Rut(rut);
                    
                    if(valida)
                        me.buscar = valida;               
                },
                //-------------------------------------------------------------------------------------------
                limpiarFiltros()
                {
                    let me  =   this;
                    me.fl_tipo          =   [];
                    me.fl_prioridad     =   [];
                    me.fl_solicitante   =   [];
                    me.fl_ubicacion     =   [];
                    me.fl_estado        =   [];
                    me.cargarIndex();
                },
                //-------------------------------------------------------------------------------------------
                filtrarDatos()
                {
                    let me  =   this;
                    me.cargarIndex();
                },
                //-------------------------------------------------------------------------------------------
                getValue(data)
                {
                    var valor   =   0;

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.value;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                getLabel(data)
                {
                    var valor   =   '';

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.label;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                mostrarObservaciones()
                {
                    let me  =   this;

                    $("#ver_observaciones").slideToggle(500, function () {
                            // ---------------------------
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarDataDefault()
                {
                    let me      =   this;
                    var ruta    =   '/consulta/datos/listado';

                    axios.get(ruta,{                        
                    }).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_carga_data   =   respuesta;
                        me.cargarTipoSolicitud();
                        me.cargarPrioridad();
                        me.cargarUbicaciones();
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarSubordinados()
                {
                    let me      =   this;
                    var ruta    =   '/subordinados/listado?id_direccion='+me.nr_id_dir_destino;

                    axios.get(ruta,{
                    }).then(function (response)
                    {
                        var respuesta           =   response.data;
                        me.arr_subordinados     =   respuesta.subordinados;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarTipoSolicitud()
                {
                    let me  =   this;
                    me.arr_tipo     =   [];
                    me.arr_tipo     =   me.arr_carga_data.arr_tipos;
                },
                //-------------------------------------------------------------------------------------------
                cargarUbicaciones()
                {
                    let me  =   this;
                    me.arr_ubicacion    =   [];
                    me.arr_ubicacion    =   me.arr_carga_data.arr_ubicaciones;
                },
                //-------------------------------------------------------------------------------------------
                cargarPrioridad()
                {
                    let me  =   this;
                    me.arr_prioridad    =   [];
                    me.arr_prioridad    =   me.arr_carga_data.arr_prioridad;
                },
                //-------------------------------------------------------------------------------------------
                cargarHistorial(nr_id_solicitud)
                {
                    let me      = this;
                    var ruta    = '/consulta/solicitud/historial';

                    axios.post(ruta,{
                        'id_solicitud'  :   nr_id_solicitud,
                    }).then(function (response) 
                    {
                        var respuesta       =   response.data;
                        me.arr_historial    =   respuesta.arr_historial;
                    }).catch(function (error) 
                    {
                        console.log(error)
                    });     
                },
                //-------------------------------------------------------------------------------------------
                getIdDespacho(data = [])
                {
                    let me      =   this;
                    var nr_id   =   0;

                    if(data.length)
                    {
                        nr_id   =   data[0]['id_despacho'];
                    }

                    return nr_id;
                },
                //-------------------------------------------------------------------------------------------
                cargarDatos()
                {
                    let me      =   this;
                    me.cargarDataDefault();
                    me.cargarIndex();
                },
                //-------------------------------------------------------------------------------------------
                cargarIndex(page = 1)
                {
                    let me      =   this;
                    var ruta    =   '/consulta/vecino';
                    console.log('dbnfjksb')

                    axios.post(ruta,{
                            'page'                  :   1,
                            'buscar'                :   me.buscar,
                    }).then(function (response)
                    {
                        var respuesta   =   response.data;
                        me.arr_index    =   respuesta.info.data;
                        me.pagination   =   respuesta.pagination;
                        me.rows         =   respuesta.info.data;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                abrirModal(modelo, accion, data = [])
                {
                    let me      =       this;

                    switch(modelo)
                    {
                        case 'archivo':
                        {
                            me.tp_modal     =   3;

                            switch(accion)
                            {
                                case 'anexar':
                                {
                                    me.limpiarDatos(accion);
                                    me.modal_adjunto        =   1;
                                    me.accion_adjunto       =   1;
                                    me.titulo_adjunto       =   'Adjuntar Documentos';
                                    me.tp_adjunto           =   'documento';
                                    $('#modal_adjunto').modal('show');

                                    break;
                                }
                                case 'revisar':
                                {
                                    me.limpiarDatos(accion);
                                    me.modal_adjunto        =   1;
                                    me.accion_adjunto       =   2;
                                    me.titulo_adjunto       =   'Revisar Documentos';
                                    me.tp_adjunto           =   'archivos';
                                    me.arr_archivo          =   data.archivos;
                                    $('#modal_adjunto').modal('show');

                                    break;
                                }
                            }

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                cerrarModal(modelo)
                {
                    let me  =   this;

                    switch(modelo)
                    {
                        case 'informacion':
                        {
                            me.modal_principal        =   0;
                            me.accion_principal       =   0;
                            me.boton_principal        =   0;
                            me.titulo_principal       =   '';
                            $('#modal_principal').modal('hide');

                            break;
                        }
                        case 'archivo':
                        {
                            me.modal_adjunto        =   0;
                            me.accion_adjunto       =   0;
                            me.boton_adjunto        =   0;
                            me.titulo_adjunto       =   '';
                            $('#modal_adjunto').modal('hide');

                            break;
                        }
                        case 'mensaje':
                        {
                            me.modal_mensaje        =   0;
                            me.accion_mensaje       =   0;
                            me.titulo_mensaje       =   '';
                            $('#modal_mensaje').modal('hide');

                            break;
                        }
                        case 'secundario':
                        {
                            me.modal_secundario     =   0;
                            me.accion_secundario    =   0;
                            me.titulo_secundario    =   '';
                            me.boton_secundario     =   0;
                            $('#modal_secundario').modal('hide');

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                limpiarDatos(accion)
                {
                    let me  =   this;

                    switch(accion)
                    {
                        case 'informacion':
                        {
                            me.arr_info             =   [];

                            break;
                        }
                        case 'anexar':
                        {
                            me.arr_files            =   '';
                            me.arr_files_obs        =   '';
                            me.file_observacion     =   '';

                            break;
                        }
                        case 'revisar':
                        {
                            me.arr_archivo  =   [];

                            break;
                        }
                        case 'asignar':
                        {
                            me.nr_id_solicitud      =   0;
                            me.nr_id_historia       =   0;
                            me.nr_id_dir_destino    =   0;
                            me.nr_id_despacho       =   0;
                            me.str_obs_asignar      =   '';
                            me.nr_subordinados      =   [];

                            break;
                        }
                        case 'finalizar':
                        case 'responder':
                        case 'observacion':
                        {
                            me.nr_id_solicitud      =   0;
                            me.nr_id_historia       =   0;
                            me.tp_observacion       =   0;
                            me.str_observacion      =   '';

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                zonaDeEspera(titulo, tiempo)
                {
                    Swal.fire({
                        title : '<h5>'+titulo+'</h5>',
                        html: '<strong> </strong>',
                        showConfirmButton: false,
                        timer: tiempo,
                        onBeforOpen: () => {
                            Swal.showLoading()
                        },
                    }).then((result) => {
                        if(result.dismiss == Swal.DismissReason.timer)
                        {
                            //----------------------------------------
                        }
                    });
                },
                //-------------------------------------------------------------------------------------------
                desplegarVentana(tp_icon, titulo, mensaje)
                {
                    let me          =   this;
                    var tp_btn      =   true;

                    /*
                        icon list
                        - success 
                        - error 
                        - warning 
                        - info 
                        - question
                    */

                    Swal.fire({
                        type: tp_icon,
                        title: titulo,
                        text: mensaje,
                        showConfirmButton: tp_btn
                    });
                },
                //-------------------------------------------------------------------------------------------
            },

            mounted() {
                let me = this;
                //me.dataDefault();
                //me.cargarDatos();
               // $('input').not('.txt_buscar').attr('disabled',true);
                $('select').not('.estados').attr('disabled',true);
                $('textarea').attr('disabled',true);
                $('button').not('.cerrar, .btn_actualizar, .btn_filtro, .btn_buscar').attr('disabled',true);
            }
        });
    </script>

    <script type="text/javascript">
        //-----------------------------------------------------------------
        $(document).ready(function(){
            /*----- Inicio - Filtrar -----*/
            $("#btn_filtrar_datos").click(function () {
                $content = $("#filtrar_datos");
                $content.slideToggle(500, function () {
                    // ---------------------------
                });
            });

            $("#close_filtrar_datos").click(function () {
                $content = $("#filtrar_datos");
                $content.slideToggle(500, function () {
                    // ---------------------------
                });
            });
            /*----- Inicio - Modal -----*/
        });
        //-----------------------------------------------------------------
        function justNumbers(e)
        {
            var keynum = window.event ? window.event.keyCode : e.which;
            if (keynum == 8)
                return true;

            return /\d/.test(String.fromCharCode(keynum));
        }
        //-----------------------------------------------------------------
    </script>
@endsection()


