<!DOCTYPE html>
<html lang="es">

<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no, minimal-ui">
	<title>Sistema Atención al Vecino</title>
	<!-- Fonts -->
	<link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;600;700&display=swap" rel="stylesheet">
	<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.13.0/css/all.min.css" rel="stylesheet" />
	<!-- Styles -->
	<link href="{{ asset('css/app_territorial.css') }}?ver=20200529" rel="stylesheet">
	<!-- Global site tag (gtag.js) - Google Analytics -->
	<script async src="https://www.googletagmanager.com/gtag/js?id=UA-168909574-1"></script>
	<script>
		window.dataLayer = window.dataLayer || [];
		function gtag(){dataLayer.push(arguments);}
		gtag('js', new Date());
		gtag('config', 'UA-168909574-1');
	</script>

	<script src="https://code.jquery.com/jquery-3.5.0.js" ></script>

	<style type="text/css">
		.login__bg img:not(.login__bg-logo) {
			  	width: 100%;
			  	height: 100%;
			  	padding: 0;
			  		-o-object-fit: fill;
			     	object-fit: fill;
			}

			@media (min-width: 992px) {
			  	.login__bg img:not(.login__bg-logo) {
			    padding: 0;
			}
		}
	</style>
</head>

<body>
	<div id="app" class="login">
		<div class="login__bg">			
			<img src="/fondo/fondo-sanmiguel.png" alt="San Miguel">
		</div>
		<div class="login__container">
			<div class="login__hidden">
				<div class="login__title">
					<h1><span>Sistema </span>Atención al Vecino</h1>
				</div>
			</div>
			<div class="login__box">
				<span class="label">Ingrese sus datos para iniciar sesión</span>
				<form method="POST" action="{{ route('login') }}">
					@csrf
					<div class="form-group @error('rut') has-error @enderror">
						<div class="input-group">
							<input id="rut" type="text" class="form-control" name="rut" value="{{ old('rut') }}" required autocomplete="rut" autofocus placeholder="Rut">
							<div class="input-group-append">
								<span class="input-group-text" id="basic-addon2">
									<i class="fas fa-user"></i>
								</span>
							</div>
						</div>
						@error('rut')
						<span class="invalid-feedback" role="alert">
							{{ $message }}
						</span>
						@enderror
					</div>
					<div class="form-group @error('password') has-error @enderror">
						<div class="input-group">
							<input id="password" type="password" class="form-control" name="password" required autocomplete="current-password" placeholder="Contraseña">
							<div class="input-group-append">
								<span class="input-group-text" id="basic-addon2">
									<i class="fas fa-lock"></i>
								</span>
							</div>
						</div>
						@error('password')
						<span class="invalid-feedback" role="alert">
							{{ $message }}
						</span>
						@enderror
					</div>
					<button type="submit" class="btn btn-block btn--login">Ingresar</button>

					@error('rut')
					<div class="form-group row mb-0">
						<div class="col-md-12">
							<a class="btn btn-link" target="_blank" style="text-decoration: underline; font-size: smaller;" href="{{ route('password.request') }}">
								Olvidé la contraseña
							</a>
						</div>
					</div>
					@enderror

					<!-- <div class="col-xs-8 hidden">
						<div class="checkbox icheck">
							<label class="">
								<div class="icheckbox_square-blue" aria-checked="false" aria-disabled="false" style="position: relative;"><input type="checkbox" style="position: absolute; top: -20%; left: -20%; display: block; width: 140%; height: 140%; margin: 0px; padding: 0px; background: rgb(255, 255, 255); border: 0px; opacity: 0;"><ins class="iCheck-helper" style="position: absolute; top: -20%; left: -20%; display: block; width: 140%; height: 140%; margin: 0px; padding: 0px; background: rgb(255, 255, 255); border: 0px; opacity: 0;"></ins></div> Remember Me
							</label>
						</div>
					</div> -->
				</form>
			</div>
		</div>
	</div>
	<!-- <script src="{{ asset('js/app.js') }}"></script> -->
	<script>
		//-----------------------------------------------------------------
	  	$("#rut").change(function() {
				var nr_rut = $("#rut").val().replace(/[^0-9kK]/g,'');
				if (nr_rut.length > 1) {
					$("#rut").val(nr_rut.substr(0, nr_rut.length-1) + '-'+ nr_rut.substr(-1) )
				} 
	    });
		//-----------------------------------------------------------------
	</script>
	@stack('scripts')
</body>

</html>