<?php $__env->startSection('body'); ?>
<div class="page-content">
    <div class="container-fluid" id="app">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0 font-size-18">Consultar Solicitudes</h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Consultar Solicitudes</a></li>
                            <li class="breadcrumb-item active">Solicitudes</li>
                        </ol>
                    </div>
                </div>

                <!-- Filtros Especificos -->
                <div class="row mb-3 not-print">
                    <div class="col-lg-3 col-md-6 col-sm-6" style="text-align:left;">
                        <!-- Filtro por Estado -->
                        <div class="row">
                            <div class="col-md-3">
                                <label class="form-control-label" for="text-input">
                                        Filtro por Estado
                                </label>
                            </div>
                            <div class="col-md-8">
                                <select @change="cargarDatos()"  v-model="fl_mostrar" class="form-control estados">
                                    <option v-for="item in arr_mostrar" :value="item.value" v-text="item.label"></option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6 col-sm-6" style="text-align: left;">
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-md-4">
                                    <label class="form-control-label" for="text-input">
                                        Filtro por Rango de Fechas
                                    </label>
                                </div>
                                <div class="col-md-8">
                                    <div class="input-group">
                                        <input type="text" class="form-control" name="fc_desde" id="fc_desde" placeholder="Desde" />
                                        <input type="text" class="form-control" name="fc_hasta" id="fc_hasta" placeholder="Hasta" />
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-6" style="text-align:right;">
                        <div class="row">
                            <div class="col-md-2">
                                <label class="form-control-label" for="text-input">
                                    Ordenar Por
                                </label>
                            </div>
                            <div class="col-md-9">
                                <div class="input-group">
                                <select v-model="tp_criterio" @change="cargarDatos()" class="form-control">
                                    <option value="id">Ticket</option>
                                    <option value="id_macroterritorio">Macrozona</option>
                                    <option value="id_unidadvecinal">Unidad Vecinal</option>
                                    <option value="nm_direccion">Dirección Municipal</option>
                                    <option value="nm_depto">Depto. Municipal</option>
                                    <option value="nm_estado">Estado</option>
                                    <option value="created_at">Fecha Ingreso</option>
                                </select>
                                <select v-model="tp_orden" @change="cargarDatos()" class="form-control">
                                    <option value="ASC">Ascendente</option>
                                    <option value="DESC">Descendente</option>
                                </select>
                            </div>
                            </div>                                
                        </div>                            
                    </div>
                    <div class="col-lg-2 col-md-6 col-sm-6" style="text-align:right">
                        <button id="btn_actualizar" class="btn btn-primary btn_activo" @click="cargarDatos();">
                            <i class="fas fa-sync"></i> Actualizar
                        </button>

                        <button class="btn btn-primary btn_activo" id="btn_filtrar_datos">
                            <i class="fas fa-search"></i> Filtrar Datos
                        </button>
                    </div>                        
                </div>

                <!-- Filtro Generales - Tabla de Datos - Paginacion -->
                <div class="row">
                    <!-- Filtro de Datos -->
                    <div class="col-md-12 col-sm-12">
                        <div class="collapse" id="filtrar_datos">
                            <div class="card">
                                <div class="card-header bg-primary">
                                    <div class="col-md-12 col-sm-12 text-center">
                                        <h5 style="color:white;">Filtro de busqueda</h5>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row ml-2 mr-2">
                                        <div class="col-md-12 col-sm-12"> </div>
                                        <!-- Dirección Municipal -->
                                        <div class="col-md-4 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Dirección Municipal :
                                                </label>
                                                <multiselect 
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_direccion"
                                                    :options="arr_direccion" 
                                                    @select="asyncDeptos" 
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Dirección Municipal"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                        <!-- Depto Municipal -->
                                        <div class="col-md-4 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Depto Municipal :
                                                </label>
                                                <multiselect 
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_depto"
                                                    :options="arr_depto" 
                                                    @select="asyncServicios" 
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Depto Municipal"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                        <!-- Servicio -->
                                        <div class="col-md-4 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Servicio :
                                                </label>
                                                <multiselect
                                                    :show-labels="false" 
                                                    :searchable="true" 
                                                    v-model="fl_servicio" 
                                                    :options="arr_servicio" 
                                                    :multiple="false" 
                                                    :showNoOptions="false" 
                                                    placeholder="Servicio" 
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                        <!-- Macrozona -->
                                        <div class="col-md-4 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Macrozona :
                                                </label>
                                                <multiselect 
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_macrozona"
                                                    :options="arr_macrozona"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Unidad Vecinal"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                        <!-- Unidad Vecinal -->
                                        <div class="col-md-4 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Unidad Vecinal :
                                                </label>
                                                <multiselect 
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_unidadvecinal"
                                                    :options="arr_unidadvecinal"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Unidad Vecinal"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                        <!-- Ticket -->
                                        <div class="col-md-4 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    N° Ticket :
                                                </label>
                                                <multiselect 
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_ticket"
                                                    :options="arr_ticket"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="N° Ticket"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                        <!-- Solicitante -->
                                        <div class="col-md-4 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Solicitante :
                                                </label>
                                                <multiselect
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_persona"
                                                    :options="arr_persona"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Solicitante"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                        <!-- Motivo -->
                                        <div class="col-md-4 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Tipo Requerimiento :
                                                </label>
                                                <multiselect
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_motivo"
                                                    :options="arr_motivo"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Tipo Requerimiento"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                        <!-- Ubicación del Problema -->
                                        <div class="col-md-4 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Dirección del Requerimiento :
                                                </label>
                                                <multiselect
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_ubicacion"
                                                    :options="arr_ubicaciones"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Dirección del Requerimiento"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <div style="float: right;">
                                        <button @click="limpiarFiltros()" type="button" class="btn btn-warning btn-sm btn_activo" style="color: white;">
                                            <i class="fas fa-undo"></i> Quitar Filtros
                                        </button>&nbsp;
                                        <button @click="filtrarDatos()" type="button" class="btn btn-primary btn-sm btn_activo"><i class="fas fa-search"></i>
                                            Filtrar Búsqueda
                                        </button>

                                        <button class="btn btn-secondary btn-sm btn_activo" id="close_filtrar_datos">
                                            Cerrar Filtro
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Tabla de Datos -->
                    <div class="responsive-table">
                        <table  class="table table-bordered border-info table-striped table-sm table-hover bl-1">
                            <thead class="bg-primary">
                                <th colspan="12" >
                                    <h6 class="text-center" style="color:white" >
                                        Listado de Solicitudes
                                    </h6>
                                </th>
                            </thead>
                            <thead class="bg-primary"  style="color:white">
                                <th class="text-center"> # </th>
                                <th class="text-center" style="min-width:100px;">Opciones</th>
                                <th class="text-center">Ticket</th>
                                <th class="text-center">Tipo de Requerimiento</th>
                                <th class="text-center">Dirección Municipal</th>                                
                                <th class="text-center">Servicio</th>
                                <th class="text-center">Tipo Ingreso</th>
                                <th class="text-center">Macrozona</th>
                                <th class="text-center">Unidad Vecinal</th>                                
                                <th class="text-center">Tiempo Tramitado</th>
                                <th class="text-center">Tiene Publicación Parcial</th>
                                <th class="text-center">Estado</th>
                            </thead>
                            <tbody>
                                <template v-if="arr_index.length">
                                    <tr v-for="(datos, index) in arr_index" :key="datos.id">
                                        <td style="text-align:center;">
                                            {{ (index + 1) }}
                                        </td>
                                        <td style="text-align:center;">
                                            <div class="dropdown">
                                                <button class="btn btn-secondary" type="button" id="menu_opcion" data-bs-toggle="dropdown" aria-expanded="false">
                                                    Opción <i class="mdi mdi-chevron-down"></i>
                                                </button>
                                                <div class="dropdown-menu" aria-labelledby="menu_opcion">
                                                    <!-- Revisar Solicitud -->
                                                    <a href="#" class="dropdown-item" 
                                                        @click="abrirModal('solicitud', 'historial', datos)">
                                                            <i class="fas fa-history" style="color: blue;"></i>
                                                            Revisar Solicitud
                                                    </a>
                                                </div>
                                            </div>
                                        </td>
                                        <td style="text-align:center;">
                                            {{ datos.nr_ticket }}
                                        </td>
                                        <td style="text-align:center;">
                                            {{ datos.nm_motivo }}
                                        </td>
                                        <td  style="text-align:left; color: black;">
                                            {{ datos.nm_direccion_destino }}
                                        </td>
                                        <td style="text-align:left;">
                                            {{ datos.nm_tipo }}
                                        </td>
                                        <td style="text-align:left;">
                                            {{ datos.nm_ingreso }}
                                        </td>
                                        <td  style="text-align:center; color: black;">
                                            {{ datos.cod_territorio }}
                                        </td>                                        
                                        <td style="text-align:center;">
                                            {{ datos.nm_unidadvecinal }}
                                        </td>
                                        <td style="text-align:center;">
                                            {{ datos.tiempo_tramitado }}
                                        </td>
                                        <td style="text-align: center;">
                                            {{ datos.tiene_pp }}
                                        </td>
                                        <td style="text-align:center;" :style="{'background-color':datos.nm_color}">
                                            <span style="font-weight: bold !important;">{{ datos.nm_estado }}</span>
                                        </td>
                                    </tr>
                                </template>
                                <template v-else>
                                    <tr>
                                        <td colspan="12">
                                            <h5 class="text-center">
                                                No hay datos para listar
                                            </h5>
                                        </td>
                                    </tr>
                                </template>
                            </tbody>
                        </table>
                    </div>

                    <!-- Paginacion -->
                    <div class="col-md-12 col-sm-12">
                        <nav>
                            <ul class="pagination">
                                <li class="page-item" v-if="pagination.current_page > 1">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(pagination.current_page - 1)">Ant</a>
                                </li>
                                <li class="page-item" v-for="page in pagesNumber" :key="page" :class="[page == isActivedPagination ? 'active' : '']">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(page, 1)" v-text="page"></a>
                                </li>
                                <li class="page-item" v-if="pagination.current_page < pagination.last_page">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(pagination.current_page + 1)">Sig</a>
                                </li>
                            </ul>
                        </nav>
                    </div>                      
                </div>
            </div>
        </div>

        <div class="modal" tabindex="-1" id="modal_historial">
            <div class="modal-dialog modal-dialog-scrollable modal-xl">
                <div class="modal-content">
                  <div class="modal-header bg-primary">
                    <h5 class="modal-title text-white" id="title_mdoal">{{ titulo_modal }}
                        <template v-if="nr_ticket">{{ ' - #' + nr_ticket }}</template> 
                        <template v-if="nr_ticket">{{ ' - Estado Actual : ' + nm_estado }}</template>
                    </h5>
                    <button type="button" class="btn-close" @click="cerrarModal('historial')" aria-label="Close"></button>
                  </div>
                  <div class="modal-body">
                        <ul class="verti-timeline list-unstyled">
                            <li :class="{'active':index == arr_historial.length -1}" class="event-list" v-for="(hist, index) in arr_historial">
                                <div class="event-timeline-dot">
                                    <i v-if="index == arr_historial.length -1" class="bx bx-right-arrow-circle bx-fade-right"></i>
                                    <i v-else class="bx bx-right-arrow-circle"></i>
                                </div>
                                <!-- Ingresada -->
                                <div class="d-flex" v-if="index == 0">
                                    <div class="flex-shrink-0 me-3">
                                        <i  class="bx bx-save h2 text-primary"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <div>
                                            <!-- Datos de Cabecera -->
                                            <span style="float: right;">Duración {{hist.fc_diferencia}} Días</span>
                                            <h5 > Solicitud ingresada a las {{hist.fc_inicio}}</h5>
                                            <p class="text-muted">Solicitud 
                                                <strong>#{{hist.nr_ticket}}</strong> ingresada por 
                                                <strong>{{hist.nm_autor}}</strong>
                                            </p>

                                            <!-- Solicitud Origen -->
                                            <div v-if="arr_solicitud.solicitud" class="row mt-2">
                                                <div class="col-lg-8 col-md-12 col-sm-12 pt-2 rounded-3" style="background-color: beige;">
                                                    <h5>
                                                        <i class="fas fa-exclamation-triangle" style="color:goldenrod;"></i>
                                                        - Solicitud Clonada
                                                    </h5>
                                                    <p class="ps-5">
                                                        <strong>Ticket Original: </strong> {{arr_solicitud.solicitud.nr_ticket }} <br>
                                                        <strong>Servicio Origen:</strong>  {{ arr_solicitud.solicitud.nm_tipo }} <br>
                                                        <strong>Depto. Origen:</strong>  {{ arr_solicitud.solicitud.nm_depto }} <br>
                                                        <strong>Dirección Origen:</strong>  {{ arr_solicitud.solicitud.nm_direccion }} <br>
                                                        <template v-if="arr_solicitud.str_clonado_html">
                                                            <strong>Descripción:</strong> 
                                                            <span v-html="arr_solicitud.str_clonado_html"></span>
                                                        </template>
                                                    </p>
                                                </div>
                                            </div>

                                            <!-- Datos de Vecino -->
                                            <div v-if="arr_solicitud.vecino" class="mt-2">
                                                <h5>- Vecino Asociado</h5>
                                                <p>
                                                    <strong>Nombre: </strong> {{arr_solicitud.vecino.nmc_vecino }} <br>
                                                    <strong>Rut:</strong>  {{ arr_solicitud.vecino.nr_rut }} <br>
                                                    <strong>Domicilio:</strong> 
                                                        <a target="_blank" :href="'https://maps.google.com/?q='+arr_solicitud.vecino.nm_ubicacion+'&z=15&t=m'">
                                                            {{ arr_solicitud.vecino.nm_ubicacion }}
                                                        </a> <br>
                                                    <strong>Correo:</strong>  {{ arr_solicitud.vecino.nm_mail }}<br>
                                                    <strong>Télefono:</strong> {{ arr_solicitud.vecino.nr_prefijo + arr_solicitud.vecino.nr_telefono }}
                                                </p>
                                            </div>

                                            <!-- Datos de la Solicitud -->
                                            <div class="mt-2" v-if="arr_solicitud.derivacion.length">
                                                <h5>- Datos de la Solicitud</h5>
                                                <ul class="verti-timeline list-unstyled">
                                                    <li class="event-list mb-1 pb-0" v-for="(derivar, indice) in arr_solicitud.derivacion">
                                                        <div class="event-timeline-dot">
                                                            <i v-if="(indice == (arr_solicitud.derivacion.length -1))" class="bx bx-right-arrow-circle bx-fade-right"></i>
                                                            <i v-else class="bx bx-right-arrow-circle"></i>
                                                        </div>
                                                        <!-- <hr class="mt-1 mb-1" style="border-top: 3px dashed black;" v-if="indice == 0">-->
                                                        <div class="d-flex" v-if="indice == 0">
                                                            <div class="flex-shrink-0 me-3">
                                                                <i class="bx bx-show-alt h2 text-primary" v-if="(indice == (arr_solicitud.derivacion.length -1))"></i>
                                                                <i class="bx bx-show-alt h2 text-secundary" v-else></i>
                                                            </div>
                                                            <div class="flex-grow-1">
                                                                <div>
                                                                    <h5 class="text-primary" v-if="(indice == (arr_solicitud.derivacion.length -1))"> - Solicitud Inicial</h5>
                                                                    <h5 class="text-secundary" v-else> - Solicitud Inicial</h5>
                                                                    <strong>Servicio : </strong> {{ derivar.nm_tipo }} <br>
                                                                    <strong>Dirección : </strong> {{ derivar.nm_direccion }} <br>
                                                                    <strong>Depto. : </strong> {{ derivar.nm_depto }} <br>
                                                                    <strong>Fecha Ingreso : </strong> {{ derivar.fc_inicio | formatDateTime }}
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="d-flex" v-else>
                                                            <div class="flex-shrink-0 me-3">
                                                                <i class="bx bx-show-alt h2 text-primary" v-if="(indice == (arr_solicitud.derivacion.length -1))"></i>
                                                                <i class="bx bx-show-alt h2 text-secundary" v-else></i>
                                                            </div>
                                                            <div class="flex-grow-1">
                                                                <div>
                                                                    <h5 class="text-primary" v-if="(indice == (arr_solicitud.derivacion.length -1))"> - Solicitud Derivada</h5>
                                                                    <h5 class="text-secundary" v-else> - Solicitud Derivada</h5>
                                                                    <strong>Servicio : </strong> {{ derivar.nm_tipo }} <br>
                                                                    <strong>Dirección : </strong> {{ derivar.nm_direccion }} <br>
                                                                    <strong>Depto. : </strong> {{ derivar.nm_depto }} <br>
                                                                    <strong>Fecha Derivación : </strong> {{ derivar.fc_inicio | formatDateTime }}
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <!--<hr class="mt-1 mb-1" style="border-top: 3px dashed black;">-->
                                                    </li>
                                                </ul>
                                                <div class="col-12 mt-2">
                                                    <h5>- Descripción de la Solicitud</h5>
                                                    <strong>Ubicación : </strong>
                                                        <a target="_blank" :href="'https://maps.google.com/?q='+arr_solicitud.nm_ubicacion+', Las Condes&z=15&t=m'">
                                                            {{ arr_solicitud.nm_ubicacion }}
                                                        </a> <br>
                                                    <template v-if="arr_solicitud.str_aclaratoria">
                                                        <strong>Aclaratoria : </strong> {{ arr_solicitud.str_aclaratoria }} <br>
                                                    </template>
                                                    <strong>Descripción : </strong> <span v-html="hist.str_solicitud_html" class="mb-0 pb-0"></span>
                                                </div>
                                            </div>

                                            <!-- Tabla de archivos -->
                                            <div v-if="arr_solicitud.archivos.length" class="table-responsive">
                                                <table class="table table-sm table-bordered">
                                                    <thead class="bg-primary">
                                                        <th colspan="3" class="text-center text-white"> Archivos Adjuntos</th>
                                                    </thead>
                                                    <thead>
                                                        <th>Opción</th>
                                                        <th>Nombre</th>
                                                        <th>Descripción</th>
                                                    </thead>
                                                    <tbody>
                                                        <tr v-for="(item,index) in arr_solicitud.archivos">
                                                            <td>
                                                                <a target="_blank" :href="'/files/get?ruta='+item.str_archivo" 
                                                                    class="btn btn-md btn-success btn-sm" style="margin-left: 5px;">
                                                                        <i  class="bx bxs-download"></i>
                                                                </a>
                                                            </td>
                                                            <td>{{item.nm_archivo}}</td>
                                                            <td>{{item.str_observacion}}</td>
                                                        </tr>
                                                    </tbody>
                                                </table>                                               
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Por Asignar -->
                                <div class="d-flex" v-if="hist.id_estado == 2">
                                    <div class="flex-shrink-0 me-3">
                                        <i  class="bx bx-search h2 text-primary"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <div>
                                            <!-- Datos de Cabecera -->
                                            <span style="float: right;">Duración {{hist.fc_diferencia}} Días</span>
                                            <span>Estado :  <strong v-text="hist.nm_estado"></strong></span> 
                                            <p class="text-muted mb-0">Solicitud 
                                                <strong>#{{hist.nr_ticket}}</strong> ingresada por 
                                                <strong>{{hist.nm_autor}}</strong>
                                            </p>
                                            <strong>Observación Visado :</strong> <span v-html="hist.str_observacion_html"></span>
                                        </div>
                                    </div>
                                </div>

                                <!-- Revisión -->
                                <div class="d-flex" v-if="hist.id_estado == 3">
                                    <div class="flex-shrink-0 me-3">
                                        <i  class="bx bx-search h2 text-primary"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <div>
                                            <!-- Datos de Cabecera -->
                                            <span style="float: right;">Duración {{hist.fc_diferencia}} Días</span>
                                            <span>Estado :  <strong v-text="hist.nm_estado"></strong></span> 
                                            <p class="text-muted mb-0">Solicitud 
                                                <strong>#{{hist.nr_ticket}}</strong> ingresada por 
                                                <strong>{{hist.nm_autor}}</strong>
                                            </p>
                                            <strong>Observación Asignación :</strong> <span v-html="hist.str_observacion_html"></span>
                                            <button type="button" @click="abrirModal('archivo', 'examinar', arr_solicitud)" 
                                                class="btn btn-primary btn-sm" title="Revisar Adjuntos" v-if="arr_solicitud.archivos_asignacion.length">
                                                    <i class="fas fa-paperclip"></i>
                                            </button>

                                            <!-- Tabla de Encargados -->
                                            <div class="col-lg-12 col-md-12 col-sm-12 table-responsive mt-2" v-if="arr_asignados.length && (index == arr_historial.length -1)">
                                                <table class="table table-bordered table-striped table-sm">
                                                    <thead>
                                                        <tr class="bg-primary">
                                                            <th colspan="5" class="text-center" style="color: white;">Lista de Funcionarios</th>
                                                        </tr>
                                                        <tr>
                                                            <th style="min-width:100px; text-align:center;">#</th>
                                                            <th style="min-width:150px; text-align:center;">Dirección</th>
                                                            <th style="min-width:200px; text-align:center;">Departamento</th>
                                                            <th style="min-width:100px; text-align:center;">Nombre</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <template v-if="arr_asignados.length">
                                                            <tr v-for="(asignado, index) in arr_asignados" :key="asignado.value">
                                                                <td class="text-center">{{ (index + 1) }}</td>
                                                                <td class="text-center">{{ asignado.nm_direccion }}</td>
                                                                <td class="text-center">{{ asignado.nm_depto }}</td>
                                                                <td class="text-center">{{ asignado.nm_funcionario }}</td>
                                                            </tr>
                                                        </template>
                                                        <template v-else>
                                                            <td colspan="5">
                                                                <div class="empty" empty-text="No hay datos para listar"></div>
                                                            </td>
                                                        </template>
                                                    </tbody>
                                                </table>
                                            </div>

                                            <!-- Tabla de Observaciones -->
                                            <div class="table-responsive" v-if="arr_respuestas.length">
                                                <table class="table table-sm table-bordered">
                                                    <thead>
                                                        <th colspan="6" class="text-center bg-primary text-white" >
                                                            Gestión Interna
                                                        </th>
                                                    </thead>
                                                    <thead class="bg-primary text-white">
                                                        <th>#</th>
                                                        <th>Usuario</th>
                                                        <th>Adjuntos</th>
                                                        <th style="min-width: 100px;">Fecha</th>
                                                        <th>Tipo</th>
                                                        <th>Mensaje</th>
                                                    </thead>
                                                    <tbody>
                                                        <tr v-for=" (item,index) in arr_respuestas">
                                                            <td>{{index +1}}</td>
                                                            <td>{{item.usuario}}</td>
                                                            <td class="text-center">
                                                                <button type="button" @click="abrirModal('archivo', 'revisar', item)" 
                                                                    class="btn btn-primary btn-sm" title="Revisar Adjuntos" v-if="item.archivos.length">
                                                                    <i class="fas fa-paperclip"></i>
                                                                </button>
                                                            </td>
                                                            <td>{{item.fc_ingreso | formatDateTime}}</td>
                                                            <td>{{item.nm_respuesta}}</td>
                                                            <template v-if="getCantidadCaracteres(item.str_observacion) < 300">
                                                                <td>
                                                                    <span v-html="item.str_observacion_html"></span>
                                                                </td>
                                                            </template>
                                                            <template v-else>
                                                                <td>
                                                                    <template v-if="(tp_visualizar.tp_resumir == 0 || tp_visualizar.tp_resumir == 1) && 
                                                                        tp_visualizar.nr_index != index">
                                                                        {{ item.str_observacion | resumir }} 
                                                                        <a href="#" class="link-primary" style="float: right;" @click="setResumir(0, index)"> VER</a>
                                                                    </template>
                                                                    <template v-else>
                                                                        <span v-html="item.str_observacion_html"></span>
                                                                        <a href="#" class="link-primary" style="float: right;" @click="setResumir(1, null)"> ACOTAR</a>
                                                                    </template>
                                                                </td>
                                                            </template>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Publicada -->
                                <div class="d-flex"  v-if="hist.id_estado == 5">
                                    <div class="flex-shrink-0 me-3">
                                        <i  class="bx bx-check-shield h2 text-primary"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <span style="float: right;">Duración {{hist.fc_diferencia}} Días</span>
                                        <h5 > Solicitud publicada a las {{hist.fc_inicio}}</h5>
                                        <span>Estado :  <strong v-text="hist.nm_estado"></strong></span>
                                        <p class="text-muted mb-0">Solicitud <strong>#{{hist.nr_ticket}}</strong> publicada por <strong>{{hist.nm_autor}}</strong></p>
                                        <strong>Publicación :</strong>
                                        <template v-if="getCantidadCaracteres(hist.str_observacion) < 300">
                                            <span v-html="hist.str_observacion_html"></span>
                                        </template>
                                        <template v-else>
                                            <template v-if="tp_resumir_publicacion == 1">
                                                {{ hist.str_observacion | resumir }} 
                                                <a href="#" class="link-primary" style="float: right;" @click="tp_resumir_publicacion = 0"> VER</a>
                                            </template>
                                            <template v-else>
                                                <span v-html="hist.str_observacion_html"></span>
                                                <a href="#" class="link-primary" style="float: right;" @click="tp_resumir_publicacion = 1"> ACOTAR</a>
                                            </template>
                                        </template>
                                        <div class="mt-2" v-if="(index == arr_historial.length -1) && hist.tp_feedback_vecino == 1">
                                            <h5>- Feedback Vecino</h5>
                                            <strong>Fecha Feedback :</strong> 
                                                <span v-if="hist.fc_feedback_vecino" v-text="hist.fc_feedback_vecino"></span> <br>
                                            <strong>Nivel Satisfacción :</strong> 
                                                <span v-if="hist.tp_satisfaccion_vecino > 0" v-text="arr_satisfaccion[hist.tp_satisfaccion_vecino].label"></span><br>
                                            <strong>Comentario Feedback :</strong> 
                                            <span v-text="hist.str_feedback_vecino"></span>
                                        </div>
                                    </div>
                                </div>

                                <!-- Finalizada -->
                                <div class="d-flex"  v-if="hist.id_estado == 6">
                                    <div class="flex-shrink-0 me-3">
                                        <i  class="bx bx-user-check h2 text-primary"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <span style="float: right;">Duración {{hist.fc_diferencia}} Días</span>
                                        <h5> Solicitud finalizada a las {{hist.fc_inicio}}</h5>
                                        <span>Estado :  <strong v-text="hist.nm_estado"></strong></span>
                                        <p class="text-muted mb-0">Solicitud <strong>#{{hist.nr_ticket}}</strong> finalizada por <strong>{{hist.nm_autor}}</strong></p>

                                        <div class="mt-2">
                                            <h5>- Feedback Territorial</h5>
                                            <strong>Fecha Feedback :</strong> 
                                                <span v-if="hist.fc_feedback" v-text="hist.fc_feedback"></span> <br>
                                            <strong>Nivel Satisfacción :</strong> 
                                                <span v-if="hist.tp_satisfaccion > 0" v-text="arr_satisfaccion[hist.tp_satisfaccion].label"></span> 
                                                <span v-else> Vecino no contactado</span> <br>
                                            <strong>Comentario Feedback :</strong> 
                                            <span v-text="hist.str_feedback"></span>
                                        </div>

                                        <div class="mt-2" v-if="hist.tp_feedback_vecino == 1">
                                            <h5>- Feedback Vecino</h5>
                                            <strong>Fecha Feedback :</strong> 
                                                <span v-if="hist.fc_feedback_vecino" v-text="hist.fc_feedback_vecino"></span> <br>
                                            <strong>Nivel Satisfacción :</strong> 
                                                <span v-if="hist.tp_satisfaccion_vecino > 0" v-text="arr_satisfaccion[hist.tp_satisfaccion_vecino].label"></span><br>
                                            <strong>Comentario Feedback :</strong> 
                                            <span v-text="hist.str_feedback_vecino"></span>
                                        </div>
                                    </div>
                                </div>

                                <!-- Rechazada -->
                                <div class="d-flex" v-if="hist.id_estado == 7">
                                    <div class="flex-shrink-0 me-3">
                                        <i  class="bx bx-trash-alt h2 text-primary"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <div>
                                            <span style="float: right;">Duración {{hist.fc_diferencia}} Días</span>
                                            <span>Estado :  <strong v-text="hist.nm_estado"></strong></span>                                             
                                            <h5 v-if="hist.id_estado == 1"> Solicitud Anulada a las {{hist.fc_inicio}}</h5>
                                            <p class="text-muted mb-0">Solicitud <strong>#{{hist.nr_ticket}}</strong> Anulada por <strong>{{hist.nm_autor}}</strong></p>
                                            <strong v-if="hist.str_observacion">Observación :</strong> <span v-html="hist.str_observacion_html"></span>
                                        </div>
                                    </div>
                                </div>

                                <!-- Derivado a Funcionario-->
                                <div class="d-flex" v-if="hist.id_estado == 8">
                                    <div class="flex-shrink-0 me-3">
                                        <i  class="bx bx-save h2 text-primary"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <div>
                                            <!-- Datos de Cabecera -->
                                            <span style="float: right;">Duración {{hist.fc_diferencia}} Días</span>
                                            <h5 > Solicitud derivada a las {{hist.fc_inicio}}</h5>
                                            <span>Estado :  <strong v-text="hist.nm_estado"></strong></span>
                                            <p class="text-muted mb-0">Solicitud 
                                                <strong>#{{hist.nr_ticket}}</strong> derivada por 
                                                <strong>{{hist.nm_autor}}</strong>
                                            </p>
                                            <strong v-if="hist.str_observacion">Observación :</strong> <span v-html="hist.str_observacion_html"></span>
                                            
                                            <!-- Datos de Solicitud -->
                                            <div class="mt-2">
                                                <h5>- Datos Solicitud</h5>
                                                <p>
                                                    <strong>Tipo de Solicitud : </strong> {{hist.nm_tipo}} <br>
                                                    <strong>Dirección</strong> : 
                                                        <a target="_blank" :href="'https://maps.google.com/?q='+arr_solicitud.nm_ubicacion+'&z=15&t=m'">
                                                            {{ arr_solicitud.nm_ubicacion }}
                                                        </a> <br>
                                                    <strong>Descripción</strong> : {{hist.str_sol_observacion}} <br>
                                                </p>
                                            </div>

                                            <!-- Tabla de Encargados -->
                                            <div class="col-lg-12 col-md-12 col-sm-12 table-responsive mt-2" v-if="arr_asignados.length && (index == arr_historial.length -1)">
                                                <table class="table table-bordered table-striped table-sm">
                                                    <thead>
                                                        <tr class="bg-primary">
                                                            <th colspan="5" class="text-center" style="color: white;">Lista de Funcionarios</th>
                                                        </tr>
                                                        <tr>
                                                            <th style="min-width:100px; text-align:center;">#</th>
                                                            <th style="min-width:150px; text-align:center;">Dirección</th>
                                                            <th style="min-width:200px; text-align:center;">Departamento</th>
                                                            <th style="min-width:100px; text-align:center;">Nombre</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <template v-if="arr_asignados.length">
                                                            <tr v-for="(asignado, index) in arr_asignados" :key="asignado.value">
                                                                <td class="text-center">{{ (index + 1) }}</td>
                                                                <td class="text-center">{{ asignado.nm_direccion }}</td>
                                                                <td class="text-center">{{ asignado.nm_depto }}</td>
                                                                <td class="text-center">{{ asignado.nm_funcionario }}</td>
                                                            </tr>
                                                        </template>
                                                        <template v-else>
                                                            <td colspan="5">
                                                                <div class="empty" empty-text="No hay datos para listar"></div>
                                                            </td>
                                                        </template>
                                                    </tbody>
                                                </table>
                                            </div>

                                            <!-- Tabla de Observaciones -->
                                            <div class="table-responsive" v-if="arr_respuestas.length">
                                                <table class="table table-sm table-bordered">
                                                    <thead>
                                                        <th colspan="6" class="text-center bg-primary text-white" >
                                                            Gestión Interna
                                                        </th>
                                                    </thead>
                                                    <thead class="bg-primary text-white">
                                                        <th>#</th>
                                                        <th>Usuario</th>
                                                        <th>Adjuntos</th>
                                                        <th style="min-width: 100px;">Fecha</th>
                                                        <th>Tipo</th>
                                                        <th>Mensaje</th>
                                                    </thead>
                                                    <tbody>
                                                        <tr v-for=" (item,index) in arr_respuestas">
                                                            <td>{{index +1}}</td>
                                                            <td>{{item.usuario}}</td>
                                                            <td class="text-center">
                                                                <button type="button" @click="abrirModal('archivo', 'revisar', item)" 
                                                                    class="btn btn-primary btn-sm" title="Revisar Adjuntos" v-if="item.archivos.length">
                                                                    <i class="fas fa-paperclip"></i>
                                                                </button>
                                                            </td>
                                                            <td>{{item.fc_ingreso | formatDateTime}}</td>
                                                            <td>{{item.nm_respuesta}}</td>
                                                            <template v-if="getCantidadCaracteres(item.str_observacion) < 300">
                                                                <td>
                                                                    <span v-html="item.str_observacion_html"></span>
                                                                </td>
                                                            </template>
                                                            <template v-else>
                                                                <td>
                                                                    <template v-if="(tp_visualizar.tp_resumir == 0 || tp_visualizar.tp_resumir == 1) && 
                                                                        tp_visualizar.nr_index != index">
                                                                        {{ item.str_observacion | resumir }} 
                                                                        <a href="#" class="link-primary" style="float: right;" @click="setResumir(0, index)"> VER</a>
                                                                    </template>
                                                                    <template v-else>
                                                                        <span v-html="item.str_observacion_html"></span>
                                                                        <a href="#" class="link-primary" style="float: right;" @click="setResumir(1, null)"> ACOTAR</a>
                                                                    </template>
                                                                </td>
                                                            </template>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Derivado a Macrozona-->
                                <div class="d-flex" v-if="hist.id_estado == 9">
                                    <div class="flex-shrink-0 me-3">
                                        <i  class="bx bx-save h2 text-primary"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <div>
                                            <!-- Datos de Cabecera -->
                                            <span style="float: right;">Duración {{hist.fc_diferencia}} Días</span>
                                            <h5 > Solicitud derivada a las {{hist.fc_inicio}}</h5>
                                            <span>Estado :  <strong v-text="hist.nm_estado"></strong></span>
                                            <p class="text-muted mb-0">Solicitud 
                                                <strong>#{{hist.nr_ticket}}</strong> derivada por 
                                                <strong>{{hist.nm_autor}}</strong>
                                            </p>
                                            <strong v-if="hist.str_observacion">Observación :</strong> <span v-html="hist.str_observacion_html"></span>
                                            
                                            <!-- Datos de Solicitud -->
                                            <div class="mt-2">
                                                <h5>- Datos Solicitud</h5>
                                                <p>
                                                    <strong>Tipo de Solicitud : </strong> {{hist.nm_tipo}} <br>
                                                    <strong>Dirección</strong> : 
                                                        <a target="_blank" :href="'https://maps.google.com/?q='+arr_solicitud.nm_ubicacion+'&z=15&t=m'">
                                                            {{ arr_solicitud.nm_ubicacion }}
                                                        </a> <br>
                                                    <strong>Descripción</strong> : {{hist.str_sol_observacion}} <br>
                                                </p>
                                            </div>                                         
                                        </div>
                                    </div>
                                </div>

                                <!-- Derivado a Asignador-->
                                <div class="d-flex" v-if="hist.id_estado == 10">
                                    <div class="flex-shrink-0 me-3">
                                        <i  class="bx bx-save h2 text-primary"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <div>
                                            <!-- Datos de Cabecera -->
                                            <span style="float: right;">Duración {{hist.fc_diferencia}} Días</span>
                                            <h5 > Solicitud derivada a las {{hist.fc_inicio}}</h5>
                                            <span>Estado :  <strong v-text="hist.nm_estado"></strong></span>
                                            <p class="text-muted mb-0">Solicitud 
                                                <strong>#{{hist.nr_ticket}}</strong> derivada por 
                                                <strong>{{hist.nm_autor}}</strong>
                                            </p>
                                            <strong v-if="hist.str_observacion">Observación :</strong> <span v-html="hist.str_observacion_html"></span>
                                            
                                            <!-- Datos de Solicitud -->
                                            <div class="mt-2">
                                                <h5>- Datos Solicitud</h5>
                                                <p>
                                                    <strong>Tipo de Solicitud : </strong> {{hist.nm_tipo}} <br>
                                                    <strong>Dirección</strong> : 
                                                        <a target="_blank" :href="'https://maps.google.com/?q='+arr_solicitud.nm_ubicacion+'&z=15&t=m'">
                                                            {{ arr_solicitud.nm_ubicacion }}
                                                        </a> <br>
                                                    <strong>Descripción</strong> : {{hist.str_sol_observacion}} <br>
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>                            
                        </ul>
                  </div>
                  <div class="modal-footer">
                    <div class="col-md-12 col-sm-12">
                        <button type="button" class="btn btn-md btn-danger col-lg-2 col-md-3 col-sm-4" style="float: left; margin-right: 5px;"
                            @click="abrirModal('solicitud','anular',arr_solicitud)" v-if="nr_estado == 1">
                                Anular Solicitud
                        </button> 
                        <button type="button" class="btn btn-md btn-secondary col-lg-2 col-md-3 col-sm-4" style="float: left;" @click="imprimir()">Imprimir</button>
                        <button type="button" class="btn btn-md btn-secondary col-lg-2 col-md-3 col-sm-4" style="float: right;" @click="cerrarModal('historial')">Cerrar</button>
                    </div>
                  </div>
                </div>
            </div>
        </div>

        <div class="modal" tabindex="-1" id="modal_adjunto">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header bg-primary">
                        <h5 class="modal-title text-white">Ingresar Adjunto</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label>Seleccione Archivo</label>
                            <input class="form-control" accept=".jpeg,.jpg,.png,.doc,.docx,.xls,.xlsx,.ppt,.pptx,.pdf,.dwg,.dgn,.rar,.zip"
                                type="file" id="file_adjunto" >
                        </div>
                        <div class="form-group mt-2">
                            <label>Ingresar Descripcón</label>
                            <textarea maxlength="200" rows="3" v-model="str_archivo" class="form-control" placeholder="Descripción del archivo"></textarea>
                            <small id="cant_caracteres" class="form-text text-muted" v-if="str_archivo"
                                v-text="'Disponible '+(200-str_archivo.trim().length)+' caracteres'"></small>
                        </div>
                        <template v-if="arr_error.length">
                            <div class="text-center text-danger">
                                <div v-for="error in arr_error" :key="error" v-text="error"></div>
                            </div>
                        </template>
                    </div>
                    <div class="modal-footer">
                        <button @click="cerrarModal('archivo')" type="button" class="btn btn-light">Cerrar</button>
                        <button type="button" class="btn btn-primary" @click="validarAdjunto(tp_adjunto, 'save')">Subir</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal Archivos -->
        <div class="modal" tabindex="-1" id="modal_revisar">
            <div class="modal-dialog modal-lg" style="margin-top: 10%">
                <div class="modal-content" style="border-color: darkgray;">
                    <div class="modal-header bg-primary">
                        <h5 class="modal-title text-white" style="color: white;">Revisar Archivos</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <table class="table table-bordered table-striped table-sm">
                            <thead>
                                <tr class="bg-primary">
                                    <th colspan="4" class="text-center" style="color: white;">Archivos Adjuntos</th>    
                                </tr>
                                <tr>
                                    <th style="min-width:50px; text-align:center;">#</th>
                                    <th style="min-width:150px; text-align:center;">Nombre</th>
                                    <th style="min-width:300px; text-align:center;">Descripción</th>
                                    <th style="min-width:50px; text-align:center;">Archivo</th>
                                </tr>
                            </thead>
                            <tbody>
                                <template v-if="arr_adjuntos.length">
                                    <tr v-for="(adjunto, index) in arr_adjuntos" :key="adjunto.id">
                                        <td class="text-center">{{ (index+1) }}</td>
                                        <td class="text-center">{{ adjunto.nm_archivo }}</td>
                                        <td class="text-left">{{ adjunto.str_observacion }}</td>
                                        <td class="text-center">
                                            <a :href="'/files/get?ruta='+adjunto.str_archivo" class="btn btn-primary btn-sm" title="Archivo Adjunto" v-if="adjunto.str_archivo">
                                                <template v-if="adjunto.ext_archivo == 'pdf'">
                                                    <i class="far fa-file-pdf"></i>
                                                </template>
                                                <template v-if="adjunto.ext_archivo == 'doc' || adjunto.ext_archivo == 'docx'">
                                                    <i class="far fa-file-word"></i>
                                                </template>
                                                <template v-if="adjunto.ext_archivo == 'ppt' || adjunto.ext_archivo == 'pptx'">
                                                    <i class="far fa-file-powerpoint"></i>
                                                </template>
                                                <template v-if="adjunto.ext_archivo == 'xls' || adjunto.ext_archivo == 'xlsx'">
                                                    <i class="far fa-file-excel"></i>
                                                </template>
                                                <template v-if="adjunto.ext_archivo == 'rar' || adjunto.ext_archivo == 'zip'">
                                                    <i class="far fa-file-archive"></i>
                                                </template>
                                                <template v-if="adjunto.ext_archivo == 'jpeg' || adjunto.ext_archivo == 'jpg' || adjunto.ext_archivo == 'png'">
                                                    <i class="far fa-file-image"></i>
                                                </template>
                                                <template v-if="adjunto.ext_archivo == 'dwg' || adjunto.ext_archivo == 'dgn'">
                                                    <i class="far fa-file-code"></i>
                                                </template>
                                            </a>
                                        </td>
                                    </tr>
                                </template>
                                <template v-else>
                                    <td colspan="4">
                                        <div class="empty" style="min-height:100px;" empty-text="No hay archivos para mostrar"></div>
                                    </td>
                                </template>
                            </tbody>
                        </table>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

    <style type="text/css">
        .bg-color-skyblue {
            background: skyblue;
        }

        .bg-color-khaki {
            background: khaki;
        }

        .bg-color-darkseagreen {
            background: darkseagreen;
        }

        .bg-color-indianred {
            background: indianred;
        }
    </style>

    

    <script type="text/javascript">
        Vue.component('vue-multiselect', window.VueMultiselect.default);

        var app = new Vue({
            el: '#app',
            data: {
                //-------------------------------------
                tp_modal                    :   0,
                tp_accion                   :   0,
                tp_btn                      :   0,
                titulo_modal                :   '',
                btn_envio                   :   0,
                btn_aprobar                 :   0,
                btn_rechazar                :   0,
                btn_asignar                 :   0,
                btn_publicar                :   0,
                btn_responder               :   0,
                btn_informar                :   0,
                btn_derivar                 :   0,
                //-------------------------------------
                arr_valida                  :   [],
                arr_error                   :   [],
                arr_form                    :   {},
                str_msj                     :   '',
                //-------------------------------------
                pagination                  : {
                    'total' : 0,
                    'current_page' : 0,
                    'per_page' : 0,
                    'last_page' : 0,
                    'from' : 0,
                    'to' : 0,
                },
                //-------------------------------------
                offset                      :   3,
                //-------------------------------------
                fl_mostrar                  :   0,
                fl_direccion                :   [],
                fl_depto                    :   [],
                fl_servicio                 :   [],
                fl_macrozona                :   [],
                fl_unidadvecinal            :   [],
                fl_ticket                   :   [],
                fl_persona                  :   [],
                fl_motivo                   :   [],
                fl_ubicacion                :   [],
                //-------------------------------------
                tp_criterio                 :   'created_at',
                tp_orden                    :   'DESC',
                //-------------------------------------
                arr_solicitud               :   [],
                arr_historial               :   [],
                arr_respuestas              :   [],
                arr_usuario                 :   [],
                arr_archivo                 :   [],
                //-------------------------------------
                arr_index                   :   [],
                arr_direccion               :   [],
                arr_depto                   :   [],
                arr_servicio                :   [],
                arr_motivo                  :   [],
                arr_macrozona               :   [],
                arr_unidadvecinal           :   [],
                arr_ticket                  :   [],
                arr_prioridad               :   [],
                arr_funcionarios            :   [],
                arr_personal                :   [],
                arr_asignados               :   [],
                arr_persona                 :   [],
                arr_ubicaciones             :   [],
                //-------------------------------------
                nr_solicitud                :   0,
                nr_fuente                   :   0,
                nr_servicio                 :   [],
                nr_motivo                   :   {},
                nr_ticket                   :   '',
                nr_direccion                :   [],
                nr_depto                    :   [],
                nr_funcionario              :   [],
                nr_estado                   :   0,
                nm_estado                   :   '',
                tp_activo                   :   0,
                tp_visado                   :   0,
                str_visado                  :   '',
                tp_observacion              :   0,
                tp_respuesta                :   0,
                str_observacion             :   '',
                str_derivar                 :   '',
                //-------------------------------------
                tp_resumir_publicacion      :   1,
                //-------------------------------------
                tp_visualizar               :   {
                    tp_resumir : 1,
                    nr_index : null,
                },
                //-------------------------------------
                arr_mostrar                 :   [
                    {
                        'value'     :   0,
                        'label'     :   'Todos',
                    },
                    {
                        'value'     :   3,
                        'label'     :   'En Gestión',
                    },
                    {
                        'value'     :   4,
                        'label'     :   'En Revisión',
                    },
                    {
                        'value'     :   5,
                        'label'     :   'Cerrado',
                    },
                ],
                fl_mostrar                  :   0,
                //-------------------------------------
                tp_recepcion                :   0,
                tp_satisfaccion             :   0,
                str_feedback                :   '',
                //-------------------------------------
                arr_recepcion               :   [
                    {
                        'value' : 0,
                        'label' : 'No Contactado',
                    },
                    {
                        'value' : 1,
                        'label' : 'Contactado',
                    },
                ],
                arr_satisfaccion            :   [
                    {
                        'value' : 0,
                        'label' : 'Seleccionar Nivel',
                    },
                    {
                        'value' : 1,
                        'label' : 'Muy satisfecho',
                    },
                    {
                        'value' : 2,
                        'label' : 'Satisfecho',
                    },
                    {
                        'value' : 3,
                        'label' : 'Normal',
                    },
                    {
                        'value' : 4,
                        'label' : 'Poco satisfecho',
                    },
                    {
                        'value' : 5,
                        'label' : 'Nada satisfecho',
                    }
                ],
                //-------------------------------------
                str_anular                  :   '',
                //-------------------------------------
                rut_vecino                  :   '',
                nm_vecino                   :   '',
                ap_paterno                  :   '',
                ap_materno                  :   '',
                nr_prefijo                  :   '+569',
                nr_telefono                 :   '',
                mail_vecino                 :   '',
                tp_ubicacion_vecino         :    1,
                str_aclara_vecino           :   '',
                arr_ubicacion_vecino        :   [],
                arr_calles_vecino           :   [],
                tp_vecino                   :   0,
                //-------------------------------------
                nr_dir_municipal            :   [],
                arr_direccion_solicitud     :   [],
                arr_calles_solicitud        :   [],
                nr_prioridad                :   2,
                tp_ubicacion_solicitud      :   1,
                str_aclara_solicitud        :   '',
                str_solicitud               :   '',
                tp_municipal                :   1,
                //-------------------------------------
                arr_files                   :   [],
                arr_str_archivo             :   [],
                str_archivo                 :   '',
                tp_adjunto                  :   '',
                tp_save_adjunto             :   0,
                arr_adjuntos                :   [],
                //-------------------------------------
            },

            components: {
                Multiselect: window.VueMultiselect.default
            },

            filters:{
                resumir: function (texto, limite=300, final=' ...')
                {
                    let me  = this;
                    var largo = texto.toString().length;
                    if(largo > limite){
                        for (var i = 0; i < largo; i++) {
                            if(texto[i] == ' ' && i >= limite) {
                                texto   =   texto.substring(0,i);
                                texto   =   texto + final;
                                return texto;
                            }
                        }                    
                    }
                    return texto;
                },

                formatDate: function (fecha)
                {
                    if(fecha)
                        return moment(String(fecha)).format('DD-MM-YYYY')
                },

                formatDateTime: function (fecha)
                {
                    if(fecha)
                    {
                        return moment(String(fecha)).format('DD-MM-YYYY HH:mm')
                    }
                },
            },

            computed:{
                //-------------------------------------------------------------------------------------------
                isActivedPagination: function()
                {
                    return this.pagination.current_page;
                },
                //-------------------------------------------------------------------------------------------
                pagesNumber: function()
                {
                    if(!this.pagination.to) {
                        return [];
                    }

                    var from = this.pagination.current_page - this.offset;
                    if(from < 1) {
                        from = 1;
                    }

                    var to = from + (this.offset * 2);
                    if(to >= this.pagination.last_page){
                        to = this.pagination.last_page;
                    }

                    var pagesArray = [];
                    while(from <= to) {
                        pagesArray.push(from);
                        from++;
                    }
                    return pagesArray;
                },                
                //-------------------------------------------------------------------------------------------
            },

            methods: {
                //-------------------------------------------------------------------------------------------
                imprimir()
                {
                    $("#modal_historial").printThis({
                        debug: false,               // show the iframe for debugging
                        importCSS: true,            // import parent page css
                        importStyle: true,          // import style tags
                        printContainer: false,      // print outer container/$.selector
                        loadCSS: "",                // path to additional css file - use an array [] for multiple
                        pageTitle: "",              // add title to print page
                        removeInline: true,        // remove inline styles from print elements
                        removeInlineSelector: "*",  // custom selectors to filter inline styles. removeInline must be true
                        printDelay: 333,            // variable print delay
                        header: null,               // prefix to html
                        footer: null,               // postfix to html
                        base: 'https://atencionvecino.lascondes.cl/',                // preserve the BASE tag or accept a string for the URL
                        formValues: true,           // preserve input/form values
                        canvas: false,              // copy canvas content
                        // doctypeString: '...',       // enter a different doctype for older markup
                        removeScripts: true,        // remove script tags from print content
                        copyTagClasses: false,      // copy classes from the html & body tag
                        beforePrintEvent: null,     // function for printEvent in iframe
                        beforePrint: null,          // function called before iframe is filled
                        afterPrint: null,           // function called before iframe is removed
                    });
                },
                //-------------------------------------------------------------------------------------------
                activeDatetimepicker()
                {
                    let fc_format1  =   'DD-MM-YYYY';
                    let fc_format2  =   'd-m-Y';
                    let fc_date     =   moment().locale('es').format(fc_format1);
                    let fc_desde    =   '';
                    let fc_hasta    =   '';
                    //-----------------------------------
                    fc_hasta = fc_date;
                    fc_desde = moment().subtract(90, 'days').format(fc_format1);
                    //-----------------------------------

                    // Configuración base para flatpickr
                    let baseConfig = {
                        dateFormat: fc_format2,
                        locale: 'es',  // Asegúrate de tener el locale de 'es' cargado si lo necesitas.
                        allowInput: true,  // Permite la entrada manual de la fecha
                    };

                    // Configuración para "Desde"
                    let desdeConfig = Object.assign({}, baseConfig, {
                        defaultDate: fc_desde,
                    });
                    flatpickr('#fc_desde', desdeConfig);

                    // Configuración para "Hasta"
                    let hastaConfig = Object.assign({}, baseConfig, {
                        defaultDate: fc_hasta,
                        maxDate: new Date(),  // Fecha máxima es la fecha actual
                    });
                    flatpickr('#fc_hasta', hastaConfig);
                },
                //-------------------------------------------------------------------------------------------
                getCantidadCaracteres(str_contenido = '')
                {
                    var cantidad    =   0;

                    if(!str_contenido)
                        return cantidad;

                    if(str_contenido.trim().length)
                        cantidad    =   str_contenido.trim().length;

                    return cantidad;
                },
                //-------------------------------------------------------------------------------------------
                setScrollTo(tag_id)
                {
                    // var container   =   $('.modal #historia_solicitud'); // $('html, body, .main-content');
                    // var scrollTo    =   $('#' + tag_id);

                    $("#" + tag_id).animate({
                        scrollTop: $(document).height()
                    }, 500);

                    // container.animate({scrollTop : $('#' + tag_id).offset().top +1000 }, 'slow');
                },
                //-------------------------------------------------------------------------------------------
                cambiarPagina(page)
                {
                    let me  =   this;
                    me.pagination.current_page = page;
                    me.cargarDatos(page);
                },
                //-------------------------------------------------------------------------------------------
                refrescarDatos()
                {
                    let me  =   this;
                    me.cargarDireccionesMunicipales();
                    me.cargarDatos();
                    me.cargarUsuario();
                    me.cargarPendientes();
                },
                //-------------------------------------------------------------------------------------------
                getLabel(data)
                {
                    var valor   =   '';

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.label;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                getValue(data)
                {
                    var valor   =   0;

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.value;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                noVecino(tp_vecino)
                {
                    let me = this;

                    if(tp_vecino == 0)
                    {
                       me.rut_vecino            =   '';
                       me.nm_vecino             =   '';
                       me.ap_paterno            =   '';
                       me.ap_materno            =   '';
                       me.nr_telefono           =   '';
                       me.mail_vecino           =   '';
                       me.tp_ubicacion_vecino   =    1;
                       me.str_aclara_vecino     =   '';
                       me.arr_ubicacion_vecino  =   [];
                       me.tp_vecino             =   tp_vecino;

                       $('.vecino').attr('disabled','True')
                    }

                    if(tp_vecino == 1)
                    {
                        me.tp_vecino             =   tp_vecino;
                    }
                },
                //-------------------------------------------------------------------------------------------
                totalizarCampo(arr, field) 
                {
                    let total = arr.reduce((a, b) => a + (Number(b[field]) || 0), 0);
                    return total.toFixed(2);
                },
                //-------------------------------------------------------------------------------------------
                filterEstados()
                {
                    let me  =   this;
                    var arr =   [];

                    if(me.arr_usuario.id_rol == 7 && (me.arr_usuario.tp_admin == 2 || me.arr_usuario.tp_admin == 3))
                    {
                        arr     =   me.arr_mostrar.filter( 
                                        event => (event.value != 1 && event.value != 2 && event.value != 6 && event.value != 7)
                                    );

                        me.arr_mostrar  =   arr;
                    }
                },
                //-------------------------------------------------------------------------------------------
                filterRespuestas(data = [])
                {
                    let me  =   this;
                    var arr =   [];

                    if(data.length)
                    {
                        arr     =   data.filter(
                                        event   =>  (event.tp_respuesta === 3 || event.tp_respuesta === 4) &&
                                                    event.tp_validado === 0
                                    );

                        if(arr.length)
                        {
                            me.tp_respuesta     =   arr[0].tp_respuesta;
                            me.str_observacion  =   arr[0].str_observacion_html;

                            setTimeout(function(){
                                if(me.tp_respuesta  ==  3)
                                {
                                    me.tp_observacion   =   5; // Rechazar Pre-Publicación Definitiva
                                    me.nr_fuente        =   arr[0].id;
                                    $('.btn_publicar').attr('disabled',false);
                                    $('.btn_informar').attr('disabled',true);
                                }
                                if(me.tp_respuesta == 4)
                                {
                                    me.tp_observacion   =   6; // Rechazar Pre-Publicación Parcial
                                    me.nr_fuente        =   arr[0].id;
                                    $('.btn_publicar').attr('disabled',true);
                                    $('.btn_informar').attr('disabled',false);
                                }
                            }, 1000);
                        }
                    }

                    return arr;
                },
                //-------------------------------------------------------------------------------------------
                setResumir(valor = 0, index = 0)
                {
                    let me  =   this;

                    me.tp_visualizar    =   {
                        tp_resumir : valor,
                        nr_index : index,
                    };
                },
                //-------------------------------------------------------------------------------------------
                validarAdjunto(tipo, accion)
                {
                    let me              =   this;
                    var extension       =   '';
                    var fileSize        =   0;
                    var file_adjunto    =   '';
                    var file_value      =   '';
                    var max             =   3;
                    var error           =   0;
                    me.arr_error        =   [];

                    switch(tipo)
                    {
                        case "documento":
                        {
                            file_adjunto    =   document.querySelector("#file_adjunto");
                            file_value      =   file_adjunto.value;
                            var tipo_ext    =   ['.jpeg','.jpg','.png','.doc','.docx','.xls','.xlsx',
                                                '.ppt','.pptx','.msg','.pdf','.dwg','.dgn','.rar','.zip'];

                            if(file_value != "")
                            {
                                var fileSize  = file_adjunto.files[0].size;
                                extension = (file_value.substring(file_value.lastIndexOf("."))).toLowerCase();

                                if(fileSize > 20971520 ) 
                                    me.arr_error.push("El archivo adjunto NO debe superar los 20 MB");

                                if(!tipo_ext.includes(extension))
                                    me.arr_error.push("El archivo seleccionado No es adminido");

                                if(me.arr_archivo.length == max)
                                    me.arr_error.push("Solo se pueden adjuntar "+max+" archivos maximo");

                                if(me.str_archivo.trim() == '' )
                                     me.arr_error.push("Favor Ingresar Descripción de Adjunto.");
                            }


                            if(me.arr_error.length)
                                me.descartarAdjunto();

                            if(accion == "save" && me.arr_error.length == 0 && file_value != "")
                            {
                                me.arr_files.push(file_adjunto.files[0]);
                                me.arr_str_archivo.push(me.str_archivo);
                                me.arr_archivo.push({
                                    'file':file_adjunto.files[0], 
                                    'descripcion':me.str_archivo,
                                    'sizeMB':parseFloat((file_adjunto.files[0].size/1048576).toFixed(2)),
                                    'sizeKB':file_adjunto.files[0].size
                                });
                                $('#modal_adjunto').modal('hide');
                                me.descartarAdjunto();
                                me.limpiarDatos('archivo');
                            }


                            break;
                        }
                    }

                    if(me.arr_error.length)
                        error   =   1;

                    return error;
                },
                //-------------------------------------------------------------------------------------------
                descartarAdjunto()
                {
                    let me              =   this;
                    var file_adjunto    =   '';

                    file_adjunto    =   document.querySelector("#file_adjunto");

                    if(file_adjunto)
                    {
                        document.querySelector("#file_adjunto").value = "";
                    }
                },
                //-------------------------------------------------------------------------------------------
                quitarAdjunto(modelo, index)
                {
                    let me          =   this;
                    me.arr_error    =   [];

                    switch(modelo)
                    {
                        case 'archivo':
                        {
                            me.arr_files.splice(index, 1);
                            me.arr_archivo.splice(index, 1);
                            me.arr_str_archivo.splice(index, 1);

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                cerrarModal(modelo)
                {
                    let me  =   this;

                    switch(modelo)
                    {
                        case 'historial':
                        {
                            if(me.nr_estado == 1 || me.nr_estado == 9) // Visación
                            {
                                tinymce.remove('#str_visado');
                                $('str_visado').remove();
                            }
                            else if(me.nr_estado == 2 || me.nr_estado == 10) // Asignador
                            {
                                tinymce.remove('#str_asignador');
                                $('str_asignador').remove();
                            }
                            else if(me.nr_estado == 3 || me.nr_estado == 4 || me.nr_estado == 8) // Funcionario
                            {                                    
                                tinymce.remove('#str_observacion');
                                $('str_observacion').remove();
                            }

                            $('#modal_historial').modal('hide');
                            me.limpiarDatos(modelo);

                            break;
                        }
                        case 'archivo':
                        {
                            $('#modal_adjunto').modal('hide');
                            me.limpiarDatos(modelo);

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                cargarPendientes()
                {
                    let me          = this;
                    var ruta        = '/contador/solicitudes/pendientes';

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta           =   response.data;                        
                        $('#pendientes_validacion').html(respuesta.nr_bandeja);
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                asyncDeptos(item)
                {
                    let me  =   this;

                    if(item)
                    {
                        me.nr_direccion     =   item;
                        me.cargarDeptosMunicipales(0, me.getValue(me.nr_direccion));
                    }
                    else
                        me.arr_depto        =   [];
                },
                //-------------------------------------------------------------------------------------------
                asyncServicios(item)
                {
                    let me  =   this;

                    if(item)
                    {
                        me.fl_depto     =   item;
                        me.cargarServicios(me.getValue(me.fl_direccion), me.getValue(me.fl_depto));
                        me.fl_servicio  =   [];
                    }
                    else
                        me.fl_servicio  =   [];
                },
                //-------------------------------------------------------------------------------------------
                asyncDerivarDeptos(item)
                {
                    let me  =   this;

                    console.log('buscar deptos');
                    console.log(item);

                    if(item)
                    {
                        me.nr_direccion     =   item;
                        me.cargarDeptosMunicipales(0, me.getValue(me.nr_direccion));
                        me.cargarServicios(me.getValue(me.nr_direccion), 0); // Servicios de la Direccion
                    }
                    else
                    {
                        me.nr_direccion     =   [];
                        me.nr_depto         =   [];
                        me.arr_depto        =   [];
                        me.nr_servicio      =   [];
                        me.arr_servicio     =   [];
                        me.cargarServicios(0,0);
                    }
                },
                //-------------------------------------------------------------------------------------------
                asyncDerivarServicios(item)
                {
                    let me  =   this;

                    console.log('buscar servicios');
                    console.log(item);

                    if(item)
                    {
                        me.nr_depto     =   item;
                        me.nr_servicio  =   [];
                        me.cargarServicios(me.getValue(me.nr_direccion), me.getValue(me.nr_depto));                        
                    }
                    else
                    {
                        me.nr_depto     =   [];
                        me.nr_servicio  =   [];
                    }
                },
                //-------------------------------------------------------------------------------------------
                asyncServiciosForDireccion(item)
                {
                    let me  =   this;

                    if(item)
                    {
                        me.nr_direccion     =   item;
                        me.cargarServicios(me.getValue(me.nr_direccion), 0);
                        me.nr_servicio      =   [];
                    }
                    else
                        me.nr_servicio      =   [];
                },
                //-------------------------------------------------------------------------------------------
                asyncFeedback()
                {
                    let me  =   this;

                    if(me.tp_recepcion == 0)
                        me.tp_satisfaccion = 0;
                },
                //-------------------------------------------------------------------------------------------
                asyncCallesSolicitud(query)
                {
                    let me          = this;
                    var ruta        = '/direccion/index';

                    if(query.length >= 3) 
                        me.cargarCalles(query,2);
                },
                //-------------------------------------------------------------------------------------------
                asyncCallesVecino(query)
                {
                    let me          = this;
                    var ruta        = '/direccion/index';

                    if(query.length >= 3) 
                        me.cargarCalles(query,1);
                },
                //-------------------------------------------------------------------------------------------
                cargarCalles(query, tp_opcion = 1)
                {
                    let me          = this;
                    var ruta        = '/direccion/index';
                    var respuesta   = [];

                    axios.post(ruta,{'nm_direccion':   query,
                    }).then(function (response)
                    {
                        var respuesta   =   response.data;

                        if(tp_opcion == 1)
                                me.arr_calles_vecino = respuesta.result;
                        
                        if(tp_opcion == 2)
                                me.arr_calles_solicitud = respuesta.result;

                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarDireccionesMunicipales()
                {
                    let me      =   this;
                    var ruta    =   '/listado/direcciones_municipales';
                    me.arr_direccion    =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_direccion    =   respuesta.direcciones;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarDeptosMunicipales(tp_filtro = 0, nr_direccion)
                {
                    let me      =   this;
                    var ruta    =   '/listado/deptos_municipales';
                    me.arr_depto    =   [];

                    axios.post(ruta,{
                        'nr_direccion'      :   nr_direccion,
                    }).then(function (response)
                    {
                        var respuesta       =   response.data;

                        if(tp_filtro == 0)
                            me.arr_depto        =   respuesta.deptos;
                        else
                            me.fl_arr_deptos    =   respuesta.deptos;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarServicios(nr_direccion = 0, nr_depto = 0)
                {
                    let me      =   this;
                    var ruta    =   '/listado/servicios';
                    me.arr_servicio     =   [];

                    axios.post(ruta,{
                        'nr_direccion'      :   nr_direccion,
                        'nr_depto'          :   nr_depto,
                    }).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_servicio     =   respuesta;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarMotivo()
                {
                    let me      =   this;
                    var ruta    =   '/motivo/listado';
                    me.arr_motivo   =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta   =   response.data;
                        me.arr_motivo   =   respuesta;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarPrioridad()
                {
                    let me      =   this;
                    var ruta    =   '/prioridad/listado';
                    me.arr_prioridad    =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_prioridad    =   respuesta;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarMacrozona()
                {
                    let me      =   this;
                    var ruta    =   '/listado/macrozona';
                    me.arr_macrozona    =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_macrozona    =   respuesta.macrozona;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarUnidadVecinal()
                {
                    let me      =   this;
                    var ruta    =   '/listar/unidadvecinales';
                    me.arr_unidadvecinal    =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta           =   response.data;
                        me.arr_unidadvecinal    =   respuesta;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarTicket()
                {
                    let me      =   this;
                    var ruta    =   '/listado/ticket';
                    me.arr_ticket    =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta    =   response.data;
                        me.arr_ticket    =   respuesta.ticket;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarUbicaciones()
                {
                    let me      =   this;
                    var ruta    =   '/listado/ubicaciones';
                    me.arr_ubicaciones      =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta           =   response.data;
                        me.arr_ubicaciones      =   respuesta.ubicaciones;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarPersonas()
                {
                    let me      =   this;
                    var ruta    =   '/listado/personas';
                    me.arr_persona      =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_persona      =   respuesta.personas;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarUsuario()
                {
                    let me      =   this;
                    var ruta    =   '/info/usuario';
                    me.arr_usuario  =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta     =   response.data;
                        me.arr_usuario    =   respuesta;

                        me.filterEstados();
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarFuncionariosAsignados(nr_servicio = 0)
                {
                    let me      =   this;
                    var ruta    =   '/listado/asignados';
                    me.arr_funcionarios     =   [];
                    me.arr_personal         =   [];

                    axios.post(ruta,{
                        'nr_servicio'       :   nr_servicio,
                    }).then(function (response)
                    {
                        var respuesta           =   response.data;
                        me.arr_funcionarios     =   respuesta.funcionarios;
                        me.arr_personal         =   respuesta.funcionarios;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarHistorial(id_consulta)
                {
                    let me      = this;
                    var ruta    = '/telefonista/historial/solicitud';
                    // me.arr_historial    =   [];

                    axios.post(ruta,{
                        'id_solicitud'  :   id_consulta,
                    }).then(function (response) 
                    {
                        var respuesta       =   response.data;
                        me.arr_historial    =   respuesta.arr_historial;
                        me.arr_respuestas   =   respuesta.arr_respuestas;
                        me.filterRespuestas(respuesta.respuestas);
                        
                        // actualizacion estado
                        me.nr_estado        =   me.arr_historial[me.arr_historial.length -1].id_estado;
                    }).catch(function (error)
                    {
                        console.log(error)
                    });     
                },
                //-------------------------------------------------------------------------------------------
                cargarDatos(page = 1)
                {
                    let me          =   this;
                    var ruta        =   '/telefonista/solicitud/index';

                    axios.post(ruta,{
                        'page'              :   page,
                        'tp_criterio'       :   me.tp_criterio,
                        'tp_orden'          :   me.tp_orden,
                        'fl_mostrar'        :   me.fl_mostrar,
                        'fc_desde'          :   document.querySelector('#fc_desde').value,
                        'fc_hasta'          :   document.querySelector('#fc_hasta').value,
                        'fl_direccion'      :   me.getValue(me.fl_direccion),
                        'fl_depto'          :   me.getValue(me.fl_depto),
                        'fl_servicio'       :   me.getValue(me.fl_servicio),                        
                        'fl_macrozona'      :   me.getValue(me.fl_macrozona),
                        'fl_unidadvecinal'  :   me.getValue(me.fl_unidadvecinal),
                        'fl_ticket'         :   me.getValue(me.fl_ticket),
                        'fl_persona'        :   me.getValue(me.fl_persona),
                        'fl_motivo'         :   me.getValue(me.fl_motivo),
                        'fl_ubicacion'      :   me.getValue(me.fl_ubicacion),
                        'tp_validar'        :   0,
                    }).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_index        =   respuesta.info.data ;
                        me.pagination       =   respuesta.pagination;
                        me.rows             =   respuesta.info.data;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },                
                //-------------------------------------------------------------------------------------------
                filtrarDatos()
                {
                    let me  =   this;
                    me.cargarDatos();
                },
                //-------------------------------------------------------------------------------------------
                limpiarFiltros()
                {
                    let me  =   this;

                    me.fl_direccion         =   [];
                    me.fl_depto             =   [];
                    me.fl_servicio          =   [];
                    me.fl_macrozona         =   [];
                    me.fl_unidadvecinal     =   [];
                    me.fl_ticket            =   [];
                    me.arr_depto            =   [];
                    me.arr_servicio         =   [];
                    me.fl_ubicacion         =   [];
                    me.fl_motivo            =   [];
                    me.fl_persona           =   [];

                    me.cargarDatos();
                },
                //-------------------------------------------------------------------------------------------
                limpiarDatos(modelo)
                {
                    let me  =   this;

                    switch(modelo)
                    {
                        case 'historial':
                        {
                            me.arr_form         =   {};
                            me.nr_funcionario   =   [];
                            me.str_visado       =   '';
                            me.str_observacion  =   '';
                            me.str_derivar      =   '';
                            me.str_feedback     =   '';
                            me.str_anular       =   '';
                            me.tp_visado        =   0;
                            me.tp_observacion   =   0;
                            me.btn_envio        =   0;
                            me.btn_aprobar      =   0;
                            me.btn_rechazar     =   0;
                            me.nr_solicitud     =   0;
                            me.btn_publicar     =   0;
                            me.btn_responder    =   0;
                            me.btn_informar     =   0;
                            me.btn_derivar      =   0;
                            me.tp_recepcion     =   0;
                            me.tp_satisfaccion  =   0;                            

                            break;
                        }
                        case 'actualizar':
                        {
                            me.nr_solicitud         =   0;
                            me.nr_prioridad         =   2;
                            me.nr_motivo            =   {};
                            /*
                            me.nr_ticket            =   '';
                            me.rut_vecino           =   '';
                            me.nm_vecino            =   '';
                            me.ap_paterno           =   '';
                            me.ap_materno           =   '';
                            me.nr_prefijo           =   '+569';
                            me.nr_telefono          =   '';
                            me.mail_vecino          =   '';
                            me.str_aclara_vecino    =   '';
                            me.arr_ubicacion_vecino =   [];
                            me.nr_direccion         =   [];
                            me.nr_servicio          =   [];
                            me.arr_direccion_solicitud  =   [];
                            me.tp_municipal             =   0;
                            me.nr_prioridad             =   2;
                            me.nr_estado                =   0;
                            me.tp_ubicacion_solicitud   =   1;
                            me.str_solicitud            =   '';
                            me.str_aclara_solicitud     =   '';
                            */

                            break;
                        }
                        case 'archivo':
                        {
                            me.str_archivo      =   '';
                            me.arr_error        =   [];
                            me.arr_valida       =   [];
                            me.tp_error         =   0;                            
                            me.descartarAdjunto();

                            break;
                        }
                        case 'revisar':
                        {
                            me.arr_adjuntos     =   [];

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                ensamblarDatos(accion)
                {
                    let me              =   this;
                    var ruta            =   '';
                    var titulo          =   '';
                    var tiempo          =   3000;
                    var error           =   0;                    
                    var formData        =   new FormData();
                    var fc_format       =   'YYYY-MM-DD';                                   
                    //----------------------------------------------------------------
                    switch(accion)
                    {
                        case 'solicitud':
                        {
                            titulo  =   'Registrar Solicitud';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                // ruta    =   '/';                            
                                // me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                //formData.append('nm_direccion', me.getLabel(me.nr_direccion));
                                //------------------------------------
                                // me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'aprobar':
                        {
                            titulo  =   'Aprobar Solicitud';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                me.btn_aprobar      =   1;
                                $('.btn_rechazar').attr('disabled',true);
                                //------------------------------------
                                ruta    =   '/macrozona/visacion';                            
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('nr_id', me.nr_solicitud);
                                formData.append('opcion', me.tp_visado);
                                formData.append('str_observacion', tinymce.get("str_visado").getContent({format: "text"}));
                                formData.append('str_observacion_html', tinymce.get("str_visado").getContent({format: "html"}));
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'rechazar':
                        {
                            titulo  =   'Rechazar Solicitud';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                me.btn_rechazar     =   1;
                                $('.btn_aprobar').attr('disabled',true);
                                //------------------------------------
                                ruta    =   '/macrozona/visacion';                            
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('nr_id', me.nr_solicitud);
                                formData.append('opcion', me.tp_visado);
                                formData.append('str_observacion', tinymce.get("str_visado").getContent({format: "text"}));
                                formData.append('str_observacion_html', tinymce.get("str_visado").getContent({format: "html"}));
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'publicar':
                        {
                            titulo  =   'Registrar Publicación Definitiva';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                me.btn_publicar     =   1;
                                $('.btn_responder').attr('disabled',true);
                                $('.btn_informar').attr('disabled',true);
                                $('.btn_derivar').attr('disabled',true);
                                //------------------------------------
                                ruta    =   '/funcionario/respuesta';                            
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('nr_id', me.nr_solicitud);
                                formData.append('nr_fuente', me.nr_fuente);
                                formData.append('opcion', me.tp_observacion);
                                formData.append('str_observacion', tinymce.get("str_observacion").getContent({format: "text"}));
                                formData.append('str_observacion_html', tinymce.get("str_observacion").getContent({format: "html"}));
                                //------------------------------------
                                if(me.arr_files.length != 0)
                                {
                                    for (var i = 0; i < me.arr_files.length; i++) 
                                    {
                                        formData.append('arr_archivo[]', me.arr_files[i]);
                                    }
                                    for (var i = 0; i < me.arr_str_archivo.length; i++) 
                                    {
                                        formData.append('arr_observacion[]', me.arr_str_archivo[i]);
                                    }
                                }
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'responder':
                        {
                            titulo  =   'Registrar Respuesta';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                me.btn_responder     =   1;
                                $('.btn_publicar').attr('disabled',true);
                                $('.btn_informar').attr('disabled',true);
                                $('.btn_derivar').attr('disabled',true);
                                //------------------------------------
                                ruta    =   '/funcionario/respuesta';                            
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('nr_id', me.nr_solicitud);
                                formData.append('nr_fuente', 0);
                                formData.append('opcion', me.tp_observacion);
                                formData.append('str_observacion', tinymce.get("str_observacion").getContent({format: "text"}));
                                formData.append('str_observacion_html', tinymce.get("str_observacion").getContent({format: "html"}));
                                //------------------------------------
                                if(me.arr_files.length != 0)
                                {
                                    for (var i = 0; i < me.arr_files.length; i++) 
                                    {
                                        formData.append('arr_archivo[]', me.arr_files[i]);
                                    }
                                    for (var i = 0; i < me.arr_str_archivo.length; i++) 
                                    {
                                        formData.append('arr_observacion[]', me.arr_str_archivo[i]);
                                    }
                                }
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'informar':
                        {
                            titulo  =   'Registrar Publicación Parcial';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                me.btn_informar     =   1;
                                $('.btn_publicar').attr('disabled',true);
                                $('.btn_responder').attr('disabled',true);
                                $('.btn_derivar').attr('disabled',true);
                                //------------------------------------
                                ruta    =   '/funcionario/respuesta';                            
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('nr_id', me.nr_solicitud);
                                formData.append('nr_fuente', me.nr_fuente);
                                formData.append('opcion', me.tp_observacion);
                                formData.append('str_observacion', tinymce.get("str_observacion").getContent({format: "text"}));
                                formData.append('str_observacion_html', tinymce.get("str_observacion").getContent({format: "html"}));
                                //------------------------------------
                                if(me.arr_files.length != 0)
                                {
                                    for (var i = 0; i < me.arr_files.length; i++) 
                                    {
                                        formData.append('arr_archivo[]', me.arr_files[i]);
                                    }
                                    for (var i = 0; i < me.arr_str_archivo.length; i++) 
                                    {
                                        formData.append('arr_observacion[]', me.arr_str_archivo[i]);
                                    }
                                }
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'derivar':
                        {
                            titulo  =   'Derivar Solicitud';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                me.btn_derivar  =   1;
                                //------------------------------------
                                ruta    =   '/solicitud/derivar';                            
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('nr_solicitud', me.nr_solicitud);
                                formData.append('nr_servicio',  me.getValue(me.nr_servicio));
                                formData.append('nm_servicio', me.getLabel(me.nr_servicio));
                                formData.append('nr_direccion', me.nr_servicio.id_direccion);
                                formData.append('nr_depto', me.nr_servicio.id_depto);
                                formData.append('str_derivar', tinymce.get("str_derivar").getContent({format: "text"}));
                                formData.append('str_derivar_html', tinymce.get("str_derivar").getContent({format: "html"}));
                                formData.append('tp_ingreso', 5); // Administrador
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'feedback':
                        {
                            titulo  =   'Registrar Feedback';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                 me.btn_derivar  =   1;
                                //------------------------------------
                                ruta    =   '/feedback/store';                            
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('nr_id', me.nr_solicitud);
                                formData.append('str_observacion', me.str_feedback);
                                formData.append('tp_satisfaccion', me.tp_satisfaccion);
                                formData.append('tp_recepcion', me.tp_recepcion);
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'anular':
                        {
                            titulo  =   'Anular Solicitud';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                 me.btn_derivar  =   1;
                                //------------------------------------
                                ruta    =   '/gestion/anular/solicitud';                            
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('nr_solicitud', me.nr_solicitud);
                                formData.append('nr_ticket', me.nr_ticket);
                                formData.append('str_anular', tinymce.get("str_anular").getContent({format: "text"}));
                                formData.append('str_anular_html', tinymce.get("str_anular").getContent({format: "html"}));
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'actualizar':
                        {
                            titulo  =   'Actualizar Solicitud';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                 me.btn_envio   =   1;
                                //------------------------------------
                                ruta    =   '/solicitud/mz/update';                            
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                // Datos de Solicitud
                                formData.append('id_consulta', me.nr_solicitud);
                                //formData.append('nr_tipo', me.getValue(me.nr_servicio));
                                //formData.append('nm_tipo', me.getLabel(me.nr_servicio));
                                formData.append('nr_motivo', me.getValue(me.nr_motivo));
                                formData.append('nr_prioridad', me.nr_prioridad);
                                // ubicacion del problema
                                //if(Object.keys(me.arr_direccion_solicitud).length)
                                //    formData.append('arr_direccion_solicitud[]', JSON.stringify(me.arr_direccion_solicitud));

                                //formData.append('str_observacion', me.str_solicitud);
                                //formData.append('str_aclaratoria_solicitud', me.str_aclara_solicitud);
                                //formData.append('nr_dir_municipal', me.getValue(me.nr_direccion));
                                //formData.append('tp_direccion_solicitud', me.tp_ubicacion_solicitud);
                                //------------------------------------
                                if(me.arr_files.length != 0)
                                {
                                    for (var i = 0; i < me.arr_files.length; i++) 
                                    {
                                        formData.append('arr_archivo[]', me.arr_files[i]);
                                    }
                                    for (var i = 0; i < me.arr_str_archivo.length; i++) 
                                    {
                                        formData.append('arr_observacion[]', me.arr_str_archivo[i]);
                                    }
                                }
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'asignar':
                        {
                            titulo  =   'Asignar Solicitud';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                me.btn_asignar     =   1;
                                $('.btn_asignar').attr('disabled',true);
                                //------------------------------------
                                ruta    =   '/solicitud/asignar';
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('nr_id', me.nr_solicitud);
                                formData.append('nr_ticket', me.nr_ticket);
                                formData.append('str_observacion', tinymce.get("str_asignador").getContent({format: "text"}));
                                formData.append('str_observacion_html', tinymce.get("str_asignador").getContent({format: "html"}));
                                //------------------------------------
                                for (var i = 0; i < me.nr_funcionario.length; i++) {
                                    formData.append('arr_funcionarios['+i+']', me.getValue(me.nr_funcionario[i]));
                                }
                                //------------------------------------
                                if(me.arr_files.length != 0)
                                {
                                    for (var i = 0; i < me.arr_files.length; i++) 
                                    {
                                        formData.append('arr_archivo[]', me.arr_files[i]);
                                    }
                                    for (var i = 0; i < me.arr_str_archivo.length; i++) 
                                    {
                                        formData.append('arr_observacion[]', me.arr_str_archivo[i]);
                                    }
                                }
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                    }
                    //----------------------------------------------------------------
                },
                //-------------------------------------------------------------------------------------------
                validarDatos(tp_validacion)
                {
                    let me          =   this;
                    var error       =   0;
                    me.arr_valida   =   [];    
                    me.arr_form     =   {}; 
                    me.str_msj      =   '';

                    switch(tp_validacion)
                    {
                        case 'solicitud':
                        {
                            

                            break;
                        }
                        case 'aprobar':
                        {
                            if(me.nr_solicitud == 0)
                                me.arr_form.nr_solicitud    =   'No se encuentra el Id de la Solicitud';                            

                            break;
                        }
                        case 'rechazar':
                        {
                            if(me.nr_solicitud == 0)
                                me.arr_form.nr_solicitud    =   'No se encuentra el Id de la Solicitud';

                            if(tinymce.get("str_visado").plugins.wordcount.body.getCharacterCount() <  10)
                                me.arr_form.str_visado      =   'La observación debe tener minimo 10 caracteres';

                            if(tinymce.get("str_visado").plugins.wordcount.body.getCharacterCount() >  2000)
                                me.arr_form.str_visado      =   'La observación debe tener maximo 2000 caracteres';

                            break;
                        }
                        case 'publicar':
                        {
                            if(me.nr_solicitud == 0)
                                me.arr_form.nr_solicitud    =   'No se encuentra el Id de la Solicitud';

                            if(tinymce.get("str_observacion").plugins.wordcount.body.getCharacterCount() <  10)
                                me.arr_form.str_observacion =   'La respuesta debe tener minimo 10 caracteres';

                            if(tinymce.get("str_observacion").plugins.wordcount.body.getCharacterCount() >  2000)
                                me.arr_form.str_observacion =   'La respuesta debe tener maximo 2000 caracteres';

                            break;
                        }
                        case 'responder':
                        {
                            if(me.nr_solicitud == 0)
                                me.arr_form.nr_solicitud    =   'No se encuentra el Id de la Solicitud';

                            if(tinymce.get("str_observacion").plugins.wordcount.body.getCharacterCount() <  10)
                                me.arr_form.str_observacion =   'La respuesta debe tener minimo 10 caracteres';

                            if(tinymce.get("str_observacion").plugins.wordcount.body.getCharacterCount() >  2000)
                                me.arr_form.str_observacion =   'La respuesta debe tener maximo 2000 caracteres';

                            break;
                        }
                        case 'informar':
                        {
                            if(me.nr_solicitud == 0)
                                me.arr_form.nr_solicitud    =   'No se encuentra el Id de la Solicitud';

                            if(tinymce.get("str_observacion").plugins.wordcount.body.getCharacterCount() <  10)
                                me.arr_form.str_observacion =   'La respuesta debe tener minimo 10 caracteres';

                            if(tinymce.get("str_observacion").plugins.wordcount.body.getCharacterCount() >  2000)
                                me.arr_form.str_observacion =   'La respuesta debe tener maximo 2000 caracteres';

                            break;
                        }
                        case 'derivar':
                        {
                            if(me.nr_solicitud == 0)
                                me.arr_form.nr_solicitud    =   'No se encuentra el Id de la Solicitud';

                            if(me.getValue(me.nr_servicio) == 0)
                                me.arr_form.nr_servicio     =   'Debe seleccionar un Servicio';

                            if(tinymce.get("str_derivar").plugins.wordcount.body.getCharacterCount() <  10)
                                me.arr_form.str_derivar   =   'La observación debe tener minimo 10 caracteres';

                            if(tinymce.get("str_derivar").plugins.wordcount.body.getCharacterCount() >  300)
                                me.arr_form.str_derivar   =   'La observación debe tener maximo 300 caracteres';

                            break;
                        }
                        case 'feedback':
                        {
                            if(me.nr_solicitud == 0)
                                me.arr_form.nr_solicitud    =   'No se encuentra el Id de la Solicitud';

                            if(me.tp_recepcion == 1 && me.tp_satisfaccion == 0)
                                me.arr_form.tp_satisfaccion     =   'Favor seleccionar el nivel de satisfacción';

                            if(me.tp_recepcion == 1 && me.str_feedback.trim().length == 0)
                                me.arr_form.str_feedback        =   'Favor ingresar la observación del feedback';

                            break;
                        }
                        case 'anular':
                        {
                            if(me.nr_solicitud == 0)
                                me.arr_form.nr_solicitud    =   'No se encuentra el Id de la Solicitud';

                            if(tinymce.get("str_anular").plugins.wordcount.body.getCharacterCount() <  10)
                                me.arr_form.str_anular   =   'La observación debe tener minimo 10 caracteres';

                            if(tinymce.get("str_anular").plugins.wordcount.body.getCharacterCount() >  300)
                                me.arr_form.str_anular   =   'La observación debe tener maximo 300 caracteres';

                            break;
                        }
                        case 'actualizar':
                        {
                            if(me.nr_solicitud == 0)
                                me.arr_form.nr_solicitud    =   'No se encuentra el Id de la Solicitud';

                            if(me.getValue(me.nr_direccion) == 0)
                                me.arr_form.nr_direccion    =   'Debe seleccionar la Dirección Municipal';

                            if(me.getValue(me.nr_servicio) == 0)
                                me.arr_form.nr_servicio     =   'Debe seleccionar un Servicio';

                            if(me.nr_prioridad == 0)
                                me.arr_form.nr_prioridad    =   'Debe indicar la Importancia';

                            if(me.str_solicitud.trim().length < 5)
                                me.arr_form.str_solicitud   =   'La Descripción de la Solicitud debe tener minimo 5 caracteres';

                            if(me.arr_direccion_solicitud === null)
                                me.arr_form.nm_ubicacion_solicitud      =   'Debe ingresar la Dirección del Requerimiento';

                            if(me.tp_ubicacion_solicitud == 0)
                                me.arr_form.tp_ubicacion_solicitud      =   'Debe indicar  si es [Frente | Altura]';

                            break;
                        }
                        case 'asignar':
                        {
                            if(me.nr_solicitud == 0)
                                me.arr_form.nr_solicitud    =   'No se encuentra el Id de la Solicitud';

                            if(me.nr_funcionario.length == 0)
                                me.arr_form.nr_funcionario  =   'Debe seleccionar a menos un funcionario';

                            if(tinymce.get("str_asignador").plugins.wordcount.body.getCharacterCount() <  10)
                                me.arr_form.str_asignador   =   'La observación debe tener minimo 10 caracteres';

                            if(tinymce.get("str_asignador").plugins.wordcount.body.getCharacterCount() >  2000)
                                me.arr_form.str_asignador   =   'La observación debe tener maximo 2000 caracteres';

                            break;
                        }
                    }

                    if(Object.keys(me.arr_form).length != 0)
                        error   =   1;

                    return error;
                },
                //-------------------------------------------------------------------------------------------
                registrarDatos(ruta, formData)
                {
                    let me              =       this;
                    var tp_icon         =       '';
                    var titulo          =       '';
                    var mensaje         =       '';
                    var error           =       '';

                    axios.post(ruta, formData, {
                        headers: {'Content-Type': 'multipart/form-data'}
                    }).then(function (response) 
                    {
                        var result  =   response.data;                       
                        tp_icon     =   result.tp_icon;
                        titulo      =   result.title;
                        mensaje     =   result.msj;
                        error       =   result.error;

                        me.desplegarVentana(tp_icon, titulo, mensaje);

                        //Limpiar Modelos
                        if(error == 0)
                        {
                            me.btn_envio    =   0;

                            if(me.tp_accion === 1)
                            {
                                me.cargarHistorial(me.nr_solicitud);
                                me.limpiarDatos('historial');
                                me.limpiarDatos('archivo');
                                me.refrescarDatos();
                                me.arr_archivo          =   [];
                                me.arr_files            =   [];
                                me.arr_str_archivo      =   [];
                                $('#modal_derivar').modal('hide');
                            }
                            if(me.tp_accion === 2)
                            {
                                me.limpiarDatos('historial');
                                me.refrescarDatos();
                                $('#modal_anular').modal('hide');
                                $('#modal_historial').modal('hide');
                            }
                            if(me.tp_accion === 3)
                            {
                                $('#modal_actualizar').modal('hide');
                                me.limpiarDatos('actualizar');
                                me.refrescarDatos();            
                            }
                            if(me.tp_accion == 4)
                            {
                                me.arr_asignados    =   result.encargado;
                                me.btn_asignar      =   0;
                                me.cargarHistorial(me.nr_solicitud);
                                me.limpiarDatos('historial');
                                me.limpiarDatos('archivo');
                                me.refrescarDatos();
                            }
                            if(me.tp_accion == 5)
                            {
                                me.limpiarDatos('historial');
                                me.limpiarDatos('archivo');
                                me.refrescarDatos();
                                $('#modal_derivar').modal('hide');
                                $('#modal_historial').modal('hide');
                            }
                        }
                    })
                    .catch(function (error) 
                    {
                        me.btn_envio        =   0;
                        me.btn_aprobar      =   0;
                        me.btn_rechazar     =   0;
                        me.btn_publicar     =   0;
                        me.btn_responder    =   0;
                        me.btn_informar     =   0;
                        me.btn_derivar      =   0;

                        if (error.response.status == 422)
                            me.validationErrors = error.response.data.errors;
                        /*// Formato de Archivo Incorrecto
                        if (error.response.status == 413)
                        {
                            //------------------------------
                        }
                        */
                    });
                },
                //-------------------------------------------------------------------------------------------
                abrirModal(modelo, accion, data = [])
                {
                    let me      =   this;                    

                    switch(modelo)
                    {
                        case 'solicitud':
                        {
                            switch(accion)
                            {
                                case 'historial':
                                {
                                    me.tp_modal                 =   1;
                                    me.tp_accion                =   1;
                                    me.tp_btn                   =   0;
                                    me.btn_envio                =   0;
                                    me.titulo_modal             =   'Historial';
                                    me.limpiarDatos(accion);
                                    me.arr_solicitud            =   data;
                                    me.nr_solicitud             =   data.id;
                                    me.nr_ticket                =   data.nr_ticket;
                                    me.nr_estado                =   data.id_estado;
                                    me.nm_estado                =   data.nm_estado;
                                    me.arr_asignados            =   data.asignados;
                                    me.cargarFuncionariosAsignados(data.id_tipo);
                                    $('#modal_historial').modal('show');
                                    me.cargarHistorial(data.id);

                                    break;
                                }
                            }

                            break;
                        }
                        case 'archivo':
                        {
                            switch(accion)
                            {
                                case 'anexar':
                                {
                                    me.tp_modal             =   1;
                                    me.tp_accion            =   1;
                                    me.tp_btn               =   1;
                                    me.btn_envio            =   0;
                                    me.titulo_adjunto       =   'Adjuntar Documentos';
                                    me.tp_adjunto           =   'documento';
                                    me.limpiarDatos(modelo);
                                    $('#modal_adjunto').modal('show');

                                    break;
                                }
                                case 'revisar':
                                {
                                    me.tp_modal             =   1;
                                    me.tp_accion            =   1;
                                    me.tp_btn               =   1;
                                    me.btn_envio            =   0;
                                    me.titulo_adjunto       =   'Revisar Documentos';
                                    me.tp_adjunto           =   'archivos';
                                    me.limpiarDatos(modelo);
                                    me.arr_adjuntos         =   data.archivos;
                                    $('#modal_revisar').modal('show');

                                    break;
                                }
                                case 'examinar':
                                {
                                    me.tp_modal             =   1;
                                    me.tp_accion            =   1;
                                    me.tp_btn               =   1;
                                    me.btn_envio            =   0;
                                    me.titulo_adjunto       =   'Revisar Documentos';
                                    me.tp_adjunto           =   'archivos';
                                    me.limpiarDatos(modelo);
                                    me.arr_adjuntos         =   data.archivos_asignacion;
                                    $('#modal_revisar').modal('show');

                                    break;
                                }
                            }

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                zonaDeEspera(titulo, tiempo)
                {
                    Swal.fire({
                        title : '<h5>'+titulo+'</h5>',
                        html: '<strong> </strong>',
                        showConfirmButton: false,
                        timer: tiempo,
                        onBeforOpen: () => {
                            Swal.showLoading()
                        },
                    }).then((result) => {
                        if(result.dismiss == Swal.DismissReason.timer)
                        {
                            //----------------------------------------
                        }
                    });
                },
                //-------------------------------------------------------------------------------------------
                desplegarVentana(tp_icon, titulo, mensaje, tp_btn = 1)
                {
                    Swal.fire({
                        icon: tp_icon,
                        title: titulo,
                        html: mensaje,
                        backdrop:false,
                        showConfirmButton: tp_btn
                    });                       
                },
                //-------------------------------------------------------------------------------------------
            },

            mounted() {
                let me = this;
                me.activeDatetimepicker();
                me.cargarUsuario();
                me.cargarPendientes();
                me.cargarDireccionesMunicipales();
                me.cargarPrioridad();
                me.cargarMotivo();
                me.cargarMacrozona();
                me.cargarUnidadVecinal();
                me.cargarTicket();
                me.cargarUbicaciones();
                me.cargarPersonas();
                me.cargarDatos();
            }
        });
    </script>

    <script type="text/javascript">
        //-----------------------------------------------------------------
        $(document).ready(function(){
            /*----- Inicio - Filtrar -----*/
            $("#btn_filtrar_datos").click(function () {
                $content = $("#filtrar_datos");
                $content.slideToggle(500, function () {
                    // ---------------------------                    
                });
            });

            $("#close_filtrar_datos").click(function () {
                $content = $("#filtrar_datos");
                $content.slideToggle(500, function () {
                    // ---------------------------                    
                });
            });
            /*----- Inicio - Modal -----*/

            $('#modal_historial').modal({backdrop: 'static', keyboard: false});
            $('#modal_derivar').modal({backdrop: 'static', keyboard: false});
            $('#modal_anular').modal({backdrop: 'static', keyboard: false});
            $('#modal_actualizar').modal({backdrop: 'static', keyboard: false});
            $('#modal_adjunto').modal({backdrop: 'static', keyboard: false});
            $('#modal_revisar').modal({backdrop: 'static', keyboard: false});
        });
        //-----------------------------------------------------------------
        function justNumbers(e)
        {
            var keynum = window.event ? window.event.keyCode : e.which;
            if (keynum == 8)
                return true;

            return /\d/.test(String.fromCharCode(keynum));
        }
        //-----------------------------------------------------------------
        function Rut(texto)
        { 
            var tmpstr = "";

            for ( i=0; i < texto.length ; i++ )   
                if ( texto.charAt(i) != ' ' && texto.charAt(i) != '.' && texto.charAt(i) != '-' )
                    tmpstr = tmpstr + texto.charAt(i);

            texto = tmpstr; 
            largo = texto.length; 

            if ( largo < 2 ) 
                return false; 

            for (i=0; i < largo ; i++ )    
                if (texto.charAt(i) !="0" && texto.charAt(i) != "1" && texto.charAt(i) !="2" && texto.charAt(i) != "3" && 
                    texto.charAt(i) != "4" && texto.charAt(i) !="5" && texto.charAt(i) != "6" && texto.charAt(i) != "7" && 
                    texto.charAt(i) !="8" && texto.charAt(i) != "9" && texto.charAt(i) !="k" && texto.charAt(i) != "K")   
                    return false;

            var invertido = "";

            for ( i=(largo-1),j=0; i>=0; i--,j++ )    
                invertido = invertido + texto.charAt(i);

            var dtexto = "";  
            dtexto = dtexto + invertido.charAt(0);  
            dtexto = dtexto + '-';  
            cnt = 0;  

            for ( i=1,j=2; i<largo; i++,j++ ) 
            { 
                if ( cnt == 3 )   
                {     
                    dtexto = dtexto + '.';      
                    j++;      
                    dtexto = dtexto + invertido.charAt(i);      
                    cnt = 1;    
                }   
                else    
                {       
                    dtexto = dtexto + invertido.charAt(i);      
                    cnt++;    
                } 
            } 

            invertido = "";

            for ( i=(dtexto.length-1),j=0; i>=0; i--,j++ )    
                invertido = invertido + dtexto.charAt(i);

            if (revisarDigito2(texto))
                return  invertido.toUpperCase();

            return false;
        }
        //-----------------------------------------------------------------
        function formatoMail(valor)
        {
            if (/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test(valor))
                return true;
            else
                return false;
        }
        //-----------------------------------------------------------------
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('template.home', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\repositorio\atencion_vecino\resources\views/telefonista/bandeja_telefonista.blade.php ENDPATH**/ ?>