<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Documento PDF</title>

    <style>
        @page  {
            margin: 35pt 20pt 30pt 20pt; /* top right bottom left - espacio para header y footer */
            header: html_myHeader;
            footer: html_myFooter;
        }

        @page  :first {
            margin-bottom: 30pt; 
            footer: html_myFooter;
        }
        
        :root {
            --primary-color: #1664c0;
            --primary-light: #d1e1f7; /* Versión clara */
            --primary-lighter: #e8f1fd; /* Versión muy clara */
        }

        /* Estilos base */
        body {
            font-family: Arial, sans-serif;
            font-size: 10pt;
            margin: 0;
            padding: 0;
            color: #333;
            line-height: 1.4;
        }

        /* Evitar saltos de página no deseados */
        .avoid-break {
            page-break-inside: avoid;
            break-inside: avoid;
        }

        /* Encabezado */
        .pdf-header {
            text-align: center;
            width: 100%;
            background-color: #1664c0;
            color: white;
            padding: 5pt 20pt 5pt 20pt; /* top right bottom left */
        }

        .pdf-header h1 {
            margin: 0;
            font-size: 15pt;
        }

        .logo-lascondes {
            width: 30%;
            height: auto;
            margin-top: 2pt;
        }

        /* Cuerpo del documento */
        .pdf-body {
            padding: 35pt;
        }

        /* Pie de página */
        .pdf-footer {
            position: fixed;
            bottom: -20pt;
            left: 0;
            right: 0;
            height: 20pt;
            background-color: #1664c0;
            color: white;
            text-align: center;
            line-height: 20pt;
            font-size: 10pt;
        }

        .page-number {
            font-weight: bold;
        }

        /* Resto de estilos igual que en tu plantilla original */
        /* Imágenes */
        .anexo-img {
            max-width: 100%;
            height: auto;
            margin-top: 10pt;
            display: block;
        }

        /* Versión mejorada de row/col para PDF */
        .grid {
            width: 100%;
            display: table;
            table-layout: fixed;
            border-collapse: collapse;
            margin-bottom: 0pt;
        }
        
        .grid-row {
            display: table-row;
        }
        
        .col {
            display: table-cell;
            vertical-align: top;
            padding: 5pt;
        }
        
        .col-1 { width: 8.33%; }
        .col-2 { width: 16.66%; }
        .col-3 { width: 25%; }
        .col-4 { width: 33.33%; }
        .col-5 { width: 41.66%; }
        .col-6 { width: 50%; }
        .col-7 { width: 58.33%; }
        .col-8 { width: 66.66%; }
        .col-9 { width: 75%; }
        .col-10 { width: 83.33%; }
        .col-11 { width: 91.66%; }
        .col-12 { width: 100%; }
        
        /* COMPONENTES REUTILIZABLES */
        .card {
            border: 1pt solid #ddd;
            border-radius: 3pt;
            margin-bottom: 15pt;
            page-break-inside: avoid;
        }
        
        .card-header {
            background-color: #1664c0;
            color: white;
            padding: 8pt;
            font-weight: bold;
            border-bottom: 1pt solid #ddd;
        }
        
        .card-body {
            padding: 10pt;
        }
        
        .card-footer {
            padding: 8pt;
            background-color: #fafafa;
            border-top: 1pt solid #eee;
            font-size: 8.5pt;
        }
        
        /* TABLAS MEJORADAS */
        .table {
            width: 100%;
            border-collapse: collapse;
            margin: 5pt 0;
            font-size: 8pt;
        }
        
        .table th {
            background-color: #f2f2f2;
            font-weight: bold;
            text-align: left;
        }
        
        .table th, 
        .table td {
            border: 1pt solid #ddd;
            padding: 5pt;
            vertical-align: top;
        }
        
        .table-striped tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        
        /* UTILIDADES */
        .mt-0 { margin-top: 0 !important; }
        .mt-5 { margin-top: 5pt !important; }
        .mt-10 { margin-top: 10pt !important; }
        .mb-0 { margin-bottom: 0 !important; }
        .mb-5 { margin-bottom: 5pt !important; }
        .mb-10 { margin-bottom: 10pt !important; }
        
        .pt-0 { padding-top: 0 !important; }
        .pt-5 { padding-top: 5pt !important; }
        .pt-10 { padding-top: 10pt !important; }
        .pb-0 { padding-bottom: 0 !important; }
        .pb-5 { padding-bottom: 5pt !important; }
        .pb-10 { padding-bottom: 10pt !important; }
        
        .text-left { text-align: left; }
        .text-center { text-align: center; }
        .text-right { text-align: right; }
        
        .bold { font-weight: bold; }
        .italic { font-style: italic; }
        .underline { text-decoration: underline; }
        
        .bg-gray { background-color: #f5f5f5; }
        .bg-yellow { background-color: #fffde7; }
        .bg-blue { background-color: #e3f2fd; }
        
        /* CONTROL DE SALTO DE PÁGINA */
        .page-break-before { page-break-before: always; }
        .page-break-after { page-break-after: always; }
        .avoid-break { page-break-inside: avoid; }
        
        /* Permitir saltos de página en elementos específicos */
        .allow-break {
            page-break-inside: auto;
            break-inside: auto;
        }
        
        /* ESTILOS ESPECÍFICOS PARA EL VECINO */
        .info-section {
            margin-top: 5pt;
            border-top: 1pt solid #eee;
            padding-top: 10pt;
        }
        
        .info-grid {
            width: 100%;
            display: table;
            table-layout: fixed;
            border-collapse: collapse;
        }

        .info-field {
            margin-bottom: 0pt;
        }

        .no-gap {
            margin: 0;
            padding: 0;
        }

        .info-container {
            margin-top: 0;
            padding-top: 0;
        }

        /*-------------------------------------------------------------------------*/
        /*-------------------------------------------------------------------------*/

        /* Timeline mejorado y estilizado */
        .timeline {
            list-style: none;
            padding-left: 0;
            margin: 0 0 20pt 0;
            position: relative;
        }

        .timeline:before {
            content: '';
            position: absolute;
            top: 0;
            bottom: 0;
            width: 2pt;
            background: #1664c0;
            left: 10pt;
            margin-left: -1pt;
        }

        .timeline-item {
            margin-bottom: 20pt;
            position: relative;
            padding-left: 35pt;
        }

        .timeline-icon {
            width: 20pt;
            height: 20pt;
            border-radius: 50%;
            background-color: #1664c0;
            position: absolute;
            left: 0;
            top: 2pt;
            text-align: center;
            color: white;
            font-weight: bold;
            line-height: 20pt;
            font-size: 12pt;
        }

        .timeline-date {
            display: inline-block;
            padding: 3pt 8pt;
            background-color: #1664c0;
            border-radius: 3pt;
            font-size: 9pt;
            color: white;
            margin-bottom: 5pt;
        }

        .timeline-label {
            font-weight: bold;
            display: block;
            margin-bottom: 3pt;
            color: #1664c0;
        }

        .timeline-content {
            font-size: 9pt;
            padding: 8pt;
            color: black;
            border-radius: 3pt;
            background-color: #fff;
            border-left: 3pt solid #5090e0;
        }

        /* Control específico de salto de página para elementos timeline */
        .timeline-item.avoid-break {
            page-break-inside: avoid;
        }

        /*-------------------------------------------------------------------------*/
        /*-------------------------------------------------------------------------*/

        /* Timeline de respuestas - estilo horizontal */
        .timeline-respuestas {
            list-style: none;
            padding-left: 0;
            margin: 0;
            position: relative;
        }

        .timeline-respuestas:before {
            content: '';
            position: absolute;
            top: 0;
            bottom: 0;
            width: 2pt;
            background: #1664c0;
            left: 10pt;
            margin-left: -1pt;
        }

        .timeline-respuesta-item {
            margin-bottom: 5px;
            position: relative;
            padding-left: 30pt;
            page-break-inside: avoid;
        }

        .timeline-respuesta-arrow {
            width: 15pt;
            height: 15pt;
            border-radius: 50%;
            background-color: #1664c0;
            position: absolute;
            left: 0;
            top: 2pt;
            text-align: center;
            color: white;
            font-weight: bold;
            line-height: 15pt;
            font-size: 10pt;
        }

        .timeline-respuesta-header {
            display: table;
            width: 100%;
            table-layout: fixed;
        }

        .timeline-respuesta-autor {
            display: table-cell;
            vertical-align: top;
            width: 70%;
            font-weight: bold;
            color: #1664c0;
        }

        .timeline-respuesta-fecha {
            display: table-cell;
            vertical-align: top;
            width: 30%;
            text-align: right;
            color: #666;
            font-size: 8pt;
        }

        .timeline-respuesta-contenido {
            margin-top: 3pt;
            font-size: 9pt;
            color: #333;
        }

        .timeline-respuesta-separador {
            border: 0;
            border-top: 1pt solid #eee;
            margin: 1pt 0;
        }

        /* Adaptación para que funcione bien en PDFs */
        .timeline-respuestas-container {
            width: 100%;
            margin-top: 5pt;
        }
    </style>
</head>
<body>
    <?php
        function limpiarHTML($html) {
            // Reemplazar múltiples saltos de línea con uno solo
            $limpio = preg_replace('/(\r\n|\r|\n){2,}/', "\n", $html);
            
            // Reemplazar combinaciones de <br> múltiples
            $limpio = preg_replace('/<br\s*\/?>\s*<br\s*\/?>/i', '<br>', $limpio);
            
            // Eliminar espacios en blanco excesivos
            $limpio = preg_replace('/\s{2,}/', ' ', $limpio);
            
            return $limpio;
        }
    ?>

    <!-- Pie de Pagína para la primera hoja -->
    <!-- <div style="position: fixed; bottom: -20pt; left: 0pt; right: 0pt; height: 30pt; background-color: #1664c0; z-index: 1000;"></div> -->
    
    <div style="position: fixed; bottom: -20pt; left: 0pt; right: 0pt; height: 30pt; background-color: #1664c0; z-index: -1;"></div>

    <script type="text/php">
        if (isset($pdf)) {
            $font = $fontMetrics->getFont("Arial", "normal");
            $size = 10;
            $y = $pdf->get_height() - 30; // Subimos un poco el texto
            $color = array(255, 255, 255);

            // Centrado
            $text = "Documento generado - <?php echo e(date('d/m/Y H:i')); ?>";
            $width = $fontMetrics->getTextWidth($text, $font, $size);
            $pdf->page_text(($pdf->get_width() - $width) / 2, $y, $text, $font, $size, $color);

            // A la derecha
            $pdf->page_text($pdf->get_width() - 100, $y, "Página {PAGE_NUM} de {PAGE_COUNT}", $font, $size, $color);
        }
    </script>

    <!-- Encabezado de páginas -->
    <div class="pdf-header">
        <div class="info-grid">
            <div class="grid-row">
                <div class="col col-6 no-gap" style="border-collapse: collapse;">
                    <img src="<?php echo e(file_exists($datos->str_logo) ? $datos->str_logo : ''); ?>" class="logo-lascondes" alt="Logo Las Condes">
                </div>
                <h1><?php echo e($datos->nm_sistema); ?></h1>
            </div>
        </div>
    </div>

    <div class="pdf-body">
        <!-- Primera página -->
        <div class="card">
            <div class="card-header">
                Información del Ticket
                <?php if($datos->nr_ticket): ?> - #<?php echo e($datos->nr_ticket); ?> <?php endif; ?>
                <?php if($datos->nm_estado): ?> - Estado Actual:<?php echo e($datos->nm_estado); ?> <?php endif; ?>
            </div>
            <div class="card-body">
                <!-- Datos del Ticket -->
                <div class="info-grid">
                    <div class="grid-row">
                        <div class="col col-6 no-gap" style="border-collapse: collapse;">
                            <?php if($datos->info_ticket): ?>
                                <div class="info-field">
                                    <span class="bold">Solicitud ingresada a las:</span> <?php echo e($datos->info_ticket->fc_ingreso); ?>

                                </div>
                            <?php endif; ?>
                            <?php if($datos->info_ticket->nm_ingreso): ?>
                                <div class="info-field">
                                    <span class="bold">Procedencia:</span> 
                                    <?php echo e(mb_convert_case($datos->info_ticket->nm_ingreso ?? '-', MB_CASE_TITLE, "UTF-8")); ?>

                                </div>
                            <?php endif; ?>
                            <?php if($datos->info_ticket): ?>
                                <div class="info-field">
                                    <span class="bold">Estado Ticket:</span> <?php echo e($datos->info_ticket->nm_estado); ?>

                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="col col-6 no-gap">
                            <?php if($datos->info_ticket): ?>
                                <div class="info-field">
                                    <span class="bold">Nro. Ticket:</span> <?php echo e($datos->info_ticket->nr_ticket); ?>

                                </div>
                            <?php endif; ?>                            
                            <?php if($datos->info_ticket): ?>
                                <div class="info-field">
                                    <span class="bold">Tipo Requerimiento:</span> <?php echo e($datos->info_ticket->nm_motivo); ?>

                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="info-grid">
                    <div class="grid-row">
                        <div class="col col-12 no-gap">
                            <?php if($datos->info_ticket): ?>
                                <div class="info-field">
                                    <span class="bold">Servicio:</span> <?php echo e($datos->info_ticket->nm_tipo); ?>

                                </div>
                            <?php endif; ?> 
                            <?php if($datos->info_ticket): ?>
                                <div class="info-field">
                                    <span class="bold">Dirección Municipal:</span> <?php echo e($datos->info_ticket->nm_direccion_destino); ?>

                                </div>
                            <?php endif; ?>
                            <?php if($datos->info_ticket): ?>
                                <div class="info-field">
                                    <span class="bold">Depto. Municipal:</span> <?php echo e($datos->info_ticket->nm_depto_destino); ?>

                                </div>
                            <?php endif; ?>
                            <?php if($datos->info_ticket): ?>
                                <div class="info-field">
                                    <span class="bold">Descripción del Requerimiento:</span> <?php echo $datos->info_ticket->str_observacion_html; ?>

                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Datos del Vecino -->
        <?php if($datos->info_vecino): ?>
            <div class="card">
                <div class="card-header">
                    Datos del Vecino
                </div>
                <div class="card-body allow-break">
                    <div class="info-grid">
                        <div class="grid-row">
                            <div class="col col-4 no-gap" style="border-collapse: collapse;">
                                <?php if($datos->info_vecino->nr_rut): ?>
                                    <div class="info-field">
                                        <span class="bold">Rut:</span> <?php echo e($datos->info_vecino->nr_rut); ?>

                                    </div>
                                <?php endif; ?>                                    
                                <?php if($datos->info_vecino->nr_telefono): ?>
                                    <div class="info-field">
                                        <span class="bold">Teléfono:</span> <?php echo e($datos->info_vecino->nr_prefijo); ?> - <?php echo e($datos->info_vecino->nr_telefono); ?>

                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="col col-8 no-gap">
                                <?php if($datos->info_vecino->nmc_vecino): ?>
                                    <div class="info-field">
                                        <span class="bold">Nombre:</span> 
                                        <?php echo e(mb_convert_case($datos->info_vecino->nmc_vecino ?? '-', MB_CASE_TITLE, "UTF-8")); ?>

                                    </div>
                                <?php endif; ?>                                    
                                <?php if($datos->info_vecino->nm_mail): ?>
                                    <div class="info-field">
                                        <span class="bold">Correo:</span> <?php echo e(strtolower($datos->info_vecino->nm_mail)); ?>

                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="info-grid">
                        <div class="grid-row">
                            <div class="col col-12 no-gap">
                                <div class="info-field">
                                    <span class="bold">Domicilio:</span> 
                                    <?php echo e(mb_convert_case($datos->info_vecino->nm_ubicacion ?? '-', MB_CASE_TITLE, "UTF-8")); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <!-- Solicitud Clonada -->
        <?php if($datos->info_clonado): ?>
            <div class="card">
                <div class="card-header">
                    Solicitud Clonada
                </div>
                <div class="card-body allow-break">
                    <div class="info-grid">
                        <div class="grid-row">
                            <div class="col col-12 no-gap" style="border-collapse: collapse;">
                                <?php if($datos->info_clonado->nr_ticket): ?>
                                    <div class="info-field">
                                        <span class="bold">Ticket Original:</span> <?php echo e($datos->info_clonado->nr_ticket); ?>

                                    </div>
                                <?php endif; ?>                                    
                                <?php if($datos->info_clonado->nm_tipo): ?>
                                    <div class="info-field">
                                        <span class="bold">Servicio Origen:</span> <?php echo e($datos->info_clonado->nm_tipo); ?>

                                    </div>
                                <?php endif; ?>
                                <?php if($datos->info_clonado->nm_depto): ?>
                                    <div class="info-field">
                                        <span class="bold">Dirección Origen:</span> <?php echo e($datos->info_clonado->nm_depto); ?>

                                    </div>
                                <?php endif; ?>                                    
                                <?php if($datos->info_clonado->nm_direccion): ?>
                                    <div class="info-field">
                                        <span class="bold">Depto. Origen:</span> <?php echo e($datos->info_clonado->nm_direccion); ?>

                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Forzar un salto de página -->
            <div class="page-break-after"></div>
        <?php endif; ?>

        <!-- Solicitud Derivada -->
        <?php if($datos->info_derivado): ?>
            <?php if($datos->info_ticket->str_observacion): ?>
                <!-- Forzar un salto de página -->
                <div class="page-break-after"></div>
            <?php endif; ?>
            <div class="card">
                <div class="card-header">
                    Historial de Derivaciones
                </div>
                <div class="card-body allow-break">
                    <ul class="timeline">
                        <?php $__currentLoopData = $datos->info_derivado; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $derivar): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="timeline-item avoid-break">
                            <div class="timeline-icon"><?php echo e($index + 1); ?></div>
                            <div class="timeline-date"><?php echo e($derivar->fc_inicio_derivacion ?? 'Sin fecha'); ?></div>
                            <div class="timeline-label"><?php if($loop->first): ?> - Solicitud Inicial <?php else: ?> - Solicitud Derivada <?php endif; ?></div>
                            <div class="timeline-content">
                                <div class="mb-5"><span style="font-weight: bold;">Servicio:</span> <?php echo e($derivar->nm_tipo); ?></div>
                                <div class="mb-5"><span style="font-weight: bold;">Dirección:</span> <?php echo e($derivar->nm_direccion); ?></div>
                                <div><span style="font-weight: bold;">Depto:</span> <?php echo e($derivar->nm_depto); ?></div>
                            </div>
                        </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        <?php endif; ?>

        <!-- Historial del Ticket -->
        <?php if($datos->data_historial): ?>
            <div class="card">
                <div class="card-header">
                    Historial del Ticket de Atención al Vecino
                </div>
                <div class="card-body allow-break">
                    <ul class="timeline">
                        <?php
                            $is_muchos_encargado_servicio   =  false;
                        ?>

                        <?php $__currentLoopData = $datos->data_historial; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $historia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <!--  Solicitud Ingresada-->
                            <?php if($index == 0): ?> 
                                <li class="timeline-item avoid-break">
                                    <div class="timeline-icon"><?php echo e($index + 1); ?></div>
                                    <div class="timeline-date">Duración <?php echo e($historia->fc_diferencia ?? ' 0 '); ?> días</div>
                                    <div class="timeline-label">Solicitud Ingresada por <?php echo e(mb_convert_case($historia->nm_autor ?? '-', MB_CASE_TITLE, "UTF-8")); ?> | <?php echo e($historia->fc_inicio ?? 'Sin fecha'); ?></div>
                                    <div class="timeline-content">
                                        <div class="mb-5"><span style="font-weight: bold;">Servicio:</span> <?php echo e($historia->nm_tipo); ?></div>
                                        <div class="mb-5"><span style="font-weight: bold;">Dirección:</span> <?php echo e($historia->nm_direccion); ?></div>
                                        <div class="mb-5"><span style="font-weight: bold;">Depto:</span> <?php echo e($historia->nm_depto); ?></div>
                                        <div class="mb-5"><span style="font-weight: bold;">Descripción del Requerimiento:</span> <?php echo $datos->info_ticket->str_observacion_html; ?></div>
                                    </div>
                                </li>
                            <?php endif; ?>
                            <!-- Por Asignar -->
                            <?php if($historia->id_estado == 2): ?> 
                                <li class="timeline-item avoid-break">
                                    <div class="timeline-icon"><?php echo e($index + 1); ?></div>
                                    <div class="timeline-date">Duración <?php echo e($historia->fc_diferencia ?? ' 0 '); ?> días</div>
                                    <div class="timeline-label">Por Asignar | <?php echo e($historia->fc_inicio ?? 'Sin fecha'); ?></div>
                                    <div class="timeline-content">
                                        
                                    </div>
                                </li>
                            <?php endif; ?>
                            <!-- En Gestión -->
                            <?php if($historia->id_estado == 3): ?> 
                                <?php if(($datos->info_derivado && count($datos->info_derivado) > 1) || $datos->info_vecino): ?> 
                                    <!-- Insertar salto de página antes de este item -->
                                    <div style="page-break-before: always;"></div> 
                                    <div style="margin-top: 20px !important; padding-top: 15px !important; height: 15px !important;"></div>
                                <?php endif; ?>
                                <li class="timeline-item avoid-break">
                                    <div class="timeline-icon"><?php echo e($index + 1); ?></div>
                                    <div class="timeline-date">Duración <?php echo e($historia->fc_diferencia ?? ' 0 '); ?> días</div>
                                    <div class="timeline-label">En Gestión | <?php echo e($historia->fc_inicio ?? 'Sin fecha'); ?></div>
                                    <div class="timeline-content">
                                        <?php
                                            if(count($historia->encargado_servicio) >= 10) {
                                                $is_muchos_encargado_servicio   =  true;
                                            }
                                        ?>

                                       <?php if(count($datos->info_respuestas)): ?>                                            
                                            <div class="card avoid-break" style="page-break-inside: avoid;">
                                                <div class="card-header" style="text-align: center;">
                                                    Gestiones Internas
                                                </div>
                                                <div class="card-body">
                                                    <div class="timeline-respuestas-container">
                                                        <ul class="timeline-respuestas">
                                                            <?php $__currentLoopData = $datos->info_respuestas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $respuesta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <li class="timeline-respuesta-item">
                                                                    <div class="timeline-respuesta-arrow">
                                                                        <?php echo e($index + 1); ?>

                                                                    </div>
                                                                    <div class="timeline-respuesta-header">
                                                                        <div class="timeline-respuesta-autor">
                                                                            <?php echo e($respuesta->nm_respuesta ?? ''); ?> - <?php echo e(mb_convert_case($respuesta->usuario ?? '-', MB_CASE_TITLE, "UTF-8")); ?>

                                                                        </div>
                                                                        <div class="timeline-respuesta-fecha">
                                                                            <i class="far fa-calendar"></i> 
                                                                            <?php echo e($respuesta->fc_ingreso ?? ''); ?>

                                                                        </div>
                                                                    </div>
                                                                    <div class="timeline-respuesta-contenido">
                                                                        <?php echo mb_convert_case(limpiarHTML($respuesta->str_observacion) ?? '-', MB_CASE_TITLE, "UTF-8"); ?>

                                                                    </div>
                                                                    <hr class="timeline-respuesta-separador">
                                                                </li>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php else: ?>
                                            <?php if(count($historia->encargado_servicio)): ?>
                                                <table class="table table-striped">
                                                    <thead>
                                                        <tr>
                                                            <th colspan="2" style="text-align: center;">Funcionarios Encargados del Servicio</th>
                                                        </tr>
                                                        <tr>
                                                            <th style="text-align: center;">Unidad Municipal</th>
                                                            <th style="text-align: center;">Funcionario </th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php $__currentLoopData = $historia->encargado_servicio; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $encargado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <tr>
                                                                <td>
                                                                    <?php echo e($encargado->nm_direccion); ?> <br>
                                                                    <?php echo e($encargado->nm_depto); ?>

                                                                </td>
                                                                <td><?php echo e(mb_convert_case($encargado->nm_funcionario ?? '-', MB_CASE_TITLE, "UTF-8")); ?></td>
                                                            </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </tbody>
                                                </table>
                                            <?php else: ?>
                                                <table class="table table-striped">
                                                    <thead>
                                                        <tr>
                                                            <th colspan="2" style="text-align: center;">Funcionarios Encargados del Servicio</th>
                                                        </tr>
                                                        <tr>
                                                            <th style="text-align: center;">Unidad Municipal</th>
                                                            <th style="text-align: center;">Funcionario </th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <td colspan="2">No se encontraron funcionarios encargados del servicio</td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </div>
                                </li>
                            <?php endif; ?>
                            <!-- Publicada -->
                            <?php if($historia->id_estado == 5): ?> 
                                <!-- Forzar un salto de página -->
                                <div class="page-break-after"></div>
                                <li class="timeline-item avoid-break">
                                    <div class="timeline-icon"><?php echo e($index + 1); ?></div>
                                    <div class="timeline-date">Duración <?php echo e($historia->fc_diferencia ?? ' 0 '); ?> días</div>
                                    <div class="timeline-label">Respuesta Publicada por <?php echo e(mb_convert_case($historia->nm_autor ?? '-', MB_CASE_TITLE, "UTF-8")); ?> | <?php echo e($historia->fc_inicio ?? 'Sin fecha'); ?></div>
                                    <div class="timeline-content">
                                        <div class="mb-5"><span style="font-weight: bold;">Publicación:</span> <?php echo $historia->str_observacion_html; ?></div>

                                        <?php if($is_muchos_encargado_servicio): ?>
                                            <div style="page-break-before: always;"></div> 
                                            <div style="margin-top: 20px !important; padding-top: 15px !important; height: 15px !important;"></div>
                                        <?php endif; ?>
                                    </div>
                                </li>
                            <?php endif; ?>
                            <!-- Finalizada -->
                            <?php if($historia->id_estado == 6): ?> 
                                <li class="timeline-item avoid-break">
                                    <div class="timeline-icon"><?php echo e($index + 1); ?></div>
                                    <div class="timeline-date">Duración <?php echo e($historia->fc_diferencia ?? ' 0 '); ?> días</div>
                                    <div class="timeline-label">Solicitud Finalizada | <?php echo e($historia->fc_inicio ?? 'Sin fecha'); ?></div>
                                    <div class="timeline-content">
                                        
                                    </div>
                                </li>
                            <?php endif; ?>
                            <!-- Rechazada -->
                            <?php if($historia->id_estado == 7): ?> 
                                <li class="timeline-item avoid-break">
                                    <div class="timeline-icon"><?php echo e($index + 1); ?></div>
                                    <div class="timeline-date">Duración <?php echo e($historia->fc_diferencia ?? ' 0 '); ?> días</div>
                                    <div class="timeline-label">Solicitud Rechazada | <?php echo e($historia->fc_inicio ?? 'Sin fecha'); ?></div>
                                    <div class="timeline-content">
                                        
                                    </div>
                                </li>
                            <?php endif; ?>
                            <!-- Derivado a Funcionario -->
                            <?php if($historia->id_estado == 8): ?> 
                                <li class="timeline-item avoid-break">
                                    <div class="timeline-icon"><?php echo e($index + 1); ?></div>
                                    <div class="timeline-date">Duración <?php echo e($historia->fc_diferencia ?? ' 0 '); ?> días</div>
                                    <div class="timeline-label">Solicitud Derivada por <?php echo e(mb_convert_case($historia->nm_autor ?? '-', MB_CASE_TITLE, "UTF-8")); ?> | <?php echo e($historia->fc_inicio ?? 'Sin fecha'); ?></div>
                                    <div class="timeline-content">
                                        <div class="mb-5"><span style="font-weight: bold;">Servicio:</span> <?php echo e($historia->nm_tipo); ?></div>
                                        <div class="mb-5"><span style="font-weight: bold;">Dirección:</span> <?php echo e($historia->nm_direccion); ?></div>
                                        <div class="mb-5"><span style="font-weight: bold;">Depto:</span> <?php echo e($historia->nm_depto); ?></div>
                                        
                                        <?php if($is_muchos_encargado_servicio): ?>
                                            <div style="page-break-before: always;"></div> 
                                            <div style="margin-top: 20px !important; padding-top: 15px !important; height: 15px !important;"></div>
                                        <?php endif; ?>
                                        <div class="mb-5"><span style="font-weight: bold;">Descripción del Requerimiento:</span> <?php echo $datos->info_ticket->str_observacion_html; ?></div>
                                            
                                        <?php if(count($historia->encargado_servicio)): ?>
                                            <table class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th colspan="2" style="text-align: center;">Funcionarios Encargados del Servicio</th>
                                                    </tr>
                                                    <tr>
                                                        <th style="text-align: center;">Unidad Municipal</th>
                                                        <th style="text-align: center;">Funcionario </th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $__currentLoopData = $historia->encargado_servicio; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $encargado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr>
                                                            <td>
                                                                <?php echo e($encargado->nm_direccion); ?> <br>
                                                                <?php echo e($encargado->nm_depto); ?>

                                                            </td>
                                                            <td><?php echo e(mb_convert_case($encargado->nm_funcionario ?? '-', MB_CASE_TITLE, "UTF-8")); ?></td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        <?php else: ?>
                                            <table class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th colspan="2" style="text-align: center;">Funcionarios Encargados del Servicio</th>
                                                    </tr>
                                                    <tr>
                                                        <th style="text-align: center;">Unidad Municipal</th>
                                                        <th style="text-align: center;">Funcionario </th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td colspan="2">No se encontraron funcionarios encargados del servicio</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        <?php endif; ?>
                                    </div>
                                </li>
                            <?php endif; ?>
                            <!-- Derivado a Macrozona -->
                            <?php if($historia->id_estado == 9): ?> 
                                <li class="timeline-item avoid-break">
                                    <div class="timeline-icon"><?php echo e($index + 1); ?></div>
                                    <div class="timeline-date">Duración <?php echo e($historia->fc_diferencia ?? ' 0 '); ?> días</div>
                                    <div class="timeline-label">Solicitud Derivada por <?php echo e(mb_convert_case($historia->nm_autor ?? '-', MB_CASE_TITLE, "UTF-8")); ?> </div> | <?php echo e($historia->fc_inicio ?? 'Sin fecha'); ?></div>
                                    <div class="timeline-content">
                                        <div class="mb-5" style="text-align: center;"><span style="font-weight: bold;">Gestionada por Macrozona</span></div>
                                    </div>
                                </li>
                            <?php endif; ?>
                            <!-- Derivado a Asignador -->
                            <?php if($historia->id_estado == 10): ?> 
                                <li class="timeline-item avoid-break">
                                    <div class="timeline-icon"><?php echo e($index + 1); ?></div>
                                    <div class="timeline-date">Duración <?php echo e($historia->fc_diferencia ?? ' 0 '); ?> días</div>
                                    <div class="timeline-label">Solicitud Derivada por <?php echo e(mb_convert_case($historia->nm_autor ?? '-', MB_CASE_TITLE, "UTF-8")); ?> </div> | <?php echo e($historia->fc_inicio ?? 'Sin fecha'); ?></div>
                                    <div class="timeline-content">
                                        <div class="mb-5" style="text-align: center;"><span style="font-weight: bold;">Gestionada por Asignador</span></div>
                                    </div>
                                </li>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        <?php endif; ?>
    </div>
</body>
</html><?php /**PATH C:\repositorio\atencion_vecino\resources\views/documentos/ticket-informacion.blade.php ENDPATH**/ ?>