<?php $__env->startSection('body'); ?>
<div class="page-content">
    <div class="container-fluid" id="app">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0 font-size-18">Mis Datos</h4>
                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Mis Datos</a></li>
                            <li class="breadcrumb-item active">Mis Datos</li>
                        </ol>
                    </div>
                </div>

                <div class="x_content">
                    <div class="col-md-10 col-sm-10 offset-1 mt-2">
                        <div class="row-flow">
                            <!-- Datos usuarios -->
                            <div class="card mt-2 border-info">
                                <div class="card-header bg-primary border-info" >
                                    <div class="form-check form-check-inline">
                                        <h4 class="form-check-label text-white" for="inlineCheckbox1">Mis Datos</h4>
                                    </div>
                                </div>
                                <div class="card-body" v-if="tp_vecino == 1">
                                    <div class="row" >
                                        <!-- Rut Vecino -->
                                        <div class="col-md-3 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label>Rut Vecino</label>
                                                <input id="rut_vecino" @change="validarRut(0);" type="text" class="form-control vecino" :disabled="true" v-model="rut_vecino">
                                                <small class="text-error text-danger" v-if="arr_valida.rut_vecino" v-text="arr_valida.rut_vecino[0]"></small>
                                                <small class="text-error text-danger" v-if="arr_form.rut_vecino"  v-text="arr_form.rut_vecino"></small>
                                            </div>
                                        </div>
                                        <!-- Nombre -->
                                        <div class="col-md-3 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label>Nombre</label>
                                                <input type="text" maxlength="50" class="form-control vecino" v-model="nm_vecino">
                                                <small class="text-error text-danger" v-if="arr_valida.nm_vecino" v-text="arr_valida.nm_vecino[0]"></small>
                                                <small class="text-error text-danger" v-if="arr_form.nm_vecino"  v-text="arr_form.nm_vecino"></small>
                                            </div>
                                        </div>
                                        <!-- Primer Apellido -->
                                        <div class="col-md-3 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label>Primer Apellido</label>
                                                <input type="text" maxlength="50" class="form-control vecino" v-model="ap_paterno">
                                                <small class="text-error text-danger" v-if="arr_valida.ap_paterno" v-text="arr_valida.ap_paterno[0]"></small>
                                                <small class="text-error text-danger" v-if="arr_form.ap_paterno"  v-text="arr_form.ap_paterno"></small>
                                            </div>
                                        </div>
                                        <!-- Segundo Apellido -->
                                        <div class="col-md-3 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label>Segundo Apellido</label>
                                                <input type="text" maxlength="50" class="form-control vecino" v-model="ap_materno">
                                                <small class="text-error text-danger" v-if="arr_valida.ap_materno" v-text="arr_valida.ap_materno[0]"></small>
                                                <small class="text-error text-danger" v-if="arr_form.ap_materno"  v-text="arr_form.ap_materno"></small>
                                            </div>
                                        </div>
                                        <!-- Telfono -->
                                        <div class="col-lg-3 col-md-4 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label>Teléfono</label>
                                                <div class=" input-group">
                                                <div class="input-group-prepend">
                                                    <div class="input-group-text">
                                                    <select v-model="pre_fijo" class="vecino">
                                                        <option value="+569">+569</option>
                                                        <option value="+562">+562</option>
                                                    </select>
                                                    </div>
                                                </div>
                                                <input v-model="nr_telefono" type="text"  maxlength="8" type="text" class="form-control vecino"
                                                        onkeypress="return justNumbers(event);">
                                                </div>
                                                <small class="text-error text-danger" v-if="arr_valida.nr_telefono" v-text="arr_valida.nr_telefono[0]"></small>
                                                <small class="text-error text-danger" v-if="arr_form.nr_telefono"  v-text="arr_form.nr_telefono"></small>
                                            </div>
                                        </div>
                                        <!-- Mail -->
                                        <div class="col-md-4 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label>Correo Electrónico</label>
                                                <input type="text" maxlength="50" id="mail_vecino" class="form-control vecino tp_bloquear_accion"
                                                    v-model="mail_vecino" @change="validarMail(0)">
                                                <small class="text-error text-danger" v-if="arr_valida.nm_mail" v-text="arr_valida.nm_mail[0]"></small>
                                                <small class="text-error text-danger" v-if="arr_form.mail_vecino"  v-text="arr_form.mail_vecino"></small>
                                            </div>
                                        </div>
                                        <!-- Confirmar Mail -->
                                        <div class="col-md-4 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label>Confirmar Correo</label>
                                                <input type="text" maxlength="50" id="confirmar_mail_vecino" class="form-control vecino tp_bloquear_accion"
                                                    v-model="confirmar_mail_vecino" @change="validarMail(0)">
                                                <small class="text-error text-danger" v-if="arr_form.confirmar_mail"  v-text="arr_form.confirmar_mail"></small>
                                            </div>
                                        </div>
                                        <!-- Regiones -->
                                        <div class="col-md-3 mt-2">
                                            <div class="form-group">
                                                <label>Región</label>
                                                <multiselect
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="nr_region"
                                                    :options="arr_region"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Ingresar Región"
                                                    @select="asyncComuna"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                                <small class="text-error text-danger" v-if="arr_valida.nr_region" v-text="arr_valida.nr_region[0]"></small>
                                                <small class="text-error text-danger" v-if="arr_form.nr_region"  v-text="arr_form.nr_region"></small>
                                            </div>
                                        </div>
                                        <!-- Comunas -->
                                        <div class="col-md-3 mt-2">
                                            <div class="form-group">
                                                <label>Comuna</label>
                                                <multiselect
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="nr_comuna"
                                                    :options="arr_comuna"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Ingresar Comuna"
                                                    @select="asyncUbicacion"
                                                    :disabled="getValue(nr_region != 0)"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                                <small class="text-error text-danger" v-if="arr_valida.nr_comuna" v-text="arr_valida.nr_comuna[0]"></small>
                                                <small class="text-error text-danger" v-if="arr_form.nr_comuna"  v-text="arr_form.nr_comuna"></small>
                                            </div>
                                        </div>
                                        <!-- Direccion Vecino -->
                                        <template v-if="tp_comuna == 1">
                                            <div class="col-md-3 mt-2">
                                                <div class="form-group">
                                                    <label>Dirección de residencia</label>
                                                    <multiselect
                                                        :show-labels="false"
                                                        :searchable="true"
                                                        v-model="arr_ubicacion_vecino"
                                                        :options="arr_calles_vecino"
                                                        :multiple="false"
                                                        :showNoOptions =false
                                                        placeholder="Ingresar Ubicacion"
                                                        @search-change="asyncUbicacionVecino"
                                                        :disabled="getValue(nr_comuna != 0)"
                                                        label="label" track-by="label">
                                                            <span slot="noResult">No se han encontrado resultados</span>
                                                    </multiselect>
                                                    <small class="text-error text-danger" v-if="arr_valida.arr_ubicacion_vecino" v-text="arr_valida.arr_ubicacion_vecino[0]"></small>
                                                    <small class="text-error text-danger" v-if="arr_form.nm_ubicacion_vecino"  v-text="arr_form.nm_ubicacion_vecino"></small>
                                                </div>
                                            </div>
                                        </template>
                                        <template v-else>
                                            <div class="col-md-3 mt-2">
                                                <div class="form-group">
                                                    <label>Dirección de residencia</label>
                                                    <input type="text" maxlength="50" class="form-control vecino" v-model="nm_ubicacion_vecino"
                                                        placeholder="Dirección y numeración del lugar de residencia">
                                                    <small class="text-error text-danger" v-if="arr_form.nm_ubicacion_vecino"  v-text="arr_form.nm_ubicacion_vecino"></small>
                                                </div>
                                            </div>
                                        </template>
                                        <!-- Clasificacion de ubicacion vecino -->
                                        <div class="col-md-2 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label>Casa/Depto/Oficina</label>
                                                <select v-model="tp_ubicacion_vecino" class="form-control  vecino">
                                                    <option value="1">Casa</option>
                                                    <option value="2">Depto</option>
                                                    <option value="3">Oficina</option>
                                                </select>
                                                <small class="text-error text-danger" v-if="arr_valida.tp_ubicacion_vecino" v-text="arr_valida.tp_ubicacion_vecino[0]"></small>
                                            </div>
                                        </div>
                                        <!-- Aclaratoria -->
                                        <div class="col-md-3 mt-2">
                                            <div class="form-group">
                                                <label>Aclaratoria</label>
                                                <input type="text" maxlength="50" class="form-control vecino" v-model="str_aclaratoria_vecino"
                                                    placeholder="Nro. Depto. | Nro. Casa | Otra aclaración del lugar">
                                                <small class="text-error text-danger" v-if="arr_form.str_aclaratoria_vecino"  v-text="arr_form.str_aclaratoria_vecino"></small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12 col-md-12 col-sm-12">
                                <button v-if="btn_envio == 0 " type="button" class="btn btn-success waves-effect waves-light col-12" @click="ensamblarDatos()">
                                    <i class="fas fa-save"></i> Actualizar
                                </button>
                                <button v-else type="button" class="btn btn-success col-12">Actualizando <i  class="fas fa-spin fa-spinner"></i></button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

    <script type="text/javascript">
        Vue.component('vue-multiselect', window.VueMultiselect.default);

        var app = new Vue({
            el: '#app',
            data: {
                //-------------------------------------
                btn_envio                   :   0,
                tp_vecino                   :   1,
                //-------------------------------------
                arr_valida                  :   [],
                arr_form                    :   {},
                str_error                   :   '',
                //-------------------------------------
                pagination                  : {
                    'total' : 0,
                    'current_page' : 0,
                    'per_page' : 0,
                    'last_page' : 0,
                    'from' : 0,
                    'to' : 0,
                },
                //-------------------------------------
                offset                      :   3,
                //-------------------------------------
                arr_index                   :   [],
                arr_region                  :   [],
                arr_comuna                  :   [],
                arr_calles_vecino           :   [],
                arr_calles_solicitud        :   [],
                //-------------------------------------
                rut_vecino                  :   '',
                nm_vecino                   :   '',
                ap_paterno                  :   '',
                ap_materno                  :   '',
                str_vecino                  :   '',
                nm_direccion                :   '',
                nr_direccion                :   0,
                nr_depto                    :   0,
                tp_ubicacion                :   1,
                pre_fijo                    :   '+569',
                nr_telefono                 :   '',
                mail_vecino                 :   '',
                confirmar_mail_vecino       :   '',
                tp_ubicacion_vecino         :   1,
                str_aclaratoria_vecino      :   '',
                arr_ubicacion_vecino        :   [],
                nm_ubicacion_vecino         :   '',
                nr_ubicacion                :   '',
                str_longitud                :   '',
                str_latitud                 :   '',
                tp_activo                   :   1,
                //-------------------------------------
                nr_region                   :   {
                    value: 13,
                    label: "Metropolitana de Santiago",
                },
                nr_comuna                   :   {
                    value: 271,
                    label: "Las Condes",
                },
                tp_comuna                   :   1,
                //------------------------------------
            },
            components: {
                Multiselect: window.VueMultiselect.default
            },

            filters:{
                resumir: function (texto, limite=90, final=' ...')
                {
                    var largo = texto.toString().length;
                    if(largo > limite){
                        for (var i = 0; i < largo; i++) {
                            if(texto[i] == ' ' && i >= limite){
                                texto = texto.substring(0,i);
                                texto = texto + final;
                                return texto;
                            }
                        }
                    }
                    return texto;
                },
                formatDate: function (fecha)
                {
                    if(fecha)
                        return moment(String(fecha)).format('DD-MM-YYYY')
                },

                formatDateTime: function (fecha)
                {
                    if(fecha)
                    {
                        return moment(String(fecha)).format('DD-MM-YYYY HH:mm')
                    }
                },
            },

            computed:{
                //-------------------------------------------------------------------------------------------
                isActivedPagination: function()
                {
                    return this.pagination.current_page;
                },
                //-------------------------------------------------------------------------------------------
                pagesNumber: function()
                {
                    if(!this.pagination.to) {
                        return [];
                    }

                    var from = this.pagination.current_page - this.offset;
                    if(from < 1) {
                        from = 1;
                    }

                    var to = from + (this.offset * 2);
                    if(to >= this.pagination.last_page){
                        to = this.pagination.last_page;
                    }

                    var pagesArray = [];
                    while(from <= to) {
                        pagesArray.push(from);
                        from++;
                    }
                    return pagesArray;
                },
                //-------------------------------------------------------------------------------------------
            },

            methods: {
                //-------------------------------------------------------------------------------------------
                getVecino()
                {
                    let me      = this;
                    var ruta    = '/buscar/vecino/'+me.rut_vecino;

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta           = response.data;
                        var error               = respuesta.error;
                        var vecino              = respuesta.vecino;
                        var tramites            = respuesta.tramites;

                        if(!error)
                            return;

                        if(tramites == 0)
                        {
                            me.nm_vecino                    =   vecino.nm_vecino;
                            me.ap_paterno                   =   vecino.ap_paterno;
                            me.ap_materno                   =   vecino.ap_materno;
                            me.mail_vecino                  =   vecino.nm_mail;
                            me.confirmar_mail_vecino        =   vecino.nm_mail;
                            me.tp_ubicacion_vecino          =   vecino.tp_direccion;
                            me.nr_telefono                  =   vecino.nr_telefono.slice(-8);
                            me.pre_fijo                     =   vecino.nr_prefijo;

                            me.arr_ubicacion_vecino         =
                            {
                                value : vecino.id_ubicacion,
                                label : vecino.nm_ubicacion,
                                nr_calle : vecino.nr_calle,
                                nm_calle : vecino.nm_calle,
                                str_latitud : vecino.str_latitud,
                                str_longitud : vecino.str_longitud,
                                cod_territorial : vecino.cod_macroterritorio,
                                cod_unidadvecinal : vecino.cod_unidadvecinal,
                            };

                            if(vecino.region)
                            {
                                me.nr_region                    = {
                                    value : vecino.region.id,
                                    label : vecino.region.nm_region,
                                };

                                me.cargarComunas(vecino.region.id);
                            }

                            if(vecino.comuna)
                            {
                                me.nr_comuna                    = {
                                    value : vecino.comuna.id,
                                    label : vecino.comuna.nm_comuna,
                                };
                            }
                        }
                        else
                        {
                            me.nm_vecino                    =   vecino.nm_vecino;
                            me.ap_paterno                   =   vecino.ap_paterno;
                            me.ap_materno                   =   vecino.ap_materno;
                            me.mail_vecino                  =   vecino.correo;
                            me.nr_telefono                  =   vecino.nr_telefono;
                            me.pre_fijo                     =   '+569';
                        }
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                getLabel(data)
                {
                    var valor   =   '';

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.label;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                getValue(data)
                {
                    var valor   =   0;

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.value;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                cargarCalles()
                {
                    let me  =   this;
                    var url =   '/calles/index';

                    axios.get(url).then(function (response)
                    {
                        var respuesta   =   response.data;
                        me.arr_region   =   respuesta.regiones;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarDirecciones(query, tp_opcion = 1)
                {
                    let me          = this;
                    var ruta        = '/direccion/index';
                    var respuesta   = [];

                    axios.post(ruta,{'nm_direccion':   query,
                    }).then(function (response)
                    {
                        var respuesta   =   response.data;

                        if(tp_opcion == 1)
                                me.arr_calles_vecino = respuesta.result;

                        if(tp_opcion == 2)
                                me.arr_calles_solicitud = respuesta.result;

                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                asyncComuna(item)
                {
                    let me          =   this;
                    var arr         =   item;

                    if(item)
                    {
                        me.nr_region    =   item;
                        me.nr_comuna    =   null;

                        me.cargarComunas(item.value);
                    }
                    else
                    {
                        me.nr_region    =   null;
                        me.nr_comuna    =   null;
                    }
                },
                //-------------------------------------------------------------------------------------------
                asyncUbicacion(item)
                {
                    let me          =   this;
                    var arr         =   item;

                    if(item)
                    {
                        me.nr_comuna    =   item;

                        if(me.getValue(item) == 271) // Las Condes
                            me.tp_comuna    =   1;
                        else
                            me.tp_comuna    =   0;
                    }
                    else
                        me.nr_comuna    =   [];
                },
                //-------------------------------------------------------------------------------------------
                asyncUbicacionSolicitud(query)
                {
                    let me          = this;
                    var ruta        = '/direccion/index';

                    if(query.length >= 3)
                        me.cargarDirecciones(query, 2);
                },
                //-------------------------------------------------------------------------------------------
                asyncUbicacionVecino(query)
                {
                    let me          = this;
                    var ruta        = '/direccion/index';

                    if(query.length >= 3)
                        me.cargarDirecciones(query,1);
                },
                //-------------------------------------------------------------------------------------------
                cargarRegiones()
                {
                    let me  =   this;
                    var url =   '/regiones/listado';

                    axios.get(url).then(function (response)
                    {
                        var respuesta   =   response.data;
                        me.arr_region   =   respuesta.regiones;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarComunas(nr_region = 0, nr_provincia = 0)
                {
                    let me      =   this;
                    var ruta    =   '/comunas/listado';

                    axios.post(ruta,{
                            'nr_region'     :   nr_region,
                            'nr_provincia'  :   nr_provincia,
                    }).then(function (response)
                    {
                        var respuesta   =   response.data;
                        me.arr_comuna   =   respuesta.comunas;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                limpiarDatos(modelo)
                {
                    let me  =   this;

                    switch(modelo)
                    {
                        case 'registrar':
                        {
                            me.arr_valida       =   [];
                            me.nr_estado        =   [];
                            me.nr_secuencia     =   [];
                            me.tp_ubicacion_vecino      =   1;
                            me.rut_vecino       =   '';
                            me.nm_vecino        =   '';
                            me.ap_paterno       =   '';
                            me.ap_materno       =   '';
                            me.nr_telefono      =   '';
                            me.mail_vecino      =   '';
                            me.confirmar_mail_vecino    =   '';
                            me.nm_direccion     =   '';
                            me.nr_direccion     =   '';
                            me.str_aclaratoria_vecino   =   '';
                            me.tp_activo        =   1;
                            me.arr_ubicacion_vecino     =   [];
                            me.nm_ubicacion_vecino      =   '';
                            me.nr_region                =   {
                                value: 13,
                                label: "Metropolitana de Santiago",
                            };
                            me.nr_comuna                =   {
                                value: 271,
                                label: "Las Condes",
                            };
                            me.tp_comuna                =   1;
                            me.tp_ubicacion             =   1;

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                validarMail(tp_validar = 0)
                {
                    let me          =   this;
                    var valida      =   null; // Valida Mail Vecino
                    var error       =   0;

                    me.mail_vecino  =   me.mail_vecino.trim().toLowerCase();
                    me.confirmar_mail_vecino    =   me.confirmar_mail_vecino.trim().toLowerCase();

                    if(tp_validar == 0)
                        me.arr_form    =   {};

                    if(me.tp_vecino == 1)
                    {
                        if(me.mail_vecino.trim().length)
                        {
                            valida     =   formatoMail(me.mail_vecino.trim());

                            if(valida == false)
                                me.arr_form.mail_vecino = 'Correo electrónico no es valido';
                        }
                        else
                            me.arr_form.mail_vecino = 'Debe ingresar correo electrónico';


                        if(me.confirmar_mail_vecino.trim().length)
                        {
                            valida     =   formatoMail(me.confirmar_mail_vecino.trim());

                            if(valida == false)
                                me.arr_form.confirmar_mail = 'Correo electrónico no es valido';
                        }
                        else
                            me.arr_form.confirmar_mail = 'Debe ingresar correo electrónico';

                        if(!(me.mail_vecino.trim() === me.confirmar_mail_vecino.trim()) &&
                            (me.mail_vecino.trim().length && me.confirmar_mail_vecino.trim().length))
                                me.arr_form.confirmar_mail = 'Los correos electrónicos no coinciden, favor validar';

                        if(Object.keys(me.arr_form).length)
                            error   =   1;
                    }

                    return error;
                },
                //-------------------------------------------------------------------------------------------
                validarRut(tp_validar = 0)
                {
                    let me          =   this;
                    var valida      =   null;

                    if(tp_validar == 0)
                        me.arr_form    =   {};

                    valida  =   Rut(me.rut_vecino.trim());

                    if(me.rut_vecino.trim().length && valida == false)
                        me.arr_form.rut_vecino = 'Rut ingresado no es valido';

                    if(!me.rut_vecino.trim().length)
                        me.arr_form.rut_vecino = 'Debe ingresar Rut';

                    // if(tp_validar == 0 && valida)
                    //     me.getVecino();
                },
                //-------------------------------------------------------------------------------------------
                validarDatos(tp_validacion)
                {
                    let me          =   this;
                    var error       =   0;
                    me.str_error    =   '';
                    me.arr_form    =   {};

                    switch(tp_validacion)
                    {
                        case 'ingresar':
                        {
                            //----------------------------------------------------------
                            me.validarMail(1);
                            me.validarRut(1);
                            //----------------------------------------------------------
                            /*----- Valida Datos del Vecino -----*/
                            if(me.nm_vecino.trim().length < 3)
                                me.arr_form.nm_vecino   =   'El Nombre debe tener mínimo 3 caracteres';

                            if(me.ap_paterno.trim().length < 3)
                                me.arr_form.ap_paterno   =   'El Primer Apellido debe tener mínimo 3 caracteres';

                            if(me.ap_materno.trim().length < 3)
                                me.arr_form.ap_materno   =   'El Segundo Apellido debe tener mínimo 3 caracteres';

                            if(me.nr_telefono.trim().length < 8)
                                me.arr_form.nr_telefono =   'Favor verificar el número de Telefono';

                            if(me.getValue(me.nr_region) == 0)
                                me.arr_form.nr_region   =   'Debe seleccionar una Región';

                            if(me.getValue(me.nr_comuna) == 0)
                                me.arr_form.nr_comuna   =   'Debe seleccionar una Comuna';

                            if(me.tp_comuna == 1)
                            {
                                if(Object.keys(me.arr_ubicacion_vecino).length == 0)
                                    me.arr_form.nm_ubicacion_vecino     =   'Debe seleccionar la Dirección de residencia';
                            }
                            else
                            {
                                if(me.nm_ubicacion_vecino.trim().length < 5)
                                    me.arr_form.nm_ubicacion_vecino     =   'Debe ingresar la Dirección de residencia';
                            }
                            //----------------------------------------------------------
                            if(Object.keys(me.arr_form).length)
                                error   =   1;
                            //----------------------------------------------------------
                            break;
                        }
                    }

                    return error;
                },
                //-------------------------------------------------------------------------------------------
                ensamblarDatos()
                {
                    let me              =   this;
                    var ruta            =   '';
                    var titulo          =   '';
                    var tiempo          =   0;
                    var error           =   0;
                    var formData        =   new FormData();
                    var fc_format       =   'YYYY-MM-DD';
                    var dir_vecino      =   '';
                    var dir_solicitud   =   '';
                    var nr_dir_solicitud    =   '';
                    var nr_dir_vecino       =   '';
                    me.arr_valida       =   [];
                    me.arr_form         =   {};
                    titulo              =   'Registrando de Requerimiento';
                    tiempo              =   3000;                    
                    //------------------------------------
                    error   =   me.validarDatos('ingresar');

                    if(error == 1)
                    {
                        me.desplegarVentana('warning', 'Registrar Requerimiento', 'Favor revisar los datos faltantes del formulario. <br><br> ' +
                            'Si requiere ayuda para ingresar su requerimiento favor comunicarse al <strong>Fono Ayuda: 02- 29507800</strong>');
                        return;
                    }
                    else
                    {
                        //-----------------------------------------------------------------------------------
                        ruta    =   '/atencion_vecino/vecino/store';
                        //-----------------------------------------------------------------------------------
                        // Datos de Vecino
                        formData.append('rut_vecino', me.rut_vecino.trim());
                        formData.append('nm_vecino', me.nm_vecino);
                        formData.append('ap_paterno', me.ap_paterno);
                        formData.append('ap_materno', me.ap_materno);
                        formData.append('nm_mail', me.mail_vecino);
                        formData.append('pre_fijo', me.pre_fijo);
                        formData.append('nr_telefono', me.nr_telefono);
                        formData.append('nr_region', me.getValue(me.nr_region));
                        formData.append('nr_comuna', me.getValue(me.nr_comuna));
                        formData.append('tp_comuna', me.tp_comuna);
                        formData.append('tp_ubicacion_vecino', me.tp_ubicacion_vecino);

                        if(me.tp_comuna == 1)
                            formData.append('arr_ubicacion_vecino[]', JSON.stringify(me.arr_ubicacion_vecino));
                        else
                            formData.append('nm_ubicacion_vecino', me.nm_ubicacion_vecino);

                        formData.append('str_aclaratoria_vecino', me.str_aclaratoria_vecino);
                        //-----------------------------------------------------------------------------------
                        me.registrarDatos(ruta, formData);
                        //-----------------------------------------------------------------------------------
                    }
                },
                //-------------------------------------------------------------------------------------------
                registrarDatos(ruta, formData)
                {
                    let me              =       this;
                    var tp_icon         =       '';
                    var titulo          =       '';
                    var mensaje         =       '';
                    var error           =       '';
                    me.arr_valida       =       [];
                    me.btn_envio        =        1;

                    axios.post(ruta, formData, {
                        headers: {'Content-Type': 'multipart/form-data'}
                    }).then(function (response)
                    {
                        var result      =   response.data;
                        tp_icon         =   result.tp_icon;
                        titulo          =   result.title;
                        mensaje         =   result.msj;
                        error           =   result.error;
                        me.btn_envio    =   0;
                        me.desplegarVentana(tp_icon, titulo, mensaje);
                    })
                    .catch(function (error)
                    {
                        // Faltan campos por llenar
                        me.btn_envio   =   0;

                        if (error.response.status == 422)
                            me.arr_valida = error.response.data.errors;
                    });
                },
                //-------------------------------------------------------------------------------------------
                desplegarVentana(tp_icon, titulo, mensaje, tp_btn = 1)
                {
                    Swal.fire({
                        icon: tp_icon,
                        title: titulo,
                        html: mensaje,
                        backdrop:false,
                        showConfirmButton: tp_btn
                    });
                },
                //-------------------------------------------------------------------------------------------
                getDataSesion()
                {
                    let me      =   this;
                    var ruta    =   '/buscar/data/vecino';

                    me.nr_rut           =   '';
                    me.nm_postulante    =   '';
                    me.nombre           =   '';
                    me.ap_paterno       =   '';
                    me.ap_materno       =   '';
                    me.email            =   '';

                    axios.get(ruta).then(function (response) 
                    {
                        var respuesta   =   response.data;
                        var error       =   respuesta.error;
                        var vecino      =   respuesta.vecino;
                        var tramites    =   respuesta.tramites;

                        if(error == 1)
                            return;

                        if(respuesta.tramites == 0)
                        {
                            me.rut_vecino                   =   vecino.nr_rut;
                            me.nm_vecino                    =   vecino.nm_vecino;
                            me.ap_paterno                   =   vecino.ap_paterno;
                            me.ap_materno                   =   vecino.ap_materno;
                            me.mail_vecino                  =   vecino.nm_mail;
                            me.confirmar_mail_vecino        =   vecino.nm_mail;
                            me.tp_ubicacion_vecino          =   vecino.tp_direccion;
                            me.nr_telefono                  =   vecino.nr_telefono.slice(-8);
                            me.pre_fijo                     =   vecino.nr_prefijo;

                            if(vecino.region)
                            {
                                me.nr_region                    = {
                                    value : vecino.region.id,
                                    label : vecino.region.nm_region,
                                };

                                me.cargarComunas(vecino.region.id);
                            }

                            if(vecino.comuna)
                            {
                                me.nr_comuna                    = {
                                    value : vecino.comuna.id,
                                    label : vecino.comuna.nm_comuna,
                                };
                            }

                            if(vecino.id_comuna == 271) // Las Condes
                            {
                                me.arr_ubicacion_vecino         =
                                {
                                    value : vecino.id_ubicacion,
                                    label : vecino.nm_ubicacion,
                                    nr_calle : vecino.nr_calle,
                                    nm_calle : vecino.nm_calle,
                                    str_latitud : vecino.str_latitud,
                                    str_longitud : vecino.str_longitud,
                                    cod_territorial : vecino.cod_macroterritorio,
                                    cod_unidadvecinal : vecino.cod_unidadvecinal,
                                };

                                me.tp_comuna    =   1;
                            }
                            else
                            {
                                me.tp_comuna    =   0;
                                me.nm_ubicacion_vecino  =   vecino.nm_ubicacion;
                            }

                        }
                        if(respuesta.tramites == 1)
                        {
                            me.rut_vecino                   =   vecino.nr_rut;
                            me.nm_vecino                    =   vecino.nm_vecino;
                            me.ap_paterno                   =   vecino.ap_paterno;
                            me.ap_materno                   =   vecino.ap_materno;
                            me.mail_vecino                  =   vecino.correo;
                            me.nr_telefono                  =   vecino.nr_telefono;
                            me.pre_fijo                     =   '+569';
                        }                        
                    }).catch(function (error) 
                    {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
            },

            mounted() {
                let me = this;
                me.cargarRegiones();
                me.cargarComunas(13);
                me.getDataSesion();
            }
        });
    </script>

    <script type="text/javascript">
        //-----------------------------------------------------------------
        $(document).ready(function(){
            /*----- Inicio - Bloquear Acciones -----*/
            $('#mail_vecino').on('cut copy paste', function(e){
                e.preventDefault();
            });

            $('#confirmar_mail_vecino').on('cut copy paste', function(e){
                e.preventDefault();
            });
            /*----- Termino - Bloquear Acciones -----*/

            /*----- Formatea Rut -----*/
            $("#rut_vecino").change(function()
            {
                var nr_rut = $("#rut_vecino").val();
                var salida = Rut(nr_rut);

                if(salida)
                    $("#rut_vecino").val(salida);
            });
        });
        //-----------------------------------------------------------------
        function justNumbers(e)
        {
            var keynum = window.event ? window.event.keyCode : e.which;
            if (keynum == 8)
                return true;

            return /\d/.test(String.fromCharCode(keynum));
        }
        //-----------------------------------------------------------------
        function Rut(texto)
        {
            var tmpstr = "";

            for ( i=0; i < texto.length ; i++ )
                if ( texto.charAt(i) != ' ' && texto.charAt(i) != '.' && texto.charAt(i) != '-' )
                    tmpstr = tmpstr + texto.charAt(i);

            texto = tmpstr;
            largo = texto.length;

            if ( largo < 2 )
                return false;

            for (i=0; i < largo ; i++ )
                if (texto.charAt(i) !="0" && texto.charAt(i) != "1" && texto.charAt(i) !="2" && texto.charAt(i) != "3" &&
                    texto.charAt(i) != "4" && texto.charAt(i) !="5" && texto.charAt(i) != "6" && texto.charAt(i) != "7" &&
                    texto.charAt(i) !="8" && texto.charAt(i) != "9" && texto.charAt(i) !="k" && texto.charAt(i) != "K")
                    return false;

            var invertido = "";

            for ( i=(largo-1),j=0; i>=0; i--,j++ )
                invertido = invertido + texto.charAt(i);

            var dtexto = "";
            dtexto = dtexto + invertido.charAt(0);
            dtexto = dtexto + '-';
            cnt = 0;

            for ( i=1,j=2; i<largo; i++,j++ )
            {
                if ( cnt == 3 )
                {
                    dtexto = dtexto + '.';
                    j++;
                    dtexto = dtexto + invertido.charAt(i);
                    cnt = 1;
                }
                else
                {
                    dtexto = dtexto + invertido.charAt(i);
                    cnt++;
                }
            }

            invertido = "";

            for ( i=(dtexto.length-1),j=0; i>=0; i--,j++ )
                invertido = invertido + dtexto.charAt(i);

            if (revisarDigito2(texto))
                return  invertido.toUpperCase();

            return false;
        }
        //-----------------------------------------------------------------
        function formatoMail(valor)
        {
            if (/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test(valor))
                return true;
            else
                return false;
        }
        //-----------------------------------------------------------------
    </script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('atencion_vecino.home_vecino', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\repositorio\atencion_vecino\resources\views/atencion_vecino/perfil_vecino.blade.php ENDPATH**/ ?>